/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.Nullable;

public class PackageDependenciesNode
extends DefaultMutableTreeNode
implements Navigatable {
    private static final EmptyIcon EMPTY_ICON = new EmptyIcon(0, IconUtil.getEmptyIcon((boolean)false).getIconHeight());
    private Set<PsiFile> myRegisteredFiles = null;
    private boolean myHasUnmarked = false;
    private boolean myHasMarked = false;
    private boolean myEquals;

    public void setEquals(boolean equals) {
        this.myEquals = equals;
    }

    public boolean isEquals() {
        return this.myEquals;
    }

    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        for (PsiFile psiFile : this.getRegisteredFiles()) {
            if (psiFile == null || !psiFile.isValid()) continue;
            set.add(psiFile);
        }
    }

    public void addFile(PsiFile file, boolean isMarked) {
        this.getRegisteredFiles().add(file);
        this.updateMarked(!isMarked, isMarked);
    }

    public Icon getOpenIcon() {
        return EMPTY_ICON;
    }

    public Icon getClosedIcon() {
        return EMPTY_ICON;
    }

    public int getWeight() {
        return 0;
    }

    public boolean hasUnmarked() {
        return this.myHasUnmarked;
    }

    public boolean hasMarked() {
        return this.myHasMarked;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    public FileStatus getStatus() {
        return FileStatus.NOT_CHANGED;
    }

    public int getContainingFiles() {
        int result = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result += ((PackageDependenciesNode)this.getChildAt(i)).getContainingFiles();
        }
        return result;
    }

    public String getPresentableFilesCount() {
        int filesCount = this.getContainingFiles();
        return filesCount > 0 ? " (" + AnalysisScopeBundle.message((String)"package.dependencies.node.items.count", (Object[])new Object[]{filesCount}) + ")" : "";
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        boolean hasUnmarked = ((PackageDependenciesNode)newChild).hasUnmarked();
        boolean hasMarked = ((PackageDependenciesNode)newChild).hasMarked();
        this.updateMarked(hasUnmarked, hasMarked);
    }

    private void updateMarked(boolean hasUnmarked, boolean hasMarked) {
        if (hasUnmarked && !this.myHasUnmarked || hasMarked && !this.myHasMarked) {
            this.myHasUnmarked |= hasUnmarked;
            this.myHasMarked |= hasMarked;
            PackageDependenciesNode parent = (PackageDependenciesNode)this.getParent();
            if (parent != null) {
                parent.updateMarked(this.myHasUnmarked, this.myHasMarked);
            }
        }
    }

    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            this.openTextEditor(focus);
        }
    }

    @Nullable
    private Editor openTextEditor(boolean focus) {
        OpenFileDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            return FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, focus);
        }
        return null;
    }

    public boolean canNavigate() {
        if (this.getProject() == null) {
            return false;
        }
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    private Project getProject() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null || psiElement.getContainingFile() == null) {
            return null;
        }
        return psiElement.getContainingFile().getProject();
    }

    @Nullable
    private OpenFileDescriptor getDescriptor() {
        if (this.getProject() == null) {
            return null;
        }
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.getProject(), virtualFile);
    }

    @Override
    public Object getUserObject() {
        return this.toString();
    }

    public boolean isValid() {
        return true;
    }

    public Set<PsiFile> getRegisteredFiles() {
        if (this.myRegisteredFiles == null) {
            this.myRegisteredFiles = new HashSet<PsiFile>();
        }
        return this.myRegisteredFiles;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        return false;
    }
}

