/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.StatusBarImpl;
import com.intellij.openapi.wm.impl.status.StatusBarPatch;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StatusBarTooltipper {
    public static void install(@NotNull StatusBarPatch patch, @NotNull StatusBar statusBar) {
        if (patch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarTooltipper.install must not be null");
        }
        if (statusBar == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarTooltipper.install must not be null");
        }
        JComponent component = patch.getComponent();
        StatusBarTooltipper.install(patch, component, statusBar);
    }

    public static void install(final @NotNull StatusBarPatch patch, final @NotNull JComponent component, final @NotNull StatusBar statusBar) {
        if (patch == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarTooltipper.install must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarTooltipper.install must not be null");
        }
        if (statusBar == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/wm/impl/status/StatusBarTooltipper.install must not be null");
        }
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String text = statusBar instanceof StatusBarImpl ? patch.updateStatusBar(((StatusBarImpl)statusBar).getEditor(), component) : null;
                statusBar.setInfo(text);
                component.setToolTipText(text);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                statusBar.setInfo(null);
                component.setToolTipText(null);
            }
        });
    }
}

