/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class ComboIcon {
    private ActiveIcon myIcon = new ActiveIcon(IconLoader.getIcon((String)"/general/combo.png"));

    public void paintIcon(Component c, Graphics g) {
        this.myIcon.setActive(this.isActive());
        Rectangle moreRect = this.getIconRec();
        if (moreRect == null) {
            return;
        }
        int iconY = this.getIconY(moreRect);
        int iconX = this.getIconX(moreRect);
        this.myIcon.paintIcon(c, g, iconX, iconY);
    }

    protected int getIconX(Rectangle iconRec) {
        return iconRec.x + iconRec.width / 2 - this.getIconWidth() / 2;
    }

    public int getIconWidth() {
        return this.myIcon.getIconWidth();
    }

    protected int getIconY(Rectangle iconRec) {
        return iconRec.y + iconRec.height / 2 - this.getIconHeight() / 2;
    }

    public int getIconHeight() {
        return this.myIcon.getIconHeight();
    }

    public abstract Rectangle getIconRec();

    public abstract boolean isActive();
}

