/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.wm.ToolWindowAnchor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class Surface
extends JComponent {
    private final Image myTopImage;
    private final Image myBottomImage;
    private final double myPixelsPerSec;
    private final int myDirection;
    private final ToolWindowAnchor myAnchor;
    private int myOffset = 0;

    public Surface(Image topImage, Image bottomImage, int direction, ToolWindowAnchor anchor, double pixelsPerSec) {
        this.myTopImage = topImage;
        this.myBottomImage = bottomImage;
        this.myAnchor = anchor;
        this.myDirection = direction;
        this.myPixelsPerSec = pixelsPerSec;
        this.setOpaque(true);
    }

    public final void runMovement() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        int distance = this.myAnchor == ToolWindowAnchor.LEFT || this.myAnchor == ToolWindowAnchor.RIGHT ? bounds.width : bounds.height;
        double desiredTime = (double)distance / this.myPixelsPerSec * 1000.0;
        long startTime = System.currentTimeMillis();
        int count = 0;
        this.myOffset = 0;
        while (true) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            long timeSpent = System.currentTimeMillis() - startTime;
            ++count;
            if ((double)timeSpent >= desiredTime) break;
            double onePaintTime = (double)timeSpent / (double)count;
            int iterations = (int)((desiredTime - (double)timeSpent) / onePaintTime);
            iterations = Math.max(1, iterations);
            this.myOffset += (distance - this.myOffset) / iterations;
        }
    }

    @Override
    public final void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.myAnchor == ToolWindowAnchor.LEFT) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(this.myOffset, 0, bounds.width - this.myOffset, bounds.height);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, this.myOffset, bounds.height);
                g.drawImage(this.myTopImage, this.myOffset - bounds.width, 0, null);
            } else {
                g.setClip(null);
                g.clipRect(bounds.width - this.myOffset, 0, this.myOffset, bounds.height);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width - this.myOffset, bounds.height);
                g.drawImage(this.myTopImage, -this.myOffset, 0, null);
            }
            this.myTopImage.flush();
        } else if (this.myAnchor == ToolWindowAnchor.RIGHT) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width - this.myOffset, bounds.height);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(bounds.width - this.myOffset, 0, this.myOffset, bounds.height);
                g.drawImage(this.myTopImage, bounds.width - this.myOffset, 0, null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, this.myOffset, bounds.height);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(this.myOffset, 0, bounds.width - this.myOffset, bounds.height);
                g.drawImage(this.myTopImage, this.myOffset, 0, null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.TOP) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, this.myOffset, bounds.width, bounds.height - this.myOffset);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, this.myOffset);
                g.drawImage(this.myTopImage, 0, -bounds.height + this.myOffset, null);
            } else {
                g.setClip(null);
                g.clipRect(0, bounds.height - this.myOffset, bounds.width, this.myOffset);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, bounds.height - this.myOffset);
                g.drawImage(this.myTopImage, 0, -this.myOffset, null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.BOTTOM) {
            if (this.myDirection == 1) {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, bounds.height - this.myOffset);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, bounds.height - this.myOffset, bounds.width, this.myOffset);
                g.drawImage(this.myTopImage, 0, bounds.height - this.myOffset, null);
            } else {
                g.setClip(null);
                g.clipRect(0, 0, bounds.width, this.myOffset);
                g.drawImage(this.myBottomImage, 0, 0, null);
                g.setClip(null);
                g.clipRect(0, this.myOffset, bounds.width, bounds.height - this.myOffset);
                g.drawImage(this.myTopImage, 0, this.myOffset, null);
            }
        }
    }
}

