/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimedReference;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandler
implements FileSystemInterface {
    @NonNls
    private static final String JARS_FOLDER = "jars";
    private final Object lock = new Object();
    private final TimedReference<ZipFile> myZipFile = new TimedReference(null);
    private final JarFileSystemImpl myFileSystem;
    private final String myBasePath;
    private SoftReference<Map<String, EntryInfo>> myRelPathsToEntries = new SoftReference<Object>(null);

    public JarHandler(JarFileSystemImpl fileSystem, String path) {
        this.myFileSystem = fileSystem;
        this.myBasePath = path;
    }

    public void refreshLocalFileForJar() {
        NewVirtualFile localJarFile = (NewVirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myBasePath);
        if (localJarFile != null) {
            localJarFile.markDirty();
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFile markDirty() {
        Object object = this.lock;
        synchronized (object) {
            this.myRelPathsToEntries.clear();
            this.myZipFile.set(null);
            NewVirtualFile root = (NewVirtualFile)JarFileSystem.getInstance().findFileByPath(this.myBasePath + "!/");
            if (root != null) {
                root.markDirty();
                return root;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<String, EntryInfo> initEntries() {
        Object object = this.lock;
        // MONITORENTER : object
        THashMap map = this.myRelPathsToEntries.get();
        if (map == null) {
            ZipFile zip = this.getZip();
            map = new THashMap();
            if (zip != null) {
                map.put("", new EntryInfo("", null, true));
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    boolean isDirectory = name.endsWith("/");
                    JarHandler.getOrCreate(isDirectory ? name.substring(0, name.length() - 1) : name, isDirectory, (Map<String, EntryInfo>)map);
                }
                this.myRelPathsToEntries = new SoftReference<THashMap>(map);
            }
        }
        THashMap tHashMap = map;
        // MONITOREXIT : object
        if (tHashMap != null) return tHashMap;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandler.initEntries must not return null");
    }

    private static EntryInfo getOrCreate(String entryName, boolean isDirectory, Map<String, EntryInfo> map) {
        EntryInfo info = map.get(entryName);
        if (info == null) {
            String shortName;
            int idx = entryName.lastIndexOf(47);
            String parentEntryName = idx > 0 ? entryName.substring(0, idx) : "";
            String string = shortName = idx > 0 ? entryName.substring(idx + 1) : entryName;
            if (".".equals(shortName)) {
                return JarHandler.getOrCreate(parentEntryName, true, map);
            }
            info = new EntryInfo(shortName, JarHandler.getOrCreate(parentEntryName, true, map), isDirectory);
            map.put(entryName, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list(VirtualFile file) {
        Object object = this.lock;
        synchronized (object) {
            EntryInfo parentEntry = this.getEntryInfo(file);
            HashSet<String> names = new HashSet<String>();
            for (EntryInfo info : this.getEntriesMap().values()) {
                if (info.parent != parentEntry) continue;
                names.add(info.shortName);
            }
            return ArrayUtil.toStringArray(names);
        }
    }

    private EntryInfo getEntryInfo(VirtualFile file) {
        String parentPath = this.getRelativePath(file);
        return this.getEntriesMap().get(parentPath);
    }

    private String getRelativePath(VirtualFile file) {
        String path = file.getPath().substring(this.myBasePath.length() + 1);
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public File getMirrorFile(File originalFile) {
        if (!this.myFileSystem.isMakeCopyOfJar(originalFile) || !originalFile.exists()) {
            return originalFile;
        }
        String folderPath = PathManager.getSystemPath() + File.separatorChar + JARS_FOLDER;
        if (!new File(folderPath).exists() && !new File(folderPath).mkdirs()) {
            return originalFile;
        }
        String fileName = originalFile.getName() + "." + Integer.toHexString(originalFile.getPath().hashCode());
        File mirror = new File(folderPath, fileName);
        if (!mirror.exists() || Math.abs(originalFile.lastModified() - mirror.lastModified()) > 2000L) {
            return this.copyToMirror(originalFile, mirror);
        }
        return mirror;
    }

    private File copyToMirror(File original, File mirror) {
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator progress = progressManager.getProgressIndicator();
        if (progress != null) {
            progress.pushState();
            progress.setText(VfsBundle.message((String)"jar.copy.progress", (Object[])new Object[]{original.getPath()}));
            progress.setFraction(0.0);
        }
        try {
            FileUtil.copy((File)original, (File)mirror);
        }
        catch (IOException e) {
            final String path1 = original.getPath();
            final String path2 = mirror.getPath();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((String)VfsBundle.message((String)"jar.copy.error.message", (Object[])new Object[]{path1, path2, e.getMessage()}), (String)VfsBundle.message((String)"jar.copy.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            }, ModalityState.NON_MODAL);
            this.myFileSystem.setNoCopyJarForPath(path1);
            return original;
        }
        if (progress != null) {
            progress.popState();
        }
        return mirror;
    }

    @Nullable
    public ZipFile getZip() {
        ZipFile zip = (ZipFile)this.myZipFile.get();
        if (zip == null) {
            try {
                zip = new ZipFile(this.getMirrorFile(this.getOriginalFile()));
                this.myZipFile.set((Object)zip);
            }
            catch (IOException e) {
                return null;
            }
        }
        return zip;
    }

    private File getOriginalFile() {
        return new File(this.myBasePath);
    }

    @Nullable
    private ZipEntry convertToEntry(VirtualFile file) {
        String path = this.getRelativePath(file);
        ZipFile zip = this.getZip();
        return zip != null ? zip.getEntry(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(VirtualFile file) {
        Object object = this.lock;
        synchronized (object) {
            ZipEntry entry = this.convertToEntry(file);
            return entry != null ? entry.getSize() : 0L;
        }
    }

    @NotNull
    public InputStream getInputStream(VirtualFile file) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.contentsToByteArray(file));
        if (byteArrayInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandler.getInputStream must not return null");
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        InputStream stream;
        Object object = this.lock;
        synchronized (object) {
            byte[] byArray;
            ZipEntry entry = this.convertToEntry(file);
            if (entry == null) {
                byte[] byArray2 = new byte[]{};
                // MONITOREXIT @DISABLED, blocks:[4, 9] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                byArray = byArray2;
                if (byArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandler.contentsToByteArray must not return null");
                return byArray;
            }
            ZipFile zip = this.getZip();
            assert (zip != null);
            stream = zip.getInputStream(entry);
            byte[] byArray3 = FileUtil.loadBytes((InputStream)stream, (int)((int)entry.getSize()));
            // MONITOREXIT @DISABLED, blocks:[2, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
            byArray = byArray3;
            if (byArray3 != null) return byArray;
        }
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandler.contentsToByteArray must not return null");
        {
            finally {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(VirtualFile file) {
        if (file.getParent() == null) {
            return -1L;
        }
        Object object = this.lock;
        synchronized (object) {
            ZipEntry entry = this.convertToEntry(file);
            return entry != null ? entry.getTime() : -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(VirtualFile file) {
        if (file.getParent() == null) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            String path = this.getRelativePath(file);
            EntryInfo info = this.getEntriesMap().get(path);
            return info == null || info.isDirectory;
        }
    }

    private Map<String, EntryInfo> getEntriesMap() {
        return this.initEntries();
    }

    public boolean isWritable(VirtualFile file) {
        return false;
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        if (fileOrDirectory.getParent() == null) {
            return this.myZipFile.get() != null || this.getOriginalFile().exists();
        }
        return this.getEntryInfo(fileOrDirectory) != null;
    }

    private static void throwReadOnly() throws IOException {
        throw new IOException("Jar file system is read-only");
    }

    @NotNull
    public OutputStream getOutputStream(VirtualFile file, Object requestor, long modStamp, long timeStamp) throws IOException {
        JarHandler.throwReadOnly();
        if (null == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandler.getOutputStream must not return null");
        }
        return null;
    }

    public VirtualFile copyFile(Object requestor, VirtualFile file, VirtualFile newParent, String copyName) throws IOException {
        JarHandler.throwReadOnly();
        return null;
    }

    public void moveFile(Object requestor, VirtualFile file, VirtualFile newParent) throws IOException {
        JarHandler.throwReadOnly();
    }

    public void renameFile(Object requestor, VirtualFile file, String newName) throws IOException {
        JarHandler.throwReadOnly();
    }

    public void setTimeStamp(VirtualFile file, long modstamp) throws IOException {
        JarHandler.throwReadOnly();
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        JarHandler.throwReadOnly();
    }

    public VirtualFile createChildDirectory(Object requestor, VirtualFile parent, String dir) throws IOException {
        JarHandler.throwReadOnly();
        return null;
    }

    public VirtualFile createChildFile(Object requestor, VirtualFile parent, String file) throws IOException {
        JarHandler.throwReadOnly();
        return null;
    }

    public void deleteFile(Object requestor, VirtualFile file) throws IOException {
        JarHandler.throwReadOnly();
    }

    private static class EntryInfo {
        final boolean isDirectory;
        private final String shortName;
        final EntryInfo parent;

        public EntryInfo(String shortName, EntryInfo parent, boolean directory) {
            this.shortName = new String(shortName);
            this.parent = parent;
            this.isDirectory = directory;
        }
    }
}

