/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vfs.VirtualFile;

public class ProjectExcludedFileIndex
extends ExcludedFileIndex {
    private final ProjectRootManager myRootManager;
    private final DirectoryIndex myDirectoryIndex;

    public ProjectExcludedFileIndex(Project project, ProjectRootManager rootManager, DirectoryIndex directoryIndex) {
        super(project);
        this.myRootManager = rootManager;
        this.myDirectoryIndex = directoryIndex;
    }

    public boolean isInContent(VirtualFile file) {
        return this.myRootManager.getFileIndex().isInContent(file);
    }

    public boolean isExcludedFile(VirtualFile file) {
        return this.myRootManager.getFileIndex().isIgnored(file);
    }

    public boolean isValidAncestor(VirtualFile baseDir, VirtualFile childDir) {
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (this.myDirectoryIndex.getInfoForDirectory(childDir) == null) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }
}

