/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;

public class PlatformVcsPathPresenter
extends VcsPathPresenter {
    public String getPresentableRelativePathFor(VirtualFile file) {
        return FileUtil.toSystemDependentName((String)file.getPath());
    }

    public String getPresentableRelativePath(ContentRevision fromRevision, ContentRevision toRevision) {
        FilePath fromPath = fromRevision.getFile();
        FilePath toPath = toRevision.getFile();
        RelativePathCalculator calculator = new RelativePathCalculator(toPath.getIOFile().getAbsolutePath(), fromPath.getIOFile().getAbsolutePath());
        calculator.execute();
        String result = calculator.getResult();
        return result == null ? null : result.replace("/", File.separator);
    }
}

