/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LazyPatchContentRevision
implements ContentRevision {
    private volatile String myContent;
    private final VirtualFile myVf;
    private final FilePath myNewFilePath;
    private final String myRevision;
    private final TextFilePatch myPatch;
    private volatile boolean myPatchApplyFailed;

    public LazyPatchContentRevision(VirtualFile vf, FilePath newFilePath, String revision, TextFilePatch patch) {
        this.myVf = vf;
        this.myNewFilePath = newFilePath;
        this.myRevision = revision;
        this.myPatch = patch;
    }

    public String getContent() {
        if (this.myContent == null) {
            try {
                Document doc = FileDocumentManager.getInstance().getDocument(this.myVf);
                if (doc == null) {
                    this.myPatchApplyFailed = true;
                    return null;
                }
                String baseContent = doc.getText();
                StringBuilder newText = new StringBuilder();
                ApplyFilePatchBase.applyModifications(this.myPatch, baseContent, newText);
                this.myContent = newText.toString();
            }
            catch (ApplyPatchException e) {
                this.myPatchApplyFailed = true;
                return null;
            }
        }
        return this.myContent;
    }

    public boolean isPatchApplyFailed() {
        return this.myPatchApplyFailed;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myNewFilePath;
        if (filePath == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision.getFile must not return null");
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = new VcsRevisionNumber(){

            public String asString() {
                return LazyPatchContentRevision.this.myRevision;
            }

            public int compareTo(VcsRevisionNumber o) {
                return 0;
            }
        };
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/patch/LazyPatchContentRevision.getRevisionNumber must not return null");
        }
        return vcsRevisionNumber;
    }
}

