/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.PatchVirtualFileReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ZipperUpdater;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.patch.AutoMatchIterator;
import com.intellij.openapi.vcs.changes.patch.FilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDifferentiatedDialog
extends DialogWrapper {
    private final ZipperUpdater myLoadQueue;
    private TextFieldWithBrowseButton myPatchFile;
    private final List<FilePatchInProgress> myPatches;
    private final MyChangeTreeList myChangesTreeList;
    private JComponent myCenterPanel;
    private JComponent mySouthPanel;
    private final Project myProject;
    private AtomicReference<FilePresentation> myRecentPathFileChange;
    private MyUpdater myUpdater;
    private Runnable myReset;
    private ChangeListChooserPanel myChangeListChooser;
    private ChangesLegendCalculator myInfoCalculator;
    private CommitLegendPanel myCommitLegendPanel;
    private final Consumer<ApplyPatchDifferentiatedDialog> myCallback;
    private boolean myContainBasedChanges;

    public ApplyPatchDifferentiatedDialog(Project project, Consumer<ApplyPatchDifferentiatedDialog> callback) {
        super(project, true);
        this.myCallback = callback;
        this.setModal(false);
        this.setTitle(VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == StdFileTypes.PATCH || file.getFileType() == FileTypes.PLAIN_TEXT;
            }
        };
        descriptor.setTitle(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]));
        this.myUpdater = new MyUpdater();
        this.myPatchFile = new TextFieldWithBrowseButton();
        this.myPatchFile.addBrowseFolderListener(VcsBundle.message((String)"patch.apply.select.title", (Object[])new Object[0]), "", project, descriptor);
        this.myPatchFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplyPatchDifferentiatedDialog.this.setPathFileChangeDefault();
                ApplyPatchDifferentiatedDialog.this.myLoadQueue.queue(ApplyPatchDifferentiatedDialog.this.myUpdater);
            }
        });
        this.myProject = project;
        this.myLoadQueue = new ZipperUpdater(500);
        this.myPatches = new LinkedList<FilePatchInProgress>();
        this.myRecentPathFileChange = new AtomicReference();
        this.myChangesTreeList = new MyChangeTreeList(project, Collections.emptyList(), new Runnable(){

            @Override
            public void run() {
                NamedTrinity includedTrinity = new NamedTrinity();
                Collection includedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getIncludedChanges();
                HashSet<Pair> set = new HashSet<Pair>();
                for (FilePatchInProgress.PatchChange change : includedChanges) {
                    TextFilePatch patch = change.getPatchInProgress().getPatch();
                    Pair pair = new Pair((Object)patch.getBeforeName(), (Object)patch.getAfterName());
                    if (set.contains(pair)) continue;
                    set.add(pair);
                    ApplyPatchDifferentiatedDialog.this.acceptChange(includedTrinity, change);
                }
                ApplyPatchDifferentiatedDialog.this.myInfoCalculator.setIncluded(includedTrinity);
                ApplyPatchDifferentiatedDialog.this.myCommitLegendPanel.update();
            }
        }, new MyChangeNodeDecorator());
        this.myReset = new Runnable(){

            @Override
            public void run() {
                ApplyPatchDifferentiatedDialog.this.reset();
            }
        };
        this.myChangeListChooser = new ChangeListChooserPanel(null, new Consumer<String>(){

            public void consume(String errorMessage) {
                ApplyPatchDifferentiatedDialog.this.setOKActionEnabled(errorMessage == null);
                ApplyPatchDifferentiatedDialog.this.setErrorText(errorMessage);
            }
        });
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        this.myChangeListChooser.setChangeLists(changeListManager.getChangeListsCopy());
        this.myChangeListChooser.setDefaultSelection((ChangeList)changeListManager.getDefaultChangeList());
        this.myChangeListChooser.init(project);
        this.myInfoCalculator = new ChangesLegendCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator);
        this.init();
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
        VirtualFile[] files = fileChooserDialog.choose(null, project);
        if (files != null && files.length > 0) {
            this.init(files[0]);
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "vcs.ApplyPatchDifferentiatedDialog";
    }

    protected String getHelpId() {
        return "reference.dialogs.vcs.patch.apply";
    }

    private void setPathFileChangeDefault() {
        this.myRecentPathFileChange.set(new FilePresentation(this.myPatchFile.getText()));
    }

    public void init(VirtualFile patchFile) {
        this.myPatchFile.setText(patchFile.getPath());
        this.myRecentPathFileChange.set(new FilePresentation(patchFile));
        this.myLoadQueue.queue(this.myUpdater);
    }

    private List<TextFilePatch> loadPatches(VirtualFile patchFile) {
        PatchReader reader;
        if (!patchFile.isValid()) {
            return Collections.emptyList();
        }
        try {
            reader = PatchVirtualFileReader.create(patchFile);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        LinkedList<TextFilePatch> result = new LinkedList<TextFilePatch>();
        while (true) {
            TextFilePatch patch;
            try {
                patch = reader.readNextPatch();
            }
            catch (PatchSyntaxException e) {
                if (e.getLine() >= 0) {
                    // empty if block
                }
                return Collections.emptyList();
            }
            if (patch == null) break;
            result.add(patch);
        }
        if (this.myPatches.isEmpty()) {
            // empty if block
        }
        return result;
    }

    public void reset() {
        this.myPatches.clear();
        this.myChangesTreeList.setChangesToDisplay(Collections.emptyList());
        this.myChangesTreeList.repaint();
        this.myContainBasedChanges = false;
    }

    protected JComponent createCenterPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
            JLabel label = new JLabel(VcsBundle.message((String)"create.patch.file.name.field", (Object[])new Object[0]));
            label.setLabelFor((Component)this.myPatchFile);
            this.myCenterPanel.add((Component)label, gb);
            ++gb.gridx;
            gb.fill = 2;
            gb.weightx = 1.0;
            this.myCenterPanel.add((Component)this.myPatchFile, gb);
            gb.gridx = 0;
            ++gb.gridy;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            gb.fill = 2;
            gb.gridwidth = 2;
            DefaultActionGroup group = new DefaultActionGroup();
            AnAction[] treeActions = this.myChangesTreeList.getTreeActions();
            group.addAll(treeActions);
            group.add((AnAction)new MapDirectory());
            MyShowDiff diffAction = new MyShowDiff();
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.getRootPane());
            group.add((AnAction)diffAction);
            group.add((AnAction)new StripUp());
            group.add((AnAction)new StripDown());
            group.add((AnAction)new ResetStrip());
            group.add((AnAction)new ZeroStrip());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("APPLY_PATCH", (ActionGroup)group, true);
            this.myCenterPanel.add((Component)toolbar.getComponent(), gb);
            gb.gridx = 0;
            ++gb.gridy;
            gb.weighty = 1.0;
            gb.gridwidth = 2;
            gb.fill = 1;
            this.myCenterPanel.add((Component)this.myChangesTreeList, gb);
            JPanel wrapper = new JPanel(new GridBagLayout());
            GridBagConstraints gb1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 1, 1), 0, 0);
            wrapper.add((Component)this.myChangeListChooser, gb1);
            ++gb1.gridx;
            gb1.fill = 0;
            gb1.weightx = 0.0;
            gb1.insets.left = 10;
            wrapper.add((Component)this.myCommitLegendPanel.getComponent(), gb1);
            gb.gridx = 0;
            ++gb.gridy;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            gb.fill = 2;
            this.myCenterPanel.add((Component)wrapper, gb);
        }
        return this.myCenterPanel;
    }

    private boolean sameBase(List<FilePatchInProgress.PatchChange> selectedChanges) {
        VirtualFile base = null;
        for (FilePatchInProgress.PatchChange change : selectedChanges) {
            VirtualFile changeBase = change.getPatchInProgress().getBase();
            if (base == null) {
                base = changeBase;
                continue;
            }
            if (base.equals(changeBase)) continue;
            return false;
        }
        return true;
    }

    private void updateTree(boolean doInitCheck) {
        List<FilePatchInProgress> patchesToSelect = this.changes2patches(this.myChangesTreeList.getSelectedChanges());
        List<FilePatchInProgress.PatchChange> changes = this.getAllChanges();
        Collection<FilePatchInProgress.PatchChange> included = this.getIncluded(doInitCheck, changes);
        this.myChangesTreeList.setChangesToDisplay(changes);
        this.myChangesTreeList.setIncludedChanges(included);
        this.myChangesTreeList.repaint();
        if (!doInitCheck && patchesToSelect != null) {
            ArrayList<FilePatchInProgress.PatchChange> toSelect = new ArrayList<FilePatchInProgress.PatchChange>(patchesToSelect.size());
            for (FilePatchInProgress.PatchChange change : changes) {
                if (!patchesToSelect.contains(change.getPatchInProgress())) continue;
                toSelect.add(change);
            }
            this.myChangesTreeList.select(toSelect);
        }
        this.myContainBasedChanges = false;
        for (FilePatchInProgress patch : this.myPatches) {
            if (!patch.baseExistsOrAdded()) continue;
            this.myContainBasedChanges = true;
            break;
        }
    }

    private List<FilePatchInProgress.PatchChange> getAllChanges() {
        return ObjectsConvertor.convert(this.myPatches, new Convertor<FilePatchInProgress, FilePatchInProgress.PatchChange>(){

            public FilePatchInProgress.PatchChange convert(FilePatchInProgress o) {
                return o.getChange();
            }
        });
    }

    private void acceptChange(NamedTrinity trinity, FilePatchInProgress.PatchChange change) {
        FilePatchInProgress patchInProgress = change.getPatchInProgress();
        if (FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus())) {
            trinity.plusAdded();
        } else if (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus())) {
            trinity.plusDeleted();
        } else {
            trinity.plusModified();
        }
    }

    private Collection<FilePatchInProgress.PatchChange> getIncluded(boolean doInitCheck, List<FilePatchInProgress.PatchChange> changes) {
        NamedTrinity totalTrinity = new NamedTrinity();
        NamedTrinity includedTrinity = new NamedTrinity();
        LinkedList<FilePatchInProgress.PatchChange> included = new LinkedList<FilePatchInProgress.PatchChange>();
        if (doInitCheck) {
            for (FilePatchInProgress.PatchChange change : changes) {
                this.acceptChange(totalTrinity, change);
                FilePatchInProgress filePatchInProgress = change.getPatchInProgress();
                if (!filePatchInProgress.baseExistsOrAdded()) continue;
                this.acceptChange(includedTrinity, change);
                included.add(change);
            }
        } else {
            FilePatchInProgress patch;
            Collection includedNow = this.myChangesTreeList.getIncludedChanges();
            HashSet<FilePatchInProgress> toBeIncluded = new HashSet<FilePatchInProgress>();
            for (FilePatchInProgress.PatchChange change : includedNow) {
                patch = change.getPatchInProgress();
                toBeIncluded.add(patch);
            }
            for (FilePatchInProgress.PatchChange change : changes) {
                patch = change.getPatchInProgress();
                this.acceptChange(totalTrinity, change);
                if (!toBeIncluded.contains(patch) || !patch.baseExistsOrAdded()) continue;
                this.acceptChange(includedTrinity, change);
                included.add(change);
            }
        }
        this.myInfoCalculator.setTotal(totalTrinity);
        this.myInfoCalculator.setIncluded(includedTrinity);
        this.myCommitLegendPanel.update();
        return included;
    }

    private List<FilePatchInProgress> changes2patches(List<FilePatchInProgress.PatchChange> selectedChanges) {
        return ObjectsConvertor.convert(selectedChanges, new Convertor<FilePatchInProgress.PatchChange, FilePatchInProgress>(){

            public FilePatchInProgress convert(FilePatchInProgress.PatchChange o) {
                return o.getPatchInProgress();
            }
        });
    }

    public Collection<FilePatchInProgress> getIncluded() {
        return ObjectsConvertor.convert(this.myChangesTreeList.getIncludedChanges(), new Convertor<FilePatchInProgress.PatchChange, FilePatchInProgress>(){

            public FilePatchInProgress convert(FilePatchInProgress.PatchChange o) {
                return o.getPatchInProgress();
            }
        });
    }

    public LocalChangeList getSelectedChangeList() {
        return this.myChangeListChooser.getSelectedList(this.myProject);
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myCallback.consume((Object)this);
    }

    private class MyChangeComparator
    implements Comparator<FilePatchInProgress.PatchChange> {
        private MyChangeComparator() {
        }

        @Override
        public int compare(FilePatchInProgress.PatchChange o1, FilePatchInProgress.PatchChange o2) {
            if (PropertiesComponent.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isTrueValue("ChangesBrowser.SHOW_FLATTEN")) {
                return o1.getPatchInProgress().getIoCurrentBase().getName().compareTo(o2.getPatchInProgress().getIoCurrentBase().getName());
            }
            return o1.getPatchInProgress().getIoCurrentBase().compareTo(o2.getPatchInProgress().getIoCurrentBase());
        }
    }

    private class MyShowDiff
    extends AnAction {
        private final MyChangeComparator myMyChangeComparator;

        private MyShowDiff() {
            super("Show Diff", "Show Diff", IconLoader.getIcon((String)"/actions/diff.png"));
            this.myMyChangeComparator = new MyChangeComparator();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() && ApplyPatchDifferentiatedDialog.this.myContainBasedChanges);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() || !ApplyPatchDifferentiatedDialog.this.myContainBasedChanges) {
                return;
            }
            List changes = ApplyPatchDifferentiatedDialog.this.getAllChanges();
            Collections.sort(changes, this.myMyChangeComparator);
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            int selectedIdx = 0;
            ArrayList<DiffRequestPresentable> diffRequestPresentables = new ArrayList<DiffRequestPresentable>(changes.size());
            if (selectedChanges.isEmpty()) {
                selectedChanges.addAll(changes);
            }
            if (!selectedChanges.isEmpty()) {
                FilePatchInProgress.PatchChange c = (FilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                for (FilePatchInProgress.PatchChange change : changes) {
                    FilePatchInProgress patchInProgress = change.getPatchInProgress();
                    if (!patchInProgress.baseExistsOrAdded()) continue;
                    DiffRequestPresentable diffRequestPresentable = change.createDiffRequestPresentable(ApplyPatchDifferentiatedDialog.this.myProject);
                    if (diffRequestPresentable != null) {
                        diffRequestPresentables.add(diffRequestPresentable);
                    }
                    if (!change.equals((Object)c)) continue;
                    selectedIdx = diffRequestPresentables.size() - 1;
                }
            }
            if (diffRequestPresentables.isEmpty()) {
                return;
            }
            ShowDiffAction.showDiffImpl(ApplyPatchDifferentiatedDialog.this.myProject, diffRequestPresentables, selectedIdx, ShowDiffAction.DiffExtendUIFactory.NONE, false);
        }
    }

    private class ResetStrip
    extends AnAction {
        private ResetStrip() {
            super("Reset Directories", "Reset Directories", IconLoader.getIcon((String)"/vcs/resetStrip.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().reset();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private class StripUp
    extends AnAction {
        private StripUp() {
            super("Strip Directory", "Strip Directory", IconLoader.getIcon((String)"/vcs/stripUp.png"));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().up();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canUp()) continue;
                return false;
            }
            return true;
        }
    }

    private class StripDown
    extends AnAction {
        private StripDown() {
            super("Restore Directory", "Restore Directory", IconLoader.getIcon((String)"/vcs/stripDown.png"));
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().down();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private boolean isEnabled() {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.isEmpty()) {
                return false;
            }
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                if (change.getPatchInProgress().canDown()) continue;
                return false;
            }
            return true;
        }
    }

    private class ZeroStrip
    extends AnAction {
        private ZeroStrip() {
            super("Remove Directories", "Remove Directories", IconLoader.getIcon((String)"/vcs/stripNull.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            for (FilePatchInProgress.PatchChange change : selectedChanges) {
                change.getPatchInProgress().setZero();
            }
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }
    }

    private static class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private MyChangeNodeDecorator() {
        }

        @Override
        public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            if (change instanceof FilePatchInProgress.PatchChange) {
                FilePatchInProgress.PatchChange patchChange = (FilePatchInProgress.PatchChange)change;
                if (!isShowFlatten) {
                    TextFilePatch filePatch = patchChange.getPatchInProgress().getPatch();
                    String patchPath = filePatch.getAfterName() == null ? filePatch.getBeforeName() : filePatch.getAfterName();
                    component.append("   ");
                    component.append("[" + patchPath + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                if (patchChange.getPatchInProgress().getCurrentStrip() > 0) {
                    component.append(" stripped " + patchChange.getPatchInProgress().getCurrentStrip(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                String text = FilePatchStatus.ADDED.equals((Object)patchChange.getPatchInProgress().getStatus()) ? "(Added)" : (FilePatchStatus.DELETED.equals((Object)patchChange.getPatchInProgress().getStatus()) ? "(Deleted)" : "(Modified)");
                component.append("   ");
                component.append(text, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public List<Pair<String, ChangeNodeDecorator.Stress>> stressPartsOfFileName(Change change, String parentPath) {
            FilePatchInProgress.PatchChange patchChange;
            String basePath;
            String basePathCorrected;
            if (change instanceof FilePatchInProgress.PatchChange && parentPath.startsWith(basePathCorrected = (basePath = (patchChange = (FilePatchInProgress.PatchChange)change).getPatchInProgress().getBase().getPath()).trim().replace('/', File.separatorChar))) {
                return Arrays.asList(new Pair((Object)basePathCorrected, (Object)ChangeNodeDecorator.Stress.BOLD), new Pair((Object)StringUtil.tail((String)parentPath, (int)basePathCorrected.length()), (Object)ChangeNodeDecorator.Stress.PLAIN));
            }
            return null;
        }

        @Override
        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
        }
    }

    private static class ChangesLegendCalculator
    implements CommitLegendPanel.InfoCalculator {
        private NamedTrinity myTotal = new NamedTrinity();
        private NamedTrinity myIncluded = new NamedTrinity();

        private ChangesLegendCalculator() {
        }

        public void setTotal(NamedTrinity trinity) {
            this.myTotal = trinity;
        }

        public void setIncluded(NamedTrinity trinity) {
            this.myIncluded = trinity;
        }

        @Override
        public int getNew() {
            return this.myTotal.getAdded();
        }

        @Override
        public int getModified() {
            return this.myTotal.getModified();
        }

        @Override
        public int getDeleted() {
            return this.myTotal.getDeleted();
        }

        @Override
        public int getIncludedNew() {
            return this.myIncluded.getAdded();
        }

        @Override
        public int getIncludedModified() {
            return this.myIncluded.getModified();
        }

        @Override
        public int getIncludedDeleted() {
            return this.myIncluded.getDeleted();
        }
    }

    private static class NamedTrinity {
        private int myAdded;
        private int myModified;
        private int myDeleted;

        public NamedTrinity() {
            this.myAdded = 0;
            this.myModified = 0;
            this.myDeleted = 0;
        }

        public NamedTrinity(int added, int modified, int deleted) {
            this.myAdded = added;
            this.myModified = modified;
            this.myDeleted = deleted;
        }

        public void plusAdded() {
            ++this.myAdded;
        }

        public void plusModified() {
            ++this.myModified;
        }

        public void plusDeleted() {
            ++this.myDeleted;
        }

        public int getAdded() {
            return this.myAdded;
        }

        public int getModified() {
            return this.myModified;
        }

        public int getDeleted() {
            return this.myDeleted;
        }
    }

    private class MapPopup
    extends BaseListPopupStep<VirtualFile> {
        private final Runnable myNewBaseSelector;

        private MapPopup(List<? extends VirtualFile> aValues, Runnable newBaseSelector) {
            if (aValues == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup.<init> must not be null");
            }
            super("Select base directory for a path", aValues);
            this.myNewBaseSelector = newBaseSelector;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue == null) {
                this.myNewBaseSelector.run();
                return null;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (FilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    FilePatchInProgress patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
            return null;
        }

        @NotNull
        public String getTextFor(VirtualFile value) {
            String string = value == null ? "Select base for a path" : value.getPath();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup.getTextFor must not return null");
            }
            return string;
        }
    }

    private class NewBaseSelector
    implements Runnable {
        private NewBaseSelector() {
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            VirtualFile[] selectedFiles = FileChooser.chooseFiles((Project)ApplyPatchDifferentiatedDialog.this.myProject, (FileChooserDescriptor)descriptor);
            if (selectedFiles.length != 1 || selectedFiles[0] == null) {
                return;
            }
            VirtualFile selectedValue = selectedFiles[0];
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (FilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    FilePatchInProgress patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
        }
    }

    private class MapDirectory
    extends AnAction {
        private final NewBaseSelector myNewBaseSelector;

        private MapDirectory() {
            super("Map base directory", "Map base directory", IconLoader.getIcon((String)"/vcs/mapBase.png"));
            this.myNewBaseSelector = new NewBaseSelector();
        }

        public void actionPerformed(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.this.sameBase(selectedChanges)) {
                FilePatchInProgress.PatchChange patchChange = (FilePatchInProgress.PatchChange)((Object)selectedChanges.get(0));
                FilePatchInProgress patch = patchChange.getPatchInProgress();
                List<VirtualFile> autoBases = patch.getAutoBasesCopy();
                if (autoBases.isEmpty() || autoBases.size() == 1 && autoBases.get(0).equals(patch.getBase())) {
                    this.myNewBaseSelector.run();
                } else {
                    autoBases.add(null);
                    MapPopup step = new MapPopup(autoBases, this.myNewBaseSelector);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showCenteredInCurrentWindow(ApplyPatchDifferentiatedDialog.this.myProject);
                }
            }
        }

        public void update(AnActionEvent e) {
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            e.getPresentation().setEnabled(selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.this.sameBase(selectedChanges));
        }
    }

    private static class MyChangeTreeList
    extends ChangesTreeList<FilePatchInProgress.PatchChange> {
        private MyChangeTreeList(Project project, Collection<FilePatchInProgress.PatchChange> initiallyIncluded, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
            super(project, initiallyIncluded, true, false, inclusionListener, decorator);
        }

        @Override
        protected DefaultTreeModel buildTreeModel(List<FilePatchInProgress.PatchChange> changes, ChangeNodeDecorator changeNodeDecorator) {
            TreeModelBuilder builder = new TreeModelBuilder(this.myProject, false);
            return builder.buildModel(ObjectsConvertor.convert(changes, new Convertor<FilePatchInProgress.PatchChange, Change>(){

                public Change convert(FilePatchInProgress.PatchChange o) {
                    return o;
                }
            }), changeNodeDecorator);
        }

        @Override
        protected List<FilePatchInProgress.PatchChange> getSelectedObjects(ChangesBrowserNode<FilePatchInProgress.PatchChange> node) {
            List<Change> under = node.getAllChangesUnder();
            return ObjectsConvertor.convert(under, new Convertor<Change, FilePatchInProgress.PatchChange>(){

                public FilePatchInProgress.PatchChange convert(Change o) {
                    return (FilePatchInProgress.PatchChange)o;
                }
            });
        }

        @Override
        protected FilePatchInProgress.PatchChange getLeadSelectedObject(ChangesBrowserNode node) {
            Object o = node.getUserObject();
            if (o instanceof FilePatchInProgress.PatchChange) {
                return (FilePatchInProgress.PatchChange)((Object)o);
            }
            return null;
        }
    }

    private static class FilePresentation {
        private final VirtualFile myVf;
        private final String myPath;

        private FilePresentation(VirtualFile vf) {
            this.myVf = vf;
            this.myPath = null;
        }

        private FilePresentation(String path) {
            this.myPath = path;
            this.myVf = null;
        }

        @Nullable
        public VirtualFile getVf() {
            if (this.myVf != null) {
                return this.myVf;
            }
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
            return file != null && !file.isDirectory() ? file : null;
        }
    }

    private class MyUpdater
    implements Runnable {
        private MyUpdater() {
        }

        @Override
        public void run() {
            FilePresentation filePresentation = (FilePresentation)ApplyPatchDifferentiatedDialog.this.myRecentPathFileChange.get();
            if (filePresentation == null || filePresentation.getVf() == null) {
                SwingUtilities.invokeLater(ApplyPatchDifferentiatedDialog.this.myReset);
                return;
            }
            final VirtualFile file = filePresentation.getVf();
            List patches = ApplyPatchDifferentiatedDialog.this.loadPatches(file);
            AutoMatchIterator autoMatchIterator = new AutoMatchIterator(ApplyPatchDifferentiatedDialog.this.myProject);
            final List<FilePatchInProgress> matchedPathes = autoMatchIterator.execute(patches);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplyPatchDifferentiatedDialog.this.myChangeListChooser.setDefaultName(file.getNameWithoutExtension().replace('_', ' ').trim());
                    ApplyPatchDifferentiatedDialog.this.myPatches.clear();
                    ApplyPatchDifferentiatedDialog.this.myPatches.addAll(matchedPathes);
                    ApplyPatchDifferentiatedDialog.this.updateTree(true);
                }
            });
        }
    }
}

