/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;

public class EditName
implements ChangeListCommand {
    @NotNull
    private final String myFromName;
    @NotNull
    private final String myToName;
    private boolean myResult;
    private LocalChangeList myListCopy;

    public EditName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/local/EditName.<init> must not be null");
        }
        if (toName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/local/EditName.<init> must not be null");
        }
        this.myFromName = fromName;
        this.myToName = toName;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        LocalChangeList fromList = worker.getCopyByName(this.myFromName);
        if (fromList != null && !fromList.isReadOnly()) {
            this.myResult = worker.editName(this.myFromName, this.myToName);
            this.myListCopy = worker.getCopyByName(this.myToName);
        }
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myListCopy != null && !this.myListCopy.isReadOnly()) {
            ((ChangeListListener)dispatcher.getMulticaster()).changeListRenamed((ChangeList)this.myListCopy, this.myFromName);
        }
    }

    public boolean isResult() {
        return this.myResult;
    }
}

