/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class LinkMouseListenerBase
extends MouseAdapter
implements MouseMotionListener {
    @Nullable
    protected abstract Object getTagAt(MouseEvent var1);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isPopupTrigger() && e.getButton() == 1) {
            Object tag = this.getTagAt(e);
            this.handleTagClick(tag, e);
        }
    }

    protected void handleTagClick(Object tag, MouseEvent event) {
        if (tag instanceof Runnable) {
            ((Runnable)tag).run();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component tree = (Component)e.getSource();
        Object tag = this.getTagAt(e);
        if (tag != null) {
            tree.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            tree.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void install(JComponent tree) {
        tree.addMouseListener(this);
        tree.addMouseMotionListener(this);
    }
}

