/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ChangelistConflictTracker {
    private final Map<String, Conflict> myConflicts = new HashMap();
    private Options myOptions = new Options();
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final EditorNotifications myEditorNotifications;
    private final ChangeListAdapter myChangeListListener;
    private final FileDocumentManager myDocumentManager;
    private final DocumentAdapter myDocumentListener;
    private final FileStatusManager myFileStatusManager;

    public ChangelistConflictTracker(Project project, ChangeListManager changeListManager, FileStatusManager fileStatusManager, EditorNotifications editorNotifications) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myEditorNotifications = editorNotifications;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFileStatusManager = fileStatusManager;
        this.myDocumentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!((ChangelistConflictTracker)ChangelistConflictTracker.this).myOptions.TRACKING_ENABLED) {
                    return;
                }
                Document document = e.getDocument();
                final VirtualFile file = ChangelistConflictTracker.this.myDocumentManager.getFile(document);
                if (file == null) {
                    return;
                }
                ChangelistConflictTracker.this.myChangeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (!ChangelistConflictTracker.this.isFromActiveChangelist(file)) {
                            String path = file.getPath();
                            Conflict conflict = (Conflict)ChangelistConflictTracker.this.myConflicts.get(path);
                            boolean newConflict = false;
                            if (conflict == null) {
                                conflict = new Conflict();
                                ChangelistConflictTracker.this.myConflicts.put(path, conflict);
                                newConflict = true;
                            }
                            conflict.timestamp = System.currentTimeMillis();
                            conflict.changelistId = ChangelistConflictTracker.this.myChangeListManager.getDefaultChangeList().getId();
                            if (newConflict && ((ChangelistConflictTracker)ChangelistConflictTracker.this).myOptions.HIGHLIGHT_CONFLICTS) {
                                ChangelistConflictTracker.this.myFileStatusManager.fileStatusChanged(file);
                                ChangelistConflictTracker.this.myEditorNotifications.updateNotifications(file);
                            }
                        }
                    }
                }, InvokeAfterUpdateMode.SILENT, null, null);
            }
        };
        this.myChangeListListener = new ChangeListAdapter(){

            public void changeListChanged(ChangeList list) {
                ChangelistConflictTracker.this.checkList(list);
            }

            public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
                ChangelistConflictTracker.this.checkList(toList);
            }

            public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
                ChangelistConflictTracker.this.clearChanges(changes, true);
            }

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                ChangelistConflictTracker.this.clearChanges(newDefaultList.getChanges(), true);
            }
        };
    }

    public boolean isWritingAllowed(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker.isWritingAllowed must not be null");
        }
        if (this.isFromActiveChangelist(file)) {
            return true;
        }
        Conflict conflict = this.myConflicts.get(file.getPath());
        return conflict != null && conflict.ignored;
    }

    public boolean isFromActiveChangelist(VirtualFile file) {
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file);
        return changeList == null || this.myChangeListManager.isDefaultChangeList((ChangeList)changeList);
    }

    private void checkList(ChangeList list) {
        this.clearChanges(list.getChanges(), this.myChangeListManager.isDefaultChangeList(list));
    }

    private void clearChanges(Collection<Change> changes, boolean removeConflict) {
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            FilePath filePath = revision.getFile();
            String path = filePath.getPath();
            if (removeConflict) {
                this.myConflicts.remove(path);
                this.myEditorNotifications.updateNotifications(filePath.getVirtualFile());
            }
            this.myFileStatusManager.fileStatusChanged(filePath.getVirtualFile());
        }
    }

    public void startTracking() {
        this.myChangeListManager.addChangeListListener((ChangeListListener)this.myChangeListListener);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    public void stopTracking() {
        this.myChangeListManager.removeChangeListListener((ChangeListListener)this.myChangeListListener);
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this.myDocumentListener);
    }

    public void saveState(Element to) {
        for (Map.Entry<String, Conflict> entry : this.myConflicts.entrySet()) {
            Element fileElement = new Element("file");
            fileElement.setAttribute("path", entry.getKey());
            String id = entry.getValue().changelistId;
            if (id != null) {
                fileElement.setAttribute("changelist", id);
            }
            fileElement.setAttribute("time", Long.toString(entry.getValue().timestamp));
            fileElement.setAttribute("ignored", Boolean.toString(entry.getValue().ignored));
            to.addContent(fileElement);
        }
        XmlSerializer.serializeInto((Object)this.myOptions, (Element)to);
    }

    public void loadState(Element from) {
        this.myConflicts.clear();
        List files = from.getChildren("file");
        for (Object file : files) {
            Element element = (Element)file;
            String path = element.getAttributeValue("path");
            if (path == null) continue;
            Conflict conflict = new Conflict();
            conflict.changelistId = element.getAttributeValue("changelist");
            try {
                conflict.timestamp = Long.parseLong(element.getAttributeValue("time"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            conflict.ignored = Boolean.parseBoolean(element.getAttributeValue("ignored"));
            this.myConflicts.put(path, conflict);
        }
        XmlSerializer.deserializeInto((Object)this.myOptions, (Element)from);
    }

    public void optionsChanged() {
        for (Map.Entry<String, Conflict> entry : this.myConflicts.entrySet()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(entry.getKey());
            if (file == null) continue;
            this.myFileStatusManager.fileStatusChanged(file);
            this.myEditorNotifications.updateNotifications(file);
        }
    }

    public Map<String, Conflict> getConflicts() {
        return this.myConflicts;
    }

    public Collection<String> getIgnoredConflicts() {
        return ContainerUtil.mapNotNull(this.myConflicts.entrySet(), (Function)new NullableFunction<Map.Entry<String, Conflict>, String>(){

            public String fun(Map.Entry<String, Conflict> entry) {
                return entry.getValue().ignored ? entry.getKey() : null;
            }
        });
    }

    public boolean hasConflict(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker.hasConflict must not be null");
        }
        if (!this.myOptions.TRACKING_ENABLED) {
            return false;
        }
        String path = file.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict != null && !conflict.ignored) {
            if (this.isFromActiveChangelist(file)) {
                this.myConflicts.remove(path);
                return false;
            }
            return true;
        }
        return false;
    }

    public void ignoreConflict(@NotNull VirtualFile file, boolean ignore) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker.ignoreConflict must not be null");
        }
        String path = file.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict == null) {
            conflict = new Conflict();
            this.myConflicts.put(path, conflict);
        }
        conflict.ignored = ignore;
        this.myEditorNotifications.updateNotifications(file);
        this.myFileStatusManager.fileStatusChanged(file);
    }

    public Project getProject() {
        return this.myProject;
    }

    public ChangeListManager getChangeListManager() {
        return this.myChangeListManager;
    }

    public Options getOptions() {
        return this.myOptions;
    }

    public static class Options {
        public boolean TRACKING_ENABLED = true;
        public boolean SHOW_DIALOG = false;
        public boolean HIGHLIGHT_CONFLICTS = true;
        public boolean HIGHLIGHT_NON_ACTIVE_CHANGELIST = false;
        public ChangelistConflictResolution LAST_RESOLUTION = ChangelistConflictResolution.IGNORE;
    }

    public static class Conflict {
        long timestamp;
        String changelistId;
        boolean ignored;
    }
}

