/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class WiseSplitter {
    private static final Border LEFT_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 1, UIUtil.getBorderSeparatorColor());
    private static final Border MIDDLE_BORDER = BorderFactory.createMatteBorder(1, 1, 0, 1, UIUtil.getBorderSeparatorColor());
    private final Runnable myRefresher;
    private final Splitter myParentSplitter;
    private final ThreeComponentsSplitter myInnerSplitter;
    private final Map<String, Integer> myInnerSplitterContents;

    public WiseSplitter(Runnable refresher, Splitter parentSplitter) {
        this.myRefresher = refresher;
        this.myParentSplitter = parentSplitter;
        this.myInnerSplitter = new ThreeComponentsSplitter(false);
        this.myInnerSplitter.setHonorComponentsMinimumSize(true);
        this.myInnerSplitterContents = new HashMap<String, Integer>();
        this.updateBorders();
    }

    public boolean canAdd() {
        return this.myInnerSplitterContents.size() <= 3;
    }

    public void add(String key, JComponent comp) {
        int idx = this.myInnerSplitterContents.size();
        this.myInnerSplitterContents.put(key, idx);
        if (idx == 0) {
            this.myParentSplitter.setFirstComponent((JComponent)this.myInnerSplitter);
            if (this.myParentSplitter.getProportion() < 0.05f) {
                this.myParentSplitter.setProportion(0.25f);
            }
            this.myInnerSplitter.setFirstComponent(comp);
            this.myInnerSplitter.setFirstSize((int)(this.myParentSplitter.getSize().getWidth() * (double)this.myParentSplitter.getProportion()));
        } else if (idx == 1) {
            Dimension dimension = this.myInnerSplitter.getSize();
            double width = dimension.getWidth() / 2.0;
            this.myInnerSplitter.setInnerComponent(comp);
            this.myInnerSplitter.setFirstSize((int)width);
        } else {
            Dimension dimension = this.myInnerSplitter.getSize();
            double width = dimension.getWidth() / 3.0;
            this.myInnerSplitter.setLastComponent(comp);
            this.myInnerSplitter.setFirstSize((int)width);
            this.myInnerSplitter.setLastSize((int)width);
        }
        this.updateBorders();
        this.myRefresher.run();
    }

    private void updateBorders() {
        boolean isEmpty;
        boolean bl = isEmpty = this.myInnerSplitterContents.size() == 0;
        if (!isEmpty) {
            this.setBorder(this.myInnerSplitter.getFirstComponent(), true);
            this.setBorder(this.myInnerSplitter.getInnerComponent(), false);
        }
        this.setBorder(this.myParentSplitter.getSecondComponent(), isEmpty);
    }

    private void setBorder(JComponent c, boolean leftMost) {
        if (c instanceof JScrollPane) {
            c.setBorder(leftMost ? LEFT_BORDER : MIDDLE_BORDER);
        }
    }

    public void remove(String key) {
        Integer idx = this.myInnerSplitterContents.remove(key);
        if (idx == null) {
            return;
        }
        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.myInnerSplitterContents.entrySet()) {
            if (entry.getValue() < idx) {
                tmp.put(entry.getKey(), entry.getValue());
                continue;
            }
            tmp.put(entry.getKey(), entry.getValue() - 1);
        }
        this.myInnerSplitterContents.clear();
        this.myInnerSplitterContents.putAll(tmp);
        if (idx == 0) {
            JComponent inner = this.myInnerSplitter.getInnerComponent();
            this.myInnerSplitter.setInnerComponent(null);
            this.myInnerSplitter.setFirstComponent(inner);
            this.lastToInner();
        } else if (idx == 1) {
            this.lastToInner();
        } else {
            this.myInnerSplitter.setLastComponent(null);
        }
        this.updateBorders();
        this.myRefresher.run();
    }

    private void lastToInner() {
        JComponent last = this.myInnerSplitter.getLastComponent();
        this.myInnerSplitter.setLastComponent(null);
        this.myInnerSplitter.setInnerComponent(last);
    }
}

