/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class IncomingChangesViewProvider
implements ChangesViewContentProvider {
    private final Project myProject;
    private final MessageBus myBus;
    private CommittedChangesTreeBrowser myBrowser;
    private MessageBusConnection myConnection;
    private final JLabel myErrorLabel = new JLabel();

    public IncomingChangesViewProvider(Project project, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
    }

    @Override
    public JComponent initContent() {
        this.myBrowser = new CommittedChangesTreeBrowser(this.myProject, Collections.<CommittedChangeList>emptyList());
        this.myBrowser.setEmptyText(VcsBundle.message((String)"incoming.changes.not.loaded.message", (Object[])new Object[0]));
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("IncomingChangesToolbar");
        ActionToolbar toolbar = this.myBrowser.createGroupFilterToolbar(this.myProject, group, null, Collections.<AnAction>emptyList());
        this.myBrowser.setToolBar(toolbar.getComponent());
        this.myBrowser.setTableContextMenu(group, Collections.<AnAction>emptyList());
        this.myConnection = this.myBus.connect();
        this.myConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new MyCommittedChangesListener());
        this.loadChangesToBrowser(false);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.myBrowser, "Center");
        contentPane.add((Component)this.myErrorLabel, "South");
        this.myErrorLabel.setForeground(Color.red);
        return contentPane;
    }

    @Override
    public void disposeContent() {
        this.myConnection.disconnect();
        this.myBrowser = null;
    }

    private void updateModel(final boolean inBackground) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IncomingChangesViewProvider.this.myProject.isDisposed()) {
                    return;
                }
                if (IncomingChangesViewProvider.this.myBrowser != null) {
                    IncomingChangesViewProvider.this.loadChangesToBrowser(inBackground);
                }
            }
        });
    }

    private void loadChangesToBrowser(final boolean inBackground) {
        final CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
        cache.hasCachesForAnyRoot(new Consumer<Boolean>(){

            public void consume(Boolean notEmpty) {
                if (Boolean.TRUE.equals(notEmpty)) {
                    List<CommittedChangeList> list = cache.getCachedIncomingChanges();
                    if (list != null) {
                        IncomingChangesViewProvider.this.myBrowser.setEmptyText(VcsBundle.message((String)"incoming.changes.empty.message", (Object[])new Object[0]));
                        IncomingChangesViewProvider.this.myBrowser.setItems(list, false, CommittedChangesBrowserUseCase.INCOMING);
                    } else {
                        cache.loadIncomingChangesAsync(null, inBackground);
                    }
                }
            }
        });
    }

    private class MyCommittedChangesListener
    extends CommittedChangesAdapter {
        private MyCommittedChangesListener() {
        }

        @Override
        public void changesLoaded(RepositoryLocation location, List<CommittedChangeList> changes) {
            IncomingChangesViewProvider.this.updateModel(true);
        }

        @Override
        public void incomingChangesUpdated(List<CommittedChangeList> receivedChanges) {
            IncomingChangesViewProvider.this.updateModel(true);
        }

        @Override
        public void refreshErrorStatusChanged(final @Nullable VcsException lastError) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (lastError != null) {
                        IncomingChangesViewProvider.this.myErrorLabel.setText("Error refreshing changes: " + lastError.getMessage());
                    } else {
                        IncomingChangesViewProvider.this.myErrorLabel.setText("");
                    }
                }
            });
        }
    }
}

