/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.SimiliarListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommittedListsSequencesZipper {
    private final VcsCommittedListsZipper myVcsPartner;
    private final List<RepositoryLocation> myInLocations;
    private final Map<String, List<CommittedChangeList>> myInLists;

    public CommittedListsSequencesZipper(VcsCommittedListsZipper vcsPartner) {
        this.myVcsPartner = vcsPartner;
        this.myInLocations = new ArrayList<RepositoryLocation>();
        this.myInLists = new HashMap<String, List<CommittedChangeList>>();
    }

    public void add(RepositoryLocation location, List<CommittedChangeList> lists) {
        this.myInLocations.add(location);
        Collections.sort(lists, new Comparator<CommittedChangeList>(){

            @Override
            public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                long num2;
                long num1 = CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o1);
                return num1 == (num2 = CommittedListsSequencesZipper.this.myVcsPartner.getNumber(o2)) ? 0 : (num1 < num2 ? -1 : 1);
            }
        });
        this.myInLists.put(location.toPresentableString(), lists);
    }

    public List<CommittedChangeList> execute() {
        Pair groupingResult = this.myVcsPartner.groupLocations(this.myInLocations);
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        for (RepositoryLocation location : (List)groupingResult.getSecond()) {
            result.addAll((Collection<CommittedChangeList>)this.myInLists.get(location.toPresentableString()));
        }
        for (RepositoryLocationGroup group : (List)groupingResult.getFirst()) {
            List locations = group.getLocations();
            ArrayList<List<CommittedChangeList>> lists = new ArrayList<List<CommittedChangeList>>(locations.size());
            for (RepositoryLocation location : locations) {
                lists.add(this.myInLists.get(location.toPresentableString()));
            }
            SimiliarListsZipper zipper = new SimiliarListsZipper(lists, this.myVcsPartner, group);
            zipper.zip();
            result.addAll(zipper.getResult());
        }
        return result;
    }
}

