/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class RemoveChangeListAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        boolean visible = RemoveChangeListAction.canRemoveChangeLists(project, lists);
        if (e.getPlace().equals("ChangesViewPopup")) {
            e.getPresentation().setVisible(visible);
        } else {
            e.getPresentation().setEnabled(visible);
        }
    }

    private static boolean canRemoveChangeLists(Project project, ChangeList[] lists) {
        if (project == null || lists == null || lists.length == 0) {
            return false;
        }
        for (ChangeList changeList : lists) {
            if (!(changeList instanceof LocalChangeList)) {
                return false;
            }
            LocalChangeList localChangeList = (LocalChangeList)changeList;
            if (localChangeList.isReadOnly()) {
                return false;
            }
            if (!localChangeList.isDefault() || ChangeListManager.getInstance((Project)project).getChangeListsCopy().size() > lists.length) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        int rc;
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        assert (lists != null);
        for (ChangeList list : lists) {
            if (!((LocalChangeList)list).isDefault()) continue;
            RemoveChangeListAction.removeActiveChangeList(project, lists, list.getChanges().isEmpty());
            return;
        }
        if (lists.length == 1) {
            LocalChangeList list = (LocalChangeList)lists[0];
            rc = list.getChanges().size() == 0 ? 0 : Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"changes.removechangelist.warning.text", (Object[])new Object[]{list.getName()}), (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        } else {
            boolean notEmpty = false;
            for (ChangeList list : lists) {
                notEmpty |= list.getChanges().size() > 0;
            }
            int n = rc = !notEmpty ? 0 : Messages.showYesNoDialog((Project)project, (String)VcsBundle.message((String)"changes.removechangelist.multiple.warning.text", (Object[])new Object[]{lists.length}), (String)VcsBundle.message((String)"changes.removechangelist.warning.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        }
        if (rc == 0) {
            for (ChangeList list : lists) {
                ChangeListManager.getInstance((Project)project).removeChangeList(list.getName());
            }
        }
    }

    private static void removeActiveChangeList(Project project, ChangeList[] lists, boolean empty) {
        List remainingLists = ChangeListManager.getInstance((Project)project).getChangeListsCopy();
        remainingLists.removeAll(Arrays.asList(lists));
        String[] names = new String[remainingLists.size()];
        for (int i = 0; i < remainingLists.size(); ++i) {
            names[i] = ((LocalChangeList)remainingLists.get(i)).getName();
        }
        int nameIndex = Messages.showChooseDialog((Project)project, (String)(empty ? VcsBundle.message((String)"changes.remove.active.empty.prompt", (Object[])new Object[0]) : VcsBundle.message((String)"changes.remove.active.prompt", (Object[])new Object[0])), (String)VcsBundle.message((String)"changes.remove.active.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])names, (String)names[0]);
        if (nameIndex < 0) {
            return;
        }
        ChangeListManager.getInstance((Project)project).setDefaultChangeList((LocalChangeList)remainingLists.get(nameIndex));
        for (ChangeList list : lists) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            changeListManager.removeChangeList(list.getName());
        }
    }
}

