/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VcsEventWatcher
extends AbstractProjectComponent {
    public VcsEventWatcher(Project project) {
        super(project);
    }

    public void projectOpened() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (VcsEventWatcher.this.myProject.isDisposed() || !DirectoryIndex.getInstance(VcsEventWatcher.this.myProject).isInitialized()) {
                            return;
                        }
                        VcsDirtyScopeManager.getInstance((Project)VcsEventWatcher.this.myProject).markEverythingDirty();
                    }
                }, ModalityState.NON_MODAL);
            }
        });
        MyProblemListener myProblemListener = new MyProblemListener();
        WolfTheProblemSolver.getInstance((Project)this.myProject).addProblemListener((WolfTheProblemSolver.ProblemListener)myProblemListener, (Disposable)this.myProject);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("VcsEventWatcher" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/VcsEventWatcher.getComponentName must not return null");
        }
        return "VcsEventWatcher";
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(VirtualFile file) {
            ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file);
        }

        public void problemsDisappeared(VirtualFile file) {
            ChangesViewManager.getInstance(VcsEventWatcher.this.myProject).refreshChangesViewNodeAsync(file);
        }
    }
}

