/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsRoot;

public class FilePathUnderVcs {
    private final FilePath myPath;
    private final AbstractVcs myVcs;

    public FilePathUnderVcs(FilePath path, AbstractVcs vcs) {
        this.myPath = path;
        this.myVcs = vcs;
    }

    FilePathUnderVcs(VcsRoot root) {
        this.myPath = new FilePathImpl(root.path);
        this.myVcs = root.vcs;
    }

    public FilePath getPath() {
        return this.myPath;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePathUnderVcs that = (FilePathUnderVcs)o;
        if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
            return false;
        }
        return !(this.myVcs != null ? !Comparing.equal((String)this.myVcs.getName(), (String)that.myVcs.getName()) : that.myVcs != null);
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myVcs != null ? this.myVcs.getName().hashCode() : 0);
        return result;
    }
}

