/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;

public class Annotater {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private final FileAnnotation myFileAnnotation;

    public Annotater(FileAnnotation fileAnnotation, Project project, VirtualFile virtualFile) {
        this.myFileAnnotation = fileAnnotation;
        this.myProject = project;
        this.myVirtualFile = virtualFile;
    }

    public void showAnnotation() {
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this.myProject, this.myVirtualFile);
        Editor editor = FileEditorManager.getInstance((Project)this.myProject).openTextEditor(openFileDescriptor, true);
        if (editor == null) {
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.cannot.open.editor", (Object[])new Object[]{this.myVirtualFile.getPresentableUrl()}), (String)VcsBundle.message((String)"message.title.cannot.open.editor", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        AnnotateToggleAction.doAnnotate(editor, this.myProject, this.myVirtualFile, this.myFileAnnotation);
    }
}

