/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import org.jetbrains.annotations.Nullable;

public class AlphaNumericTypeCommand
extends TypeCommand {
    public AlphaNumericTypeCommand(String text, int line) {
        super(text, line);
    }

    @Override
    public ActionCallback _execute(PlaybackRunner.StatusCallback cb, Robot robot, boolean directActionCall) {
        return this.type(robot, this.getText());
    }

    protected ActionCallback type(final Robot robot, final String text) {
        final ActionCallback result = new ActionCallback();
        TypingTarget typingTarget = AlphaNumericTypeCommand.findTarget();
        if (typingTarget != null) {
            typingTarget.type(text).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    result.setDone();
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    AlphaNumericTypeCommand.this.typeByRobot(robot, text).notify(result);
                }
            });
        } else {
            this.typeByRobot(robot, text).notify(result);
        }
        return result;
    }

    private ActionCallback typeByRobot(Robot robot, String text) {
        for (int i = 0; i < text.length(); ++i) {
            char each = text.charAt(i);
            if ('\\' == each && i + 1 < text.length()) {
                char next = text.charAt(i + 1);
                boolean processed = true;
                switch (next) {
                    case 'n': {
                        this.type(robot, 10, 0);
                        break;
                    }
                    case 't': {
                        this.type(robot, 9, 0);
                        break;
                    }
                    case 'r': {
                        this.type(robot, 10, 0);
                        break;
                    }
                    default: {
                        processed = false;
                    }
                }
                if (processed) {
                    ++i;
                    continue;
                }
            }
            this.type(robot, this.get(each));
        }
        return new ActionCallback.Done();
    }

    @Nullable
    public static TypingTarget findTarget() {
        if (!Registry.is((String)"actionSystem.playback.useTypingTargets")) {
            return null;
        }
        for (Component each = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); each != null; each = each.getParent()) {
            if (!(each instanceof TypingTarget)) continue;
            return (TypingTarget)each;
        }
        return null;
    }
}

