/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.ActionCallback;
import java.awt.Robot;

public abstract class AbstractCommand
implements PlaybackCommand {
    public static String CMD_PREFIX = "%";
    private String myText;
    private int myLine;

    public AbstractCommand(String text, int line) {
        this.myText = text != null ? text : null;
        this.myLine = line;
    }

    public String getText() {
        return this.myText;
    }

    public int getLine() {
        return this.myLine;
    }

    @Override
    public boolean canGoFurther() {
        return true;
    }

    @Override
    public final ActionCallback execute(PlaybackRunner.StatusCallback cb, Robot robot, boolean useDirectActionCall) {
        try {
            this.dumpCommand(cb);
            return this._execute(cb, robot, useDirectActionCall);
        }
        catch (Exception e) {
            cb.error(e.getMessage(), this.getLine());
            return new ActionCallback.Rejected();
        }
    }

    protected abstract ActionCallback _execute(PlaybackRunner.StatusCallback var1, Robot var2, boolean var3);

    public void dumpCommand(PlaybackRunner.StatusCallback cb) {
        cb.message(this.getText(), this.getLine());
    }

    public void dumpError(PlaybackRunner.StatusCallback cb, String text) {
        cb.error(text, this.getLine());
    }
}

