/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ComplexPackagingElementNode;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComplexElementSubstitutionParameters {
    private Set<ComplexPackagingElementType<?>> myTypesToSubstitute = new HashSet();
    private Set<ComplexPackagingElement<?>> mySubstituted = new HashSet();

    public void setSubstituteAll() {
        this.myTypesToSubstitute.addAll(Arrays.asList(PackagingElementFactory.getInstance().getComplexElementTypes()));
        this.mySubstituted.clear();
    }

    public void setSubstituteNone() {
        this.myTypesToSubstitute.clear();
        this.mySubstituted.clear();
    }

    public boolean shouldSubstitute(@NotNull ComplexPackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ComplexElementSubstitutionParameters.shouldSubstitute must not be null");
        }
        ComplexPackagingElementType type = (ComplexPackagingElementType)element.getType();
        return this.myTypesToSubstitute.contains(type) || this.mySubstituted.contains(element);
    }

    public void setShowContent(ComplexPackagingElementType<?> type, boolean showContent) {
        if (showContent) {
            this.myTypesToSubstitute.add(type);
        } else {
            this.myTypesToSubstitute.remove(type);
        }
        Iterator<ComplexPackagingElement<?>> iterator = this.mySubstituted.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().equals(type)) continue;
            iterator.remove();
        }
    }

    public Set<ComplexPackagingElementType<?>> getTypesToSubstitute() {
        return Collections.unmodifiableSet(this.myTypesToSubstitute);
    }

    public void setShowContent(ComplexPackagingElementNode complexNode) {
        this.mySubstituted.addAll(complexNode.getPackagingElements());
    }

    public void doNotSubstitute(ComplexPackagingElement<?> element) {
        this.mySubstituted.remove(element);
    }

    public boolean isShowContentForType(@NotNull ComplexPackagingElementType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ComplexElementSubstitutionParameters.isShowContentForType must not be null");
        }
        return this.myTypesToSubstitute.contains(type);
    }

    public boolean isAllSubstituted() {
        return this.myTypesToSubstitute.containsAll(Arrays.asList(PackagingElementFactory.getInstance().getComplexElementTypes()));
    }

    public boolean isNoneSubstituted() {
        return this.myTypesToSubstitute.isEmpty() && this.mySubstituted.isEmpty();
    }

    public void setTypesToShowContent(Collection<ComplexPackagingElementType<?>> types) {
        this.myTypesToSubstitute.clear();
        this.myTypesToSubstitute.addAll(types);
    }
}

