/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.Facet;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.SidePanel;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Place.Navigator {
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    private final UIState myUiState = new UIState();
    private Splitter mySplitter;
    private JComponent myToolbarComponent;
    @NonNls
    private static final String CATEGORY = "category";
    private JComponent myToFocus;
    private boolean myWasUiDisposed;
    private final Project myProject;
    private final ModuleManager myModuleManager;
    private final FacetStructureConfigurable myFacetStructureConfigurable;
    private final ArtifactsStructureConfigurable myArtifactsStructureConfigurable;
    private History myHistory = new History((Place.Navigator)this);
    private SidePanel mySidePanel;
    private JPanel myComponent;
    private final Wrapper myDetails = new Wrapper();
    private Configurable mySelectedConfigurable;
    private final ProjectJdksModel myProjectJdksModel = new ProjectJdksModel();
    private ProjectConfigurable myProjectConfig;
    private final ProjectLibrariesConfigurable myProjectLibrariesConfig;
    private final GlobalLibrariesConfigurable myGlobalLibrariesConfig;
    private ModuleStructureConfigurable myModulesConfig;
    private boolean myWasIntialized;
    private final List<Configurable> myName2Config = new ArrayList<Configurable>();
    private final StructureConfigurableContext myContext;
    private final ModulesConfigurator myModuleConfigurator;
    private JdkListConfigurable myJdkListConfig;
    private final JLabel myEmptySelection = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);

    public ProjectStructureConfigurable(Project project, ModuleManager moduleManager, ProjectLibrariesConfigurable projectLibrariesConfigurable, GlobalLibrariesConfigurable globalLibrariesConfigurable, ModuleStructureConfigurable moduleStructureConfigurable, FacetStructureConfigurable facetStructureConfigurable, ArtifactsStructureConfigurable artifactsStructureConfigurable) {
        this.myProject = project;
        this.myModuleManager = moduleManager;
        this.myFacetStructureConfigurable = facetStructureConfigurable;
        this.myArtifactsStructureConfigurable = artifactsStructureConfigurable;
        this.myModuleConfigurator = new ModulesConfigurator(this.myProject, this.myProjectJdksModel);
        this.myContext = new StructureConfigurableContext(this.myProject, this.myModuleConfigurator);
        this.myModuleConfigurator.setContext(this.myContext);
        this.myProjectLibrariesConfig = projectLibrariesConfigurable;
        this.myGlobalLibrariesConfig = globalLibrariesConfigurable;
        this.myModulesConfig = moduleStructureConfigurable;
        this.myProjectLibrariesConfig.init(this.myContext);
        this.myGlobalLibrariesConfig.init(this.myContext);
        this.myModulesConfig.init(this.myContext);
        this.myFacetStructureConfigurable.init(this.myContext);
        this.myArtifactsStructureConfigurable.init(this.myContext, this.myModulesConfig, this.myProjectLibrariesConfig, this.myGlobalLibrariesConfig);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue("project.structure.last.edited");
        String proportion = propertiesComponent.getValue("project.structure.proportion");
        this.myUiState.proportion = proportion != null ? Float.parseFloat(proportion) : 0.0f;
        String sideProportion = propertiesComponent.getValue("project.structure.side.proportion");
        this.myUiState.sideProportion = sideProportion != null ? Float.parseFloat(sideProportion) : 0.0f;
    }

    @NonNls
    public String getId() {
        return "project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return IconLoader.getIcon((String)"/modules/modules.png");
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.mySelectedConfigurable != null ? this.mySelectedConfigurable.getHelpTopic() : "";
    }

    public JComponent createComponent() {
        this.myComponent = new MyPanel();
        this.mySplitter = new Splitter(false, 0.15f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new BackAction((JComponent)this.myComponent));
        toolbarGroup.add((AnAction)new ForwardAction((JComponent)this.myComponent));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)this.myComponent);
        this.myToolbarComponent = toolbar.getComponent();
        left.add((Component)this.myToolbarComponent, "North");
        left.add((Component)this.mySidePanel, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        this.myComponent.add((Component)this.mySplitter, "Center");
        this.myWasIntialized = true;
        return this.myComponent;
    }

    private void initSidePanel() {
        boolean isDefaultProject = this.myProject == ProjectManager.getInstance().getDefaultProject();
        this.mySidePanel = new SidePanel(this, this.myHistory);
        this.mySidePanel.addSeparator("Project Settings");
        this.addProjectConfig();
        if (!isDefaultProject) {
            this.addModulesConfig();
        }
        this.addProjectLibrariesConfig();
        if (!isDefaultProject) {
            this.addFacetsConfig();
            this.addArtifactsConfig();
        }
        this.mySidePanel.addSeparator("Platform Settings");
        this.addJdkListConfig();
        this.addGlobalLibrariesConfig();
    }

    private void addArtifactsConfig() {
        this.addConfigurable((Configurable)this.myArtifactsStructureConfigurable);
    }

    public ArtifactsStructureConfigurable getArtifactsStructureConfigurable() {
        return this.myArtifactsStructureConfigurable;
    }

    private void addFacetsConfig() {
        if (FacetStructureConfigurable.isEnabled()) {
            this.addConfigurable((Configurable)this.myFacetStructureConfigurable);
        }
    }

    private void addJdkListConfig() {
        if (this.myJdkListConfig == null) {
            this.myJdkListConfig = JdkListConfigurable.getInstance(this.myProject);
            this.myJdkListConfig.init(this.myContext);
        }
        this.addConfigurable((Configurable)this.myJdkListConfig);
    }

    private void addProjectConfig() {
        this.myProjectConfig = new ProjectConfigurable(this.myProject, this.myModuleConfigurator, this.myProjectJdksModel);
        this.addConfigurable((Configurable)this.myProjectConfig);
    }

    private void addProjectLibrariesConfig() {
        this.addConfigurable((Configurable)this.myProjectLibrariesConfig);
    }

    private void addGlobalLibrariesConfig() {
        this.addConfigurable((Configurable)this.myGlobalLibrariesConfig);
    }

    private void addModulesConfig() {
        this.myModulesConfig = ModuleStructureConfigurable.getInstance(this.myProject);
        this.addConfigurable((Configurable)this.myModulesConfig);
    }

    public boolean isModified() {
        for (Configurable each : this.myName2Config) {
            if (!each.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable each : this.myName2Config) {
            if (!each.isModified()) continue;
            each.apply();
        }
        this.myContext.getDaemonAnalyzer().clearCaches();
    }

    public void reset() {
        this.myWasUiDisposed = false;
        this.myContext.reset();
        this.myProjectJdksModel.reset(this.myProject);
        Configurable toSelect = null;
        for (Configurable each : this.myName2Config) {
            if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(each.getDisplayName())) {
                toSelect = each;
            }
            if (each instanceof MasterDetailsComponent) {
                ((MasterDetailsComponent)each).setHistory(this.myHistory);
            }
            each.reset();
        }
        this.myHistory.clear();
        if (toSelect == null && this.myName2Config.size() > 0) {
            toSelect = this.myName2Config.iterator().next();
        }
        this.removeSelected();
        this.navigateTo(toSelect != null ? ProjectStructureConfigurable.createPlaceFor(toSelect) : null, false);
        if (this.myUiState.proportion > 0.0f) {
            this.mySplitter.setProportion(this.myUiState.proportion);
        }
    }

    public void disposeUIResources() {
        if (!this.myWasIntialized) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue("project.structure.last.edited", this.myUiState.lastEditedConfigurable);
        propertiesComponent.setValue("project.structure.proportion", String.valueOf(this.myUiState.proportion));
        propertiesComponent.setValue("project.structure.side.proportion", String.valueOf(this.myUiState.sideProportion));
        this.myWasUiDisposed = true;
        this.myUiState.proportion = this.mySplitter.getProportion();
        this.saveSideProportion();
        this.myContext.getDaemonAnalyzer().stop();
        for (Configurable each : this.myName2Config) {
            each.disposeUIResources();
        }
        this.myContext.clear();
        this.myName2Config.clear();
        this.myModuleConfigurator.getFacetsConfigurator().clearMaps();
        this.myWasIntialized = false;
    }

    public History getHistory() {
        return this.myHistory;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable.queryPlace must not be null");
        }
        place.putPath(CATEGORY, (Object)this.mySelectedConfigurable);
        Place.queryFurther((Object)this.mySelectedConfigurable, (Place)place);
    }

    public ActionCallback selectProjectGeneralSettings(boolean requestFocus) {
        Place place = new Place().putPath(CATEGORY, (Object)this.myProjectConfig);
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@Nullable String moduleToSelect, String tab, boolean requestFocus) {
        Place place = new Place().putPath(CATEGORY, (Object)this.myModulesConfig);
        if (moduleToSelect != null) {
            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module != null);
            place = place.putPath("treeObject", (Object)module);
        }
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@Nullable Facet facetToSelect, boolean requestFocus) {
        Place place = new Place().putPath(CATEGORY, (Object)this.myModulesConfig);
        if (facetToSelect != null) {
            place = place.putPath("treeObject", (Object)facetToSelect);
        }
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@NotNull Sdk sdk, boolean requestFocus) {
        if (sdk == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable.select must not be null");
        }
        Place place = new Place().putPath(CATEGORY, (Object)this.myJdkListConfig);
        place.putPath("treeName", (Object)sdk.getName());
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback selectProjectOrGlobalLibrary(@NotNull Library library, boolean requestFocus) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable.selectProjectOrGlobalLibrary must not be null");
        }
        Place place = new Place().putPath(CATEGORY, (Object)this.getConfigurableFor(library));
        place.putPath("treeName", (Object)library.getName());
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@Nullable Artifact artifact, boolean requestFocus) {
        Place place = new Place().putPath(CATEGORY, (Object)this.myArtifactsStructureConfigurable);
        if (artifact != null) {
            place.putPath("treeName", (Object)artifact.getName());
        }
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@NotNull LibraryOrderEntry libraryOrderEntry, boolean requestFocus) {
        if (libraryOrderEntry == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable.select must not be null");
        }
        Library lib = libraryOrderEntry.getLibrary();
        if (lib == null || lib.getTable() == null) {
            Place place = new Place().putPath(CATEGORY, (Object)this.myModulesConfig);
            place.putPath("treeObject", (Object)libraryOrderEntry.getOwnerModule());
            return this.navigateTo(place, requestFocus);
        }
        Place place = new Place().putPath(CATEGORY, (Object)this.getConfigurableFor(lib));
        place.putPath("treeName", (Object)libraryOrderEntry.getLibraryName());
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Configurable toSelect = (Configurable)place.getPath(CATEGORY);
        JComponent detailsContent = this.myDetails.getTargetComponent();
        if (this.mySelectedConfigurable != toSelect) {
            this.saveSideProportion();
            this.removeSelected();
            if (toSelect != null) {
                detailsContent = toSelect.createComponent();
                this.myDetails.setContent(detailsContent);
            }
            this.mySelectedConfigurable = toSelect;
            if (this.mySelectedConfigurable != null) {
                this.myUiState.lastEditedConfigurable = this.mySelectedConfigurable.getDisplayName();
            }
            if (toSelect instanceof MasterDetailsComponent) {
                MasterDetailsComponent masterDetails = (MasterDetailsComponent)toSelect;
                if (this.myUiState.sideProportion > 0.0f) {
                    masterDetails.getSplitter().setProportion(this.myUiState.sideProportion);
                }
                masterDetails.setHistory(this.myHistory);
            }
            if (toSelect instanceof DetailsComponent.Facade) {
                ((DetailsComponent.Facade)toSelect).getDetailsComponent().setBannerMinHeight(this.myToolbarComponent.getPreferredSize().height);
            }
        }
        if (detailsContent != null) {
            JComponent toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(detailsContent);
            if (toFocus == null) {
                toFocus = detailsContent;
            }
            if (requestFocus) {
                this.myToFocus = toFocus;
                UIUtil.requestFocus((JComponent)toFocus);
            }
        }
        ActionCallback result = new ActionCallback();
        Place.goFurther((Object)toSelect, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        this.myDetails.revalidate();
        this.myDetails.repaint();
        if (toSelect != null) {
            this.mySidePanel.select(ProjectStructureConfigurable.createPlaceFor(toSelect));
        }
        if (!this.myHistory.isNavigatingNow() && this.mySelectedConfigurable != null) {
            this.myHistory.pushQueryPlace();
        }
        return result;
    }

    private void saveSideProportion() {
        if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.mySelectedConfigurable).getSplitter().getProportion();
        }
    }

    private void removeSelected() {
        this.myDetails.removeAll();
        this.mySelectedConfigurable = null;
        this.myUiState.lastEditedConfigurable = null;
        this.myDetails.add((Component)this.myEmptySelection, (Object)"Center");
    }

    public static ProjectStructureConfigurable getInstance(Project project) {
        return (ProjectStructureConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, ProjectStructureConfigurable.class);
    }

    public ProjectJdksModel getProjectJdksModel() {
        return this.myProjectJdksModel;
    }

    public JdkListConfigurable getJdkConfig() {
        return this.myJdkListConfig;
    }

    public ProjectLibrariesConfigurable getProjectLibrariesConfig() {
        return this.myProjectLibrariesConfig;
    }

    public GlobalLibrariesConfigurable getGlobalLibrariesConfig() {
        return this.myGlobalLibrariesConfig;
    }

    public ModuleStructureConfigurable getModulesConfig() {
        return this.myModulesConfig;
    }

    public ProjectConfigurable getProjectConfig() {
        return this.myProjectConfig;
    }

    private void addConfigurable(Configurable configurable) {
        this.myName2Config.add(configurable);
        this.mySidePanel.addPlace(ProjectStructureConfigurable.createPlaceFor(configurable), new Presentation(configurable.getDisplayName()));
    }

    private static Place createPlaceFor(Configurable configurable) {
        return new Place().putPath(CATEGORY, (Object)configurable);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    public BaseLibrariesConfigurable getConfigurableFor(Library library) {
        if ("project".equals(library.getTable().getTableLevel())) {
            return this.myProjectLibrariesConfig;
        }
        return this.myGlobalLibrariesConfig;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(dataId)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1024, 768);
        }
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        public String lastEditedConfigurable;
    }
}

