/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JavadocEditor
extends ModuleElementsEditor {
    private JTable myTable;
    private JButton myAddPathButton;
    private JButton myAddUrlButton;
    private JButton myRemoveButton;
    public static final String NAME = ProjectBundle.message((String)"module.javadoc.title", (Object[])new Object[0]);
    public static final Icon ICON = IconLoader.getIcon((String)"/modules/javadoc.png");

    public JavadocEditor(ModuleConfigurationState state) {
        super(state);
    }

    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    public String getDisplayName() {
        return NAME;
    }

    public Icon getIcon() {
        return ICON;
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.myTable);
        int count = this.myTable.getRowCount();
        String[] urls = ArrayUtil.newStringArray((int)count);
        for (int row = 0; row < count; ++row) {
            TableItem item = ((MyTableModel)this.myTable.getModel()).getTableItemAt(row);
            urls[row] = item.getUrl();
        }
        this.getModel().setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    @Override
    public JComponent createComponentImpl() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        mainPanel.setPreferredSize(new Dimension(-1, 200));
        DefaultTableModel tableModel = this.createModel();
        this.myTable = new Table((TableModel)tableModel);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new MyRenderer()));
        this.myTable.setShowGrid(false);
        this.myTable.setDragEnabled(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myAddPathButton = new JButton(ProjectBundle.message((String)"module.javadoc.add.path.button", (Object[])new Object[0]));
        this.myAddPathButton.addActionListener(new AddPathActionListener());
        this.myAddUrlButton = new JButton(ProjectBundle.message((String)"module.javadoc.add.url.button", (Object[])new Object[0]));
        this.myAddUrlButton.addActionListener(new AddUrlActionListener());
        this.myRemoveButton = new JButton(ProjectBundle.message((String)"module.javadoc.remove.button", (Object[])new Object[0]));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List removedItems = TableUtil.removeSelectedItems((JTable)JavadocEditor.this.myTable);
                if (removedItems.size() > 0) {
                    JavadocEditor.this.saveData();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myAddPathButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        panel.add((Component)this.myAddUrlButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(6, 6, 0, 0), 0, 0));
        panel.add((Component)this.myRemoveButton, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(6, 6, 0, 0), 0, 0));
        mainPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTable), "Center");
        mainPanel.add((Component)panel, "East");
        PanelWithText panelWithText = new PanelWithText(ProjectBundle.message((String)"project.roots.javadoc.tab.description", (Object[])new Object[0]));
        panelWithText.setBorder(null);
        mainPanel.add((Component)panelWithText, "North");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selectedIndex = JavadocEditor.this.myTable.getSelectedRow();
                JavadocEditor.this.myRemoveButton.setEnabled(selectedIndex >= 0);
            }
        });
        if (tableModel.getRowCount() > 0) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{0});
        } else {
            this.myRemoveButton.setEnabled(false);
        }
        return mainPanel;
    }

    protected DefaultTableModel createModel() {
        String[] javadocUrls;
        MyTableModel tableModel = new MyTableModel();
        for (String javadocUrl : javadocUrls = this.getModel().getRootUrls(JavadocOrderRootType.getInstance())) {
            tableModel.addTableItem(new TableItem(javadocUrl));
        }
        return tableModel;
    }

    @Override
    public void moduleStateChanged() {
        if (this.myTable != null) {
            DefaultTableModel tableModel = this.createModel();
            this.myTable.setModel(tableModel);
            this.myRemoveButton.setEnabled(tableModel.getRowCount() > 0);
        }
    }

    private class AddPathActionListener
    extends MyAddAction {
        private final FileChooserDescriptor myDescriptor;

        public AddPathActionListener() {
            this.myDescriptor = new FileChooserDescriptor(false, true, true, false, true, true);
            this.myDescriptor.setTitle(ProjectBundle.message((String)"module.javadoc.add.path.title", (Object[])new Object[0]));
            this.myDescriptor.setDescription(ProjectBundle.message((String)"module.javadoc.add.path.prompt", (Object[])new Object[0]));
        }

        @Override
        protected VirtualFile[] getFiles() {
            VirtualFile[] files = FileChooser.chooseFiles((Component)JavadocEditor.this.myTable, (FileChooserDescriptor)this.myDescriptor);
            return files != null ? files : VirtualFile.EMPTY_ARRAY;
        }
    }

    private class AddUrlActionListener
    extends MyAddAction {
        private AddUrlActionListener() {
        }

        @Override
        protected VirtualFile[] getFiles() {
            return new VirtualFile[]{Util.showSpecifyJavadocUrlDialog(JavadocEditor.this.myTable)};
        }
    }

    private abstract class MyAddAction
    implements ActionListener {
        private MyAddAction() {
        }

        protected abstract VirtualFile[] getFiles();

        @Override
        public void actionPerformed(ActionEvent e) {
            VirtualFile[] files = this.getFiles();
            MyTableModel tableModel = (MyTableModel)JavadocEditor.this.myTable.getModel();
            boolean changes = false;
            for (VirtualFile file : files) {
                if (file == null) continue;
                tableModel.addTableItem(new TableItem(file));
                changes = true;
            }
            if (changes) {
                JavadocEditor.this.saveData();
                TableUtil.selectRows((JTable)JavadocEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
            }
        }
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements ItemRemovable {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return TableItem.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public TableItem getTableItemAt(int row) {
            return (TableItem)this.getValueAt(row, 0);
        }

        public void addTableItem(TableItem item) {
            this.addRow(new Object[]{item});
        }
    }

    private static class TableItem {
        private final String myUrl;
        private final CellAppearance myCellAppearance;

        public TableItem(VirtualFile file) {
            this.myUrl = file.getUrl();
            this.myCellAppearance = CellAppearanceUtils.forVirtualFile((VirtualFile)file);
        }

        public TableItem(String url) {
            this.myUrl = url;
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            this.myCellAppearance = file != null ? CellAppearanceUtils.forVirtualFile((VirtualFile)file) : SimpleTextCellAppearance.invalid((String)url, (Icon)CellAppearanceUtils.INVALID_ICON);
        }

        public String getUrl() {
            return this.myUrl;
        }

        public CellAppearance getCellAppearance() {
            return this.myCellAppearance;
        }
    }

    private static class MyRenderer
    extends ColoredTableCellRenderer {
        private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private MyRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(NO_FOCUS_BORDER);
            TableItem tableItem = (TableItem)value;
            if (tableItem != null) {
                tableItem.getCellAppearance().customize((SimpleColoredComponent)this);
            }
        }
    }
}

