/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryTableBase
implements PersistentStateComponent<Element>,
LibraryTable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.libraries.LibraryTableBase");
    private final EventDispatcher<LibraryTable.Listener> myDispatcher = EventDispatcher.create(LibraryTable.Listener.class);
    private LibraryModel myModel = new LibraryModel();
    private boolean myFirstLoad = true;

    public LibraryTable.ModifiableModel getModifiableModel() {
        return new LibraryModel(this.myModel);
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            this.myModel.writeExternal(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void loadState(Element element) {
        try {
            if (this.myFirstLoad) {
                this.myModel.readExternal(element);
            } else {
                LibraryModel model = new LibraryModel();
                model.readExternal(element);
                this.commit(model);
            }
            this.myFirstLoad = false;
        }
        catch (InvalidDataException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.myModel.getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTableBase.getLibraries must not return null");
        }
        return libraryArray;
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator<Library> iterator = this.myModel.getLibraryIterator();
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTableBase.getLibraryIterator must not return null");
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTableBase.getLibraryByName must not be null");
        }
        return this.myModel.getLibraryByName(name);
    }

    public void addListener(LibraryTable.Listener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void addListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void removeListener(LibraryTable.Listener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private void fireLibraryAdded(Library library) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireLibraryAdded: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryAdded(library);
    }

    private void fireBeforeLibraryRemoved(Library library) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fireBeforeLibraryRemoved: " + library);
        }
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).beforeLibraryRemoved(library);
    }

    public void dispose() {
        for (Library library : this.getLibraries()) {
            Disposer.dispose((Disposable)library);
        }
    }

    public Library createLibrary() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        return this.createLibrary(null);
    }

    public void fireLibraryRenamed(LibraryImpl library) {
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRenamed((Library)library);
    }

    public Library createLibrary(String name) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        Library library = modifiableModel.createLibrary(name);
        modifiableModel.commit();
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTableBase.removeLibrary must not be null");
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    private void commit(LibraryModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ArrayList addedLibraries = new ArrayList(model.myLibraries);
        addedLibraries.removeAll(this.myModel.myLibraries);
        ArrayList removedLibraries = new ArrayList(this.myModel.myLibraries);
        removedLibraries.removeAll(model.myLibraries);
        for (Library library : removedLibraries) {
            this.fireBeforeLibraryRemoved(library);
        }
        this.myModel = model;
        for (Library library : removedLibraries) {
            Disposer.dispose((Disposable)library);
            this.fireAfterLibraryRemoved(library);
        }
        for (Library library : addedLibraries) {
            this.fireLibraryAdded(library);
        }
    }

    private void fireAfterLibraryRemoved(Library library) {
        ((LibraryTable.Listener)this.myDispatcher.getMulticaster()).afterLibraryRemoved(library);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myModel = new LibraryModel();
        this.myModel.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myModel.writeExternal(element);
    }

    public class LibraryModel
    implements LibraryTable.ModifiableModel,
    JDOMExternalizable {
        private final ArrayList<Library> myLibraries = new ArrayList();
        private boolean myWritable;

        private LibraryModel() {
            this.myWritable = false;
        }

        private LibraryModel(LibraryModel that) {
            this.myWritable = true;
            this.myLibraries.addAll(that.myLibraries);
        }

        public void commit() {
            this.myWritable = false;
            LibraryTableBase.this.commit(this);
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            Iterator<Library> iterator = Collections.unmodifiableList(this.myLibraries).iterator();
            if (iterator == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel.getLibraryIterator must not return null");
            }
            return iterator;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name) {
            LibraryImpl library;
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel.getLibraryByName must not be null");
            }
            for (Library myLibrary : this.myLibraries) {
                library = (LibraryImpl)myLibrary;
                if (!Comparing.equal((String)name, (String)library.getName())) continue;
                return library;
            }
            String libraryPrefix = "library.";
            String libPath = System.getProperty("library." + name);
            if (libPath != null) {
                library = new LibraryImpl(name, LibraryTableBase.this, null);
                library.addRoot(libPath, OrderRootType.CLASSES);
                return library;
            }
            return null;
        }

        @NotNull
        public Library[] getLibraries() {
            Library[] libraryArray = this.myLibraries.toArray(new Library[this.myLibraries.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel.getLibraries must not return null");
            }
            return libraryArray;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myWritable);
        }

        public Library createLibrary(String name) {
            this.assertWritable();
            LibraryImpl library = new LibraryImpl(name, LibraryTableBase.this, null);
            this.myLibraries.add(library);
            return library;
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryTableBase$LibraryModel.removeLibrary must not be null");
            }
            this.assertWritable();
            this.myLibraries.remove(library);
        }

        public boolean isChanged() {
            if (!this.myWritable) {
                return false;
            }
            HashSet thisLibraries = new HashSet(this.myLibraries);
            HashSet thatLibraries = new HashSet(((LibraryTableBase)LibraryTableBase.this).myModel.myLibraries);
            return !thisLibraries.equals(thatLibraries);
        }

        public void readExternal(Element element) throws InvalidDataException {
            HashMap<String, Library> libraries = new HashMap<String, Library>();
            for (Library library : this.myLibraries) {
                libraries.put(library.getName(), library);
            }
            List libraryElements = element.getChildren("library");
            for (Object libraryElement1 : libraryElements) {
                Element libraryElement = (Element)libraryElement1;
                LibraryImpl library = new LibraryImpl(LibraryTableBase.this, libraryElement, null);
                if (library.getName() != null) {
                    Library oldLibrary = (Library)libraries.get(library.getName());
                    if (oldLibrary != null) {
                        this.removeLibrary(oldLibrary);
                    }
                    this.myLibraries.add(library);
                    LibraryTableBase.this.fireLibraryAdded(library);
                    continue;
                }
                Disposer.dispose((Disposable)library);
            }
        }

        public void writeExternal(Element element) throws WriteExternalException {
            for (Library library : this.myLibraries) {
                if (library.getName() == null || ((LibraryEx)library).isDisposed()) continue;
                library.writeExternal(element);
            }
        }
    }
}

