/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class LibraryOrderEntryBaseImpl
extends OrderEntryBaseImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl");
    protected final ProjectRootManagerImpl myProjectRootManagerImpl;
    @NotNull
    protected DependencyScope myScope = DependencyScope.COMPILE;
    private final MyRootSetChangedListener myRootSetChangedListener = new MyRootSetChangedListener();
    private RootProvider myCurrentlySubscribedRootProvider = null;

    LibraryOrderEntryBaseImpl(RootModelImpl rootModel, ProjectRootManagerImpl instanceImpl) {
        super(rootModel);
        this.myProjectRootManagerImpl = instanceImpl;
    }

    protected final void init() {
        this.updateFromRootProviderAndSubscribe();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray;
        if (type == OrderRootType.COMPILATION_CLASSES) {
            virtualFileArray = this.getRootFiles(OrderRootType.CLASSES);
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getFiles must not return null");
            return virtualFileArray;
        }
        if (type == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
            if (this.myScope == DependencyScope.RUNTIME || this.myScope == DependencyScope.TEST) {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
                if (VirtualFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getFiles must not return null");
                return virtualFileArray;
            } else {
                virtualFileArray = this.getRootFiles(OrderRootType.CLASSES);
                if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getFiles must not return null");
                return virtualFileArray;
            }
        }
        if (type == OrderRootType.CLASSES_AND_OUTPUT) {
            virtualFileArray = this.myScope == DependencyScope.PROVIDED ? VirtualFile.EMPTY_ARRAY : this.getRootFiles(OrderRootType.CLASSES);
            if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getFiles must not return null");
            return virtualFileArray;
        }
        virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray != null) return virtualFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getFiles must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String[] getUrls(OrderRootType type) {
        String[] stringArray;
        LOG.assertTrue(!this.getRootModel().getModule().isDisposed());
        RootProvider rootProvider = this.getRootProvider();
        if (rootProvider == null) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
            return stringArray;
        }
        if (type == OrderRootType.COMPILATION_CLASSES) {
            stringArray = rootProvider.getUrls(OrderRootType.CLASSES);
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
            return stringArray;
        }
        if (type == OrderRootType.PRODUCTION_COMPILATION_CLASSES) {
            if (this.myScope == DependencyScope.RUNTIME || this.myScope == DependencyScope.TEST) {
                stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                if (ArrayUtil.EMPTY_STRING_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
                return stringArray;
            } else {
                stringArray = rootProvider.getUrls(OrderRootType.CLASSES);
                if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
                return stringArray;
            }
        }
        if (type == OrderRootType.CLASSES_AND_OUTPUT) {
            stringArray = this.myScope == DependencyScope.PROVIDED ? ArrayUtil.EMPTY_STRING_ARRAY : rootProvider.getUrls(OrderRootType.CLASSES);
            if (stringArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
            return stringArray;
        }
        stringArray = rootProvider.getUrls(type);
        if (stringArray != null) return stringArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getUrls must not return null");
    }

    public VirtualFile[] getRootFiles(OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider == null ? VirtualFile.EMPTY_ARRAY : LibraryOrderEntryBaseImpl.filterDirectories(rootProvider.getFiles(type));
    }

    private static VirtualFile[] filterDirectories(VirtualFile[] files) {
        List filtered = ContainerUtil.mapNotNull((Object[])files, (Function)new Function<VirtualFile, VirtualFile>(){

            public VirtualFile fun(VirtualFile file) {
                return file.isDirectory() ? file : null;
            }
        });
        return VfsUtil.toVirtualFileArray((Collection)filtered);
    }

    protected abstract RootProvider getRootProvider();

    public String[] getRootUrls(OrderRootType type) {
        RootProvider rootProvider = this.getRootProvider();
        return rootProvider == null ? ArrayUtil.EMPTY_STRING_ARRAY : rootProvider.getUrls(type);
    }

    @NotNull
    public final Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl.getOwnerModule must not return null");
        }
        return module;
    }

    protected void updateFromRootProviderAndSubscribe() {
        this.getRootModel().makeExternalChange(new Runnable(){

            @Override
            public void run() {
                LibraryOrderEntryBaseImpl.this.resubscribe(LibraryOrderEntryBaseImpl.this.getRootProvider());
            }
        });
    }

    private void resubscribe(RootProvider wrapper) {
        this.unsubscribe();
        this.subscribe(wrapper);
    }

    private void subscribe(RootProvider wrapper) {
        if (wrapper != null) {
            this.addListenerToWrapper(wrapper, this.myRootSetChangedListener);
        }
        this.myCurrentlySubscribedRootProvider = wrapper;
    }

    private void addListenerToWrapper(RootProvider wrapper, RootProvider.RootSetChangedListener rootSetChangedListener) {
        this.myProjectRootManagerImpl.addRootSetChangedListener(rootSetChangedListener, wrapper);
    }

    private void unsubscribe() {
        if (this.myCurrentlySubscribedRootProvider != null) {
            RootProvider wrapper = this.myCurrentlySubscribedRootProvider;
            this.removeListenerFromWrapper(wrapper, this.myRootSetChangedListener);
        }
        this.myCurrentlySubscribedRootProvider = null;
    }

    protected void removeListenerFromWrapper(RootProvider wrapper, RootProvider.RootSetChangedListener rootSetChangedListener) {
        this.myProjectRootManagerImpl.removeRootSetChangedListener(rootSetChangedListener, wrapper);
    }

    @Override
    public void dispose() {
        this.unsubscribe();
        super.dispose();
    }

    private class MyRootSetChangedListener
    implements RootProvider.RootSetChangedListener {
        private MyRootSetChangedListener() {
        }

        public void rootSetChanged(RootProvider wrapper) {
            LibraryOrderEntryBaseImpl.this.updateFromRootProviderAndSubscribe();
        }
    }
}

