/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfo {
    public Module module;
    public boolean isInModuleSource;
    public boolean isTestSource;
    public boolean isInLibrarySource;
    public VirtualFile libraryClassRoot;
    public VirtualFile contentRoot;
    public VirtualFile sourceRoot;
    private List<OrderEntry> orderEntries = null;

    public boolean equals(Object o) {
        assert (ApplicationManager.getApplication().isUnitTestMode()) : "DirectoryInfo.equals should only be used in tests";
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryInfo)) {
            return false;
        }
        DirectoryInfo info = (DirectoryInfo)o;
        if (this.isInLibrarySource != info.isInLibrarySource) {
            return false;
        }
        if (this.isInModuleSource != info.isInModuleSource) {
            return false;
        }
        if (this.isTestSource != info.isTestSource) {
            return false;
        }
        if (this.module != null ? !this.module.equals(info.module) : info.module != null) {
            return false;
        }
        if (this.orderEntries != null ? !new HashSet<OrderEntry>(this.orderEntries).equals(new HashSet<OrderEntry>(info.orderEntries)) : info.orderEntries != null) {
            return false;
        }
        if (!Comparing.equal((Object)this.libraryClassRoot, (Object)info.libraryClassRoot)) {
            return false;
        }
        if (!Comparing.equal((Object)this.contentRoot, (Object)info.contentRoot)) {
            return false;
        }
        return Comparing.equal((Object)this.sourceRoot, (Object)info.sourceRoot);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("DirectoryInfo shall not be used as a key to HashMap");
    }

    public String toString() {
        return "DirectoryInfo{module=" + this.module + ", isInModuleSource=" + this.isInModuleSource + ", isTestSource=" + this.isTestSource + ", isInLibrarySource=" + this.isInLibrarySource + ", libraryClassRoot=" + this.libraryClassRoot + ", contentRoot=" + this.contentRoot + ", sourceRoot=" + this.sourceRoot + "}";
    }

    public List<OrderEntry> getOrderEntries() {
        return this.orderEntries == null ? Collections.emptyList() : this.orderEntries;
    }

    public void addOrderEntries(List<OrderEntry> orderEntries, @Nullable DirectoryInfo parentInfo, @Nullable List<OrderEntry> oldParentEntries) {
        if (orderEntries.isEmpty()) {
            this.orderEntries = null;
        } else if (this.orderEntries == null) {
            this.orderEntries = orderEntries;
        } else if (parentInfo != null && oldParentEntries == this.orderEntries) {
            this.orderEntries = parentInfo.orderEntries;
        } else {
            LinkedHashSet<OrderEntry> tmp = new LinkedHashSet<OrderEntry>(this.orderEntries.size() + orderEntries.size());
            tmp.addAll(this.orderEntries);
            tmp.addAll(orderEntries);
            this.orderEntries = new ArrayList<OrderEntry>(tmp);
        }
    }
}

