/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ExcludedOutputFolder;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.ExcludeFolderImpl;
import com.intellij.openapi.roots.impl.ExcludedOutputFolderImpl;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.SourceFolderImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ContentEntryImpl
extends RootModelComponentBase
implements ContentEntry,
ClonableContentEntry,
Comparable<ContentEntryImpl> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.SimpleContentEntryImpl");
    private final VirtualFilePointer myRoot;
    @NonNls
    public static final String ELEMENT_NAME = "content";
    private final LinkedHashSet<SourceFolder> mySourceFolders = new LinkedHashSet();
    private final TreeSet<ExcludeFolder> myExcludeFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
    private final TreeSet<ExcludedOutputFolder> myExcludedOutputFolders = new TreeSet<ContentFolder>(ContentFolderComparator.INSTANCE);
    @NonNls
    public static final String URL_ATTRIBUTE = "url";

    ContentEntryImpl(VirtualFile file, RootModelImpl m) {
        this(file.getUrl(), m);
    }

    ContentEntryImpl(String url, RootModelImpl m) {
        super(m);
        this.myRoot = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, m.myVirtualFilePointerListener);
    }

    ContentEntryImpl(Element e, RootModelImpl m) throws InvalidDataException {
        this(ContentEntryImpl.getUrlFrom(e), m);
        this.initSourceFolders(e);
        this.initExcludeFolders(e);
    }

    private static String getUrlFrom(Element e) throws InvalidDataException {
        LOG.assertTrue(ELEMENT_NAME.equals(e.getName()));
        String url = e.getAttributeValue(URL_ATTRIBUTE);
        if (url == null) {
            throw new InvalidDataException();
        }
        return url;
    }

    private void initSourceFolders(Element e) throws InvalidDataException {
        this.mySourceFolders.clear();
        for (Object child : e.getChildren("sourceFolder")) {
            this.mySourceFolders.add(new SourceFolderImpl((Element)child, this));
        }
    }

    private void initExcludeFolders(Element e) throws InvalidDataException {
        this.myExcludeFolders.clear();
        for (Object child : e.getChildren("excludeFolder")) {
            this.myExcludeFolders.add((ExcludeFolder)new ExcludeFolderImpl((Element)child, this));
        }
    }

    public VirtualFile getFile() {
        VirtualFile file = this.myRoot.getFile();
        return file == null || !file.isDirectory() ? null : file;
    }

    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/ContentEntryImpl.getUrl must not return null");
        }
        return string;
    }

    public SourceFolder[] getSourceFolders() {
        return this.mySourceFolders.toArray(new SourceFolder[this.mySourceFolders.size()]);
    }

    public VirtualFile[] getSourceFolderFiles() {
        assert (!this.isDisposed());
        SourceFolder[] sourceFolders = this.getSourceFolders();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(sourceFolders.length);
        for (SourceFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result.add(file);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public ExcludeFolder[] getExcludeFolders() {
        ArrayList<ExcludeFolder> result = new ArrayList<ExcludeFolder>(this.myExcludeFolders);
        for (DirectoryIndexExcludePolicy excludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.getRootModel().getProject())) {
            VirtualFilePointer[] files;
            for (VirtualFilePointer file : files = excludePolicy.getExcludeRootsForModule((ModuleRootModel)this.getRootModel())) {
                this.addExcludeForOutputPath(file, result);
            }
        }
        if (this.getRootModel().isExcludeExplodedDirectory()) {
            this.addExcludeForOutputPath(this.getRootModel().myExplodedDirectoryPointer, result);
        }
        return result.toArray(new ExcludeFolder[result.size()]);
    }

    private void addExcludeForOutputPath(VirtualFilePointer outputPath, ArrayList<ExcludeFolder> result) {
        if (outputPath == null) {
            return;
        }
        VirtualFile outputPathFile = outputPath.getFile();
        VirtualFile file = this.myRoot.getFile();
        if (outputPathFile != null && file != null) {
            result.add((ExcludeFolder)new ExcludedOutputFolderImpl(this, outputPath));
        }
    }

    public VirtualFile[] getExcludeFolderFiles() {
        assert (!this.isDisposed());
        ExcludeFolder[] excludeFolders = this.getExcludeFolders();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ExcludeFolder excludeFolder : excludeFolders) {
            VirtualFile file = excludeFolder.getFile();
            if (file == null) continue;
            result.add(file);
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addSourceFolder must not be null");
        }
        this.assertCanAddFolder(file);
        return this.addSourceFolder(new SourceFolderImpl(file, isTestSource, this));
    }

    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addSourceFolder must not be null");
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addSourceFolder must not be null");
        }
        this.assertCanAddFolder(file);
        return this.addSourceFolder(new SourceFolderImpl(file, isTestSource, packagePrefix, this));
    }

    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addSourceFolder must not be null");
        }
        this.assertFolderUnderMe(url);
        return this.addSourceFolder(new SourceFolderImpl(url, isTestSource, this));
    }

    private SourceFolder addSourceFolder(SourceFolderImpl f) {
        this.mySourceFolders.add(f);
        return f;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.removeSourceFolder must not be null");
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(sourceFolder, this.mySourceFolders);
        this.mySourceFolders.remove(sourceFolder);
    }

    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addExcludeFolder must not be null");
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(file);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(file, this));
    }

    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.addExcludeFolder must not be null");
        }
        assert (!this.isDisposed());
        this.assertCanAddFolder(url);
        return this.addExcludeFolder((ExcludeFolder)new ExcludeFolderImpl(url, this));
    }

    private void assertCanAddFolder(VirtualFile file) {
        this.assertCanAddFolder(file.getUrl());
    }

    private void assertCanAddFolder(String url) {
        this.getRootModel().assertWritable();
        this.assertFolderUnderMe(url);
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/ContentEntryImpl.removeExcludeFolder must not be null");
        }
        assert (!this.isDisposed());
        this.assertCanRemoveFrom(excludeFolder, this.myExcludeFolders);
        this.myExcludeFolders.remove(excludeFolder);
    }

    private ExcludeFolder addExcludeFolder(ExcludeFolder f) {
        this.myExcludeFolders.add(f);
        return f;
    }

    private <T extends ContentFolder> void assertCanRemoveFrom(T f, Set<T> ff) {
        this.getRootModel().assertWritable();
        LOG.assertTrue(ff.contains(f));
    }

    private void assertFolderUnderMe(String url) {
        String rootUrl = this.getUrl();
        try {
            if (!FileUtil.isAncestor((File)new File(rootUrl), (File)new File(url), (boolean)false)) {
                LOG.error("The file " + url + " is not under content entry root " + rootUrl);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSynthetic() {
        return false;
    }

    @Override
    public ContentEntry cloneEntry(RootModelImpl rootModel) {
        ContentFolder folder;
        assert (!this.isDisposed());
        ContentEntryImpl cloned = new ContentEntryImpl(this.myRoot.getUrl(), rootModel);
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)sourceFolder).cloneFolder(cloned);
            cloned.mySourceFolders.add((SourceFolder)folder);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)excludeFolder).cloneFolder(cloned);
            cloned.myExcludeFolders.add((ExcludeFolder)folder);
        }
        for (ExcludedOutputFolder excludedOutputFolder : this.myExcludedOutputFolders) {
            if (!(excludedOutputFolder instanceof ClonableContentFolder)) continue;
            folder = ((ClonableContentFolder)excludedOutputFolder).cloneFolder(cloned);
            cloned.myExcludedOutputFolders.add((ExcludedOutputFolder)folder);
        }
        return cloned;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SourceFolder mySourceFolder : this.mySourceFolders) {
            ContentFolder contentFolder = (ContentFolder)mySourceFolder;
            Disposer.dispose((Disposable)((Disposable)contentFolder));
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)((Disposable)excludeFolder));
        }
    }

    @Override
    protected void projectOpened() {
        super.projectOpened();
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            ((RootModelComponentBase)sourceFolder).projectOpened();
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            ((RootModelComponentBase)excludeFolder).projectOpened();
        }
        for (ExcludedOutputFolder excludedOutputFolder : this.myExcludedOutputFolders) {
            ((RootModelComponentBase)excludedOutputFolder).projectOpened();
        }
    }

    @Override
    protected void projectClosed() {
        super.projectClosed();
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            ((RootModelComponentBase)sourceFolder).projectClosed();
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            ((RootModelComponentBase)excludeFolder).projectClosed();
        }
        for (ExcludedOutputFolder excludedOutputFolder : this.myExcludedOutputFolders) {
            ((RootModelComponentBase)excludedOutputFolder).projectClosed();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element subElement;
        assert (!this.isDisposed());
        LOG.assertTrue(ELEMENT_NAME.equals(element.getName()));
        element.setAttribute(URL_ATTRIBUTE, this.myRoot.getUrl());
        for (SourceFolder sourceFolder : this.mySourceFolders) {
            if (!(sourceFolder instanceof SourceFolderImpl)) continue;
            subElement = new Element("sourceFolder");
            ((SourceFolderImpl)sourceFolder).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (ExcludeFolder excludeFolder : this.myExcludeFolders) {
            if (!(excludeFolder instanceof ExcludeFolderImpl)) continue;
            subElement = new Element("excludeFolder");
            ((ExcludeFolderImpl)excludeFolder).writeExternal(subElement);
            element.addContent(subElement);
        }
    }

    @Override
    public int compareTo(ContentEntryImpl other) {
        int i = this.getUrl().compareTo(other.getUrl());
        if (i != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare((Object[])this.getSourceFolders(), (Object[])other.getSourceFolders());
        if (i != 0) {
            return i;
        }
        i = ArrayUtil.lexicographicCompare((Object[])this.getExcludeFolders(), (Object[])other.getExcludeFolders());
        if (i != 0) {
            return i;
        }
        Object[] excludedOutputFolders = this.myExcludedOutputFolders.toArray(new ExcludedOutputFolder[this.myExcludedOutputFolders.size()]);
        Object[] otherExcludedOutputFolders = other.myExcludedOutputFolders.toArray(new ExcludedOutputFolder[other.myExcludedOutputFolders.size()]);
        return ArrayUtil.lexicographicCompare((Object[])excludedOutputFolders, (Object[])otherExcludedOutputFolders);
    }

    private static final class ContentFolderComparator
    implements Comparator<ContentFolder> {
        public static final ContentFolderComparator INSTANCE = new ContentFolderComparator();

        private ContentFolderComparator() {
        }

        @Override
        public int compare(ContentFolder o1, ContentFolder o2) {
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

