/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.UnknownSdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageListenerList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectJdkTable", roamingType=RoamingType.DISABLED, storages={@Storage(id="other", file="$APP_CONFIG$/jdk.table.xml")})
public class ProjectJdkTableImpl
extends ProjectJdkTable
implements PersistentStateComponent<Element>,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectJdkTableImpl");
    private final List<Sdk> mySdks = new ArrayList<Sdk>();
    private final MessageListenerList<ProjectJdkTable.Listener> myListenerList;
    @NonNls
    private static final String ELEMENT_JDK = "jdk";
    private final Map<String, ProjectJdkImpl> myCachedProjectJdks = new HashMap<String, ProjectJdkImpl>();
    private final MessageBus myMessageBus = ApplicationManager.getApplication().getMessageBus();

    public ProjectJdkTableImpl() {
        this.myListenerList = new MessageListenerList(this.myMessageBus, JDK_TABLE_TOPIC);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(VirtualFileEvent event) {
                this.updateJdks(event.getFile());
            }

            private void updateJdks(VirtualFile file) {
                if (file.isDirectory() || !StdFileTypes.ARCHIVE.equals(file.getFileType())) {
                    return;
                }
                for (Sdk sdk : ProjectJdkTableImpl.this.mySdks) {
                    VirtualFile home;
                    SdkType sdkType = sdk.getSdkType();
                    if (!(sdkType instanceof JavaSdkType) || (home = sdk.getHomeDirectory()) == null || !VfsUtil.isAncestor((VirtualFile)home, (VirtualFile)file, (boolean)true)) continue;
                    sdkType.setupSdkPaths(sdk);
                    break;
                }
            }
        });
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"jdk.table")};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.table.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl.getPresentableName must not return null");
        }
        return string;
    }

    @Nullable
    public Sdk findJdk(String name) {
        for (Sdk jdk : this.mySdks) {
            if (!Comparing.strEqual((String)name, (String)jdk.getName())) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk findJdk(String name, String type) {
        SdkType[] sdkTypes;
        Sdk projectJdk = this.findJdk(name);
        if (projectJdk != null) {
            return projectJdk;
        }
        String sdkTypeName = this.getSdkTypeName(type);
        String uniqueName = sdkTypeName + "." + name;
        projectJdk = this.myCachedProjectJdks.get(uniqueName);
        if (projectJdk != null) {
            return projectJdk;
        }
        String jdkPrefix = "jdk.";
        String jdkPath = System.getProperty("jdk." + name);
        if (jdkPath == null) {
            return null;
        }
        for (SdkType sdkType : sdkTypes = SdkType.getAllTypes()) {
            if (!Comparing.strEqual((String)sdkTypeName, (String)sdkType.getName())) continue;
            if (!sdkType.isValidSdkHome(jdkPath)) break;
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name, sdkType);
            projectJdkImpl.setHomePath(jdkPath);
            sdkType.setupSdkPaths((Sdk)projectJdkImpl);
            this.myCachedProjectJdks.put(uniqueName, projectJdkImpl);
            return projectJdkImpl;
        }
        return null;
    }

    protected String getSdkTypeName(String type) {
        return type;
    }

    public Sdk[] getAllJdks() {
        return this.mySdks.toArray(new Sdk[this.mySdks.size()]);
    }

    public List<Sdk> getSdksOfType(SdkType type) {
        Sdk[] sdks;
        ArrayList<Sdk> result = new ArrayList<Sdk>();
        for (Sdk sdk : sdks = this.getAllJdks()) {
            if (sdk.getSdkType() != type) continue;
            result.add(sdk);
        }
        return result;
    }

    public Sdk findMostRecentSdkOfType(final SdkType type) {
        return this.findMostRecentSdk(new Condition<Sdk>(){

            public boolean value(Sdk sdk) {
                return sdk.getSdkType() == type;
            }
        });
    }

    public Sdk findMostRecentSdk(Condition<Sdk> condition) {
        Sdk found = null;
        for (Sdk each : this.getAllJdks()) {
            if (!condition.value((Object)each)) continue;
            if (found == null) {
                found = each;
                continue;
            }
            if (Comparing.compare((Comparable)((Object)each.getVersionString()), (Comparable)((Object)found.getVersionString())) <= 0) continue;
            found = each;
        }
        return found;
    }

    public void addJdk(Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.mySdks.add(jdk);
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkAdded(jdk);
    }

    public void removeJdk(Sdk jdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkRemoved(jdk);
        this.mySdks.remove(jdk);
    }

    public void updateJdk(Sdk originalJdk, Sdk modifiedJdk) {
        String previousName = originalJdk.getName();
        String newName = modifiedJdk.getName();
        ((ProjectJdkImpl)modifiedJdk).copyTo((ProjectJdkImpl)originalJdk);
        if (previousName != null ? !previousName.equals(newName) : newName != null) {
            ((ProjectJdkTable.Listener)this.myMessageBus.syncPublisher(JDK_TABLE_TOPIC)).jdkNameChanged(originalJdk, previousName);
        }
    }

    public void addListener(ProjectJdkTable.Listener listener) {
        this.myListenerList.add((Object)listener);
    }

    public void removeListener(ProjectJdkTable.Listener listener) {
        this.myListenerList.remove((Object)listener);
    }

    public SdkType getDefaultSdkType() {
        return UnknownSdkType.getInstance(null);
    }

    public Sdk createSdk(String name, SdkType sdkType) {
        return new ProjectJdkImpl(name, sdkType);
    }

    public void loadState(Element element) {
        this.mySdks.clear();
        List children = element.getChildren(ELEMENT_JDK);
        for (Object aChildren : children) {
            Element e = (Element)aChildren;
            ProjectJdkImpl jdk = new ProjectJdkImpl(null, null);
            try {
                jdk.readExternal(e);
            }
            catch (InvalidDataException ex) {
                LOG.error((Throwable)ex);
            }
            this.mySdks.add(jdk);
        }
    }

    public Element getState() {
        Element element = new Element("ProjectJdkTableImpl");
        for (Sdk jdk : this.mySdks) {
            Element e = new Element(ELEMENT_JDK);
            try {
                ((ProjectJdkImpl)jdk).writeExternal(e);
            }
            catch (WriteExternalException e1) {
                continue;
            }
            element.addContent(e);
        }
        return element;
    }
}

