/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkImpl
extends JavaSdk {
    @NonNls
    private static final String VM_EXE_NAME = "java";
    @NonNls
    private final Pattern myVersionStringPattern = Pattern.compile("^(.*)java version \"([1234567890_.]*)\"(.*)$");
    public static final Icon ICON = IconLoader.getIcon((String)"/nodes/ppJdkClosed.png");
    private static final Icon JDK_ICON_EXPANDED = IconLoader.getIcon((String)"/nodes/ppJdkOpen.png");
    private static final Icon ADD_ICON = IconLoader.getIcon((String)"/general/addJdk.png");
    @NonNls
    private static final String JAVA_VERSION_PREFIX = "java version ";
    private final Map<String, String> myCachedVersionStrings = new HashMap();

    public JavaSdkImpl() {
        super("JavaSDK");
    }

    public String getPresentableName() {
        return ProjectBundle.message((String)"sdk.java.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public Icon getIconForExpandedTreeNode() {
        return JDK_ICON_EXPANDED;
    }

    public Icon getIconForAddAction() {
        return ADD_ICON;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return null;
    }

    public void saveAdditionalData(SdkAdditionalData additionalData, Element additional) {
    }

    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    public String getBinPath(Sdk sdk) {
        return JavaSdkImpl.getConvertedHomePath(sdk) + "bin";
    }

    @NonNls
    public String getToolsPath(Sdk sdk) {
        String versionString = sdk.getVersionString();
        boolean isJdk1_x = versionString != null && (versionString.contains("1.0") || versionString.contains("1.1"));
        return JavaSdkImpl.getConvertedHomePath(sdk) + "lib" + File.separator + (isJdk1_x ? "classes.zip" : "tools.jar");
    }

    public String getVMExecutablePath(Sdk sdk) {
        return this.getBinPath(sdk) + File.separator + VM_EXE_NAME;
    }

    private static String getConvertedHomePath(Sdk sdk) {
        String path = sdk.getHomePath().replace('/', File.separatorChar);
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public String suggestHomePath() {
        if (SystemInfo.isMac) {
            return "/System/Library/Frameworks/JavaVM.framework/Versions/";
        }
        if (SystemInfo.isLinux) {
            return "/usr/lib/jvm/";
        }
        return null;
    }

    public boolean isValidSdkHome(String path) {
        return JavaSdkImpl.checkForJdk((File)new File(path));
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        String versionString;
        String versionString2;
        Matcher matcher;
        boolean replaceNameWithVersion;
        String suggestedName = currentSdkName != null && currentSdkName.length() > 0 ? ((replaceNameWithVersion = (matcher = this.myVersionStringPattern.matcher(currentSdkName)).matches()) ? ((versionString2 = this.getVersionString(sdkHome)) == null ? currentSdkName : matcher.replaceFirst("$1" + versionString2 + "$3")) : currentSdkName) : ((versionString = this.getVersionString(sdkHome)) != null ? JavaSdkImpl.getVersionNumber(versionString) : ProjectBundle.message((String)"sdk.java.unknown.name", (Object[])new Object[0]));
        return suggestedName;
    }

    private static String getVersionNumber(String versionString) {
        if (versionString.startsWith(JAVA_VERSION_PREFIX)) {
            int dotIdx;
            if ((versionString = versionString.substring(JAVA_VERSION_PREFIX.length())).startsWith("\"") && versionString.endsWith("\"")) {
                versionString = versionString.substring(1, versionString.length() - 1);
            }
            if ((dotIdx = versionString.indexOf(46)) > 0) {
                try {
                    int major = Integer.parseInt(versionString.substring(0, dotIdx));
                    int minorDot = versionString.indexOf(46, dotIdx + 1);
                    if (minorDot > 0) {
                        int minor = Integer.parseInt(versionString.substring(dotIdx + 1, minorDot));
                        versionString = String.valueOf(major) + "." + String.valueOf(minor);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return versionString;
    }

    public void setupSdkPaths(Sdk sdk) {
        File jdkHome = new File(sdk.getHomePath());
        VirtualFile[] classes = JavaSdkImpl.findClasses(jdkHome, false);
        VirtualFile sources = JavaSdkImpl.findSources(jdkHome);
        VirtualFile docs = JavaSdkImpl.findDocs(jdkHome, "docs/api");
        SdkModificator sdkModificator = sdk.getSdkModificator();
        LinkedHashSet<VirtualFile> previousRoots = new LinkedHashSet<VirtualFile>(Arrays.asList(sdkModificator.getRoots(OrderRootType.CLASSES)));
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        previousRoots.removeAll(new HashSet<VirtualFile>(Arrays.asList(classes)));
        for (VirtualFile aClass : classes) {
            sdkModificator.addRoot(aClass, OrderRootType.CLASSES);
        }
        for (VirtualFile root : previousRoots) {
            sdkModificator.addRoot(root, OrderRootType.CLASSES);
        }
        if (sources != null) {
            sdkModificator.addRoot(sources, OrderRootType.SOURCES);
        }
        if (docs != null) {
            sdkModificator.addRoot(docs, JavadocOrderRootType.getInstance());
        } else if (SystemInfo.isMac) {
            VirtualFile appleDocs;
            VirtualFile commonDocs = JavaSdkImpl.findDocs(jdkHome, "docs");
            if (commonDocs == null && (commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "doc/api")) == null) {
                commonDocs = JavaSdkImpl.findInJar(new File(jdkHome, "docs.jar"), "docs/api");
            }
            if (commonDocs != null) {
                sdkModificator.addRoot(commonDocs, JavadocOrderRootType.getInstance());
            }
            if ((appleDocs = JavaSdkImpl.findDocs(jdkHome, "appledocs")) == null) {
                appleDocs = JavaSdkImpl.findInJar(new File(jdkHome, "appledocs.jar"), "appledoc/api");
            }
            if (appleDocs != null) {
                sdkModificator.addRoot(appleDocs, JavadocOrderRootType.getInstance());
            }
        }
        sdkModificator.commitChanges();
    }

    public final String getVersionString(String sdkHome) {
        if (this.myCachedVersionStrings.containsKey(sdkHome)) {
            return this.myCachedVersionStrings.get(sdkHome);
        }
        String versionString = JavaSdkImpl.getJdkVersion((String)sdkHome);
        if (versionString != null && versionString.length() == 0) {
            versionString = null;
        }
        if (versionString != null) {
            this.myCachedVersionStrings.put(sdkHome, versionString);
        }
        return versionString;
    }

    @NotNull
    public String getComponentName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/projectRoots/impl/JavaSdkImpl.getComponentName must not return null");
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public int compareTo(@NotNull String versionString, @NotNull String versionNumber) {
        if (versionString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/projectRoots/impl/JavaSdkImpl.compareTo must not be null");
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/projectRoots/impl/JavaSdkImpl.compareTo must not be null");
        }
        return JavaSdkImpl.getVersionNumber(versionString).compareTo(versionNumber);
    }

    public Sdk createJdk(String jdkName, String home, boolean isJre) {
        ProjectJdkImpl jdk = new ProjectJdkImpl(jdkName, (SdkType)this);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path = home.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path);
        jdk.setVersionString(jdkName);
        File jdkHomeFile = new File(home);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, isJre);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        JavaSdkImpl.addDocs(jdkHomeFile, sdkModificator);
        sdkModificator.commitChanges();
        return jdk;
    }

    public static Sdk getMockJdkCE() {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/mockJDK");
        if (mockJdkCEPath.exists()) {
            return JavaSdkImpl.createMockJdk(mockJdkCEPath.getPath(), "java 1.5", JavaSdkImpl.getInstance());
        }
        mockJdkCEPath = new File(PathManager.getHomePath(), "community/java/mockJDK");
        if (mockJdkCEPath.exists()) {
            return JavaSdkImpl.createMockJdk(mockJdkCEPath.getPath(), "java 1.5", JavaSdkImpl.getInstance());
        }
        return JavaSdkImpl.getMockJdk("java 1.5");
    }

    public static Sdk getMockJdk(@NonNls String versionName) {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/mockJDK");
        if (mockJdkCEPath.exists()) {
            return JavaSdkImpl.createMockJdk(mockJdkCEPath.getPath(), versionName, JavaSdkImpl.getInstance());
        }
        String forcedPath = System.getProperty("idea.testingFramework.mockJDK");
        String jdkHome = forcedPath != null ? forcedPath : PathManager.getHomePath() + File.separator + "mockJDK";
        return JavaSdkImpl.createMockJdk(jdkHome, versionName, JavaSdkImpl.getInstance());
    }

    public static Sdk getMockJdk15(@NonNls String versionName) {
        File mockJdkCEPath = new File(PathManager.getHomePath(), "java/mockJDK");
        if (mockJdkCEPath.exists()) {
            return JavaSdkImpl.createMockJdk(mockJdkCEPath.getPath(), versionName, JavaSdkImpl.getInstance());
        }
        String jdkHome = PathManager.getHomePath() + File.separator + "mockJDK-1.5";
        return JavaSdkImpl.createMockJdk(jdkHome, versionName, JavaSdkImpl.getInstance());
    }

    public static Sdk getMockJdk17(@NonNls String versionName) {
        String jdkHome = PathManager.getHomePath() + File.separator + "mockJDK-1.7";
        return JavaSdkImpl.createMockJdk(jdkHome, versionName, JavaSdkImpl.getInstance());
    }

    private static Sdk createMockJdk(String jdkHome, String versionName, JavaSdk javaSdk) {
        File jdkHomeFile = new File(jdkHome);
        if (!jdkHomeFile.exists()) {
            return null;
        }
        ProjectJdkImpl jdk = new ProjectJdkImpl(versionName, (SdkType)javaSdk);
        SdkModificator sdkModificator = jdk.getSdkModificator();
        String path = jdkHome.replace(File.separatorChar, '/');
        sdkModificator.setHomePath(path);
        sdkModificator.setVersionString(versionName);
        JavaSdkImpl.addSources(jdkHomeFile, sdkModificator);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, false);
        JavaSdkImpl.addClasses(jdkHomeFile, sdkModificator, true);
        sdkModificator.commitChanges();
        return jdk;
    }

    private static void addClasses(File file, SdkModificator sdkModificator, boolean isJre) {
        VirtualFile[] classes;
        for (VirtualFile virtualFile : classes = JavaSdkImpl.findClasses(file, isJre)) {
            sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
        }
    }

    private static VirtualFile[] findClasses(File file, boolean isJre) {
        File[] jarDirs;
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return f.getName().endsWith(".jar");
            }
        };
        if (SystemInfo.isMac && !file.getName().startsWith("mockJDK")) {
            File libFile = new File(file, "lib");
            File classesFile = new File(file, "../Classes");
            File libExtFile = new File(libFile, "ext");
            File libEndorsedFile = new File(libFile, "endorsed");
            jarDirs = new File[]{libEndorsedFile, libFile, classesFile, libExtFile};
        } else {
            String jre = "jre";
            File jreLibFile = isJre ? new File(file, "lib") : new File(new File(file, "jre"), "lib");
            File jreLibExtFile = new File(jreLibFile, "ext");
            File jreLibEndorsedFile = new File(jreLibFile, "endorsed");
            jarDirs = new File[]{jreLibEndorsedFile, jreLibFile, jreLibExtFile};
        }
        LinkedHashSet<File> childrenSet = new LinkedHashSet<File>();
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = jarDir.listFiles(jarFileFilter)) {
                try {
                    childrenSet.add(jarFile.getCanonicalFile());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (File child : childrenSet) {
            String url = "jar://" + child.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile == null) continue;
            result.add(vFile);
        }
        File classesZipFile = new File(new File(file, "lib"), "classes.zip");
        if (!classesZipFile.isDirectory() && classesZipFile.exists()) {
            String url = "jar://" + classesZipFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                result.add(vFile);
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        VirtualFile vFile = JavaSdkImpl.findSources(file);
        if (vFile != null) {
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public static VirtualFile findSources(File file) {
        File srcfile = new File(file, "src");
        File jarfile = new File(file, "src.jar");
        if (!jarfile.exists()) {
            jarfile = new File(file, "src.zip");
        }
        if (jarfile.exists()) {
            VirtualFile vFile = JavaSdkImpl.findInJar(jarfile, "src");
            if (vFile != null) {
                return vFile;
            }
            vFile = JavaSdkImpl.findInJar(jarfile, "");
            return vFile;
        }
        if (!srcfile.exists() || !srcfile.isDirectory()) {
            return null;
        }
        String path = srcfile.getAbsolutePath().replace(File.separatorChar, '/');
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    private static void addDocs(File file, SdkModificator rootContainer) {
        VirtualFile vFile = JavaSdkImpl.findDocs(file, "docs/api");
        if (vFile != null) {
            rootContainer.addRoot(vFile, JavadocOrderRootType.getInstance());
        }
    }

    @Nullable
    private static VirtualFile findInJar(File jarFile, String relativePath) {
        if (!jarFile.exists()) {
            return null;
        }
        String url = "jar://" + jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/" + relativePath;
        return VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Nullable
    public static VirtualFile findDocs(File file, String relativePath) {
        if (!(file = new File(file.getAbsolutePath() + File.separator + relativePath.replace('/', File.separatorChar))).exists() || !file.isDirectory()) {
            return null;
        }
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        return LocalFileSystem.getInstance().findFileByPath(path);
    }
}

