/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SmoothProgressAdapter
extends BlockingProgressIndicator {
    private static final int SHOW_DELAY = 500;
    private final Alarm myStartupAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
    protected ProgressIndicator myOriginal;
    private final Project myProject;
    private boolean myOriginalStarted;
    private DialogWrapper myDialog;
    private final Runnable myShowRequest = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SmoothProgressAdapter smoothProgressAdapter = SmoothProgressAdapter.this;
            synchronized (smoothProgressAdapter) {
                if (!SmoothProgressAdapter.this.isRunning()) {
                    return;
                }
                SmoothProgressAdapter.this.myOriginal.start();
                SmoothProgressAdapter.this.myOriginalStarted = true;
                SmoothProgressAdapter.this.myOriginal.setText(SmoothProgressAdapter.this.getText());
                SmoothProgressAdapter.this.myOriginal.setFraction(SmoothProgressAdapter.this.getFraction());
                SmoothProgressAdapter.this.myOriginal.setText2(SmoothProgressAdapter.this.getText2());
            }
        }
    };

    public SmoothProgressAdapter(ProgressIndicator original, Project project) {
        this.myOriginal = original;
        this.myProject = project;
        if (this.myOriginal.isModal()) {
            this.myOriginal.setModalityProgress((ProgressIndicator)this);
            this.setModalityProgress(this);
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.myOriginal.setIndeterminate(indeterminate);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myOriginal.isIndeterminate();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        this.myOriginalStarted = false;
        this.myStartupAlarm.addRequest(this.myShowRequest, 500);
    }

    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.start();
        if (this.isModal()) {
            this.showDialog();
        }
    }

    private void showDialog() {
        if (this.myDialog == null) {
            this.myDialog = new DialogWrapper(this.myProject, false){
                {
                    this.getWindow().setBounds(0, 0, 1, 1);
                    this.setResizable(false);
                }

                protected boolean isProgressDialog() {
                    return true;
                }

                protected JComponent createCenterPanel() {
                    return null;
                }
            };
            this.myDialog.setModal(true);
            this.myDialog.setUndecorated(true);
            this.myDialog.show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.myOriginal.isRunning()) {
            this.myOriginal.stop();
        } else {
            this.myStartupAlarm.cancelAllRequests();
            if (!this.myOriginalStarted && this.myOriginal instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myOriginal));
            }
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                semaphore.waitFor();
                if (SmoothProgressAdapter.this.myDialog != null) {
                    SmoothProgressAdapter.this.myDialog.close(0);
                    SmoothProgressAdapter.this.myDialog = null;
                }
            }
        });
        try {
            super.stop();
        }
        finally {
            semaphore.up();
        }
    }

    @Override
    public synchronized void setText(String text) {
        super.setText(text);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText(text);
        }
    }

    @Override
    public synchronized void setFraction(double fraction) {
        super.setFraction(fraction);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setFraction(fraction);
        }
    }

    @Override
    public synchronized void setText2(String text) {
        super.setText2(text);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText2(text);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.myOriginal.cancel();
    }

    @Override
    public boolean isCanceled() {
        if (super.isCanceled()) {
            return true;
        }
        if (!this.myOriginalStarted) {
            return false;
        }
        return this.myOriginal.isCanceled();
    }

    public ProgressIndicator getOriginal() {
        return this.myOriginal;
    }
}

