/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurableWrapper
implements SearchableConfigurable {
    private final Project myProject;
    private final Configurable myDelegate;

    public ProjectConfigurableWrapper(Project project, Configurable delegate) {
        this.myProject = project;
        this.myDelegate = delegate;
    }

    public String getDisplayName() {
        return this.myDelegate.getDisplayName();
    }

    public void reset() {
        this.myDelegate.reset();
    }

    public void apply() throws ConfigurationException {
        this.checkProjectFileWritable();
        this.myDelegate.apply();
    }

    private void checkProjectFileWritable() {
        File file;
        String path = this.myProject.getPresentableUrl();
        if (path != null && (file = new File(path)).exists() && !file.canWrite()) {
            Messages.showMessageDialog((Project)this.myProject, (String)OptionsBundle.message((String)"project.file.read.only.error.message", (Object[])new Object[0]), (String)OptionsBundle.message((String)"cannot.save.settings.default.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    public String getHelpTopic() {
        return this.myDelegate.getHelpTopic();
    }

    public void disposeUIResources() {
        this.myDelegate.disposeUIResources();
    }

    public boolean isModified() {
        return this.myDelegate.isModified();
    }

    public JComponent createComponent() {
        return this.myDelegate.createComponent();
    }

    public Icon getIcon() {
        return this.myDelegate.getIcon();
    }

    @NonNls
    public String getId() {
        return this.myDelegate instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myDelegate).getId() : "";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return this.myDelegate instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myDelegate).enableSearch(option) : null;
    }
}

