/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import java.awt.event.KeyEvent;

public class ControlPanelMnemonicsUtil {
    private ControlPanelMnemonicsUtil() {
    }

    public static Configurable getConfigurableFromMnemonic(KeyEvent e, ConfigurableGroup[] groups) {
        if (e.getModifiers() != 0) {
            return null;
        }
        ConfigurableGroup group = ControlPanelMnemonicsUtil.getGroupFromKeycode(e.getKeyCode(), groups);
        if (group == null) {
            return null;
        }
        int idx = ControlPanelMnemonicsUtil.getIndexFromKeycode(e.getKeyCode(), group == groups[0]);
        if (idx < 0 || idx >= group.getConfigurables().length) {
            return null;
        }
        return group.getConfigurables()[idx];
    }

    public static int getIndexFromKeycode(int keyCode, boolean isNumeric) {
        if (isNumeric) {
            if (keyCode >= 49 && keyCode <= 57) {
                return keyCode - 49;
            }
            if (keyCode >= 97 && keyCode <= 105) {
                return keyCode - 97;
            }
            if (keyCode == 96 || keyCode == 48) {
                return 9;
            }
        } else if (keyCode >= 65 && keyCode <= 90) {
            return keyCode - 65;
        }
        return -1;
    }

    public static ConfigurableGroup getGroupFromKeycode(int keyCode, ConfigurableGroup[] groups) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 96 && keyCode <= 105) {
            return groups[0];
        }
        if (keyCode >= 65 && keyCode <= 90 && groups.length > 1) {
            return groups[1];
        }
        return null;
    }
}

