/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ModulePointerManagerImpl
extends ModulePointerManager {
    private final Map<String, ModulePointerImpl> myUnresolved = new HashMap<String, ModulePointerImpl>();
    private final Map<Module, ModulePointerImpl> myPointers = new HashMap<Module, ModulePointerImpl>();
    private final Project myProject;

    public ModulePointerManagerImpl(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void beforeModuleRemoved(Project project, Module module) {
                ModulePointerManagerImpl.this.unregisterPointer(module);
            }

            public void moduleAdded(Project project, Module module) {
                ModulePointerManagerImpl.this.moduleAppears(module);
            }

            public void modulesRenamed(Project project, List<Module> modules) {
                for (Module module : modules) {
                    ModulePointerManagerImpl.this.moduleAppears(module);
                }
            }
        });
    }

    private void moduleAppears(Module module) {
        ModulePointerImpl pointer = this.myUnresolved.remove(module.getName());
        if (pointer != null && pointer.getModule() == null) {
            pointer.moduleAdded(module);
            this.registerPointer(module, pointer);
        }
    }

    private void registerPointer(final Module module, ModulePointerImpl pointer) {
        this.myPointers.put(module, pointer);
        Disposer.register((Disposable)module, (Disposable)new Disposable(){

            public void dispose() {
                ModulePointerManagerImpl.this.unregisterPointer(module);
            }
        });
    }

    private void unregisterPointer(Module module) {
        ModulePointerImpl pointer = this.myPointers.remove(module);
        if (pointer != null) {
            pointer.moduleRemoved(module);
            this.myUnresolved.put(pointer.getModuleName(), pointer);
        }
    }

    @NotNull
    public ModulePointer create(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModulePointerManagerImpl.create must not be null");
        }
        ModulePointerImpl pointer = this.myPointers.get(module);
        if (pointer == null) {
            pointer = this.myUnresolved.get(module.getName());
            if (pointer == null) {
                pointer = new ModulePointerImpl(module);
            } else {
                pointer.moduleAdded(module);
            }
            this.registerPointer(module, pointer);
        }
        ModulePointerImpl modulePointerImpl = pointer;
        if (modulePointerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModulePointerManagerImpl.create must not return null");
        }
        return modulePointerImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        ModulePointer modulePointer;
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModulePointerManagerImpl.create must not be null");
        }
        Module module = ModuleManagerImpl.getInstance((Project)this.myProject).findModuleByName(moduleName);
        if (module != null) {
            modulePointer = this.create(module);
            if (modulePointer == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModulePointerManagerImpl.create must not return null");
            return modulePointer;
        }
        ModulePointerImpl pointer = this.myUnresolved.get(moduleName);
        if (pointer == null) {
            pointer = new ModulePointerImpl(moduleName);
            this.myUnresolved.put(moduleName, pointer);
        }
        if ((modulePointer = pointer) != null) return modulePointer;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModulePointerManagerImpl.create must not return null");
    }
}

