/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.CommonBundle;
import com.intellij.application.options.ExportSchemeAction;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.QuickListsPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable {
    private JComboBox myKeymapList;
    private JList myShortcutsList;
    private final DefaultComboBoxModel myKeymapListModel = new DefaultComboBoxModel();
    private KeymapImpl mySelectedKeymap;
    private JButton myCopyButton;
    private JButton myDeleteButton;
    private JButton myResetToDefault;
    private JButton myAddKeyboardShortcutButton;
    private JButton myAddMouseShortcutButton;
    private JButton myRemoveShortcutButton;
    @NonNls
    private JEditorPane myDescription;
    private JLabel myBaseKeymapLabel;
    private ActionsTree myActionsTree;
    private FilterComponent myFilterComponent;
    private JBPopup myPopup = null;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private boolean myQuickListsModified = false;
    private JButton myExportButton;
    private QuickListsPanel myQuickListsPanel;

    public KeymapPanel() {
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        keymapPanel.add((Component)this.createKeymapListPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.processCurrentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }
        });
    }

    public void setQuickListsPanel(QuickListsPanel quickListsPanel) {
        this.myQuickListsPanel = quickListsPanel;
    }

    public void quickListRenamed(QuickList oldQuickList, QuickList newQuickList) {
        for (Keymap keymap : this.getAllKeymaps()) {
            KeymapImpl impl = (KeymapImpl)keymap;
            String actionId = oldQuickList.getActionId();
            String newActionId = newQuickList.getActionId();
            Shortcut[] shortcuts = impl.getShortcuts(actionId);
            if (shortcuts == null) continue;
            for (Shortcut shortcut : shortcuts) {
                impl.removeShortcut(actionId, shortcut);
                impl.addShortcut(newActionId, shortcut);
            }
        }
        this.myQuickListsModified = true;
    }

    private JPanel createKeymapListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.myKeymapList = new JComboBox(this.myKeymapListModel);
        this.myKeymapList.setEditor(new MyEditor());
        this.myKeymapList.setRenderer(new MyKeymapRenderer());
        JLabel keymapLabel = new JLabel(KeyMapBundle.message((String)"keymaps.border.factory.title", (Object[])new Object[0]));
        keymapLabel.setLabelFor(this.myKeymapList);
        panel.add((Component)keymapLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        panel.add((Component)this.myKeymapList, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.createKeymapButtonsPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myKeymapList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.processCurrentKeymapChanged();
            }
        });
        panel.add((Component)this.createKeymapNamePanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                KeymapPanel.this.showOption(option);
            }
        };
    }

    void processCurrentKeymapChanged() {
        KeymapImpl selectedKeymap;
        this.myCopyButton.setEnabled(false);
        this.myDeleteButton.setEnabled(false);
        this.myResetToDefault.setEnabled(false);
        this.myAddKeyboardShortcutButton.setEnabled(false);
        this.myAddMouseShortcutButton.setEnabled(false);
        this.myRemoveShortcutButton.setEnabled(false);
        if (this.myExportButton != null) {
            this.myExportButton.setEnabled(false);
        }
        this.mySelectedKeymap = selectedKeymap = this.getSelectedKeymap();
        if (selectedKeymap == null) {
            this.myActionsTree.reset(new KeymapImpl(), this.getCurrentQuickListIds());
            return;
        }
        this.myKeymapList.setEditable(this.mySelectedKeymap.canModify());
        this.myCopyButton.setEnabled(true);
        this.myBaseKeymapLabel.setText("");
        Keymap parent = this.mySelectedKeymap.getParent();
        if (parent != null) {
            this.myBaseKeymapLabel.setText(KeyMapBundle.message((String)"based.on.keymap.label", (Object[])new Object[]{parent.getPresentableName()}));
            if (this.mySelectedKeymap.canModify() && this.mySelectedKeymap.getOwnActionIds().length > 0) {
                this.myResetToDefault.setEnabled(true);
            }
        }
        if (this.mySelectedKeymap.canModify()) {
            this.myDeleteButton.setEnabled(true);
            this.myAddKeyboardShortcutButton.setEnabled(true);
            this.myAddMouseShortcutButton.setEnabled(true);
            this.myRemoveShortcutButton.setEnabled(true);
            if (!this.getSchemesManager().isShared((Scheme)this.mySelectedKeymap) && this.myExportButton != null) {
                this.myExportButton.setEnabled(true);
            }
        }
        this.myActionsTree.reset(this.mySelectedKeymap, this.getCurrentQuickListIds());
        this.updateShortcutsList();
    }

    private KeymapImpl getSelectedKeymap() {
        return (KeymapImpl)this.myKeymapList.getSelectedItem();
    }

    List<Keymap> getAllKeymaps() {
        ComboBoxModel model = this.myKeymapList.getModel();
        ArrayList<Keymap> result = new ArrayList<Keymap>();
        for (int i = 0; i < model.getSize(); ++i) {
            result.add((Keymap)model.getElementAt(i));
        }
        return result;
    }

    private JPanel createShortcutsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel currentKeysLabel = new JLabel(KeyMapBundle.message((String)"shortcuts.keymap.label", (Object[])new Object[0]));
        panel.add((Component)currentKeysLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.myShortcutsList = new JList(new DefaultListModel());
        this.myShortcutsList.setSelectionMode(0);
        this.myShortcutsList.setCellRenderer(new ShortcutListRenderer());
        currentKeysLabel.setLabelFor(this.myShortcutsList);
        JScrollPane scrollPane = new JScrollPane(this.myShortcutsList);
        scrollPane.setPreferredSize(new Dimension(160, 200));
        panel.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 2), 0, 0));
        panel.add((Component)this.createShortcutsButtonsPanel(), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myActionsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KeymapPanel.this.updateShortcutsList();
            }
        });
        return panel;
    }

    private JPanel createKeymapButtonsPanel() {
        final JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        panel.setLayout(new GridBagLayout());
        this.myCopyButton = new JButton(KeyMapBundle.message((String)"copy.keymap.button", (Object[])new Object[0]));
        Insets insets = new Insets(2, 2, 2, 2);
        this.myCopyButton.setMargin(insets);
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        panel.add((Component)this.myCopyButton, gc);
        this.myResetToDefault = new JButton(CommonBundle.message((String)"button.reset", (Object[])new Object[0]));
        this.myResetToDefault.setMargin(insets);
        panel.add((Component)this.myResetToDefault, gc);
        this.myDeleteButton = new JButton(KeyMapBundle.message((String)"delete.keymap.button", (Object[])new Object[0]));
        this.myDeleteButton.setMargin(insets);
        gc.weightx = 1.0;
        panel.add((Component)this.myDeleteButton, gc);
        final SchemesManager<Keymap, KeymapImpl> schemesManager = this.getSchemesManager();
        if (schemesManager.isExportAvailable()) {
            this.myExportButton = new JButton("Share...");
            this.myExportButton.setMnemonic('S');
            this.myExportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeymapImpl selected = KeymapPanel.this.getSelectedKeymap();
                    ExportSchemeAction.doExport(selected, schemesManager);
                }
            });
            this.myExportButton.setMargin(insets);
            panel.add((Component)this.myExportButton, gc);
        }
        if (schemesManager.isImportAvailable()) {
            JButton importButton = new JButton("Import Shared...");
            importButton.setMnemonic('I');
            importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SchemesToImportPopup<Keymap, KeymapImpl> popup = new SchemesToImportPopup<Keymap, KeymapImpl>((Component)panel){

                        @Override
                        protected void onSchemeSelected(KeymapImpl scheme) {
                            if (scheme != null) {
                                scheme.setCanModify(true);
                                KeymapPanel.this.myKeymapListModel.addElement(scheme);
                                KeymapPanel.this.myKeymapList.setSelectedItem(scheme);
                                KeymapPanel.this.processCurrentKeymapChanged();
                            }
                        }
                    };
                    popup.show(schemesManager, KeymapPanel.collectKeymaps(KeymapPanel.this.myKeymapListModel));
                }
            });
            importButton.setMargin(insets);
            panel.add((Component)importButton, gc);
        }
        this.myCopyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.copyKeymap();
            }
        });
        this.myResetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.resetKeymap();
            }
        });
        this.myDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.deleteKeymap();
            }
        });
        return panel;
    }

    private static Collection<Keymap> collectKeymaps(DefaultComboBoxModel list) {
        HashSet<Keymap> names = new HashSet<Keymap>();
        for (int i = 0; i < list.getSize(); ++i) {
            names.add((Keymap)list.getElementAt(i));
        }
        return names;
    }

    private SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return ((KeymapManagerEx)KeymapManager.getInstance()).getSchemesManager();
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.myActionsTree = new ActionsTree();
        JComponent component = this.myActionsTree.getComponent();
        component.setPreferredSize(new Dimension(100, 300));
        panel.add((Component)this.createToolbarPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)component, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel rightPanel = new JPanel(new GridLayout(2, 1, 0, 5));
        rightPanel.add(this.createDescriptionPanel());
        rightPanel.add(this.createShortcutsPanel());
        panel.add((Component)rightPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        return panel;
    }

    private JPanel createToolbarPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)KeymapPanel.this.myActionsTree.getTree());
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        panel.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        group = new DefaultActionGroup();
        final JComponent searchToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        final Alarm alarm = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm.cancelAllRequests();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                            return;
                        }
                        if (!KeymapPanel.this.myTreeExpansionMonitor.isFreeze()) {
                            KeymapPanel.this.myTreeExpansionMonitor.freeze();
                        }
                        String filter = this.getFilter();
                        KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.getCurrentQuickListIds());
                        JTree tree = KeymapPanel.this.myActionsTree.getTree();
                        TreeUtil.expandAll((JTree)tree);
                        if (filter == null || filter.length() == 0) {
                            TreeUtil.collapseAll((JTree)tree, (int)0);
                            KeymapPanel.this.myTreeExpansionMonitor.restore();
                        }
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        panel.add((Component)this.myFilterComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        group.add(new AnAction(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), IconLoader.getIcon((String)"/ant/shortcutFilter.png")){

            public void actionPerformed(AnActionEvent e) {
                KeymapPanel.this.myFilterComponent.reset();
                if (KeymapPanel.this.myPopup == null || KeymapPanel.this.myPopup.getContent() == null) {
                    KeymapPanel.this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)KeymapPanel.this.createFilteringPanel(), null).setRequestFocus(true).setTitle(KeyMapBundle.message((String)"filter.settings.popup.title", (Object[])new Object[0])).setMovable(true).createPopup();
                }
                KeymapPanel.this.myPopup.showUnderneathOf((Component)searchToolbar);
            }
        });
        group.add(new AnAction(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/gc.png")){

            public void actionPerformed(AnActionEvent e) {
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.getCurrentQuickListIds());
                TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
                KeymapPanel.this.myTreeExpansionMonitor.restore();
            }
        });
        panel.add((Component)searchToolbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(300, -1);
            }
        };
        panel.add((Component)new JLabel(KeyMapBundle.message((String)"action.description.ide.border.factory.title", (Object[])new Object[0])), "North");
        this.myDescription = new JEditorPane("text/html", "<html><body></body></html>");
        this.myDescription.setEditable(false);
        panel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myDescription), "Center");
        return panel;
    }

    private JPanel createKeymapNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myBaseKeymapLabel = new JLabel(KeyMapBundle.message((String)"parent.keymap.label", (Object[])new Object[0]));
        Dimension preferredSize = this.myBaseKeymapLabel.getPreferredSize();
        this.myBaseKeymapLabel.setPreferredSize(new Dimension(preferredSize.width * 2, preferredSize.height));
        this.myBaseKeymapLabel.setMinimumSize(new Dimension(preferredSize.width * 2, preferredSize.height));
        panel.add((Component)this.myBaseKeymapLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createFilteringPanel() {
        this.myActionsTree.reset(this.getSelectedKeymap(), this.getCurrentQuickListIds());
        JPanel filterComponent = new JPanel(new GridBagLayout());
        filterComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        final ShortcutTextField firstShortcut = new ShortcutTextField();
        final ShortcutTextField secondShortcut = new ShortcutTextField();
        final JCheckBox enable2Shortcut = new JCheckBox(KeyMapBundle.message((String)"filter.enable.second.stroke.checkbox", (Object[])new Object[0]));
        firstShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        secondShortcut.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                KeymapPanel.this.filterTreeByShortcut(firstShortcut, enable2Shortcut, secondShortcut);
            }
        });
        JLabel firstLabel = new JLabel(KeyMapBundle.message((String)"filter.first.stroke.input", (Object[])new Object[0]));
        final JLabel secondLabel = new JLabel(KeyMapBundle.message((String)"filter.second.stroke.input", (Object[])new Object[0]));
        filterComponent.add((Component)firstLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 2, 0, 0), 0, 0));
        filterComponent.add((Component)firstShortcut, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 2, 0, 0), 0, 0));
        enable2Shortcut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                secondShortcut.setEnabled(enable2Shortcut.isSelected());
                secondLabel.setEnabled(enable2Shortcut.isSelected());
                if (enable2Shortcut.isSelected()) {
                    secondShortcut.requestFocusInWindow();
                }
            }
        });
        filterComponent.add((Component)enable2Shortcut, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterComponent.add((Component)secondLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 2, 0, 0), 0, 0));
        filterComponent.add((Component)secondShortcut, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 2, 0, 0), 0, 0));
        enable2Shortcut.setSelected(false);
        secondLabel.setEnabled(false);
        secondShortcut.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                firstShortcut.requestFocus();
            }
        });
        return filterComponent;
    }

    private void filterTreeByShortcut(ShortcutTextField firstShortcut, JCheckBox enable2Shortcut, ShortcutTextField secondShortcut) {
        KeyStroke keyStroke = firstShortcut.getKeyStroke();
        if (keyStroke != null) {
            if (!this.myTreeExpansionMonitor.isFreeze()) {
                this.myTreeExpansionMonitor.freeze();
            }
            this.myActionsTree.filterTree(new KeyboardShortcut(keyStroke, enable2Shortcut.isSelected() ? secondShortcut.getKeyStroke() : null), this.getCurrentQuickListIds());
            JTree tree = this.myActionsTree.getTree();
            TreeUtil.expandAll((JTree)tree);
        }
    }

    public void showOption(String option) {
        this.createFilteringPanel();
        this.myFilterComponent.setFilter(option);
        this.myActionsTree.filter(option, this.getCurrentQuickListIds());
    }

    private JPanel createShortcutsButtonsPanel() {
        JPanel panel = new JPanel(new GridLayout(3, 1, 0, 4));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myAddKeyboardShortcutButton = new JButton(KeyMapBundle.message((String)"add.keyboard.shortcut.button", (Object[])new Object[0]));
        panel.add(this.myAddKeyboardShortcutButton);
        this.myAddMouseShortcutButton = new JButton(KeyMapBundle.message((String)"add.mouse.shortcut.button", (Object[])new Object[0]));
        panel.add(this.myAddMouseShortcutButton);
        this.myRemoveShortcutButton = new JButton(KeyMapBundle.message((String)"remove.shortcut.button", (Object[])new Object[0]));
        panel.add(this.myRemoveShortcutButton);
        this.myAddKeyboardShortcutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.addKeyboardShortcut();
            }
        });
        this.myAddMouseShortcutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.addMouseShortcut();
            }
        });
        this.myRemoveShortcutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.removeShortcut();
            }
        });
        return panel;
    }

    private void addKeyboardShortcut() {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        KeyboardShortcutDialog dialog = new KeyboardShortcutDialog(this, actionId, this.getCurrentQuickListIds());
        Shortcut selected = (Shortcut)this.myShortcutsList.getSelectedValue();
        KeyboardShortcut selectedKeyboardShortcut = selected instanceof KeyboardShortcut ? (KeyboardShortcut)selected : null;
        dialog.setData(this.mySelectedKeymap, selectedKeyboardShortcut);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        KeyboardShortcut keyboardShortcut = dialog.getKeyboardShortcut();
        if (keyboardShortcut == null) {
            return;
        }
        HashMap<String, ArrayList<KeyboardShortcut>> conflicts = this.mySelectedKeymap.getConflicts(actionId, keyboardShortcut);
        if (conflicts.size() > 0) {
            int result = Messages.showDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String[])new String[]{KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0])}, (int)0, (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String id : conflicts.keySet()) {
                    ArrayList list = (ArrayList)conflicts.get((Object)id);
                    for (KeyboardShortcut shortcut : list) {
                        this.mySelectedKeymap.removeShortcut(id, (Shortcut)shortcut);
                    }
                }
            } else if (result != 1) {
                return;
            }
        }
        Shortcut[] shortcuts = this.mySelectedKeymap.getShortcuts(actionId);
        for (int i = 0; i < shortcuts.length; ++i) {
            Shortcut shortcut = shortcuts[i];
            if (!shortcut.equals(keyboardShortcut)) continue;
            this.myShortcutsList.setSelectedIndex(i);
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)keyboardShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)keyboardShortcut);
        }
        this.updateShortcutsList();
        this.myShortcutsList.setSelectedIndex(this.myShortcutsList.getModel().getSize() - 1);
        this.repaintLists();
        this.processCurrentKeymapChanged();
    }

    private QuickList[] getCurrentQuickListIds() {
        if (this.myQuickListsPanel != null) {
            return this.myQuickListsPanel.getCurrentQuickListIds();
        }
        return QuickListsManager.getInstance().getAllQuickLists();
    }

    private void addMouseShortcut() {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Shortcut shortcut = (Shortcut)this.myShortcutsList.getSelectedValue();
        MouseShortcut mouseShortcut = shortcut instanceof MouseShortcut ? (MouseShortcut)shortcut : null;
        MouseShortcutDialog dialog = new MouseShortcutDialog(this, mouseShortcut, this.mySelectedKeymap, actionId, this.myActionsTree.getMainGroup());
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        mouseShortcut = dialog.getMouseShortcut();
        if (mouseShortcut == null) {
            return;
        }
        String[] actionIds = this.mySelectedKeymap.getActionIds(mouseShortcut);
        if (actionIds.length > 1 || actionIds.length == 1 && !actionId.equals(actionIds[0])) {
            int result = Messages.showDialog((Component)this, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String[])new String[]{KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0])}, (int)0, (Icon)Messages.getWarningIcon());
            if (result == 0) {
                for (String id : actionIds) {
                    this.mySelectedKeymap.removeShortcut(id, (Shortcut)mouseShortcut);
                }
            } else if (result != 1) {
                return;
            }
        }
        Shortcut[] shortcuts = this.mySelectedKeymap.getShortcuts(actionId);
        for (int i = 0; i < shortcuts.length; ++i) {
            if (!shortcuts[i].equals(mouseShortcut)) continue;
            this.myShortcutsList.setSelectedIndex(i);
            return;
        }
        this.mySelectedKeymap.addShortcut(actionId, (Shortcut)mouseShortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), (Shortcut)mouseShortcut);
        }
        this.updateShortcutsList();
        this.myShortcutsList.setSelectedIndex(this.myShortcutsList.getModel().getSize() - 1);
        this.repaintLists();
        this.processCurrentKeymapChanged();
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    private void removeShortcut() {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Shortcut shortcut = (Shortcut)this.myShortcutsList.getSelectedValue();
        if (shortcut == null) {
            return;
        }
        int selectedIndex = this.myShortcutsList.getSelectedIndex();
        this.mySelectedKeymap.removeShortcut(actionId, shortcut);
        if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
            this.mySelectedKeymap.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), shortcut);
        }
        this.updateShortcutsList();
        int count = this.myShortcutsList.getModel().getSize();
        if (count > 0) {
            this.myShortcutsList.setSelectedIndex(Math.max(selectedIndex - 1, 0));
        } else {
            this.myShortcutsList.clearSelection();
        }
        this.repaintLists();
        this.processCurrentKeymapChanged();
    }

    private void copyKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        KeymapImpl newKeymap = keymap.deriveKeymap();
        String newKeymapName = KeyMapBundle.message((String)"new.keymap.name", (Object[])new Object[0]);
        if (!this.tryNewKeymapName(newKeymapName)) {
            int i = 0;
            while (!this.tryNewKeymapName(newKeymapName = KeyMapBundle.message((String)"new.indexed.keymap.name", (Object[])new Object[]{i}))) {
                ++i;
            }
        }
        newKeymap.setName(newKeymapName);
        newKeymap.setCanModify(true);
        this.myKeymapListModel.addElement(newKeymap);
        this.myKeymapList.setSelectedItem(newKeymap);
        this.myKeymapList.getEditor().selectAll();
        this.processCurrentKeymapChanged();
    }

    private boolean tryNewKeymapName(String name) {
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap k = (Keymap)this.myKeymapListModel.getElementAt(i);
            if (!name.equals(k.getName())) continue;
            return false;
        }
        return true;
    }

    private void deleteKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        int result = Messages.showYesNoDialog((Component)this, (String)KeyMapBundle.message((String)"delete.keymap.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"delete.keymap.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (result != 0) {
            return;
        }
        this.myKeymapListModel.removeElement(this.myKeymapList.getSelectedItem());
        this.processCurrentKeymapChanged();
    }

    private void resetKeymap() {
        KeymapImpl keymap = this.getSelectedKeymap();
        if (keymap == null) {
            return;
        }
        keymap.clearOwnActionsIds();
        this.processCurrentKeymapChanged();
    }

    public String getId() {
        return "preferences.keymap";
    }

    private void updateShortcutsList() {
        DefaultListModel shortcutsModel = (DefaultListModel)this.myShortcutsList.getModel();
        shortcutsModel.clear();
        String actionId = this.myActionsTree.getSelectedActionId();
        this.myDescription.setText(" ");
        if (actionId != null && this.mySelectedKeymap != null) {
            Shortcut[] shortcuts;
            QuickList list = this.myActionsTree.getSelectedQuickList();
            if (list != null) {
                String description = list.getDescription().trim();
                if (description.length() > 0) {
                    this.myDescription.setText(this.prepareDescription(description));
                }
            } else {
                String description;
                AnAction action = ActionManager.getInstance().getActionOrStub(actionId);
                if (action != null && (description = action.getTemplatePresentation().getDescription()) != null && description.trim().length() > 0) {
                    this.myDescription.setText(this.prepareDescription(description));
                }
            }
            for (Shortcut shortcut : shortcuts = this.mySelectedKeymap.getShortcuts(actionId)) {
                shortcutsModel.addElement(shortcut);
            }
            if (shortcutsModel.size() > 0) {
                this.myShortcutsList.setSelectedIndex(0);
            }
            this.myAddKeyboardShortcutButton.setEnabled(this.mySelectedKeymap.canModify());
            this.myAddMouseShortcutButton.setEnabled(this.mySelectedKeymap.canModify());
            this.myRemoveShortcutButton.setEnabled(this.mySelectedKeymap.canModify() && shortcutsModel.size() > 0);
        } else {
            this.myAddKeyboardShortcutButton.setEnabled(false);
            this.myAddMouseShortcutButton.setEnabled(false);
            this.myRemoveShortcutButton.setEnabled(false);
        }
    }

    @NonNls
    private String prepareDescription(String description) {
        return "<html><body>" + (this.myFilterComponent != null ? SearchUtil.markup(description, this.myFilterComponent.getFilter()) : description) + "</body></html>";
    }

    public void disposeUI() {
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.myPopup.cancel();
        }
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
    }

    public void reset() {
        Keymap[] keymaps;
        this.myKeymapListModel.removeAllElements();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        for (Keymap keymap1 : keymaps = keymapManager.getAllKeymaps()) {
            KeymapImpl keymap = (KeymapImpl)keymap1;
            if (keymap.canModify()) {
                keymap = keymap.copy(true);
            }
            this.myKeymapListModel.addElement(keymap);
            if (!Comparing.equal((Object)keymapManager.getActiveKeymap(), (Object)keymap1)) continue;
            this.mySelectedKeymap = keymap;
        }
        if (this.myKeymapListModel.getSize() == 0) {
            KeymapImpl keymap = new KeymapImpl();
            keymap.setName(KeyMapBundle.message((String)"keymap.no.name", (Object[])new Object[0]));
            this.myKeymapListModel.addElement(keymap);
        }
        this.myKeymapList.setSelectedItem(this.mySelectedKeymap);
    }

    public void apply() throws ConfigurationException {
        this.ensureUniqueKeymapNames();
        KeymapManagerImpl keymapManager = (KeymapManagerImpl)KeymapManager.getInstance();
        keymapManager.removeAllKeymapsExceptUnmodifiable();
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap modelKeymap = (Keymap)this.myKeymapListModel.getElementAt(i);
            if (!modelKeymap.canModify()) continue;
            KeymapImpl keymapToAdd = ((KeymapImpl)modelKeymap).copy(true);
            keymapManager.addKeymap(keymapToAdd);
        }
        keymapManager.setActiveKeymap(this.mySelectedKeymap);
    }

    private void ensureUniqueKeymapNames() throws ConfigurationException {
        HashSet<String> keymapNames = new HashSet<String>();
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            Keymap modelKeymap = (Keymap)this.myKeymapListModel.getElementAt(i);
            String name = modelKeymap.getName();
            if (keymapNames.contains(name)) {
                throw new ConfigurationException(KeyMapBundle.message((String)"configuration.all.keymaps.should.have.unique.names.error.message", (Object[])new Object[0]));
            }
            keymapNames.add(name);
        }
    }

    public boolean isModified() {
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        if (!Comparing.equal((Object)this.mySelectedKeymap, (Object)keymapManager.getActiveKeymap())) {
            return true;
        }
        Object[] managerKeymaps = keymapManager.getAllKeymaps();
        Object[] panelKeymaps = new Keymap[this.myKeymapListModel.getSize()];
        for (int i = 0; i < this.myKeymapListModel.getSize(); ++i) {
            panelKeymaps[i] = (Keymap)this.myKeymapListModel.getElementAt(i);
        }
        return !Comparing.equal((Object[])managerKeymaps, (Object[])panelKeymaps);
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return "Keymap";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }

    private static class MyEditor
    implements ComboBoxEditor {
        private KeymapImpl myKeymap = null;
        private final JTextField myTextField = new JTextField();

        public MyEditor() {
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MyEditor.this.myKeymap != null && MyEditor.this.myKeymap.canModify()) {
                        MyEditor.this.myKeymap.setName(MyEditor.this.myTextField.getText());
                    }
                }
            });
            if (!LafManager.getInstance().isUnderAquaLookAndFeel()) {
                this.myTextField.setBorder(null);
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.myTextField;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject instanceof KeymapImpl) {
                this.myKeymap = (KeymapImpl)anObject;
                this.myTextField.setText(this.myKeymap.getPresentableName());
            }
        }

        @Override
        public Object getItem() {
            return this.myKeymap;
        }

        @Override
        public void selectAll() {
            this.myTextField.selectAll();
            this.myTextField.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }

    private static final class ShortcutListRenderer
    extends DefaultListCellRenderer {
        private ShortcutListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Shortcut shortcut = (Shortcut)value;
            this.setText(KeymapUtil.getShortcutText((Shortcut)shortcut));
            this.setIcon(KeymapUtil.getShortcutIcon((Shortcut)shortcut));
            return this;
        }
    }

    private static final class MyKeymapRenderer
    extends ColoredListCellRenderer {
        private MyKeymapRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Keymap keymap = (Keymap)value;
            if (keymap != null) {
                String name = keymap.getPresentableName();
                if (name == null) {
                    name = KeyMapBundle.message((String)"keymap.noname.presentable.name", (Object[])new Object[0]);
                }
                this.append(name, selected ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
    }
}

