/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.keymap.KeymapGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class Group
implements KeymapGroup {
    private Group myParent;
    private final String myName;
    private String myId;
    private final Icon myIcon;
    private final Icon myOpenIcon;
    private final ArrayList<Object> myChildren;
    private final Set<String> myIds = new HashSet<String>();

    public Group(String name, String id, Icon icon, Icon openIcon) {
        this.myName = name;
        this.myId = id;
        this.myIcon = icon;
        this.myOpenIcon = openIcon;
        this.myChildren = new ArrayList();
    }

    public Group(String name, Icon openIcon, Icon icon) {
        this.myChildren = new ArrayList();
        this.myOpenIcon = openIcon;
        this.myIcon = icon;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public Icon getOpenIcon() {
        return this.myOpenIcon;
    }

    public String getId() {
        return this.myId;
    }

    public void addActionId(String id) {
        this.myChildren.add(id);
    }

    public void addQuickList(QuickList list) {
        this.myChildren.add(list);
    }

    public void addGroup(KeymapGroup keymapGroup) {
        Group group = (Group)keymapGroup;
        this.myChildren.add(group);
        group.myParent = this;
    }

    public void addSeparator() {
        this.myChildren.add(Separator.getInstance());
    }

    public boolean containsId(String id) {
        return this.myIds.contains(id);
    }

    public Set<String> initIds() {
        for (Object child : this.myChildren) {
            if (child instanceof String) {
                this.myIds.add((String)child);
                continue;
            }
            if (child instanceof QuickList) {
                this.myIds.add(((QuickList)child).getActionId());
                continue;
            }
            if (!(child instanceof Group)) continue;
            this.myIds.addAll(((Group)child).initIds());
        }
        return this.myIds;
    }

    public ArrayList<Object> getChildren() {
        return this.myChildren;
    }

    public int getSize() {
        return this.myChildren.size();
    }

    public void normalizeSeparators() {
        while (this.myChildren.size() > 0 && this.myChildren.get(0) instanceof Separator) {
            this.myChildren.remove(0);
        }
        while (this.myChildren.size() > 0 && this.myChildren.get(this.myChildren.size() - 1) instanceof Separator) {
            this.myChildren.remove(this.myChildren.size() - 1);
        }
        for (int i = 1; i < this.myChildren.size() - 1; ++i) {
            if (!(this.myChildren.get(i) instanceof Separator) || !(this.myChildren.get(i + 1) instanceof Separator)) continue;
            this.myChildren.remove(i);
            --i;
        }
    }

    public String getActionQualifiedPath(String id) {
        for (Object child : this.myChildren) {
            String path;
            if (child instanceof QuickList) {
                child = ((QuickList)child).getActionId();
            }
            if (child instanceof String) {
                if (!id.equals(child)) continue;
                AnAction action = ActionManager.getInstance().getActionOrStub(id);
                String path2 = action != null ? action.getTemplatePresentation().getText() : id;
                return !this.isRoot() ? this.getName() + " | " + path2 : path2;
            }
            if (!(child instanceof Group) || (path = ((Group)child).getActionQualifiedPath(id)) == null) continue;
            return !this.isRoot() ? this.getName() + " | " + path : path;
        }
        return null;
    }

    public boolean isRoot() {
        return this.myParent == null;
    }

    public String getQualifiedPath() {
        StringBuffer path = new StringBuffer(64);
        Group group = this;
        while (group != null && !group.isRoot()) {
            path.insert(0, group.getName() + " | ");
            group = group.myParent;
        }
        return path.toString();
    }

    public void addAll(Group group) {
        for (Object o : group.getChildren()) {
            if (o instanceof String) {
                this.addActionId((String)o);
                continue;
            }
            if (o instanceof QuickList) {
                this.addQuickList((QuickList)o);
                continue;
            }
            if (o instanceof Group) {
                this.addGroup((Group)o);
                continue;
            }
            if (!(o instanceof Separator)) continue;
            this.addSeparator();
        }
    }

    public ActionGroup constructActionGroup(boolean popup) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup(this.getName(), popup);
        AnAction groupToRestorePresentation = null;
        if (this.getName() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getName());
        } else if (this.getId() != null) {
            groupToRestorePresentation = actionManager.getAction(this.getId());
        }
        if (groupToRestorePresentation != null) {
            group.copyFrom(groupToRestorePresentation);
        }
        for (Object o : this.myChildren) {
            if (o instanceof String) {
                group.add(actionManager.getAction((String)o));
                continue;
            }
            if (o instanceof Separator) {
                group.addSeparator();
                continue;
            }
            if (!(o instanceof Group)) continue;
            group.add((AnAction)((Group)o).constructActionGroup(popup));
        }
        return group;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        if (group.getName() != null && this.getName() != null) {
            return group.getName().equals(this.getName());
        }
        if (this.getChildren() != null && group.getChildren() != null) {
            if (this.getChildren().size() != group.getChildren().size()) {
                return false;
            }
            for (int i = 0; i < this.getChildren().size(); ++i) {
                if (this.getChildren().get(i).equals(group.getChildren().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

