/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.AppTopics;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.ReadFileType;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.ex.CustomFileTypeFactory;
import com.intellij.openapi.fileTypes.ex.ExternalizableFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.ImportedFileType;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeManagerImpl
extends FileTypeManagerEx
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    private static final Logger LOG;
    private static final int VERSION = 7;
    private final Set<FileType> myDefaultTypes = new THashSet();
    private final ArrayList<FileTypeIdentifiableByVirtualFile> mySpecialFileTypes = new ArrayList();
    private final ArrayList<Pattern> myIgnorePatterns = new ArrayList();
    private FileTypeAssocTable<FileType> myPatternsTable = new FileTypeAssocTable();
    private final Set<String> myIgnoredFileMasksSet = new LinkedHashSet<String>();
    private final Set<String> myNotIgnoredFiles = new ConcurrentHashSet();
    private final Set<String> myIgnoredFiles = new ConcurrentHashSet();
    private final FileTypeAssocTable<FileType> myInitialAssociations = new FileTypeAssocTable();
    private final Map<FileNameMatcher, String> myUnresolvedMappings = new THashMap();
    private final Map<FileNameMatcher, String> myUnresolvedRemovedMappings = new THashMap();
    @NonNls
    private static final String ELEMENT_FILETYPE = "filetype";
    @NonNls
    private static final String ELEMENT_FILETYPES = "filetypes";
    @NonNls
    private static final String ELEMENT_IGNOREFILES = "ignoreFiles";
    @NonNls
    private static final String ATTRIBUTE_LIST = "list";
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ATTRIBUTE_EXTENSIONS = "extensions";
    @NonNls
    private static final String ATTRIBUTE_BINARY = "binary";
    @NonNls
    private static final String ATTRIBUTE_DEFAULT_EXTENSION = "default_extension";
    private final MessageBus myMessageBus;
    private static final Map<String, StandardFileType> ourStandardFileTypes;
    @NonNls
    private static final String[] FILE_TYPES_WITH_PREDEFINED_EXTENSIONS;
    private final SchemesManager<FileType, AbstractFileType> mySchemesManager;
    @NonNls
    private static final String FILE_SPEC = "$ROOT_CONFIG$/filetypes";
    private final Map<FileTypeListener, MessageBusConnection> myAdapters = new HashMap<FileTypeListener, MessageBusConnection>();

    private static void initFactory(FileTypeConsumer consumer, FileTypeFactory factory) {
        factory.createFileTypes(consumer);
    }

    public FileTypeManagerImpl(MessageBus bus, SchemesManagerFactory schemesManagerFactory) {
        this.myMessageBus = bus;
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)new SchemeProcessor<AbstractFileType>(){

            public AbstractFileType readScheme(Document document) throws InvalidDataException {
                SyntaxTable table;
                if (document == null) {
                    throw new InvalidDataException();
                }
                Element root = document.getRootElement();
                if (root == null || !FileTypeManagerImpl.ELEMENT_FILETYPE.equals(root.getName())) {
                    throw new InvalidDataException();
                }
                Element element = root.getChild("highlighting");
                if (element != null && (table = AbstractFileType.readSyntaxTable(element)) != null) {
                    ReadFileType type = new ReadFileType(table, root);
                    String fileTypeName = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_NAME);
                    String fileTypeDescr = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_DESCRIPTION);
                    String iconPath = root.getAttributeValue(FileTypeManagerImpl.ATTRIBUTE_ICON);
                    FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, type);
                    return type;
                }
                return null;
            }

            public boolean shouldBeSaved(AbstractFileType fileType) {
                return FileTypeManagerImpl.this.shouldBeSavedToFile((FileType)fileType);
            }

            public Document writeScheme(AbstractFileType fileType) throws WriteExternalException {
                Element root = new Element(FileTypeManagerImpl.ELEMENT_FILETYPE);
                FileTypeManagerImpl.writeHeader(root, (FileType)fileType);
                fileType.writeExternal(root);
                Element map = new Element("extensionMap");
                root.addContent(map);
                if (fileType instanceof ImportedFileType) {
                    FileTypeManagerImpl.writeImportedExtensionsMap(map, (ImportedFileType)fileType);
                } else {
                    FileTypeManagerImpl.this.writeExtensionsMap(map, (FileType)fileType, false);
                }
                return new Document(root);
            }

            public void initScheme(AbstractFileType scheme) {
            }

            public void onSchemeAdded(AbstractFileType scheme) {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                if (scheme instanceof ReadFileType) {
                    FileTypeManagerImpl.this.loadFileType((ReadFileType)scheme);
                }
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }

            public void onSchemeDeleted(AbstractFileType scheme) {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.myPatternsTable.removeAllAssociations(scheme);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }

            public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
            }
        }, RoamingType.PER_USER);
        for (StandardFileType pair : ourStandardFileTypes.values()) {
            this.registerFileTypeWithoutNotification(pair.fileType, pair.matchers);
        }
        if (this.loadAllFileTypes()) {
            this.restoreStandardFileExtensions();
        }
    }

    private static void writeImportedExtensionsMap(Element map, ImportedFileType type) {
        for (FileNameMatcher matcher : type.getOriginalPatterns()) {
            Element content = AbstractFileType.writeMapping((FileType)type, matcher, false);
            if (content == null) continue;
            map.addContent(content);
        }
    }

    private boolean shouldBeSavedToFile(FileType fileType) {
        if (!(fileType instanceof JDOMExternalizable) || !FileTypeManagerImpl.shouldSave(fileType)) {
            return false;
        }
        return !this.myDefaultTypes.contains(fileType) || FileTypeManagerImpl.isDefaultModified(fileType);
    }

    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getStdFileType must not be null");
        }
        StandardFileType stdFileType = ourStandardFileTypes.get(name);
        Object object = stdFileType != null ? stdFileType.fileType : new PlainTextFileType();
        if (object == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getStdFileType must not return null");
        }
        return object;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{FileTypeManagerImpl.getOrCreateFileTypesDir(), PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = FileTypesBundle.message("filetype.settings.component", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getPresentableName must not return null");
        }
        return string;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    @NotNull
    public FileType getFileTypeByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByFileName must not be null");
        }
        FileType type = this.myPatternsTable.findAssociatedFileType(fileName);
        FileType fileType = type == null ? UnknownFileType.INSTANCE : type;
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByFileName must not return null");
        }
        return fileType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByFile must not be null");
        }
        for (int i = 0; i < this.mySpecialFileTypes.size(); ++i) {
            FileTypeIdentifiableByVirtualFile fileType2 = this.mySpecialFileTypes.get(i);
            if (!fileType2.isMyFileType(file)) continue;
            fileType = fileType2;
            if (fileType == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByFile must not return null");
            return fileType;
        }
        fileType = this.getFileTypeByFileName(file.getName());
        if (fileType != null) return fileType;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByFile must not return null");
    }

    public boolean isFileOfType(VirtualFile file, FileType type) {
        if (type instanceof FileTypeIdentifiableByVirtualFile) {
            return ((FileTypeIdentifiableByVirtualFile)type).isMyFileType(file);
        }
        List<FileNameMatcher> matchers = this.getAssociations(type);
        for (FileNameMatcher matcher : matchers) {
            if (!matcher.accept(file.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public FileType getFileTypeByExtension(@NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByExtension must not be null");
        }
        FileType fileType = this.getFileTypeByFileName("IntelliJ_IDEA_RULES." + extension);
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getFileTypeByExtension must not return null");
        }
        return fileType;
    }

    @Override
    public void registerFileType(FileType fileType) {
        this.registerFileType(fileType, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public void registerFileType(final @NotNull FileType type, final @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.registerFileType must not be null");
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.registerFileType must not be null");
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileTypeManagerImpl.this.fireBeforeFileTypesChanged();
                FileTypeManagerImpl.this.registerFileTypeWithoutNotification(type, defaultAssociations);
                FileTypeManagerImpl.this.fireFileTypesChanged();
            }
        });
    }

    @Override
    public void unregisterFileType(FileType fileType) {
        this.fireBeforeFileTypesChanged();
        this.unregisterFileTypeWithoutNotification(fileType);
        this.fireFileTypesChanged();
    }

    private void unregisterFileTypeWithoutNotification(FileType fileType) {
        this.removeAllAssociations(fileType);
        this.mySchemesManager.removeScheme((Scheme)fileType);
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            FileTypeIdentifiableByVirtualFile fakeFileType = (FileTypeIdentifiableByVirtualFile)fileType;
            this.mySpecialFileTypes.remove(fakeFileType);
        }
    }

    @NotNull
    public FileType[] getRegisteredFileTypes() {
        List fileTypes = this.mySchemesManager.getAllSchemes();
        FileType[] fileTypeArray = fileTypes.toArray(new FileType[fileTypes.size()]);
        if (fileTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getRegisteredFileTypes must not return null");
        }
        return fileTypeArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String string = fileName.substring(index + 1);
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getExtension must not return null");
        return string2;
    }

    @NotNull
    public String getIgnoredFilesList() {
        StringBuilder sb = new StringBuilder();
        for (String ignoreMask : this.myIgnoredFileMasksSet) {
            sb.append(ignoreMask);
            sb.append(';');
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getIgnoredFilesList must not return null");
        }
        return string;
    }

    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.setIgnoredFilesList must not be null");
        }
        this.fireBeforeFileTypesChanged();
        this.setIgnoredFilesListWithoutNotification(list);
        this.fireFileTypesChanged();
    }

    private void setIgnoredFilesListWithoutNotification(String list) {
        this.myIgnoredFileMasksSet.clear();
        this.myIgnorePatterns.clear();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            String ignoredFile = tokenizer.nextToken();
            if (ignoredFile == null || this.myIgnoredFileMasksSet.contains(ignoredFile)) continue;
            if (!this.myIgnoredFileMasksSet.contains(ignoredFile)) {
                this.myIgnorePatterns.add(PatternUtil.fromMask((String)ignoredFile));
            }
            this.myIgnoredFileMasksSet.add(ignoredFile);
        }
        Pattern p = Pattern.compile(".*\\.__del__");
        this.myIgnorePatterns.add(p);
    }

    @Override
    public boolean isIgnoredFilesListEqualToCurrent(String list) {
        THashSet tempSet = new THashSet();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            tempSet.add(tokenizer.nextToken());
        }
        return tempSet.equals(this.myIgnoredFileMasksSet);
    }

    public boolean isFileIgnored(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.isFileIgnored must not be null");
        }
        if (this.myNotIgnoredFiles.contains(name)) {
            return false;
        }
        if (this.myIgnoredFiles.contains(name)) {
            return true;
        }
        for (Pattern pattern : this.myIgnorePatterns) {
            if (!pattern.matcher(name).matches()) continue;
            this.myIgnoredFiles.add(name);
            return true;
        }
        this.myNotIgnoredFiles.add(name);
        return false;
    }

    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getAssociatedExtensions must not be null");
        }
        String[] stringArray = this.myPatternsTable.getAssociatedExtensions(type);
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getAssociatedExtensions must not return null");
        }
        return stringArray;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getAssociations must not be null");
        }
        List<FileNameMatcher> list = this.myPatternsTable.getAssociations(type);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getAssociations must not return null");
        }
        return list;
    }

    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.associate must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.associate must not be null");
        }
        this.associate(type, matcher, true);
    }

    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.removeAssociation must not be null");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.removeAssociation must not be null");
        }
        this.removeAssociation(type, matcher, true);
    }

    private void removeAllAssociations(FileType type) {
        this.myPatternsTable.removeAllAssociations(type);
    }

    @Override
    public void fireBeforeFileTypesChanged() {
        FileTypeEvent event = new FileTypeEvent((FileTypeManager)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(AppTopics.FILE_TYPES)).beforeFileTypesChanged(event);
    }

    @Override
    public SchemesManager<FileType, AbstractFileType> getSchemesManager() {
        return this.mySchemesManager;
    }

    @Override
    public void fireFileTypesChanged() {
        this.myNotIgnoredFiles.clear();
        this.myIgnoredFiles.clear();
        FileTypeEvent event = new FileTypeEvent((FileTypeManager)this);
        ((FileTypeListener)this.myMessageBus.syncPublisher(AppTopics.FILE_TYPES)).fileTypesChanged(event);
    }

    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.addFileTypeListener must not be null");
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(AppTopics.FILE_TYPES, (Object)listener);
        this.myAdapters.put(listener, connection);
    }

    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.removeFileTypeListener must not be null");
        }
        MessageBusConnection connection = this.myAdapters.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }

    private static boolean isDefaultModified(FileType fileType) {
        if (fileType instanceof ExternalizableFileType) {
            return ((ExternalizableFileType)fileType).isModified();
        }
        return true;
    }

    public String getExternalFileName() {
        return ELEMENT_FILETYPES;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        int savedVersion = FileTypeManagerImpl.getVersion(parentNode);
        for (Object o : parentNode.getChildren()) {
            Element e = (Element)o;
            if (ELEMENT_FILETYPES.equals(e.getName())) {
                List children = e.getChildren(ELEMENT_FILETYPE);
                for (Object aChildren : children) {
                    Element element = (Element)aChildren;
                    this.loadFileType(element, true, null, false);
                }
                continue;
            }
            if (ELEMENT_IGNOREFILES.equals(e.getName())) {
                this.setIgnoredFilesListWithoutNotification(e.getAttributeValue(ATTRIBUTE_LIST));
                continue;
            }
            if (!"extensionMap".equals(e.getName())) continue;
            this.readGlobalMappings(e);
        }
        if (savedVersion == 0) {
            this.addIgnore(".svn");
        }
        if (savedVersion < 2) {
            this.restoreStandardFileExtensions();
        }
        if (savedVersion < 4) {
            this.addIgnore("*.pyc");
            this.addIgnore("*.pyo");
            this.addIgnore(".git");
        }
        if (savedVersion < 5) {
            this.addIgnore("*.hprof");
        }
        if (savedVersion < 6) {
            this.addIgnore("_svn");
        }
        if (savedVersion < 7) {
            this.addIgnore(".hg");
        }
    }

    private void readGlobalMappings(Element e) {
        List<Pair<FileNameMatcher, String>> associations = AbstractFileType.readAssociations(e);
        for (Pair<FileNameMatcher, String> association : associations) {
            FileType type = this.getFileTypeByName((String)association.getSecond());
            if (type != null) {
                this.associate(type, (FileNameMatcher)association.getFirst(), false);
                continue;
            }
            this.myUnresolvedMappings.put((FileNameMatcher)association.getFirst(), (String)association.getSecond());
        }
        List<Pair<FileNameMatcher, String>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Pair<FileNameMatcher, String> removedAssociation : removedAssociations) {
            FileType type = this.getFileTypeByName((String)removedAssociation.getSecond());
            if (type != null) {
                this.removeAssociation(type, (FileNameMatcher)removedAssociation.getFirst(), false);
                continue;
            }
            this.myUnresolvedRemovedMappings.put((FileNameMatcher)removedAssociation.getFirst(), (String)removedAssociation.getSecond());
        }
    }

    private void readMappingsForFileType(Element e, FileType type) {
        List<Pair<FileNameMatcher, String>> associations = AbstractFileType.readAssociations(e);
        for (Pair<FileNameMatcher, String> association : associations) {
            this.associate(type, (FileNameMatcher)association.getFirst(), false);
        }
        List<Pair<FileNameMatcher, String>> removedAssociations = AbstractFileType.readRemovedAssociations(e);
        for (Pair<FileNameMatcher, String> removedAssociation : removedAssociations) {
            this.removeAssociation(type, (FileNameMatcher)removedAssociation.getFirst(), false);
        }
    }

    private void addIgnore(@NonNls String ignoreMask) {
        if (!this.myIgnoredFileMasksSet.contains(ignoreMask)) {
            this.myIgnorePatterns.add(PatternUtil.fromMask((String)ignoreMask));
            this.myIgnoredFileMasksSet.add(ignoreMask);
        }
    }

    private void restoreStandardFileExtensions() {
        for (String name : FILE_TYPES_WITH_PREDEFINED_EXTENSIONS) {
            StandardFileType stdFileType = ourStandardFileTypes.get(name);
            if (stdFileType == null) continue;
            FileType fileType = stdFileType.fileType;
            for (FileNameMatcher matcher : this.myPatternsTable.getAssociations(fileType)) {
                FileType defaultFileType = this.myInitialAssociations.findAssociatedFileType(matcher);
                if (defaultFileType == null || defaultFileType == fileType) continue;
                this.removeAssociation(fileType, matcher, false);
                this.associate(defaultFileType, matcher, false);
            }
            for (FileNameMatcher matcher : this.myInitialAssociations.getAssociations(fileType)) {
                this.associate(fileType, matcher, false);
            }
        }
    }

    private static int getVersion(Element node) {
        String verString = node.getAttributeValue(ATTRIBUTE_VERSION);
        if (verString == null) {
            return 0;
        }
        try {
            return Integer.parseInt(verString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        parentNode.setAttribute(ATTRIBUTE_VERSION, String.valueOf(7));
        Element element = new Element(ELEMENT_IGNOREFILES);
        parentNode.addContent(element);
        element.setAttribute(ATTRIBUTE_LIST, this.getIgnoredFilesList());
        Element map = new Element("extensionMap");
        parentNode.addContent(map);
        List<FileType> fileTypes = Arrays.asList(this.getRegisteredFileTypes());
        Collections.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (FileType type : fileTypes) {
            this.writeExtensionsMap(map, type, true);
        }
    }

    private void writeExtensionsMap(Element map, FileType type, boolean specifyTypeName) {
        Element content;
        List<FileNameMatcher> assocs = this.myPatternsTable.getAssociations(type);
        HashSet<FileNameMatcher> defaultAssocs = new HashSet<FileNameMatcher>(this.myInitialAssociations.getAssociations(type));
        for (FileNameMatcher matcher : assocs) {
            if (defaultAssocs.contains(matcher)) {
                defaultAssocs.remove(matcher);
                continue;
            }
            if (!FileTypeManagerImpl.shouldSave(type) || type instanceof ImportedFileType && ((ImportedFileType)type).getOriginalPatterns().contains(matcher) || (content = AbstractFileType.writeMapping(type, matcher, specifyTypeName)) == null) continue;
            map.addContent(content);
        }
        for (FileNameMatcher matcher : defaultAssocs) {
            content = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName);
            if (content == null) continue;
            map.addContent(content);
        }
        if (type instanceof ImportedFileType) {
            List<FileNameMatcher> original = ((ImportedFileType)type).getOriginalPatterns();
            for (FileNameMatcher matcher : original) {
                Element content2;
                if (assocs.contains(matcher) || (content2 = AbstractFileType.writeRemovedMapping(type, matcher, specifyTypeName)) == null) continue;
                map.addContent(content2);
            }
        }
    }

    @Nullable
    private FileType getFileTypeByName(String name) {
        return (FileType)this.mySchemesManager.findSchemeByName(name);
    }

    private static List<FileNameMatcher> parse(@NonNls String semicolonDelimited) {
        if (semicolonDelimited == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<FileNameMatcher> list = new ArrayList<FileNameMatcher>();
        while (tokenizer.hasMoreTokens()) {
            list.add((FileNameMatcher)new ExtensionFileNameMatcher(tokenizer.nextToken().trim()));
        }
        return list;
    }

    private void registerFileTypeWithoutNotification(FileType fileType, List<FileNameMatcher> matchers) {
        String name;
        this.mySchemesManager.addNewScheme((Scheme)fileType, true);
        for (FileNameMatcher matcher : matchers) {
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myInitialAssociations.addAssociation(matcher, fileType);
        }
        if (fileType instanceof FileTypeIdentifiableByVirtualFile) {
            this.mySpecialFileTypes.add((FileTypeIdentifiableByVirtualFile)fileType);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedMappings.keySet())) {
            name = this.myUnresolvedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.myPatternsTable.addAssociation(matcher, fileType);
            this.myUnresolvedMappings.remove(matcher);
        }
        for (FileNameMatcher matcher : new THashSet(this.myUnresolvedRemovedMappings.keySet())) {
            name = this.myUnresolvedRemovedMappings.get(matcher);
            if (!Comparing.equal((String)name, (String)fileType.getName())) continue;
            this.removeAssociation(fileType, matcher, false);
            this.myUnresolvedRemovedMappings.remove(matcher);
        }
    }

    private boolean loadAllFileTypes() {
        Collection collection = this.mySchemesManager.loadSchemes();
        boolean res = false;
        for (AbstractFileType fileType : collection) {
            ReadFileType readFileType = (ReadFileType)fileType;
            FileType loadedFileType = this.loadFileType(readFileType);
            res |= this.myInitialAssociations.hasAssociationsFor(loadedFileType);
        }
        return res;
    }

    private FileType loadFileType(ReadFileType readFileType) {
        return this.loadFileType(readFileType.getElement(), false, this.mySchemesManager.isShared((Scheme)readFileType) ? readFileType.getExternalInfo() : null, true);
    }

    private FileType loadFileType(Element typeElement, boolean isDefaults, ExternalInfo info, boolean ignoreExisting) {
        String fileTypeName = typeElement.getAttributeValue(ATTRIBUTE_NAME);
        String fileTypeDescr = typeElement.getAttributeValue(ATTRIBUTE_DESCRIPTION);
        String iconPath = typeElement.getAttributeValue(ATTRIBUTE_ICON);
        String extensionsStr = typeElement.getAttributeValue(ATTRIBUTE_EXTENSIONS);
        FileType type = this.getFileTypeByName(fileTypeName);
        if (isDefaults && !ignoreExisting) {
            extensionsStr = this.filterAlreadyRegisteredExtensions(extensionsStr);
        }
        List<FileNameMatcher> exts = FileTypeManagerImpl.parse(extensionsStr);
        if (type != null && !ignoreExisting) {
            if (isDefaults) {
                return type;
            }
            if (extensionsStr != null) {
                this.removeAllAssociations(type);
                for (FileNameMatcher ext : exts) {
                    this.associate(type, ext, false);
                }
            }
            if (type instanceof JDOMExternalizable) {
                try {
                    ((JDOMExternalizable)type).readExternal(typeElement);
                }
                catch (InvalidDataException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            type = FileTypeManagerImpl.loadCustomFile(typeElement, info);
            if (type instanceof UserFileType) {
                FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, (UserFileType)type);
            }
            this.registerFileTypeWithoutNotification(type, exts);
        }
        if (type instanceof UserFileType) {
            UserFileType ft = (UserFileType)type;
            FileTypeManagerImpl.setFileTypeAttributes(fileTypeName, fileTypeDescr, iconPath, ft);
        }
        if (isDefaults) {
            this.myDefaultTypes.add(type);
            if (type instanceof ExternalizableFileType) {
                ((ExternalizableFileType)type).markDefaultSettings();
            }
        } else {
            Element extensions = typeElement.getChild("extensionMap");
            if (extensions != null) {
                this.readMappingsForFileType(extensions, type);
            }
        }
        return type;
    }

    private String filterAlreadyRegisteredExtensions(String semicolonDelimited) {
        StringTokenizer tokenizer = new StringTokenizer(semicolonDelimited, ";", false);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String extension = tokenizer.nextToken().trim();
            if (this.getFileTypeByExtension(extension) != UnknownFileType.INSTANCE) continue;
            list.add(extension);
        }
        return StringUtil.join(list, (String)";");
    }

    private static FileType loadCustomFile(Element typeElement, ExternalInfo info) {
        CustomFileTypeFactory factory;
        SyntaxTable table;
        AbstractFileType type = null;
        Element element = typeElement.getChild("highlighting");
        if (element != null && (table = AbstractFileType.readSyntaxTable(element)) != null) {
            if (info == null) {
                type = new AbstractFileType(table);
            } else {
                type = new ImportedFileType(table, info);
                ((ImportedFileType)type).readOriginalMatchers(typeElement);
            }
            type.initSupport();
            return type;
        }
        CustomFileTypeFactory[] arr$ = (CustomFileTypeFactory[])Extensions.getExtensions(CustomFileTypeFactory.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (type = (factory = arr$[i$]).createFileType(typeElement)) == null; ++i$) {
        }
        if (type == null) {
            type = new UserBinaryFileType();
        }
        return type;
    }

    private static void setFileTypeAttributes(String fileTypeName, String fileTypeDescr, String iconPath, UserFileType ft) {
        if (iconPath != null && !"".equals(iconPath.trim())) {
            Icon icon = IconLoader.getIcon((String)iconPath);
            ft.setIcon(icon);
        }
        if (fileTypeDescr != null) {
            ft.setDescription(fileTypeDescr);
        }
        if (fileTypeName != null) {
            ft.setName(fileTypeName);
        }
    }

    private static File getOrCreateFileTypesDir() {
        String directoryPath = PathManager.getConfigPath() + File.separator + ELEMENT_FILETYPES;
        File directory = new File(directoryPath);
        if (!directory.exists() && !directory.mkdir()) {
            LOG.error("Could not create directory: " + directory.getAbsolutePath());
            return null;
        }
        return directory;
    }

    private static boolean shouldSave(FileType fileType) {
        return fileType != FileTypes.UNKNOWN && !fileType.isReadOnly();
    }

    private static void writeHeader(Element root, FileType fileType) {
        root.setAttribute(ATTRIBUTE_BINARY, String.valueOf(fileType.isBinary()));
        root.setAttribute(ATTRIBUTE_DEFAULT_EXTENSION, fileType.getDefaultExtension());
        root.setAttribute(ATTRIBUTE_DESCRIPTION, fileType.getDescription());
        root.setAttribute(ATTRIBUTE_NAME, fileType.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getComponentName() {
        if (!"Idea".equals(System.getProperty("idea.platform.prefix"))) return "FileTypeManager";
        return "CommunityFileTypes";
    }

    public FileTypeAssocTable getExtensionMap() {
        return this.myPatternsTable;
    }

    public void setPatternsTable(Set<FileType> fileTypes, FileTypeAssocTable assocTable) {
        this.fireBeforeFileTypesChanged();
        this.mySchemesManager.clearAllSchemes();
        for (FileType fileType : fileTypes) {
            this.mySchemesManager.addNewScheme((Scheme)fileType, true);
            if (!(fileType instanceof AbstractFileType)) continue;
            ((AbstractFileType)fileType).initSupport();
        }
        this.myPatternsTable = assocTable.copy();
        this.fireFileTypesChanged();
    }

    public void associate(FileType fileType, FileNameMatcher matcher, boolean fireChange) {
        if (!this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.addAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    public void removeAssociation(FileType fileType, FileNameMatcher matcher, boolean fireChange) {
        if (this.myPatternsTable.isAssociatedWith(fileType, matcher)) {
            if (fireChange) {
                this.fireBeforeFileTypesChanged();
            }
            this.myPatternsTable.removeAssociation(matcher, fileType);
            if (fireChange) {
                this.fireFileTypesChanged();
            }
        }
    }

    @Nullable
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl.getKnownFileTypeOrAssociate must not be null");
        }
        return FileTypeChooser.getKnownFileTypeOrAssociate(file);
    }

    static {
        FileTypeFactory[] fileTypeFactories;
        LOG = Logger.getInstance((String)"#com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl");
        ourStandardFileTypes = new LinkedHashMap<String, StandardFileType>();
        FILE_TYPES_WITH_PREDEFINED_EXTENSIONS = new String[]{"JSP", "JSPX", "DTD", "HTML", "Properties", "XHTML"};
        FileTypeConsumer consumer = new FileTypeConsumer(){

            public void consume(@NotNull FileType fileType, String extensions) {
                if (fileType == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1.consume must not be null");
                }
                this.register(fileType, FileTypeManagerImpl.parse(extensions));
            }

            public void consume(@NotNull FileType fileType, FileNameMatcher ... matchers) {
                if (fileType == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1.consume must not be null");
                }
                this.register(fileType, new ArrayList<FileNameMatcher>(Arrays.asList(matchers)));
            }

            public FileType getStandardFileTypeByName(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/impl/FileTypeManagerImpl$1.getStandardFileTypeByName must not be null");
                }
                StandardFileType type = (StandardFileType)ourStandardFileTypes.get(name);
                return type != null ? type.fileType : null;
            }

            private void register(FileType fileType, List<FileNameMatcher> fileNameMatchers) {
                StandardFileType type = (StandardFileType)ourStandardFileTypes.get(fileType.getName());
                if (type != null) {
                    for (FileNameMatcher matcher : fileNameMatchers) {
                        type.matchers.add(matcher);
                    }
                } else {
                    ourStandardFileTypes.put(fileType.getName(), new StandardFileType(fileType, fileNameMatchers));
                }
            }
        };
        for (FileTypeFactory factory : fileTypeFactories = (FileTypeFactory[])Extensions.getExtensions((ExtensionPointName)FileTypeFactory.FILE_TYPE_FACTORY_EP)) {
            try {
                FileTypeManagerImpl.initFactory(consumer, factory);
            }
            catch (Error ex) {
                PluginManager.disableIncompatiblePlugin((Object)factory, (Throwable)ex);
            }
        }
    }

    private static class StandardFileType {
        private final FileType fileType;
        private final List<FileNameMatcher> matchers;

        private StandardFileType(FileType fileType, List<FileNameMatcher> matchers) {
            this.fileType = fileType;
            this.matchers = matchers;
        }
    }
}

