/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.Nullable;

public class TextEditorPsiDataProvider
implements EditorDataProvider {
    @Nullable
    public Object getData(String dataId, Editor e, VirtualFile file) {
        if (!file.isValid()) {
            return null;
        }
        if (dataId.equals(AnActionEvent.injectedId((String)PlatformDataKeys.EDITOR.getName()))) {
            if (PsiDocumentManager.getInstance((Project)e.getProject()).isUncommited(e.getDocument())) {
                return e;
            }
            return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(e, TextEditorPsiDataProvider.getPsiFile(e, file));
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_ELEMENT.getName()))) {
            return TextEditorPsiDataProvider.getPsiElementIn((Editor)this.getData(AnActionEvent.injectedId((String)PlatformDataKeys.EDITOR.getName()), e, file), file);
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiElementIn(e, file);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.LANGUAGE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, file);
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)PlatformDataKeys.EDITOR.getName()), e, file);
            if (psiFile == null || editor == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(editor, psiFile);
        }
        if (LangDataKeys.LANGUAGE.is(dataId)) {
            PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(e, file);
            if (psiFile == null) {
                return null;
            }
            return TextEditorPsiDataProvider.getLanguageAtCurrentPositionInEditor(e, psiFile);
        }
        if (dataId.equals(AnActionEvent.injectedId((String)PlatformDataKeys.VIRTUAL_FILE.getName()))) {
            PsiFile psiFile = (PsiFile)this.getData(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()), e, file);
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        }
        if (dataId.equals(AnActionEvent.injectedId((String)LangDataKeys.PSI_FILE.getName()))) {
            Editor editor = (Editor)this.getData(AnActionEvent.injectedId((String)PlatformDataKeys.EDITOR.getName()), e, file);
            if (editor == null) {
                return null;
            }
            Project project = editor.getProject();
            if (project == null) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (LangDataKeys.PSI_FILE.is(dataId)) {
            return TextEditorPsiDataProvider.getPsiFile(e, file);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            PsiDirectory psiDirectory;
            PsiFile psiFile = PsiManager.getInstance((Project)e.getProject()).findFile(file);
            PsiDirectory psiDirectory2 = psiDirectory = psiFile != null ? psiFile.getParent() : null;
            if (psiDirectory != null && psiDirectory.isPhysical()) {
                return new IdeView(){

                    public void selectElement(PsiElement element) {
                        Editor editor = EditorHelper.openInEditor(element);
                        if (editor != null) {
                            ToolWindowManager.getInstance((Project)element.getProject()).activateEditorComponent();
                        }
                    }

                    public PsiDirectory[] getDirectories() {
                        return new PsiDirectory[]{psiDirectory};
                    }

                    public PsiDirectory getOrChooseDirectory() {
                        return psiDirectory;
                    }
                };
            }
        }
        return null;
    }

    private static Language getLanguageAtCurrentPositionInEditor(Editor editor, PsiFile psiFile) {
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        return PsiUtilBase.getLanguageAtOffset((PsiFile)psiFile, (int)mostProbablyCorrectLanguageOffset);
    }

    @Nullable
    private static PsiElement getPsiElementIn(Editor editor, VirtualFile file) {
        PsiFile psiFile = TextEditorPsiDataProvider.getPsiFile(editor, file);
        if (psiFile == null) {
            return null;
        }
        try {
            return TargetElementUtilBase.findTargetElement(editor, TargetElementUtilBase.getInstance().getReferenceSearchFlags());
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private static PsiFile getPsiFile(Editor e, VirtualFile file) {
        if (!file.isValid()) {
            return null;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile != null && psiFile.isValid() ? psiFile : null;
    }
}

