/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.createEditor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.createEditor must not be null");
        }
        LOG.assertTrue(this.accept(project, file));
        PsiAwareTextEditorImpl psiAwareTextEditorImpl = new PsiAwareTextEditorImpl(project, file, this);
        if (psiAwareTextEditorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.createEditor must not return null");
        }
        return psiAwareTextEditorImpl;
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.readState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.readState must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.readState must not be null");
        }
        TextEditorState state = (TextEditorState)super.readState(element, project, file);
        Element child = element.getChild(FOLDING_ELEMENT);
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        state.FOLDING_STATE = child != null && document != null ? CodeFoldingManager.getInstance(project).readFoldingState(child, document) : null;
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.readState must not return null");
        }
        return textEditorState;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.writeState must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.writeState must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.writeState must not be null");
        }
        super.writeState(_state, project, element);
        TextEditorState state = (TextEditorState)_state;
        if (state.FOLDING_STATE != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project).writeFoldingState(state.FOLDING_STATE, e);
            }
            catch (WriteExternalException e1) {
                // empty catch block
            }
            element.addContent(e);
        }
    }

    @Override
    protected TextEditorState getStateImpl(Project project, Editor editor, @NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider.getStateImpl must not be null");
        }
        TextEditorState state = super.getStateImpl(project, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project != null) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                state.FOLDING_STATE = CodeFoldingManager.getInstance(project).saveFoldingState(editor);
            } else {
                state.FOLDING_STATE = null;
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(final Project project, final Editor editor, final TextEditorState state) {
        super.setStateImpl(project, editor, state);
        if (project != null && state.FOLDING_STATE != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    CodeFoldingManager.getInstance(project).restoreFoldingState(editor, state.FOLDING_STATE);
                }
            });
        }
    }

    @Override
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(Editor editor) {
        return new PsiAwareEditorWrapper(editor);
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            super(editor);
            Project project = editor.getProject();
            this.myBackgroundHighlighter = project == null ? null : new TextEditorBackgroundHighlighter(project, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }
    }
}

