/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FileEditorInfoPane
extends JPanel {
    private int myCounter = 0;
    private final JPanel myCards;
    private final JButton myPrevButton;
    private final JButton myNextButton;
    private final List<JComponent> myComponents;
    private final JPanel myButtonsPanel;

    public FileEditorInfoPane() {
        super(new BorderLayout());
        final CardLayout layout = new CardLayout();
        this.myCards = new JPanel(layout);
        this.myComponents = new ArrayList<JComponent>();
        this.add((Component)this.myCards, "Center");
        this.myPrevButton = new JButton("<");
        this.myNextButton = new JButton(">");
        this.myButtonsPanel = new JPanel(new GridLayout(1, 2));
        this.myButtonsPanel.add(this.myPrevButton);
        this.myButtonsPanel.add(this.myNextButton);
        this.myPrevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                layout.previous(FileEditorInfoPane.this.myCards);
                FileEditorInfoPane.this.updateButtons();
            }
        });
        this.myNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                layout.next(FileEditorInfoPane.this.myCards);
                FileEditorInfoPane.this.updateButtons();
            }
        });
        this.add((Component)this.myButtonsPanel, "East");
        this.myButtonsPanel.setVisible(false);
        this.setVisible(false);
    }

    public void addInfo(JComponent component) {
        this.myComponents.add(component);
        this.myCards.add((Component)component, String.valueOf(this.myCounter++));
        this.updateButtons();
        this.validate();
    }

    public void removeInfo(JComponent component) {
        this.myComponents.remove(component);
        this.myCards.remove(component);
        this.updateButtons();
        this.validate();
    }

    private int getCurrentCard() {
        for (int i = 0; i < this.myComponents.size(); ++i) {
            if (!this.myComponents.get(i).isVisible()) continue;
            return i;
        }
        return -1;
    }

    private void updateButtons() {
        int count = this.myComponents.size();
        if (count > 0) {
            this.setVisible(true);
            if (count == 1) {
                this.myButtonsPanel.setVisible(false);
            } else {
                this.myButtonsPanel.setVisible(true);
                int currentCard = this.getCurrentCard();
                this.myNextButton.setEnabled(currentCard + 1 < count);
                this.myPrevButton.setEnabled(currentCard - 1 >= 0);
            }
        } else {
            this.setVisible(false);
        }
    }
}

