/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.event;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EditorEventMulticasterImpl
implements EditorEventMulticasterEx {
    private final EventDispatcher<DocumentListener> myDocumentMulticaster = EventDispatcher.create(DocumentListener.class);
    private final EventDispatcher<EditReadOnlyListener> myEditReadOnlyMulticaster = EventDispatcher.create(EditReadOnlyListener.class);
    private final EventDispatcher<EditorMouseListener> myEditorMouseMulticaster = EventDispatcher.create(EditorMouseListener.class);
    private final EventDispatcher<EditorMouseMotionListener> myEditorMouseMotionMulticaster = EventDispatcher.create(EditorMouseMotionListener.class);
    private final EventDispatcher<ErrorStripeListener> myErrorStripeMulticaster = EventDispatcher.create(ErrorStripeListener.class);
    private final EventDispatcher<CaretListener> myCaretMulticaster = EventDispatcher.create(CaretListener.class);
    private final EventDispatcher<SelectionListener> mySelectionMulticaster = EventDispatcher.create(SelectionListener.class);
    private final EventDispatcher<VisibleAreaListener> myVisibleAreaMulticaster = EventDispatcher.create(VisibleAreaListener.class);
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
    private final EventDispatcher<FocusChangeListener> myFocusChangeListenerMulticaster = EventDispatcher.create(FocusChangeListener.class);

    public void registerDocument(DocumentEx document) {
        document.addDocumentListener((DocumentListener)this.myDocumentMulticaster.getMulticaster());
        document.addEditReadOnlyListener((EditReadOnlyListener)this.myEditReadOnlyMulticaster.getMulticaster());
    }

    public void registerEditor(EditorEx editor) {
        editor.addEditorMouseListener((EditorMouseListener)this.myEditorMouseMulticaster.getMulticaster());
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this.myEditorMouseMotionMulticaster.getMulticaster());
        ((EditorMarkupModel)editor.getMarkupModel()).addErrorMarkerListener((ErrorStripeListener)this.myErrorStripeMulticaster.getMulticaster());
        editor.getCaretModel().addCaretListener((CaretListener)this.myCaretMulticaster.getMulticaster());
        editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionMulticaster.getMulticaster());
        editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this.myVisibleAreaMulticaster.getMulticaster());
        editor.addPropertyChangeListener((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster());
        editor.addFocusListener((FocusChangeListener)this.myFocusChangeListenerMulticaster.getMulticaster());
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentMulticaster.addListener((EventListener)listener);
    }

    public void addDocumentListener(final DocumentListener listener, Disposable parentDisposable) {
        this.addDocumentListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                EditorEventMulticasterImpl.this.removeDocumentListener(listener);
            }
        });
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentMulticaster.removeListener((EventListener)listener);
    }

    public void addEditorMouseListener(EditorMouseListener listener) {
        this.myEditorMouseMulticaster.addListener((EventListener)listener);
    }

    public void addEditorMouseListener(final EditorMouseListener listener, Disposable parentDisposable) {
        this.addEditorMouseListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                EditorEventMulticasterImpl.this.removeEditorMouseListener(listener);
            }
        });
    }

    public void removeEditorMouseListener(EditorMouseListener listener) {
        this.myEditorMouseMulticaster.removeListener((EventListener)listener);
    }

    public void addEditorMouseMotionListener(EditorMouseMotionListener listener) {
        this.myEditorMouseMotionMulticaster.addListener((EventListener)listener);
    }

    public void addEditorMouseMotionListener(final EditorMouseMotionListener listener, Disposable parentDisposable) {
        this.addEditorMouseMotionListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                EditorEventMulticasterImpl.this.removeEditorMouseMotionListener(listener);
            }
        });
    }

    public void removeEditorMouseMotionListener(EditorMouseMotionListener listener) {
        this.myEditorMouseMotionMulticaster.removeListener((EventListener)listener);
    }

    public void addCaretListener(CaretListener listener) {
        this.myCaretMulticaster.addListener((EventListener)listener);
    }

    public void addCaretListener(final CaretListener listener, Disposable parentDisposable) {
        this.addCaretListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                EditorEventMulticasterImpl.this.removeCaretListener(listener);
            }
        });
    }

    public void removeCaretListener(CaretListener listener) {
        this.myCaretMulticaster.removeListener((EventListener)listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mySelectionMulticaster.addListener((EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.mySelectionMulticaster.removeListener((EventListener)listener);
    }

    @Override
    public void addErrorStripeListener(ErrorStripeListener listener) {
        this.myErrorStripeMulticaster.addListener((EventListener)listener);
    }

    @Override
    public void removeErrorStripeListener(ErrorStripeListener listener) {
        this.myErrorStripeMulticaster.removeListener((EventListener)listener);
    }

    public void addVisibleAreaListener(VisibleAreaListener listener) {
        this.myVisibleAreaMulticaster.addListener((EventListener)listener);
    }

    public void removeVisibleAreaListener(VisibleAreaListener listener) {
        this.myVisibleAreaMulticaster.removeListener((EventListener)listener);
    }

    @Override
    public void addEditReadOnlyListener(EditReadOnlyListener listener) {
        this.myEditReadOnlyMulticaster.addListener((EventListener)listener);
    }

    @Override
    public void removeEditReadOnlyListener(EditReadOnlyListener listener) {
        this.myEditReadOnlyMulticaster.removeListener((EventListener)listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeMulticaster.addListener((EventListener)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeMulticaster.removeListener((EventListener)listener);
    }

    @Override
    public void addFocusChangeListner(FocusChangeListener listener) {
        this.myFocusChangeListenerMulticaster.addListener((EventListener)listener);
    }

    @Override
    public void removeFocusChangeListner(FocusChangeListener listener) {
        this.myFocusChangeListenerMulticaster.removeListener((EventListener)listener);
    }

    public Map<Class, List> getListeners() {
        LinkedHashMap<Class, List> myCopy = new LinkedHashMap<Class, List>();
        myCopy.put(DocumentListener.class, new ArrayList(this.myDocumentMulticaster.getListeners()));
        myCopy.put(EditReadOnlyListener.class, new ArrayList(this.myEditReadOnlyMulticaster.getListeners()));
        myCopy.put(EditorMouseListener.class, new ArrayList(this.myEditorMouseMulticaster.getListeners()));
        myCopy.put(EditorMouseMotionListener.class, new ArrayList(this.myEditorMouseMotionMulticaster.getListeners()));
        myCopy.put(ErrorStripeListener.class, new ArrayList(this.myErrorStripeMulticaster.getListeners()));
        myCopy.put(CaretListener.class, new ArrayList(this.myCaretMulticaster.getListeners()));
        myCopy.put(SelectionListener.class, new ArrayList(this.mySelectionMulticaster.getListeners()));
        myCopy.put(VisibleAreaListener.class, new ArrayList(this.myVisibleAreaMulticaster.getListeners()));
        myCopy.put(PropertyChangeListener.class, new ArrayList(this.myPropertyChangeMulticaster.getListeners()));
        myCopy.put(FocusChangeListener.class, new ArrayList(this.myFocusChangeListenerMulticaster.getListeners()));
        return myCopy;
    }
}

