/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.codeInsight.hint.DocumentFragmentTooltipRenderer;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.impl.BorderEffect;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.ContextMenuImpl;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.IndentsModelImpl;
import com.intellij.openapi.editor.impl.IterationState;
import com.intellij.openapi.editor.impl.LeftHandScrollbarLayout;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelEvent;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JScrollPane2;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.EmptyClipboardOwner;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TIntArrayList;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorImpl
extends UserDataHolderBase
implements EditorEx,
HighlighterClient,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorImpl");
    private static final Key DND_COMMAND_KEY = Key.create((String)"DndCommand");
    public static final Key<Boolean> DO_DOCUMENT_UPDATE_TEST = Key.create((String)"DoDocumentUpdateTest");
    private final DocumentImpl myDocument;
    private final JPanel myPanel;
    private final JScrollPane myScrollPane;
    private final EditorComponentImpl myEditorComponent;
    private final EditorGutterComponentImpl myGutterComponent;
    private final CommandProcessor myCommandProcessor;
    private final MyScrollBar myVerticalScrollBar;
    private final CopyOnWriteArrayList<EditorMouseListener> myMouseListeners = ContainerUtil.createEmptyCOWList();
    private final CopyOnWriteArrayList<EditorMouseMotionListener> myMouseMotionListeners;
    private int myCharHeight = -1;
    private int myLineHeight = -1;
    private int myDescent = -1;
    private boolean myIsInsertMode = true;
    private final CaretCursor myCaretCursor;
    private final ScrollingTimer myScrollingTimer = new ScrollingTimer();
    private final Key<Object> MOUSE_DRAGGED_GROUP = Key.create((String)"MouseDraggedGroup");
    private final DocumentListener myEditorDocumentAdapter;
    private final SettingsImpl mySettings;
    private boolean isReleased = false;
    private MouseEvent myMousePressedEvent = null;
    private int mySavedSelectionStart = -1;
    private int mySavedSelectionEnd = -1;
    private int myLastColumnNumber = 0;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private MyEditable myEditable;
    private EditorColorsScheme myScheme;
    private final boolean myIsViewer;
    private final SelectionModelImpl mySelectionModel;
    private final EditorMarkupModelImpl myMarkupModel;
    private final FoldingModelImpl myFoldingModel;
    private final ScrollingModelImpl myScrollingModel;
    private final CaretModelImpl myCaretModel;
    private static final RepaintCursorCommand ourCaretBlinkingCommand;
    private int myMouseSelectionState = 0;
    private FoldRegion myMouseSelectedRegion = null;
    private static final int MOUSE_SELECTION_STATE_NONE = 0;
    private static final int MOUSE_SELECTION_STATE_WORD_SELECTED = 1;
    private static final int MOUSE_SELECTION_STATE_LINE_SELECTED = 2;
    private final MarkupModelListener myMarkupModelListener;
    private EditorHighlighter myHighlighter;
    private int myScrollbarOrientation;
    private boolean myMousePressedInsideSelection;
    private FontMetrics myPlainFontMetrics;
    private FontMetrics myBoldFontMetrics;
    private FontMetrics myItalicFontMetrics;
    private FontMetrics myBoldItalicFontMetrics;
    private static final int CACHED_CHARS_BUFFER_SIZE = 300;
    private final ArrayList<CachedFontContent> myFontCache = new ArrayList();
    private FontInfo myCurrentFontType = null;
    private final EditorSizeContainer mySizeContainer = new EditorSizeContainer();
    private Runnable myCursorUpdater;
    private int myCaretUpdateVShift;
    private final Project myProject;
    private long myMouseSelectionChangeTimestamp;
    private int mySavedCaretOffsetForDNDUndoHack;
    private final ArrayList<FocusChangeListener> myFocusListeners = new ArrayList();
    private MyInputMethodHandler myInputMethodRequestsHandler;
    private InputMethodRequests myInputMethodRequestsSwingWrapper;
    private boolean myIsOneLineMode;
    private boolean myIsRendererMode;
    private VirtualFile myVirtualFile;
    private boolean myIsColumnMode = false;
    private Color myForcedBackground = null;
    private Dimension myPreferredSize;
    private Runnable myGutterSizeUpdater = null;
    private boolean myGutterNeedsUpdate = false;
    private Alarm myAppleRepaintAlarm;
    private boolean myEmbeddedIntoDialogWrapper;
    private CachedFontContent myLastCache;
    private boolean mySpacesHaveSameWidth;
    private Point myLastBackgroundPosition = null;
    private Color myLastBackgroundColor = null;
    private int myLastBackgroundWidth;
    private static final boolean ourIsUnitTestMode;
    private final JPanel myHeaderPanel;
    private MouseEvent myInitialMouseEvent;
    private boolean myIgnoreMouseEventsConsecutiveToInitial;
    private String myReleasedAt = null;
    private EditorDropHandler myDropHandler;
    private char[] myPrefixText;
    private TextAttributes myPrefixAttributes;
    private IndentsModel myIndentsModel;
    private static final int WAVE_HEIGHT = 2;
    private static final int WAVE_SEGMENT_LENGTH = 4;
    private static final TooltipGroup FOLDING_TOOLTIP_GROUP;

    public EditorImpl(Document document, boolean viewer, Project project) {
        this.myProject = project;
        this.myDocument = (DocumentImpl)document;
        this.myScheme = new MyColorSchemeDelegate();
        this.myIsViewer = viewer;
        this.mySettings = new SettingsImpl(this);
        this.mySelectionModel = new SelectionModelImpl(this);
        this.myMarkupModel = new EditorMarkupModelImpl(this);
        this.myFoldingModel = new FoldingModelImpl(this);
        this.myCaretModel = new CaretModelImpl(this);
        this.mySizeContainer.reset();
        this.myCommandProcessor = CommandProcessor.getInstance();
        this.myEditorDocumentAdapter = new EditorDocumentAdapter();
        this.myMouseMotionListeners = ContainerUtil.createEmptyCOWList();
        this.myMarkupModelListener = new MarkupModelListener(){

            @Override
            public void rangeHighlighterChanged(MarkupModelEvent event) {
                EditorImpl.this.assertIsDispatchThread();
                RangeHighlighterImpl rangeHighlighter = (RangeHighlighterImpl)event.getHighlighter();
                if (rangeHighlighter.isValid()) {
                    int start = rangeHighlighter.getAffectedAreaStartOffset();
                    int end = rangeHighlighter.getAffectedAreaEndOffset();
                    int startLine = EditorImpl.this.myDocument.getLineNumber(start);
                    int endLine = EditorImpl.this.myDocument.getLineNumber(end);
                    EditorImpl.this.repaintLines(Math.max(0, startLine - 1), Math.min(endLine + 1, EditorImpl.this.getDocument().getLineCount()));
                } else {
                    EditorImpl.this.repaint(0, EditorImpl.this.getDocument().getTextLength());
                }
                ((EditorMarkupModelImpl)EditorImpl.this.getMarkupModel()).repaint();
                ((EditorMarkupModelImpl)EditorImpl.this.getMarkupModel()).markDirtied();
                GutterIconRenderer renderer = rangeHighlighter.getGutterIconRenderer();
                if (renderer != null) {
                    EditorImpl.this.updateGutterSize();
                }
                EditorImpl.this.updateCaretCursor();
            }
        };
        ((MarkupModelEx)this.myDocument.getMarkupModel(this.myProject)).addMarkupModelListener(this.myMarkupModelListener);
        ((MarkupModelEx)this.getMarkupModel()).addMarkupModelListener(this.myMarkupModelListener);
        this.myDocument.addDocumentListener(this.myFoldingModel);
        this.myDocument.addDocumentListener(this.myCaretModel);
        this.myDocument.addDocumentListener(this.mySelectionModel);
        this.myDocument.addDocumentListener(this.myEditorDocumentAdapter);
        this.myIndentsModel = new IndentsModelImpl(this);
        this.myCaretModel.addCaretListener(new CaretListener(){
            private LightweightHint myCurrentHint = null;
            private IndentGuideDescriptor myCurrentCaretGuide = null;

            public void caretPositionChanged(CaretEvent e) {
                IndentGuideDescriptor newGuide = EditorImpl.this.myIndentsModel.getCaretIndentGuide();
                if (!Comparing.equal((Object)this.myCurrentCaretGuide, (Object)newGuide)) {
                    EditorImpl.this.repaintGuide(newGuide);
                    EditorImpl.this.repaintGuide(this.myCurrentCaretGuide);
                    this.myCurrentCaretGuide = newGuide;
                    if (this.myCurrentHint != null) {
                        this.myCurrentHint.hide();
                        this.myCurrentHint = null;
                    }
                    if (newGuide != null) {
                        Rectangle visibleArea = EditorImpl.this.getScrollingModel().getVisibleArea();
                        int line = newGuide.startLine;
                        if (EditorImpl.this.logicalLineToY(line) < visibleArea.y) {
                            TextRange textRange = new TextRange(EditorImpl.this.myDocument.getLineStartOffset(line), EditorImpl.this.myDocument.getLineEndOffset(line));
                            this.myCurrentHint = EditorFragmentComponent.showEditorFragmentHint(EditorImpl.this, textRange, false, false);
                        }
                    }
                }
            }
        });
        this.myCaretCursor = new CaretCursor();
        this.myFoldingModel.flushCaretShift();
        this.myScrollbarOrientation = 1;
        EmptyEditorHighlighter highlighter = new EmptyEditorHighlighter(this.myScheme.getAttributes(HighlighterColors.TEXT));
        this.setHighlighter(highlighter);
        this.myEditorComponent = new EditorComponentImpl(this);
        this.myScrollPane = new MyScrollPane();
        this.myPanel = new JPanel(){

            @Override
            public void addNotify() {
                super.addNotify();
                if (((JComponent)this.getParent()).getBorder() != null) {
                    EditorImpl.this.myScrollPane.setBorder(null);
                }
            }
        };
        this.myHeaderPanel = new MyHeaderPanel();
        this.myVerticalScrollBar = new MyScrollBar(1);
        this.myGutterComponent = new EditorGutterComponentImpl(this);
        this.initComponent();
        this.myScrollingModel = new ScrollingModelImpl(this);
        this.myGutterComponent.updateSize();
        Dimension preferredSize = this.getPreferredSize();
        this.myEditorComponent.setSize(preferredSize);
        if (Patches.APPLE_BUG_ID_3716835) {
            this.myScrollingModel.addVisibleAreaListener(new VisibleAreaListener(){

                public void visibleAreaChanged(VisibleAreaEvent e) {
                    if (EditorImpl.this.myAppleRepaintAlarm == null) {
                        EditorImpl.this.myAppleRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                    }
                    EditorImpl.this.myAppleRepaintAlarm.cancelAllRequests();
                    EditorImpl.this.myAppleRepaintAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            EditorImpl.this.repaint(0, EditorImpl.this.myDocument.getTextLength());
                        }
                    }, 50, ModalityState.stateForComponent((Component)EditorImpl.this.myEditorComponent));
                }
            });
        }
        this.updateCaretCursor();
        if (!ourIsUnitTestMode) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditorComponent, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!EditorImpl.this.isDisposed() && !EditorImpl.this.myScrollingModel.isScrollingNow()) {
                        EditorImpl.this.myScrollingModel.disableAnimation();
                        EditorImpl.this.myScrollingModel.scrollHorizontally(0);
                        EditorImpl.this.myScrollingModel.enableAnimation();
                    }
                }
            });
        }
    }

    private void repaintGuide(IndentGuideDescriptor guide) {
        if (guide != null) {
            this.repaintLines(guide.startLine, guide.endLine);
        }
    }

    public void setPrefixTextAndAttributes(String prefixText, TextAttributes attributes) {
        this.myPrefixText = prefixText == null ? null : prefixText.toCharArray();
        this.myPrefixAttributes = attributes;
    }

    public boolean isViewer() {
        return this.myIsViewer || this.myIsRendererMode;
    }

    @Override
    public boolean isRendererMode() {
        return this.myIsRendererMode;
    }

    @Override
    public void setRendererMode(boolean isRendererMode) {
        this.myIsRendererMode = isRendererMode;
    }

    @Override
    public void setFile(VirtualFile vFile) {
        this.myVirtualFile = vFile;
        this.reinitSettings();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModelImpl selectionModelImpl = this.mySelectionModel;
        if (selectionModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getSelectionModel must not return null");
        }
        return selectionModelImpl;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        EditorMarkupModelImpl editorMarkupModelImpl = this.myMarkupModel;
        if (editorMarkupModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getMarkupModel must not return null");
        }
        return editorMarkupModelImpl;
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        FoldingModelImpl foldingModelImpl = this.myFoldingModel;
        if (foldingModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getFoldingModel must not return null");
        }
        return foldingModelImpl;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModelImpl caretModelImpl = this.myCaretModel;
        if (caretModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getCaretModel must not return null");
        }
        return caretModelImpl;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        ScrollingModelImpl scrollingModelImpl = this.myScrollingModel;
        if (scrollingModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getScrollingModel must not return null");
        }
        return scrollingModelImpl;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorImpl.assertReadAccess();
        SettingsImpl settingsImpl = this.mySettings;
        if (settingsImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getSettings must not return null");
        }
        return settingsImpl;
    }

    @Override
    public void reinitSettings() {
        this.assertIsDispatchThread();
        this.myCharHeight = -1;
        this.myLineHeight = -1;
        this.myDescent = -1;
        this.myPlainFontMetrics = null;
        this.myCaretModel.reinitSettings();
        this.mySelectionModel.reinitSettings();
        this.mySettings.reinitSettings();
        EditorImpl.ourCaretBlinkingCommand.setBlinkCaret(this.mySettings.isBlinkCaret());
        EditorImpl.ourCaretBlinkingCommand.setBlinkPeriod(this.mySettings.getCaretBlinkPeriod());
        this.mySizeContainer.reset();
        this.myFoldingModel.refreshSettings();
        this.myFoldingModel.rebuild();
        if (this.myScheme instanceof MyColorSchemeDelegate) {
            ((MyColorSchemeDelegate)this.myScheme).updateGlobalScheme();
        }
        this.myHighlighter.setColorScheme(this.myScheme);
        this.myGutterComponent.reinitSettings();
        this.myGutterComponent.revalidate();
        this.myEditorComponent.repaint();
        this.updateCaretCursor();
        if (this.myInitialMouseEvent != null) {
            this.myIgnoreMouseEventsConsecutiveToInitial = true;
        }
    }

    public void release() {
        if (this.isReleased) {
            LOG.error("Double release. First released at:  =====\n" + this.myReleasedAt + "\n======");
        }
        this.myReleasedAt = StringUtil.getThrowableText((Throwable)new Throwable());
        this.isReleased = true;
        this.myDocument.removeDocumentListener((DocumentListener)this.myHighlighter);
        this.myDocument.removeDocumentListener(this.myEditorDocumentAdapter);
        this.myDocument.removeDocumentListener(this.myFoldingModel);
        this.myDocument.removeDocumentListener(this.myCaretModel);
        this.myDocument.removeDocumentListener(this.mySelectionModel);
        MarkupModelEx markupModel = (MarkupModelEx)this.myDocument.getMarkupModel(this.myProject, false);
        if (markupModel instanceof MarkupModelImpl) {
            markupModel.removeMarkupModelListener(this.myMarkupModelListener);
        }
        this.myMarkupModel.dispose();
        this.myLineHeight = -1;
        this.myCharHeight = -1;
        this.myDescent = -1;
        this.myPlainFontMetrics = null;
        this.myScrollingModel.dispose();
        this.myGutterComponent.dispose();
        this.clearCaretThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaretThread() {
        RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
        synchronized (repaintCursorCommand) {
            if (ourCaretBlinkingCommand.myEditor == this) {
                ourCaretBlinkingCommand.myEditor = null;
            }
        }
    }

    private void initComponent() {
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myHeaderPanel, "North");
        this.myGutterComponent.setOpaque(true);
        this.myScrollPane.setVerticalScrollBar(this.myVerticalScrollBar);
        MyScrollBar horizontalScrollBar = new MyScrollBar(0);
        this.myScrollPane.setHorizontalScrollBar(horizontalScrollBar);
        this.myScrollPane.setViewportView(this.myEditorComponent);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setRowHeaderView(this.myGutterComponent);
        this.stopOptimizedScrolling();
        this.myEditorComponent.setTransferHandler(new MyTransferHandler());
        this.myEditorComponent.setAutoscrolls(true);
        if (this.mayShowToolbar()) {
            JLayeredPane layeredPane = new JLayeredPane(){

                @Override
                public void doLayout() {
                    Component[] components = this.getComponents();
                    Rectangle r = this.getBounds();
                    for (Component c : components) {
                        if (c instanceof JScrollPane) {
                            c.setBounds(0, 0, r.width, r.height);
                            continue;
                        }
                        Dimension d = c.getPreferredSize();
                        MyScrollBar scrollBar = EditorImpl.this.getVerticalScrollBar();
                        c.setBounds(r.width - d.width - scrollBar.getWidth() - 30, 20, d.width, d.height);
                    }
                }
            };
            layeredPane.add((Component)this.myScrollPane, JLayeredPane.DEFAULT_LAYER);
            this.myPanel.add(layeredPane);
            new ContextMenuImpl(layeredPane, this.myScrollPane, this);
        } else {
            this.myPanel.add(this.myScrollPane);
        }
        this.myEditorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (Patches.APPLE_BUG_ID_3337563) {
                    return;
                }
                if (event.isConsumed()) {
                    return;
                }
                if (EditorImpl.this.processKeyTyped(event)) {
                    event.consume();
                }
            }
        });
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.myEditorComponent.addMouseListener(mouseAdapter);
        this.myGutterComponent.addMouseListener(mouseAdapter);
        MyMouseMotionListener mouseMotionListener = new MyMouseMotionListener();
        this.myEditorComponent.addMouseMotionListener(mouseMotionListener);
        this.myGutterComponent.addMouseMotionListener(mouseMotionListener);
        this.myEditorComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorImpl.this.myCaretCursor.activate();
                int caretLine = EditorImpl.this.getCaretModel().getLogicalPosition().line;
                EditorImpl.this.repaintLines(caretLine, caretLine);
                EditorImpl.this.fireFocusGained();
                if (EditorImpl.this.myGutterNeedsUpdate) {
                    EditorImpl.this.updateGutterSize();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                EditorImpl.this.clearCaretThread();
                int caretLine = EditorImpl.this.getCaretModel().getLogicalPosition().line;
                EditorImpl.this.repaintLines(caretLine, caretLine);
                EditorImpl.this.fireFocusLost();
            }
        });
        try {
            DropTarget dropTarget = this.myEditorComponent.getDropTarget();
            if (dropTarget != null) {
                dropTarget.addDropTargetListener(new DropTargetAdapter(){

                    @Override
                    public void drop(DropTargetDropEvent dtde) {
                    }

                    @Override
                    public void dragOver(DropTargetDragEvent dtde) {
                        Point location = dtde.getLocation();
                        EditorImpl.this.moveCaretToScreenPos(location.x, location.y);
                        EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                });
            }
        }
        catch (TooManyListenersException e) {
            LOG.error((Throwable)e);
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EditorImpl.this.myMarkupModel.repaint();
            }
        });
    }

    private boolean mayShowToolbar() {
        return !this.isEmbeddedIntoDialogWrapper() && !this.isOneLineMode() && ContextMenuImpl.mayShowToolbar(this.myDocument);
    }

    @Override
    public void setFontSize(int fontSize) {
        int oldFontSize = this.myScheme.getEditorFontSize();
        this.myScheme.setEditorFontSize(fontSize);
        this.myPropertyChangeSupport.firePropertyChange("fontSize", oldFontSize, fontSize);
    }

    public ActionCallback type(final String text) {
        final ActionCallback result = new ActionCallback();
        Application app = ApplicationManager.getApplication();
        if (!app.isWriteAccessAllowed()) {
            result.setRejected();
        } else {
            app.runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < text.length(); ++i) {
                        if (EditorImpl.this.processKeyTyped(text.charAt(i))) continue;
                        result.setRejected();
                        return;
                    }
                    result.setDone();
                }
            });
        }
        return result;
    }

    private boolean processKeyTyped(char c) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        if (queue.shouldNotTypeInEditor() || ProgressManager.getInstance().hasModalProgressIndicator()) {
            return false;
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        DataContext dataContext = this.getDataContext();
        actionManager.fireBeforeEditorTyping(c, dataContext);
        EditorActionManager.getInstance().getTypedAction().actionPerformed((Editor)this, c, dataContext);
        return true;
    }

    private void fireFocusLost() {
        FocusChangeListener[] listeners;
        for (FocusChangeListener listener : listeners = this.getFocusListeners()) {
            listener.focusLost(this);
        }
    }

    private FocusChangeListener[] getFocusListeners() {
        return this.myFocusListeners.toArray(new FocusChangeListener[this.myFocusListeners.size()]);
    }

    private void fireFocusGained() {
        FocusChangeListener[] listeners;
        for (FocusChangeListener listener : listeners = this.getFocusListeners()) {
            listener.focusGained(this);
        }
    }

    @Override
    public void setHighlighter(EditorHighlighter highlighter) {
        this.assertIsDispatchThread();
        Document document = this.getDocument();
        if (this.myHighlighter != null) {
            document.removeDocumentListener((DocumentListener)this.myHighlighter);
        }
        document.addDocumentListener((DocumentListener)highlighter);
        highlighter.setEditor((HighlighterClient)this);
        highlighter.setText(document.getCharsSequence());
        this.myHighlighter = highlighter;
        if (document instanceof DocumentImpl) {
            ((DocumentImpl)document).rememberEditorHighlighterForCachesOptimization(highlighter);
        }
        if (this.myPanel != null) {
            this.reinitSettings();
        }
    }

    @Override
    public EditorHighlighter getHighlighter() {
        this.assertIsDispatchThread();
        return this.myHighlighter;
    }

    @NotNull
    public JComponent getContentComponent() {
        EditorComponentImpl editorComponentImpl = this.myEditorComponent;
        if (editorComponentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getContentComponent must not return null");
        }
        return editorComponentImpl;
    }

    @Override
    public EditorGutterComponentEx getGutterComponentEx() {
        return this.myGutterComponent;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setInsertMode(boolean mode) {
        this.assertIsDispatchThread();
        boolean oldValue = this.myIsInsertMode;
        this.myIsInsertMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("insertMode", oldValue, mode);
        LogicalPosition caretPosition = this.getCaretModel().getLogicalPosition();
        this.getCaretModel().moveToLogicalPosition(caretPosition);
    }

    public boolean isInsertMode() {
        return this.myIsInsertMode;
    }

    @Override
    public void setColumnMode(boolean mode) {
        this.assertIsDispatchThread();
        boolean oldValue = this.myIsColumnMode;
        this.myIsColumnMode = mode;
        this.myPropertyChangeSupport.firePropertyChange("columnMode", oldValue, mode);
    }

    public boolean isColumnMode() {
        return this.myIsColumnMode;
    }

    private int yPositionToVisibleLineNumber(int y) {
        return y / this.getLineHeight();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        int column;
        VisualPosition visualPosition;
        int line;
        block21: {
            int charWidth;
            int x;
            int fontType;
            int px;
            block20: {
                int textLength;
                int offset;
                if (p == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.xyToVisualPosition must not be null");
                }
                line = this.yPositionToVisibleLineNumber(p.y);
                px = p.x;
                if (line == 0 && this.myPrefixText != null) {
                    char c;
                    char[] arr$ = this.myPrefixText;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; px -= EditorUtil.charWidth(c, this.myPrefixAttributes.getFontType(), this), ++i$) {
                        c = arr$[i$];
                    }
                }
                if ((offset = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(line, 0)))) >= (textLength = this.myDocument.getTextLength())) {
                    visualPosition = new VisualPosition(line, 0);
                    if (visualPosition == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.xyToVisualPosition must not return null");
                    return visualPosition;
                }
                column = 0;
                int prevX = 0;
                CharSequence text = this.myDocument.getCharsNoThreadCheck();
                char c = ' ';
                IterationState state = new IterationState(this, offset, false);
                fontType = state.getMergedAttributes().getFontType();
                int spaceSize = EditorUtil.getSpaceWidth(fontType, this);
                x = 0;
                block1: while (offset < textLength) {
                    int len$;
                    char[] arr$;
                    FoldRegion region;
                    if (offset >= state.getEndOffset()) {
                        state.advance();
                        fontType = state.getMergedAttributes().getFontType();
                    }
                    if ((region = state.getCurrentFold()) != null) {
                        char[] placeholder;
                        arr$ = placeholder = region.getPlaceholderText().toCharArray();
                        len$ = arr$.length;
                    } else {
                        prevX = x;
                        c = text.charAt(offset);
                        if (c == '\n') break;
                        x = c == '\t' ? EditorUtil.nextTabStop(x, this) : (x += EditorUtil.charWidth(c, fontType, this));
                        if (x >= px) break;
                        column = c == '\t' ? (column += (x - prevX) / spaceSize) : ++column;
                        ++offset;
                        continue;
                    }
                    for (int i$ = 0; i$ < len$; ++column, ++i$) {
                        char aPlaceholder = arr$[i$];
                        c = aPlaceholder;
                        if ((x += EditorUtil.charWidth(c, fontType, this)) >= px) break block1;
                    }
                    offset = region.getEndOffset();
                }
                charWidth = EditorUtil.charWidth(c, fontType, this);
                if (x < px || c != 9) break block20;
                if (this.mySettings.isCaretInsideTabs()) {
                    column += (px - prevX) / spaceSize;
                    if ((px - prevX) % spaceSize > spaceSize / 2) {
                        ++column;
                    }
                    break block21;
                } else if ((x - px) * 2 < x - prevX) {
                    column += (x - prevX) / spaceSize;
                }
                break block21;
            }
            if (x >= px) {
                if ((x - px) * 2 < charWidth) {
                    ++column;
                }
            } else {
                column += (px - x) / EditorUtil.getSpaceWidth(fontType, this);
            }
        }
        if ((visualPosition = new VisualPosition(line, column)) != null) return visualPosition;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.xyToVisualPosition must not return null");
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
        if (visualPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.offsetToVisualPosition must not return null");
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int line = this.calcLogicalLineNumber(offset);
        int column = this.calcColumnNumber(offset, line);
        LogicalPosition logicalPosition = new LogicalPosition(line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.offsetToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.xyToLogicalPosition must not be null");
        }
        Point pp = p.x >= 0 && p.y >= 0 ? p : new Point(Math.max(p.x, 0), Math.max(p.y, 0));
        LogicalPosition logicalPosition = this.visualToLogicalPosition(this.xyToVisualPosition(pp));
        if (logicalPosition == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.xyToLogicalPosition must not return null");
        }
        return logicalPosition;
    }

    private int logicalLineToY(int line) {
        VisualPosition visible = this.logicalToVisualPosition(new LogicalPosition(line, 0));
        return this.visibleLineNumberToYPosition(visible.line);
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.logicalPositionToXY must not be null");
        }
        VisualPosition visible = this.logicalToVisualPosition(pos);
        int y = this.visibleLineNumberToYPosition(visible.line);
        int lineStartOffset = pos.line == 0 ? 0 : (pos.line >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(pos.line));
        int x = this.getTabbedTextWidth(lineStartOffset, visible);
        Point point = new Point(x, y);
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.logicalPositionToXY must not return null");
        }
        return point;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.visualPositionToXY must not be null");
        }
        int y = this.visibleLineNumberToYPosition(visible.line);
        int logLine = this.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visible.line, (int)0)).line;
        int lineStartOffset = logLine == 0 ? 0 : (logLine >= this.myDocument.getLineCount() ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(logLine));
        int x = this.getTabbedTextWidth(lineStartOffset, visible);
        Point point = new Point(x, y);
        if (point == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.visualPositionToXY must not return null");
        }
        return point;
    }

    private int getTabbedTextWidth(int lineStartOffset, VisualPosition pos) {
        int x = 0;
        if (lineStartOffset == 0 && this.myPrefixText != null) {
            for (char c : this.myPrefixText) {
                x += EditorUtil.charWidth(c, this.myPrefixAttributes.getFontType(), this);
            }
        }
        if (pos.column == 0) {
            return x;
        }
        int offset = lineStartOffset;
        CharSequence text = this.myDocument.getCharsNoThreadCheck();
        int textLength = this.myDocument.getTextLength();
        IterationState state = new IterationState(this, offset, false);
        int fontType = state.getMergedAttributes().getFontType();
        int spaceSize = EditorUtil.getSpaceWidth(fontType, this);
        int column = 0;
        block1: while (column < pos.column && offset < textLength) {
            FoldRegion region;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((region = state.getCurrentFold()) != null) {
                char[] placeholder;
                for (char aPlaceholder : placeholder = region.getPlaceholderText().toCharArray()) {
                    x += EditorUtil.charWidth(aPlaceholder, fontType, this);
                    if (++column >= pos.column) break block1;
                }
                offset = region.getEndOffset();
                continue;
            }
            char c = text.charAt(offset);
            if (c == '\n') break;
            if (c == '\t') {
                int prevX = x;
                x = EditorUtil.nextTabStop(x, this);
                column += (x - prevX) / spaceSize;
            } else {
                x += EditorUtil.charWidth(c, fontType, this);
                ++column;
            }
            ++offset;
        }
        if (column != pos.column) {
            x += EditorUtil.getSpaceWidth(fontType, this) * (pos.column - column);
        }
        return x;
    }

    public int visibleLineNumberToYPosition(int lineNum) {
        if (lineNum < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + lineNum);
        }
        return lineNum * this.getLineHeight();
    }

    @Override
    public void repaint(int startOffset, int endOffset) {
        if (!this.isShowing() || this.myScrollPane == null || this.myDocument.isInBulkUpdate()) {
            return;
        }
        this.assertIsDispatchThread();
        if (endOffset > this.myDocument.getTextLength()) {
            endOffset = this.myDocument.getTextLength();
        }
        if (startOffset < endOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            int endLine = this.myDocument.getLineNumber(endOffset);
            this.repaintLines(startLine, endLine);
        }
    }

    private boolean isShowing() {
        return this.myGutterComponent != null && this.myGutterComponent.isShowing();
    }

    private void repaintToScreenBotton(int startLine) {
        Rectangle visibleRect = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int yEndLine = visibleRect.y + visibleRect.height;
        this.myEditorComponent.repaintEditorComponent(visibleRect.x, yStartLine, visibleRect.x + visibleRect.width, yEndLine - yStartLine);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), yEndLine - yStartLine);
    }

    public void repaintLines(int startLine, int endLine) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle visibleRect = this.getScrollingModel().getVisibleArea();
        int yStartLine = this.logicalLineToY(startLine);
        int yEndLine = this.logicalLineToY(endLine) + this.getLineHeight() + 2;
        this.myEditorComponent.repaintEditorComponent(visibleRect.x, yStartLine, visibleRect.x + visibleRect.width, yEndLine - yStartLine);
        this.myGutterComponent.repaint(0, yStartLine, this.myGutterComponent.getWidth(), yEndLine - yStartLine);
    }

    private void beforeChangedUpdate(DocumentEvent e) {
        if (!this.myDocument.isInBulkUpdate()) {
            Rectangle viewRect = this.getScrollingModel().getVisibleArea();
            Point pos = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
            this.myCaretUpdateVShift = pos.y - viewRect.y;
        }
        this.mySizeContainer.beforeChange(e);
    }

    private void changedUpdate(DocumentEvent e) {
        if (this.myScrollPane == null) {
            return;
        }
        this.stopOptimizedScrolling();
        this.mySelectionModel.removeBlockSelection();
        this.mySizeContainer.changedUpdate(e);
        this.validateSize();
        int startLine = this.calcLogicalLineNumber(e.getOffset());
        int endLine = this.calcLogicalLineNumber(e.getOffset() + e.getNewLength());
        boolean painted = false;
        if (this.myDocument.getTextLength() > 0) {
            int startDocLine = this.myDocument.getLineNumber(e.getOffset());
            int endDocLine = this.myDocument.getLineNumber(e.getOffset() + e.getNewLength());
            if (e.getOldLength() > e.getNewLength() || startDocLine != endDocLine) {
                this.updateGutterSize();
            }
            if (EditorImpl.countLineFeeds(e.getOldFragment()) != EditorImpl.countLineFeeds(e.getNewFragment())) {
                this.repaintToScreenBotton(startLine);
                painted = true;
            }
        }
        this.updateCaretCursor();
        if (!painted) {
            this.repaintLines(startLine, endLine);
        }
        if (!this.myDocument.isInBulkUpdate()) {
            Point caretLocation = this.visualPositionToXY(this.getCaretModel().getVisualPosition());
            int scrollOffset = caretLocation.y - this.myCaretUpdateVShift;
            this.getScrollingModel().scrollVertically(scrollOffset);
        }
    }

    private static int countLineFeeds(CharSequence c) {
        return StringUtil.countNewLines((CharSequence)c);
    }

    private void updateGutterSize() {
        if (this.myGutterSizeUpdater != null) {
            return;
        }
        this.myGutterSizeUpdater = new Runnable(){

            @Override
            public void run() {
                if (!EditorImpl.this.isDisposed()) {
                    if (EditorImpl.this.isShowing()) {
                        EditorImpl.this.myGutterComponent.updateSize();
                        EditorImpl.this.myGutterNeedsUpdate = false;
                    } else {
                        EditorImpl.this.myGutterNeedsUpdate = true;
                    }
                }
                EditorImpl.this.myGutterSizeUpdater = null;
            }
        };
        SwingUtilities.invokeLater(this.myGutterSizeUpdater);
    }

    void validateSize() {
        Dimension dim = this.getPreferredSize();
        if (!dim.equals(this.myPreferredSize) && !this.myDocument.isInBulkUpdate()) {
            this.myPreferredSize = dim;
            this.stopOptimizedScrolling();
            int lineNum = Math.max(1, this.getDocument().getLineCount());
            this.myGutterComponent.setLineNumberAreaWidth(this.getFontMetrics(0).stringWidth(Integer.toString(lineNum + 2)) + 6);
            this.myEditorComponent.setSize(dim);
            this.myEditorComponent.fireResized();
            this.myMarkupModel.repaint();
        }
    }

    void recalcSizeAndRepaint() {
        this.mySizeContainer.reset();
        this.validateSize();
        this.myEditorComponent.repaintEditorComponent();
    }

    @NotNull
    public Document getDocument() {
        DocumentImpl documentImpl = this.myDocument;
        if (documentImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getDocument must not return null");
        }
        return documentImpl;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getComponent must not return null");
        }
        return jPanel;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.addEditorMouseListener must not be null");
        }
        this.myMouseListeners.add(listener);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.removeEditorMouseListener must not be null");
        }
        boolean success = this.myMouseListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.addEditorMouseMotionListener must not be null");
        }
        this.myMouseMotionListeners.add(listener);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.removeEditorMouseMotionListener must not be null");
        }
        boolean success = this.myMouseMotionListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public boolean isDisposed() {
        return this.isReleased;
    }

    void paint(Graphics g) {
        Rectangle clip;
        this.startOptimizedScrolling();
        if (this.myCursorUpdater != null) {
            this.myCursorUpdater.run();
            this.myCursorUpdater = null;
        }
        if ((clip = EditorImpl.getClipBounds(g)) == null) {
            return;
        }
        Rectangle viewRect = this.getScrollingModel().getVisibleArea();
        if (viewRect == null) {
            return;
        }
        if (this.isReleased) {
            g.setColor(new Color(128, 255, 128));
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            return;
        }
        this.paintBackgrounds(g, clip);
        this.paintRectangularSelection(g);
        this.paintRightMargin(g, clip);
        this.paintCustomRenderers((Graphics2D)g, clip);
        MarkupModel docMarkup = this.myDocument.getMarkupModel(this.myProject);
        this.paintLineMarkersSeparators(g, clip, docMarkup);
        this.paintLineMarkersSeparators(g, clip, this.myMarkupModel);
        this.paintText(g, clip);
        this.paintSegmentHighlightersBorderAndAfterEndOfLine(g, clip);
        BorderEffect borderEffect = new BorderEffect(this, g);
        borderEffect.paintHighlighters(this.getHighlighter());
        borderEffect.paintHighlighters(docMarkup.getAllHighlighters());
        borderEffect.paintHighlighters(this.getMarkupModel().getAllHighlighters());
        this.paintCaretCursor(g);
        this.paintComposedTextDecoration((Graphics2D)g);
    }

    private void paintCustomRenderers(Graphics2D g, Rectangle clip) {
        EditorMarkupModelImpl mm = this.myMarkupModel;
        int clipStartOffset = this.logicalPositionToOffset(this.xyToLogicalPosition(new Point(0, clip.y)));
        int clipEndOffset = this.logicalPositionToOffset(this.xyToLogicalPosition(new Point(0, clip.y + clip.height + this.getLineHeight())));
        for (RangeHighlighter highlighter : mm.getAllHighlighters()) {
            CustomHighlighterRenderer customRenderer;
            if (!highlighter.isValid() || (customRenderer = highlighter.getCustomRenderer()) == null || clipStartOffset >= highlighter.getEndOffset() || clipEndOffset <= highlighter.getStartOffset()) continue;
            customRenderer.paint((Editor)this, highlighter, (Graphics)g);
        }
    }

    public IndentsModel getIndentsModel() {
        return this.myIndentsModel;
    }

    public void setHeaderComponent(JComponent header) {
        this.myHeaderPanel.removeAll();
        if (header != null) {
            this.myHeaderPanel.add(header);
        }
        this.myHeaderPanel.revalidate();
    }

    public boolean hasHeaderComponent() {
        return this.myHeaderPanel.getComponentCount() > 0;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        if (this.hasHeaderComponent()) {
            return (JComponent)this.myHeaderPanel.getComponent(0);
        }
        return null;
    }

    @Override
    public void setBackgroundColor(Color color) {
        if (this.getBackgroundIgnoreForced().equals(color)) {
            this.myForcedBackground = null;
            return;
        }
        this.myForcedBackground = color;
    }

    @Override
    public void resetBackgourndColor() {
        this.myForcedBackground = null;
    }

    public Color getForegroundColor() {
        return this.myScheme.getDefaultForeground();
    }

    @Override
    public Color getBackroundColor() {
        if (this.myForcedBackground != null) {
            return this.myForcedBackground;
        }
        return this.getBackgroundIgnoreForced();
    }

    private Color getBackgroundColor(TextAttributes attributes) {
        Color attrColor = attributes.getBackgroundColor();
        return attrColor == this.myScheme.getDefaultBackground() ? this.getBackroundColor() : attrColor;
    }

    private Color getBackgroundIgnoreForced() {
        Color color = this.myScheme.getDefaultBackground();
        if (this.myDocument.isWritable()) {
            return color;
        }
        Color readOnlyColor = this.myScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
        return readOnlyColor != null ? readOnlyColor : color;
    }

    private void paintComposedTextDecoration(Graphics2D g) {
        if (this.myInputMethodRequestsHandler != null && this.myInputMethodRequestsHandler.composedText != null) {
            VisualPosition visStart = this.offsetToVisualPosition(Math.min(this.myInputMethodRequestsHandler.composedTextStart, this.myDocument.getTextLength()));
            int y = this.visibleLineNumberToYPosition(visStart.line) + this.getLineHeight() - this.getDescent() + 1;
            Point p1 = this.visualPositionToXY(visStart);
            Point p2 = this.logicalPositionToXY(this.offsetToLogicalPosition(Math.min(this.myInputMethodRequestsHandler.composedTextEnd, this.myDocument.getTextLength())));
            Stroke saved = g.getStroke();
            BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
            g.setStroke(dotted);
            UIUtil.drawLine((Graphics)g, (int)p1.x, (int)y, (int)p2.x, (int)y);
            g.setStroke(saved);
        }
    }

    private static Rectangle getClipBounds(Graphics g) {
        return g.getClipBounds();
    }

    private void paintRightMargin(Graphics g, Rectangle clip) {
        Color rightMargin = this.myScheme.getColor(EditorColors.RIGHT_MARGIN_COLOR);
        if (!this.mySettings.isRightMarginShown() || rightMargin == null) {
            return;
        }
        int x = this.mySettings.getRightMargin(this.myProject) * EditorUtil.getSpaceWidth(0, this);
        if (x >= clip.x && x < clip.x + clip.width) {
            g.setColor(rightMargin);
            UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
        }
    }

    private void paintSegmentHighlightersBorderAndAfterEndOfLine(Graphics g, Rectangle clip) {
        RangeHighlighter[] segmentHighlighters;
        if (this.myDocument.getLineCount() == 0) {
            return;
        }
        int startLineNumber = this.yPositionToVisibleLineNumber(clip.y);
        int endLineNumber = this.yPositionToVisibleLineNumber(clip.y + clip.height) + 1;
        MarkupModel docMarkup = this.myDocument.getMarkupModel(this.myProject);
        for (RangeHighlighter segmentHighlighter : segmentHighlighters = docMarkup.getAllHighlighters()) {
            this.paintSegmentHighlighterAfterEndOfLine(g, (RangeHighlighterEx)segmentHighlighter, startLineNumber, endLineNumber);
        }
        for (RangeHighlighter segmentHighlighter : segmentHighlighters = this.getMarkupModel().getAllHighlighters()) {
            this.paintSegmentHighlighterAfterEndOfLine(g, (RangeHighlighterEx)segmentHighlighter, startLineNumber, endLineNumber);
        }
    }

    private void paintSegmentHighlighterAfterEndOfLine(Graphics g, RangeHighlighterEx segmentHighlighter, int startLineNumber, int endLineNumber) {
        if (!segmentHighlighter.isValid()) {
            return;
        }
        if (segmentHighlighter.isAfterEndOfLine()) {
            int startOffset = segmentHighlighter.getStartOffset();
            int visibleStartLine = this.offsetToVisualPosition((int)startOffset).line;
            if (!this.getFoldingModel().isOffsetCollapsed(startOffset) && visibleStartLine >= startLineNumber && visibleStartLine <= endLineNumber) {
                int logStartLine = this.offsetToLogicalPosition((int)startOffset).line;
                LogicalPosition logPosition = this.offsetToLogicalPosition(this.myDocument.getLineEndOffset(logStartLine));
                Point end = this.logicalPositionToXY(logPosition);
                int charWidth = EditorUtil.getSpaceWidth(0, this);
                int lineHeight = this.getLineHeight();
                TextAttributes attributes = segmentHighlighter.getTextAttributes();
                if (attributes != null && this.getBackgroundColor(attributes) != null) {
                    g.setColor(this.getBackgroundColor(attributes));
                    g.fillRect(end.x, end.y, charWidth, lineHeight);
                }
                if (attributes != null && attributes.getEffectColor() != null) {
                    int y = this.visibleLineNumberToYPosition(visibleStartLine) + this.getLineHeight() - this.getDescent() + 1;
                    g.setColor(attributes.getEffectColor());
                    if (attributes.getEffectType() == EffectType.WAVE_UNDERSCORE) {
                        EditorImpl.drawWave(g, end.x, end.x + charWidth - 1, y);
                    } else if (attributes.getEffectType() != EffectType.BOXED) {
                        UIUtil.drawLine((Graphics)g, (int)end.x, (int)y, (int)(end.x + charWidth - 1), (int)y);
                    }
                }
            }
        }
    }

    @Override
    public int getMaxWidthInRange(int startOffset, int endOffset) {
        int width = 0;
        VisualPosition start = this.offsetToVisualPosition(startOffset);
        VisualPosition end = this.offsetToVisualPosition(endOffset);
        for (int i = start.line; i <= end.line; ++i) {
            int lastColumn = EditorUtil.getLastVisualLineColumnNumber(this, i) + 1;
            int lineWidth = this.visualPositionToXY((VisualPosition)new VisualPosition((int)i, (int)lastColumn)).x;
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    private void paintBackgrounds(Graphics g, Rectangle clip) {
        Color defaultBackground = this.getBackroundColor();
        g.setColor(defaultBackground);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int lineHeight = this.getLineHeight();
        int visibleLineNumber = clip.y / lineHeight;
        int startLineNumber = this.xyToLogicalPosition((Point)new Point((int)0, (int)clip.y)).line;
        Point position = new Point(0, visibleLineNumber * lineHeight);
        if (startLineNumber == 0 && this.myPrefixText != null) {
            position.x = this.drawBackground(g, this.myPrefixAttributes.getBackgroundColor(), new String(this.myPrefixText), position, this.myPrefixAttributes.getFontType(), defaultBackground, clip);
        }
        if (startLineNumber >= this.myDocument.getLineCount() || startLineNumber < 0) {
            if (position.x > 0) {
                this.flushBackground(g, clip);
            }
            return;
        }
        int start = this.myDocument.getLineStartOffset(startLineNumber);
        IterationState iterationState = new IterationState(this, start, this.paintSelection());
        LineIterator lIterator = this.createLineIterator();
        lIterator.start(start);
        if (lIterator.atEnd()) {
            return;
        }
        this.myLastBackgroundPosition = null;
        this.myLastBackgroundColor = null;
        TextAttributes attributes = iterationState.getMergedAttributes();
        Color backColor = this.getBackgroundColor(attributes);
        int fontType = attributes.getFontType();
        CharSequence text = this.myDocument.getCharsNoThreadCheck();
        int lastLineIndex = Math.max(0, this.myDocument.getLineCount() - 1);
        while (!iterationState.atEnd() && !lIterator.atEnd()) {
            FoldRegion collapsedFolderAt;
            int lEnd;
            int hEnd = iterationState.getEndOffset();
            if (hEnd >= (lEnd = lIterator.getEnd())) {
                collapsedFolderAt = this.myFoldingModel.getCollapsedRegionAtOffset(start);
                if (collapsedFolderAt == null) {
                    position.x = this.drawBackground(g, backColor, text.subSequence(start, lEnd - lIterator.getSeparatorLength()), position, fontType, defaultBackground, clip);
                    if (lIterator.getLineNumber() < lastLineIndex) {
                        if (backColor != null && !backColor.equals(defaultBackground)) {
                            g.setColor(backColor);
                            g.fillRect(position.x, position.y, clip.x + clip.width - position.x, lineHeight);
                        }
                    } else {
                        EditorImpl.paintAfterFileEndBackground(iterationState, g, position, clip, lineHeight, defaultBackground);
                        break;
                    }
                    position.x = 0;
                    if (position.y > clip.y + clip.height) break;
                    position.y += lineHeight;
                    start = lEnd;
                }
                lIterator.advance();
                continue;
            }
            collapsedFolderAt = iterationState.getCurrentFold();
            position.x = collapsedFolderAt != null ? this.drawBackground(g, backColor, collapsedFolderAt.getPlaceholderText(), position, fontType, defaultBackground, clip) : (hEnd > lEnd - lIterator.getSeparatorLength() ? this.drawBackground(g, backColor, text.subSequence(start, lEnd - lIterator.getSeparatorLength()), position, fontType, defaultBackground, clip) : this.drawBackground(g, backColor, text.subSequence(start, hEnd), position, fontType, defaultBackground, clip));
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            backColor = this.getBackgroundColor(attributes);
            fontType = attributes.getFontType();
            start = iterationState.getStartOffset();
        }
        this.flushBackground(g, clip);
        if (lIterator.getLineNumber() >= lastLineIndex && position.y <= clip.y + clip.height) {
            EditorImpl.paintAfterFileEndBackground(iterationState, g, position, clip, lineHeight, defaultBackground);
        }
    }

    private void paintRectangularSelection(Graphics g) {
        int height;
        int y;
        SelectionModel model = this.getSelectionModel();
        if (!model.hasBlockSelection()) {
            return;
        }
        LogicalPosition blockStart = model.getBlockStart();
        LogicalPosition blockEnd = model.getBlockEnd();
        assert (blockStart != null);
        assert (blockEnd != null);
        Point start = this.logicalPositionToXY(blockStart);
        Point end = this.logicalPositionToXY(blockEnd);
        g.setColor(this.myScheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
        if (start.y <= end.y) {
            y = start.y;
            height = end.y - y + this.getLineHeight();
        } else {
            y = end.y;
            height = start.y - end.y + this.getLineHeight();
        }
        int x = Math.min(start.x, end.x);
        int width = Math.max(2, Math.abs(end.x - start.x));
        g.fillRect(x, y, width, height);
    }

    private static void paintAfterFileEndBackground(IterationState iterationState, Graphics g, Point position, Rectangle clip, int lineHeight, Color defaultBackground) {
        Color backColor = iterationState.getPastFileEndBackground();
        if (backColor != null && !backColor.equals(defaultBackground)) {
            g.setColor(backColor);
            g.fillRect(position.x, position.y, clip.x + clip.width - position.x, lineHeight);
        }
    }

    private int drawBackground(Graphics g, Color backColor, CharSequence text, Point position, int fontType, Color defaultBackground, Rectangle clip) {
        int w = this.getTextSegmentWidth(text, position.x, fontType, clip);
        if (backColor != null && !backColor.equals(defaultBackground) && clip.intersects(position.x, position.y, w, this.getLineHeight())) {
            if (backColor.equals(this.myLastBackgroundColor) && this.myLastBackgroundPosition.y == position.y && this.myLastBackgroundPosition.x + this.myLastBackgroundWidth == position.x) {
                this.myLastBackgroundWidth += w;
            } else {
                this.flushBackground(g, clip);
                this.myLastBackgroundColor = backColor;
                this.myLastBackgroundPosition = new Point(position);
                this.myLastBackgroundWidth = w;
            }
        }
        return position.x + w;
    }

    private void flushBackground(Graphics g, Rectangle clip) {
        if (this.myLastBackgroundColor != null) {
            Point position = this.myLastBackgroundPosition;
            int w = this.myLastBackgroundWidth;
            int height = this.getLineHeight();
            if (clip.intersects(position.x, position.y, w, height)) {
                g.setColor(this.myLastBackgroundColor);
                g.fillRect(position.x, position.y, w, height);
            }
            this.myLastBackgroundColor = null;
        }
    }

    private LineIterator createLineIterator() {
        return this.myDocument.createLineIterator();
    }

    private void paintText(Graphics g, Rectangle clip) {
        FoldRegion collapsedFolderAt;
        this.myCurrentFontType = null;
        this.myLastCache = null;
        int plainSpaceWidth = EditorUtil.getSpaceWidth(0, this);
        int boldSpaceWidth = EditorUtil.getSpaceWidth(1, this);
        int italicSpaceWidth = EditorUtil.getSpaceWidth(2, this);
        int boldItalicSpaceWidth = EditorUtil.getSpaceWidth(3, this);
        this.mySpacesHaveSameWidth = plainSpaceWidth == boldSpaceWidth && plainSpaceWidth == italicSpaceWidth && plainSpaceWidth == boldItalicSpaceWidth;
        int lineHeight = this.getLineHeight();
        int visibleLineNumber = clip.y / lineHeight;
        int startLineNumber = this.xyToLogicalPosition((Point)new Point((int)0, (int)clip.y)).line;
        Point position = new Point(0, visibleLineNumber * lineHeight);
        if (startLineNumber == 0 && this.myPrefixText != null) {
            position.x = this.drawString(g, this.myPrefixText, 0, this.myPrefixText.length, position, clip, this.myPrefixAttributes.getEffectColor(), this.myPrefixAttributes.getEffectType(), this.myPrefixAttributes.getFontType(), this.myPrefixAttributes.getForegroundColor());
        }
        if (startLineNumber >= this.myDocument.getLineCount() || startLineNumber < 0) {
            if (position.x > 0) {
                this.flushCachedChars(g);
            }
            return;
        }
        int start = this.myDocument.getLineStartOffset(startLineNumber);
        IterationState iterationState = new IterationState(this, start, this.paintSelection());
        LineIterator lIterator = this.createLineIterator();
        lIterator.start(start);
        if (lIterator.atEnd()) {
            return;
        }
        TextAttributes attributes = iterationState.getMergedAttributes();
        Color currentColor = attributes.getForegroundColor();
        if (currentColor == null) {
            currentColor = this.getForegroundColor();
        }
        Color effectColor = attributes.getEffectColor();
        EffectType effectType = attributes.getEffectType();
        int fontType = attributes.getFontType();
        g.setColor(currentColor);
        char[] chars = this.myDocument.getRawChars();
        while (!iterationState.atEnd() && !lIterator.atEnd()) {
            FoldRegion collapsedFolderAt2;
            int lEnd;
            int hEnd = iterationState.getEndOffset();
            if (hEnd >= (lEnd = lIterator.getEnd())) {
                collapsedFolderAt2 = this.myFoldingModel.getCollapsedRegionAtOffset(start);
                if (collapsedFolderAt2 == null) {
                    this.drawString(g, chars, start, lEnd - lIterator.getSeparatorLength(), position, clip, effectColor, effectType, fontType, currentColor);
                    position.x = 0;
                    if (position.y > clip.y + clip.height) break;
                    position.y += lineHeight;
                    start = lEnd;
                }
                lIterator.advance();
                continue;
            }
            collapsedFolderAt2 = iterationState.getCurrentFold();
            if (collapsedFolderAt2 != null) {
                int foldingXStart = position.x;
                position.x = this.drawString(g, collapsedFolderAt2.getPlaceholderText(), position, clip, effectColor, effectType, fontType, currentColor);
                BorderEffect.paintFoldedEffect(g, foldingXStart, position.y, position.x, this.getLineHeight(), effectColor, effectType);
            } else {
                position.x = hEnd > lEnd - lIterator.getSeparatorLength() ? this.drawString(g, chars, start, lEnd - lIterator.getSeparatorLength(), position, clip, effectColor, effectType, fontType, currentColor) : this.drawString(g, chars, start, hEnd, position, clip, effectColor, effectType, fontType, currentColor);
            }
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            currentColor = attributes.getForegroundColor();
            if (currentColor == null) {
                currentColor = this.getForegroundColor();
            }
            effectColor = attributes.getEffectColor();
            effectType = attributes.getEffectType();
            fontType = attributes.getFontType();
            start = iterationState.getStartOffset();
        }
        if ((collapsedFolderAt = iterationState.getCurrentFold()) != null) {
            int foldingXStart = position.x;
            int foldingXEnd = this.drawString(g, collapsedFolderAt.getPlaceholderText(), position, clip, effectColor, effectType, fontType, currentColor);
            BorderEffect.paintFoldedEffect(g, foldingXStart, position.y, foldingXEnd, this.getLineHeight(), effectColor, effectType);
        }
        this.flushCachedChars(g);
    }

    private boolean paintSelection() {
        return !this.isOneLineMode() || IJSwingUtilities.hasFocus(this.getContentComponent());
    }

    private void flushCachedChars(Graphics g) {
        for (CachedFontContent cache : this.myFontCache) {
            cache.flushContent(g);
        }
        this.myLastCache = null;
    }

    private void paintCaretCursor(Graphics g) {
        this.myCaretCursor.paint(g);
    }

    private void paintLineMarkersSeparators(Graphics g, Rectangle clip, MarkupModel markupModel) {
        RangeHighlighter[] lineMarkers;
        if (markupModel == null) {
            return;
        }
        for (RangeHighlighter lineMarker : lineMarkers = markupModel.getAllHighlighters()) {
            this.paintLineMarkerSeparator(lineMarker, clip, g);
        }
    }

    private void paintLineMarkerSeparator(RangeHighlighter marker, Rectangle clip, Graphics g) {
        if (!marker.isValid()) {
            return;
        }
        Color separatorColor = marker.getLineSeparatorColor();
        if (separatorColor != null) {
            int lineNumber;
            int n = lineNumber = marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? marker.getDocument().getLineNumber(marker.getStartOffset()) : marker.getDocument().getLineNumber(marker.getEndOffset());
            if (lineNumber < 0 || lineNumber >= this.myDocument.getLineCount()) {
                return;
            }
            int y = this.visibleLineNumberToYPosition(this.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lineNumber, (int)0)).line);
            if (marker.getLineSeparatorPlacement() != SeparatorPlacement.TOP) {
                y += this.getLineHeight();
            }
            if (y < clip.y || y > clip.y + clip.height) {
                return;
            }
            int endShift = clip.x + clip.width;
            g.setColor(separatorColor);
            if (this.mySettings.isRightMarginShown() && this.myScheme.getColor(EditorColors.RIGHT_MARGIN_COLOR) != null) {
                endShift = Math.min(endShift, this.mySettings.getRightMargin(this.myProject) * EditorUtil.getSpaceWidth(0, this));
            }
            UIUtil.drawLine((Graphics)g, (int)0, (int)(y - 1), (int)endShift, (int)(y - 1));
        }
    }

    private int drawString(Graphics g, char[] text, int start, int end, Point position, Rectangle clip, Color effectColor, EffectType effectType, int fontType, Color fontColor) {
        boolean isInClip;
        if (start >= end) {
            return position.x;
        }
        boolean bl = isInClip = this.getLineHeight() + position.y >= clip.y && position.y <= clip.y + clip.height;
        if (!isInClip) {
            return position.x;
        }
        int y = this.getLineHeight() - this.getDescent() + position.y;
        int x = position.x;
        return this.drawTabbedString(g, text, start, end, x, y, effectColor, effectType, fontType, fontColor, clip);
    }

    private int drawString(Graphics g, String text, Point position, Rectangle clip, Color effectColor, EffectType effectType, int fontType, Color fontColor) {
        boolean isInClip;
        boolean bl = isInClip = this.getLineHeight() + position.y >= clip.y && position.y <= clip.y + clip.height;
        if (!isInClip) {
            return position.x;
        }
        int y = this.getLineHeight() - this.getDescent() + position.y;
        int x = position.x;
        return this.drawTabbedString(g, text.toCharArray(), 0, text.length(), x, y, effectColor, effectType, fontType, fontColor, clip);
    }

    private int drawTabbedString(Graphics g, char[] text, int start, int end, int x, int y, Color effectColor, EffectType effectType, int fontType, Color fontColor, Rectangle clip) {
        int xStart = x;
        for (int i = start; i < end; ++i) {
            if (text[i] != '\t') continue;
            x = this.drawTablessString(text, start, i, g, x, y, fontType, fontColor, clip);
            int x1 = EditorUtil.nextTabStop(x, this);
            this.drawTabPlacer(g, y, x, x1);
            x = x1;
            start = i + 1;
        }
        x = this.drawTablessString(text, start, end, g, x, y, fontType, fontColor, clip);
        if (effectColor != null) {
            Color savedColor = g.getColor();
            int xEnd = x;
            if (xStart < clip.x && xEnd < clip.x || xStart > clip.x + clip.width && xEnd > clip.x + clip.width) {
                return x;
            }
            if (xEnd > clip.x + clip.width) {
                xEnd = clip.x + clip.width;
            }
            if (xStart < clip.x) {
                xStart = clip.x;
            }
            if (effectType == EffectType.LINE_UNDERSCORE) {
                g.setColor(effectColor);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
                g.setColor(savedColor);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                g.setColor(effectColor);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)y, (int)xEnd, (int)y);
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)(y + 1), (int)xEnd, (int)(y + 1));
                g.setColor(savedColor);
            } else if (effectType == EffectType.STRIKEOUT) {
                g.setColor(effectColor);
                int y1 = y - this.getCharHeight() / 2;
                UIUtil.drawLine((Graphics)g, (int)xStart, (int)y1, (int)xEnd, (int)y1);
                g.setColor(savedColor);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                g.setColor(effectColor);
                EditorImpl.drawWave(g, xStart, xEnd, y + 1);
                g.setColor(savedColor);
            }
        }
        return x;
    }

    private int drawTablessString(char[] text, int start, int end, Graphics g, int x, int y, int fontType, Color fontColor, Rectangle clip) {
        int endX = x;
        if (start < end) {
            FontInfo font = EditorUtil.fontForChar(text[start], fontType, this);
            for (int j = start; j < end; ++j) {
                char c = text[j];
                FontInfo newFont = EditorUtil.fontForChar(c, fontType, this);
                if (font != newFont || endX > clip.x + clip.width) {
                    if (!(x < clip.x && endX < clip.x || x > clip.x + clip.width && endX > clip.x + clip.width)) {
                        this.drawCharsCached(g, text, start, j, x, y, fontType, fontColor);
                    }
                    start = j;
                    x = endX;
                    font = newFont;
                }
                if (x < clip.x && endX < clip.x) {
                    start = j;
                    x = endX;
                    font = newFont;
                } else if (x > clip.x + clip.width) {
                    return endX;
                }
                endX += font.charWidth(c, this.myEditorComponent);
            }
            if (!(x < clip.x && endX < clip.x || x > clip.x + clip.width && endX > clip.x + clip.width)) {
                this.drawCharsCached(g, text, start, end, x, y, fontType, fontColor);
            }
        }
        return endX;
    }

    private void drawTabPlacer(Graphics g, int y, int start, int stop) {
        if (this.mySettings.isWhitespacesShown()) {
            stop -= g.getFontMetrics().charWidth(' ') / 2;
            Color oldColor = g.getColor();
            g.setColor(this.myScheme.getColor(EditorColors.WHITESPACES_COLOR));
            int charHeight = this.getCharHeight();
            int halfCharHeight = charHeight / 2;
            int mid = y - halfCharHeight;
            int top = y - charHeight;
            UIUtil.drawLine((Graphics)g, (int)start, (int)mid, (int)stop, (int)mid);
            UIUtil.drawLine((Graphics)g, (int)stop, (int)y, (int)stop, (int)top);
            g.fillPolygon(new int[]{stop - halfCharHeight, stop - halfCharHeight, stop}, new int[]{y, y - charHeight, y - halfCharHeight}, 3);
            g.setColor(oldColor);
        }
    }

    private void drawCharsCached(Graphics g, char[] data, int start, int end, int x, int y, int fontType, Color color) {
        if (this.mySpacesHaveSameWidth && this.myLastCache != null && EditorImpl.spacesOnly(data, start, end)) {
            this.myLastCache.addContent(g, data, start, end, x, y, null);
        } else {
            FontInfo fnt = EditorUtil.fontForChar(data[start], fontType, this);
            CachedFontContent cache = null;
            for (CachedFontContent fontCache : this.myFontCache) {
                if (fontCache.myFontType != fnt) continue;
                cache = fontCache;
                break;
            }
            if (cache == null) {
                cache = new CachedFontContent(fnt);
                this.myFontCache.add(cache);
            }
            this.myLastCache = cache;
            cache.addContent(g, data, start, end, x, y, color);
        }
    }

    private static boolean spacesOnly(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (chars[i] == ' ') continue;
            return false;
        }
        return true;
    }

    private void drawChars(Graphics g, char[] data, int start, int end, int x, int y) {
        g.drawChars(data, start, end - start, x, y);
        if (this.mySettings.isWhitespacesShown()) {
            Color oldColor = g.getColor();
            g.setColor(this.myScheme.getColor(EditorColors.WHITESPACES_COLOR));
            FontMetrics metrics = g.getFontMetrics();
            int halfSpaceWidth = metrics.charWidth(' ') / 2;
            for (int i = start; i < end; ++i) {
                if (data[i] == ' ') {
                    g.fillRect(x + halfSpaceWidth, y, 1, 1);
                }
                x += metrics.charWidth(data[i]);
            }
            g.setColor(oldColor);
        }
    }

    private static void drawWave(Graphics g, int xStart, int xEnd, int y) {
        int startSegment = xStart / 4;
        int endSegment = xEnd / 4;
        for (int i = startSegment; i < endSegment; ++i) {
            EditorImpl.drawWaveSegment(g, 4 * i, y);
        }
        int x = 4 * endSegment;
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 2), (int)(x + 2), (int)y);
    }

    private static void drawWaveSegment(Graphics g, int x, int y) {
        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + 2), (int)(x + 2), (int)y);
        UIUtil.drawLine((Graphics)g, (int)(x + 2), (int)y, (int)(x + 4), (int)(y + 2));
    }

    private int getTextSegmentWidth(CharSequence text, int xStart, int fontType, Rectangle clip) {
        int x = xStart;
        int textLength = text.length();
        for (int i = 0; i < textLength && xStart < clip.x + clip.width; ++i) {
            x = text.charAt(i) == '\t' ? EditorUtil.nextTabStop(x, this) : (x += EditorUtil.charWidth(text.charAt(i), fontType, this));
            if (x > clip.x + clip.width) break;
        }
        return x - xStart;
    }

    public int getLineHeight() {
        if (this.myLineHeight != -1) {
            return this.myLineHeight;
        }
        EditorImpl.assertReadAccess();
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
        this.myLineHeight = (int)((float)fontMetrics.getHeight() * (this.isOneLineMode() ? 1.0f : this.myScheme.getLineSpacing()));
        if (this.myLineHeight == 0) {
            this.myLineHeight = fontMetrics.getHeight();
            if (this.myLineHeight == 0) {
                this.myLineHeight = 12;
            }
        }
        return this.myLineHeight;
    }

    int getDescent() {
        if (this.myDescent != -1) {
            return this.myDescent;
        }
        FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
        this.myDescent = fontMetrics.getDescent();
        return this.myDescent;
    }

    FontMetrics getFontMetrics(int fontType) {
        if (this.myPlainFontMetrics == null) {
            this.assertIsDispatchThread();
            this.myPlainFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
            this.myBoldFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.BOLD));
            this.myItalicFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.ITALIC));
            this.myBoldItalicFontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.BOLD_ITALIC));
        }
        if (fontType == 0) {
            return this.myPlainFontMetrics;
        }
        if (fontType == 1) {
            return this.myBoldFontMetrics;
        }
        if (fontType == 2) {
            return this.myItalicFontMetrics;
        }
        if (fontType == 3) {
            return this.myBoldItalicFontMetrics;
        }
        LOG.error("Unknown font type: " + fontType);
        return this.myPlainFontMetrics;
    }

    private int getCharHeight() {
        if (this.myCharHeight == -1) {
            this.assertIsDispatchThread();
            FontMetrics fontMetrics = this.myEditorComponent.getFontMetrics(this.myScheme.getFont(EditorFontType.PLAIN));
            this.myCharHeight = fontMetrics.charWidth('a');
        }
        return this.myCharHeight;
    }

    public Dimension getPreferredSize() {
        if (ourIsUnitTestMode && this.getUserData(DO_DOCUMENT_UPDATE_TEST) == null) {
            return new Dimension(1, 1);
        }
        Dimension draft = this.getSizeWithoutCaret();
        int additionalSpace = this.mySettings.getAdditionalColumnsCount() * EditorUtil.getSpaceWidth(0, this);
        if (!this.myDocument.isInBulkUpdate()) {
            int caretX = this.visualPositionToXY((VisualPosition)this.getCaretModel().getVisualPosition()).x;
            draft.width = Math.max(caretX, draft.width) + additionalSpace;
        } else {
            draft.width += additionalSpace;
        }
        return draft;
    }

    private Dimension getSizeWithoutCaret() {
        Dimension size = this.mySizeContainer.getContentSize();
        if (this.isOneLineMode()) {
            return new Dimension(size.width, this.getLineHeight());
        }
        if (this.mySettings.isAdditionalPageAtBottom()) {
            int lineHeight = this.getLineHeight();
            return new Dimension(size.width, size.height + Math.max(this.getScrollingModel().getVisibleArea().height - 2 * lineHeight, lineHeight));
        }
        return this.getContentSize();
    }

    @Override
    public Dimension getContentSize() {
        Dimension size = this.mySizeContainer.getContentSize();
        return new Dimension(size.width, size.height + this.mySettings.getAdditionalLinesCount() * this.getLineHeight());
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.logicalPositionToOffset must not be null");
        }
        EditorImpl.assertReadAccess();
        this.assertIsDispatchThread();
        if (this.myDocument.getLineCount() == 0) {
            return 0;
        }
        if (pos.line < 0) {
            throw new IndexOutOfBoundsException("Wrong line: " + pos.line);
        }
        if (pos.column < 0) {
            throw new IndexOutOfBoundsException("Wrong column:" + pos.column);
        }
        if (pos.line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        int start = this.myDocument.getLineStartOffset(pos.line);
        int end = this.myDocument.getLineEndOffset(pos.line);
        CharSequence text = this.myDocument.getCharsNoThreadCheck();
        if (pos.column == 0) {
            return start;
        }
        return EditorUtil.calcOffset(this, text, start, end, pos.column, EditorUtil.getTabSize(this));
    }

    @Override
    public void setLastColumnNumber(int val) {
        this.assertIsDispatchThread();
        this.myLastColumnNumber = val;
    }

    @Override
    public int getLastColumnNumber() {
        EditorImpl.assertReadAccess();
        return this.myLastColumnNumber;
    }

    int getVisibleLineCount() {
        int line = this.getDocument().getLineCount();
        return line -= this.myFoldingModel.getFoldedLinesCountBefore(this.getDocument().getTextLength() + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        VisualPosition visualPosition;
        if (logicalPos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.logicalToVisualPosition must not be null");
        }
        EditorImpl.assertReadAccess();
        if (!this.myFoldingModel.isFoldingEnabled()) {
            visualPosition = new VisualPosition(logicalPos.line, logicalPos.column);
            if (visualPosition == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.logicalToVisualPosition must not return null");
            return visualPosition;
        }
        int offset = this.logicalPositionToOffset(logicalPos);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset);
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            if (offset < this.getDocument().getTextLength()) {
                offset = outermostCollapsed.getStartOffset();
                LogicalPosition foldStart = this.offsetToLogicalPosition(offset);
                visualPosition = this.logicalToVisualPosition(foldStart);
                if (visualPosition == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.logicalToVisualPosition must not return null");
                return visualPosition;
            }
            offset = outermostCollapsed.getEndOffset() + 3;
        }
        int line = logicalPos.line;
        int column = logicalPos.column;
        line -= this.myFoldingModel.getFoldedLinesCountBefore(offset);
        FoldRegion[] toplevel = this.myFoldingModel.fetchTopLevel();
        for (int idx = this.myFoldingModel.getLastTopLevelIndexBefore(offset); idx >= 0; --idx) {
            FoldRegion region = toplevel[idx];
            if (!region.isValid()) continue;
            if (region.getDocument().getLineNumber(region.getEndOffset()) != logicalPos.line || region.getEndOffset() > offset) break;
            LogicalPosition foldStart = this.offsetToLogicalPosition(region.getStartOffset());
            LogicalPosition foldEnd = this.offsetToLogicalPosition(region.getEndOffset());
            column += foldStart.column + region.getPlaceholderText().length() - foldEnd.column;
            offset = region.getStartOffset();
            logicalPos = foldStart;
        }
        LOG.assertTrue(line >= 0);
        visualPosition = new VisualPosition(line, Math.max(0, column));
        if (visualPosition != null) return visualPosition;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.logicalToVisualPosition must not return null");
    }

    @Nullable
    private FoldRegion getLastCollapsedBeforePosition(VisualPosition visual) {
        VisualPosition visFoldEnd;
        LogicalPosition logFoldEnd;
        FoldRegion region;
        FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
        if (topLevelCollapsed == null) {
            return null;
        }
        int start = 0;
        int end = topLevelCollapsed.length - 1;
        int i = 0;
        while (start <= end) {
            i = (start + end) / 2;
            region = topLevelCollapsed[i];
            logFoldEnd = this.offsetToLogicalPosition(region.getEndOffset() - 1);
            visFoldEnd = this.logicalToVisualPosition(logFoldEnd);
            if (visFoldEnd.line < visual.line) {
                start = i + 1;
                continue;
            }
            if (visFoldEnd.line > visual.line) {
                end = i - 1;
                continue;
            }
            if (visFoldEnd.column < visual.column) {
                start = i + 1;
                continue;
            }
            if (visFoldEnd.column > visual.column) {
                end = i - 1;
                continue;
            }
            --i;
            break;
        }
        while (i >= 0 && i < topLevelCollapsed.length && !topLevelCollapsed[i].isValid()) {
            --i;
        }
        if (i >= 0 && i < topLevelCollapsed.length) {
            region = topLevelCollapsed[i];
            logFoldEnd = this.offsetToLogicalPosition(region.getEndOffset() - 1);
            visFoldEnd = this.logicalToVisualPosition(logFoldEnd);
            if (visFoldEnd.line > visual.line || visFoldEnd.line == visual.line && visFoldEnd.column > visual.column) {
                if (--i >= 0) {
                    return topLevelCollapsed[i];
                }
                return null;
            }
            return region;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        LogicalPosition logicalPosition;
        if (visiblePos == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.visualToLogicalPosition must not be null");
        }
        EditorImpl.assertReadAccess();
        if (!this.myFoldingModel.isFoldingEnabled()) {
            logicalPosition = new LogicalPosition(visiblePos.line, visiblePos.column);
            if (logicalPosition == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.visualToLogicalPosition must not return null");
            return logicalPosition;
        }
        int line = visiblePos.line;
        int column = visiblePos.column;
        FoldRegion lastCollapsedBefore = this.getLastCollapsedBeforePosition(visiblePos);
        if (lastCollapsedBefore != null) {
            LogicalPosition logFoldEnd = this.offsetToLogicalPosition(lastCollapsedBefore.getEndOffset());
            VisualPosition visFoldEnd = this.logicalToVisualPosition(logFoldEnd);
            line = logFoldEnd.line + (visiblePos.line - visFoldEnd.line);
            if (visFoldEnd.line == visiblePos.line) {
                if (visiblePos.column < visFoldEnd.column) {
                    logicalPosition = this.offsetToLogicalPosition(lastCollapsedBefore.getStartOffset());
                    if (logicalPosition == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.visualToLogicalPosition must not return null");
                    return logicalPosition;
                }
                column = logFoldEnd.column + (visiblePos.column - visFoldEnd.column);
            }
        }
        if (column < 0) {
            column = 0;
        }
        if ((logicalPosition = new LogicalPosition(line, column)) != null) return logicalPosition;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.visualToLogicalPosition must not return null");
    }

    private int calcLogicalLineNumber(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0) {
            return 0;
        }
        if (offset > textLength || offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + " textLength: " + textLength);
        }
        int lineIndex = this.myDocument.getLineNumber(offset);
        LOG.assertTrue(lineIndex >= 0 && lineIndex < this.myDocument.getLineCount());
        return lineIndex;
    }

    @Override
    public int calcColumnNumber(int offset, int lineIndex) {
        if (this.myDocument.getTextLength() == 0) {
            return 0;
        }
        CharSequence text = this.myDocument.getCharsSequence();
        int start = this.myDocument.getLineStartOffset(lineIndex);
        if (start == offset) {
            return 0;
        }
        return EditorUtil.calcColumnNumber(this, text, start, offset, EditorUtil.getTabSize(this));
    }

    private void moveCaretToScreenPos(int x, int y) {
        int lineEndOffset;
        int lineEndColumnNumber;
        int totalLines;
        if (x < 0) {
            x = 0;
        }
        LogicalPosition pos = this.xyToLogicalPosition(new Point(x, y));
        int columnNumber = pos.column;
        int lineNumber = pos.line;
        if (lineNumber < 0) {
            lineNumber = 0;
            columnNumber = 0;
        }
        if ((totalLines = this.myDocument.getLineCount()) <= 0) {
            this.getCaretModel().moveToOffset(0);
            return;
        }
        if (lineNumber >= totalLines) {
            this.moveCaretToScreenPos(x, this.logicalLineToY(totalLines - 1));
            return;
        }
        if (!this.mySettings.isVirtualSpace() && columnNumber > (lineEndColumnNumber = this.calcColumnNumber(lineEndOffset = this.myDocument.getLineEndOffset(lineNumber), lineNumber))) {
            columnNumber = lineEndColumnNumber;
        }
        if (!this.mySettings.isCaretInsideTabs()) {
            int offset = this.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
            CharSequence text = this.myDocument.getCharsSequence();
            if (offset >= 0 && offset < this.myDocument.getTextLength() && text.charAt(offset) == '\t') {
                columnNumber = this.calcColumnNumber(offset, lineNumber);
            }
        }
        LogicalPosition pos1 = new LogicalPosition(lineNumber, columnNumber);
        this.getCaretModel().moveToLogicalPosition(pos1);
    }

    private boolean checkIgnore(MouseEvent e, boolean isFinalCheck) {
        if (!this.myIgnoreMouseEventsConsecutiveToInitial) {
            this.myInitialMouseEvent = null;
            return false;
        }
        if (e.getComponent() != this.myInitialMouseEvent.getComponent() || !e.getPoint().equals(this.myInitialMouseEvent.getPoint())) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
            return false;
        }
        if (isFinalCheck) {
            this.myIgnoreMouseEventsConsecutiveToInitial = false;
            this.myInitialMouseEvent = null;
        }
        e.consume();
        return true;
    }

    private void processMouseReleased(MouseEvent e) {
        if (this.checkIgnore(e, true)) {
            return;
        }
        if (e.getSource() == this.myGutterComponent) {
            this.myGutterComponent.mouseReleased(e);
        }
        if (this.getMouseEventArea(e) != EditorMouseEventArea.EDITING_AREA || e.getY() < 0 || e.getX() < 0) {
            return;
        }
        final FoldRegion region = ((FoldingModelEx)this.getFoldingModel()).getFoldingPlaceholderAt(e.getPoint());
        if (e.getX() >= 0 && e.getY() >= 0 && region != null && region == this.myMouseSelectedRegion) {
            this.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    EditorImpl.this.myFoldingModel.flushCaretShift();
                    region.setExpanded(true);
                }
            });
        }
        if (this.myMousePressedEvent != null && this.myMousePressedEvent.getClickCount() == 1 && this.myMousePressedInsideSelection) {
            this.getSelectionModel().removeSelection();
        }
    }

    @Override
    public DataContext getDataContext() {
        return this.getProjectAwareDataContext(DataManager.getInstance().getDataContext((Component)this.getContentComponent()));
    }

    private DataContext getProjectAwareDataContext(final DataContext original) {
        if (PlatformDataKeys.PROJECT.getData(original) == this.myProject) {
            return original;
        }
        return new DataContext(){

            public Object getData(String dataId) {
                if (PlatformDataKeys.PROJECT.is(dataId)) {
                    return EditorImpl.this.myProject;
                }
                return original.getData(dataId);
            }
        };
    }

    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.getMouseEventArea must not be null");
        }
        if (this.myGutterComponent != e.getSource()) {
            return EditorMouseEventArea.EDITING_AREA;
        }
        int x = this.myGutterComponent.convertX(e.getX());
        if (x >= this.myGutterComponent.getLineNumberAreaOffset() && x < this.myGutterComponent.getLineNumberAreaOffset() + this.myGutterComponent.getLineNumberAreaWidth()) {
            return EditorMouseEventArea.LINE_NUMBERS_AREA;
        }
        if (x >= this.myGutterComponent.getAnnotationsAreaOffset() && x <= this.myGutterComponent.getAnnotationsAreaOffset() + this.myGutterComponent.getAnnotationsAreaWidth()) {
            return EditorMouseEventArea.ANNOTATIONS_AREA;
        }
        if (x >= this.myGutterComponent.getLineMarkerAreaOffset() && x < this.myGutterComponent.getLineMarkerAreaOffset() + this.myGutterComponent.getLineMarkerAreaWidth()) {
            return EditorMouseEventArea.LINE_MARKERS_AREA;
        }
        if (x >= this.myGutterComponent.getFoldingAreaOffset() && x < this.myGutterComponent.getFoldingAreaOffset() + this.myGutterComponent.getFoldingAreaWidth()) {
            return EditorMouseEventArea.FOLDING_OUTLINE_AREA;
        }
        return null;
    }

    private void requestFocus() {
        this.myEditorComponent.requestFocus();
    }

    private void validateMousePointer(MouseEvent e) {
        if (e.getSource() == this.myGutterComponent) {
            FoldRegion foldingAtCursor = this.myGutterComponent.findFoldingAnchorAt(e.getX(), e.getY());
            this.myGutterComponent.setActiveFoldRegion(foldingAtCursor);
            if (foldingAtCursor != null) {
                this.myGutterComponent.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.myGutterComponent.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            this.myGutterComponent.setActiveFoldRegion(null);
            if (this.getSelectionModel().hasSelection() && (e.getModifiersEx() & 0xC00) == 0) {
                int offset = this.logicalPositionToOffset(this.xyToLogicalPosition(e.getPoint()));
                if (this.getSelectionModel().getSelectionStart() <= offset && offset < this.getSelectionModel().getSelectionEnd()) {
                    this.myEditorComponent.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            this.myEditorComponent.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    private void runMouseDraggedCommand(final MouseEvent e) {
        if (this.myCommandProcessor == null || this.myMousePressedEvent != null && this.myMousePressedEvent.isConsumed()) {
            return;
        }
        this.myCommandProcessor.executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                EditorImpl.this.processMouseDragged(e);
            }
        }, "", this.MOUSE_DRAGGED_GROUP, UndoConfirmationPolicy.DEFAULT, this.getDocument());
    }

    private void processMouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Rectangle rect = this.getScrollingModel().getVisibleArea();
        int x = e.getX();
        if (e.getSource() == this.myGutterComponent) {
            x = 0;
        }
        int dx = 0;
        if (x < rect.x && rect.x > 0) {
            dx = x - rect.x;
        } else if (x > rect.x + rect.width) {
            dx = x - rect.x - rect.width;
        }
        int dy = 0;
        int y = e.getY();
        if (y < rect.y && rect.y > 0) {
            dy = y - rect.y;
        } else if (y > rect.y + rect.height) {
            dy = y - rect.y - rect.height;
        }
        if (dx == 0 && dy == 0) {
            this.myScrollingTimer.stop();
            SelectionModel selectionModel = this.getSelectionModel();
            int oldSelectionStart = selectionModel.getLeadSelectionOffset();
            int oldCaretOffset = this.getCaretModel().getOffset();
            LogicalPosition oldLogicalCaret = this.getCaretModel().getLogicalPosition();
            this.moveCaretToScreenPos(x, y);
            this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            int newCaretOffset = this.getCaretModel().getOffset();
            int caretShift = newCaretOffset - this.mySavedSelectionStart;
            if (this.myMousePressedEvent != null && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.EDITING_AREA && this.getMouseEventArea(this.myMousePressedEvent) != EditorMouseEventArea.LINE_NUMBERS_AREA) {
                selectionModel.setSelection(oldSelectionStart, newCaretOffset);
            } else if (this.isColumnMode() || e.isAltDown()) {
                LogicalPosition blockStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : oldLogicalCaret;
                selectionModel.setBlockSelection(blockStart, this.getCaretModel().getLogicalPosition());
            } else {
                if (this.getMouseSelectionState() != 0) {
                    if (caretShift < 0) {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.mySelectionModel.getWordAtCaretStart();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionEnd, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    } else {
                        int newSelection = newCaretOffset;
                        if (this.getMouseSelectionState() == 1) {
                            newSelection = this.mySelectionModel.getWordAtCaretEnd();
                        } else if (this.getMouseSelectionState() == 2) {
                            newSelection = this.logicalPositionToOffset(this.visualToLogicalPosition(new VisualPosition(this.getCaretModel().getVisualPosition().line + 1, 0)));
                        }
                        if (newSelection < 0) {
                            newSelection = newCaretOffset;
                        }
                        selectionModel.setSelection(this.mySavedSelectionStart, newSelection);
                        this.getCaretModel().moveToOffset(newSelection);
                    }
                    return;
                }
                if (!this.myMousePressedInsideSelection) {
                    selectionModel.setSelection(oldSelectionStart, newCaretOffset);
                } else if (caretShift != 0 && this.myMousePressedEvent != null) {
                    if (this.mySettings.isDndEnabled()) {
                        boolean isCopy = UIUtil.isControlKeyDown((MouseEvent)e) || this.isViewer() || !this.getDocument().isWritable();
                        this.mySavedCaretOffsetForDNDUndoHack = oldCaretOffset;
                        this.getContentComponent().getTransferHandler().exportAsDrag(this.getContentComponent(), e, isCopy ? 1 : 2);
                    } else {
                        selectionModel.removeSelection();
                    }
                    this.myMousePressedEvent = null;
                }
            }
        } else {
            this.myScrollingTimer.start(dx, dy);
        }
    }

    void updateCaretCursor() {
        if (!ourIsUnitTestMode && !IJSwingUtilities.hasFocus(this.getContentComponent())) {
            this.stopOptimizedScrolling();
        }
        if (this.myCursorUpdater == null) {
            this.myCursorUpdater = new Runnable(){

                @Override
                public void run() {
                    if (EditorImpl.this.myCursorUpdater == null) {
                        return;
                    }
                    EditorImpl.this.myCursorUpdater = null;
                    VisualPosition caretPosition = EditorImpl.this.getCaretModel().getVisualPosition();
                    Point pos1 = EditorImpl.this.visualPositionToXY(caretPosition);
                    Point pos2 = EditorImpl.this.visualPositionToXY(new VisualPosition(caretPosition.line, caretPosition.column + 1));
                    EditorImpl.this.myCaretCursor.setPosition(pos1, pos2.x - pos1.x);
                }
            };
        }
    }

    @Override
    public boolean setCaretVisible(boolean b) {
        boolean old = this.myCaretCursor.isActive();
        if (b) {
            this.myCaretCursor.activate();
        } else {
            this.myCaretCursor.passivate();
        }
        return old;
    }

    @Override
    public boolean setCaretEnabled(boolean enabled) {
        boolean old = this.myCaretCursor.isEnabled();
        this.myCaretCursor.setEnabled(enabled);
        return old;
    }

    @Override
    public void addFocusListener(FocusChangeListener listener) {
        this.myFocusListeners.add(listener);
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isOneLineMode() {
        return this.myIsOneLineMode;
    }

    @Override
    public boolean isEmbeddedIntoDialogWrapper() {
        return this.myEmbeddedIntoDialogWrapper;
    }

    @Override
    public void setEmbeddedIntoDialogWrapper(boolean b) {
        this.assertIsDispatchThread();
        this.myEmbeddedIntoDialogWrapper = b;
        this.myScrollPane.setFocusable(!b);
        this.myEditorComponent.setFocusCycleRoot(!b);
        this.myEditorComponent.setFocusable(b);
    }

    @Override
    public void setOneLineMode(boolean isOneLineMode) {
        this.myIsOneLineMode = isOneLineMode;
        this.getScrollPane().setInputMap(1, null);
        this.reinitSettings();
    }

    @Override
    public void stopOptimizedScrolling() {
        this.myEditorComponent.setOpaque(false);
    }

    private void startOptimizedScrolling() {
        this.myEditorComponent.setOpaque(true);
    }

    private MyEditable getViewer() {
        if (this.myEditable == null) {
            this.myEditable = new MyEditable();
        }
        return this.myEditable;
    }

    @Override
    public CopyProvider getCopyProvider() {
        return this.getViewer();
    }

    @Override
    public CutProvider getCutProvider() {
        return this.getViewer();
    }

    @Override
    public PasteProvider getPasteProvider() {
        return this.getViewer();
    }

    @Override
    public DeleteProvider getDeleteProvider() {
        return this.getViewer();
    }

    @Override
    public void setColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorImpl.setColorsScheme must not be null");
        }
        this.assertIsDispatchThread();
        this.myScheme = scheme;
        this.reinitSettings();
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorImpl.assertReadAccess();
        EditorColorsScheme editorColorsScheme = this.myScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getColorsScheme must not return null");
        }
        return editorColorsScheme;
    }

    void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread(this.myEditorComponent);
    }

    private static void assertReadAccess() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessAllowed();
    }

    @Override
    public void setVerticalScrollbarOrientation(int type) {
        this.assertIsDispatchThread();
        int currentHorOffset = this.myScrollingModel.getHorizontalScrollOffset();
        this.myScrollbarOrientation = type;
        if (type == 0) {
            this.myScrollPane.setLayout(new LeftHandScrollbarLayout());
        } else {
            this.myScrollPane.setLayout(new ScrollPaneLayout());
        }
        this.myScrollingModel.scrollHorizontally(currentHorOffset);
    }

    @Override
    public void setVerticalScrollbarVisible(boolean b) {
        if (b) {
            this.myScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.myScrollPane.setVerticalScrollBarPolicy(21);
        }
    }

    @Override
    public void setHorizontalScrollbarVisible(boolean b) {
        if (b) {
            this.myScrollPane.setHorizontalScrollBarPolicy(30);
        } else {
            this.myScrollPane.setHorizontalScrollBarPolicy(31);
        }
    }

    int getVerticalScrollbarOrientation() {
        return this.myScrollbarOrientation;
    }

    MyScrollBar getVerticalScrollBar() {
        return this.myVerticalScrollBar;
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    private int getMouseSelectionState() {
        return this.myMouseSelectionState;
    }

    private void setMouseSelectionState(int mouseSelectionState) {
        this.myMouseSelectionState = mouseSelectionState;
        this.myMouseSelectionChangeTimestamp = System.currentTimeMillis();
    }

    void replaceInputMethodText(InputMethodEvent e) {
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.replaceInputMethodText(e);
    }

    void inputMethodCaretPositionChanged(InputMethodEvent e) {
        this.getInputMethodRequests();
        this.myInputMethodRequestsHandler.setInputMethodCaretPosition(e);
    }

    InputMethodRequests getInputMethodRequests() {
        if (this.myInputMethodRequestsHandler == null) {
            this.myInputMethodRequestsHandler = new MyInputMethodHandler();
            this.myInputMethodRequestsSwingWrapper = new MyInputMethodHandleSwingThreadWrapper(this.myInputMethodRequestsHandler);
        }
        return this.myInputMethodRequestsSwingWrapper;
    }

    @Override
    public boolean processKeyTyped(KeyEvent e) {
        if (e.getID() != 400) {
            return false;
        }
        char c = e.getKeyChar();
        if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
            this.processKeyTyped(c);
            return true;
        }
        return false;
    }

    void beforeModalityStateChanged() {
        this.myScrollingModel.beforeModalityStateChanged();
    }

    public EditorDropHandler getDropHandler() {
        return this.myDropHandler;
    }

    public void setDropHandler(EditorDropHandler dropHandler) {
        this.myDropHandler = dropHandler;
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutterComponentEx editorGutterComponentEx = this.getGutterComponentEx();
        if (editorGutterComponentEx == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorImpl.getGutter must not return null");
        }
        return editorGutterComponentEx;
    }

    @Override
    public int calcColumnNumber(CharSequence text, int start, int offset, int tabSize) {
        IterationState state = new IterationState(this, start, false);
        int fontType = state.getMergedAttributes().getFontType();
        int column = 0;
        int x = 0;
        int spaceSize = EditorUtil.getSpaceWidth(fontType, this);
        for (int i = start; i < offset; ++i) {
            char c;
            if (i >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            if ((c = text.charAt(i)) == '\t') {
                int prevX = x;
                x = EditorUtil.nextTabStop(x, this);
                column += (x - prevX) / spaceSize;
                continue;
            }
            x += EditorUtil.charWidth(c, fontType, this);
            ++column;
        }
        return column;
    }

    public void putInfo(Map<String, String> info) {
        VisualPosition visual = this.getCaretModel().getVisualPosition();
        info.put("caret", visual.getLine() + ":" + visual.getColumn());
    }

    static {
        ourIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        ourCaretBlinkingCommand = new RepaintCursorCommand();
        ourCaretBlinkingCommand.start();
        FOLDING_TOOLTIP_GROUP = new TooltipGroup("FOLDING_TOOLTIP_GROUP", 10);
    }

    private class MyHeaderPanel
    extends JPanel {
        private int myOldHeight;

        private MyHeaderPanel() {
            super(new BorderLayout());
            this.myOldHeight = 0;
        }

        @Override
        public void revalidate() {
            this.myOldHeight = this.getHeight();
            super.revalidate();
        }

        @Override
        protected void validateTree() {
            int height = this.myOldHeight;
            super.validateTree();
            if ((height -= this.getHeight()) != 0) {
                EditorImpl.this.myVerticalScrollBar.setValue(EditorImpl.this.myVerticalScrollBar.getValue() - height);
            }
            this.myOldHeight = this.getHeight();
        }
    }

    private class MyScrollPane
    extends JScrollPane2 {
        private MyScrollPane() {
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            if (EditorImpl.this.mySettings.isWheelFontChangeEnabled()) {
                boolean changeFontSize;
                boolean bl = SystemInfo.isMac ? !e.isControlDown() && e.isMetaDown() && !e.isAltDown() && !e.isShiftDown() : (changeFontSize = e.isControlDown() && !e.isMetaDown() && !e.isAltDown() && !e.isShiftDown());
                if (changeFontSize) {
                    EditorImpl.this.setFontSize(EditorImpl.this.myScheme.getEditorFontSize() + e.getWheelRotation());
                    return;
                }
            }
            super.processMouseWheelEvent(e);
        }
    }

    private class EditorSizeContainer {
        private TIntArrayList myLineWidths;
        private volatile boolean myIsDirty;
        private int myOldEndLine;
        private Dimension mySize;
        private int myMaxWidth = -1;

        private EditorSizeContainer() {
        }

        public synchronized void reset() {
            int visLinesCount = EditorImpl.this.getVisibleLineCount();
            this.myLineWidths = new TIntArrayList(visLinesCount + 300);
            int[] values = new int[visLinesCount];
            Arrays.fill(values, -1);
            this.myLineWidths.add(values);
            this.myIsDirty = true;
        }

        public synchronized void beforeChange(DocumentEvent e) {
            if (EditorImpl.this.myDocument.isInBulkUpdate()) {
                this.myMaxWidth = this.mySize != null ? this.mySize.width : -1;
            }
            this.myOldEndLine = this.getVisualPositionLine(e.getOffset() + e.getOldLength());
        }

        private int getVisualPositionLine(int offset) {
            int startLineOffset = EditorImpl.this.myDocument.getLineStartOffset(EditorImpl.this.calcLogicalLineNumber(offset));
            return EditorImpl.this.offsetToVisualPosition((int)startLineOffset).line;
        }

        public synchronized void changedUpdate(DocumentEvent e) {
            int startLine = e.getOldLength() == 0 ? this.myOldEndLine : this.getVisualPositionLine(e.getOffset());
            int newEndLine = e.getNewLength() == 0 ? startLine : this.getVisualPositionLine(e.getOffset() + e.getNewLength());
            int oldEndLine = this.myOldEndLine;
            int lineWidthSize = this.myLineWidths.size();
            if (lineWidthSize == 0) {
                this.reset();
            } else {
                boolean toAddNewLines;
                int min = Math.min(oldEndLine, newEndLine);
                boolean bl = toAddNewLines = min >= lineWidthSize;
                if (toAddNewLines) {
                    int[] delta = new int[min - lineWidthSize + 1];
                    this.myLineWidths.insert(lineWidthSize, delta);
                }
                for (int i = startLine; i <= min; ++i) {
                    this.myLineWidths.set(i, -1);
                }
                if (newEndLine > oldEndLine) {
                    int[] delta = new int[newEndLine - oldEndLine];
                    Arrays.fill(delta, -1);
                    this.myLineWidths.insert(oldEndLine + 1, delta);
                } else if (oldEndLine > newEndLine && !toAddNewLines && newEndLine + 1 < lineWidthSize) {
                    this.myLineWidths.remove(newEndLine + 1, Math.min(oldEndLine, lineWidthSize) - newEndLine);
                }
                this.myIsDirty = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateSizes() {
            if (!this.myIsDirty) {
                return;
            }
            EditorSizeContainer editorSizeContainer = this;
            synchronized (editorSizeContainer) {
                if (!this.myIsDirty) {
                    return;
                }
                int lineCount = this.myLineWidths.size();
                if (this.myMaxWidth != -1 && EditorImpl.this.myDocument.isInBulkUpdate()) {
                    this.mySize = new Dimension(this.myMaxWidth, EditorImpl.this.getLineHeight() * lineCount);
                    this.myIsDirty = false;
                    return;
                }
                CharSequence text = EditorImpl.this.myDocument.getCharsNoThreadCheck();
                int end = EditorImpl.this.myDocument.getTextLength();
                int x = 0;
                int fontSize = EditorImpl.this.myScheme.getEditorFontSize();
                String fontName = EditorImpl.this.myScheme.getEditorFontName();
                block3: for (int line = 0; line < lineCount; ++line) {
                    if (this.myLineWidths.getQuick(line) != -1) continue;
                    x = 0;
                    int offset = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(line, 0)));
                    if (offset >= EditorImpl.this.myDocument.getTextLength()) {
                        this.myLineWidths.set(line, 0);
                        break;
                    }
                    IterationState state = new IterationState(EditorImpl.this, offset, false);
                    int fontType = state.getMergedAttributes().getFontType();
                    while (offset < end && line < lineCount) {
                        FoldRegion collapsed;
                        char c = text.charAt(offset);
                        if (offset >= state.getEndOffset()) {
                            state.advance();
                            fontType = state.getMergedAttributes().getFontType();
                        }
                        if ((collapsed = state.getCurrentFold()) != null) {
                            String placeholder = collapsed.getPlaceholderText();
                            for (int i = 0; i < placeholder.length(); ++i) {
                                x += EditorUtil.charWidth(placeholder.charAt(i), fontType, EditorImpl.this);
                            }
                            offset = collapsed.getEndOffset();
                            continue;
                        }
                        if (c == '\t') {
                            x = EditorUtil.nextTabStop(x, EditorImpl.this);
                            ++offset;
                            continue;
                        }
                        if (c == '\n') {
                            this.myLineWidths.set(line, x);
                            if (line + 1 >= lineCount || this.myLineWidths.getQuick(line + 1) != -1) continue block3;
                            ++offset;
                            x = 0;
                            ++line;
                            continue;
                        }
                        x += ComplementaryFontsRegistry.getFontAbleToDisplay(c, fontSize, fontType, fontName).charWidth(c, EditorImpl.this.myEditorComponent);
                        ++offset;
                    }
                }
                if (lineCount > 0) {
                    this.myLineWidths.set(lineCount - 1, x);
                }
                int maxWidth = 0;
                for (int i = 0; i < lineCount; ++i) {
                    maxWidth = Math.max(maxWidth, this.myLineWidths.getQuick(i));
                }
                this.mySize = new Dimension(maxWidth, EditorImpl.this.getLineHeight() * lineCount);
                this.myIsDirty = false;
            }
        }

        public Dimension getContentSize() {
            this.validateSizes();
            return this.mySize;
        }
    }

    class EditorDocumentAdapter
    implements PrioritizedDocumentListener {
        EditorDocumentAdapter() {
        }

        public void beforeDocumentChange(DocumentEvent e) {
            EditorImpl.this.beforeChangedUpdate(e);
        }

        public void documentChanged(DocumentEvent e) {
            EditorImpl.this.changedUpdate(e);
        }

        @Override
        public int getPriority() {
            return 5;
        }
    }

    private static class MyTransferHandler
    extends TransferHandler {
        private RangeMarker myDraggedRange = null;

        private MyTransferHandler() {
        }

        private static Editor getEditor(JComponent comp) {
            EditorComponentImpl editorComponent = (EditorComponentImpl)comp;
            return editorComponent.getEditor();
        }

        @Override
        public boolean importData(JComponent comp, final Transferable t) {
            final EditorImpl editor = (EditorImpl)MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = editor.getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                dropHandler.handleDrop(t, editor.getProject());
                return true;
            }
            final int caretOffset = editor.getCaretModel().getOffset();
            if (this.myDraggedRange != null && this.myDraggedRange.getStartOffset() <= caretOffset && caretOffset < this.myDraggedRange.getEndOffset()) {
                return false;
            }
            if (this.myDraggedRange != null) {
                editor.getCaretModel().moveToOffset(editor.mySavedCaretOffsetForDNDUndoHack);
            }
            CommandProcessor.getInstance().executeCommand(editor.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int offset;
                                editor.getSelectionModel().removeSelection();
                                if (MyTransferHandler.this.myDraggedRange != null) {
                                    editor.getCaretModel().moveToOffset(caretOffset);
                                    offset = caretOffset;
                                } else {
                                    offset = editor.getCaretModel().getOffset();
                                }
                                if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                                    return;
                                }
                                EditorActionHandler pasteHandler = EditorActionManager.getInstance().getActionHandler("EditorPaste");
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                Transferable backup = null;
                                try {
                                    backup = clipboard.getContents(this);
                                    clipboard.setContents(t, (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
                                }
                                catch (Exception e) {
                                    LOG.info("Error communicating with system clipboard", (Throwable)e);
                                }
                                editor.putUserData(EditorEx.LAST_PASTED_REGION, null);
                                pasteHandler.execute((Editor)editor, editor.getDataContext());
                                try {
                                    if (backup != null) {
                                        clipboard.setContents(backup, (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
                                    }
                                }
                                catch (IllegalStateException e) {
                                    LOG.info((Throwable)e);
                                }
                                TextRange range = (TextRange)editor.getUserData(EditorEx.LAST_PASTED_REGION);
                                if (range != null) {
                                    editor.getCaretModel().moveToOffset(range.getStartOffset());
                                    editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                                }
                            }
                            catch (Exception exception) {
                                LOG.error((Throwable)exception);
                            }
                        }
                    });
                }
            }, EditorBundle.message((String)"paste.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, editor.getDocument());
            return true;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            Editor editor = MyTransferHandler.getEditor(comp);
            EditorDropHandler dropHandler = ((EditorImpl)editor).getDropHandler();
            if (dropHandler != null && dropHandler.canHandleDrop(transferFlavors)) {
                return true;
            }
            if (editor.isViewer()) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            if (editor.getDocument().getRangeGuard(offset, offset) != null) {
                return false;
            }
            for (DataFlavor transferFlavor : transferFlavors) {
                if (!transferFlavor.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            Editor editor = MyTransferHandler.getEditor(c);
            String s = editor.getSelectionModel().getSelectedText();
            if (s == null) {
                return null;
            }
            int selectionStart = editor.getSelectionModel().getSelectionStart();
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            this.myDraggedRange = editor.getDocument().createRangeMarker(selectionStart, selectionEnd);
            return new StringSelection(s);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (data == null) {
                return;
            }
            Component last = DnDManager.getInstance().getLastDropHandler();
            if (last != null && !(last instanceof EditorComponentImpl)) {
                return;
            }
            final Editor editor = MyTransferHandler.getEditor(source);
            if (action == 2 && !editor.isViewer()) {
                if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), editor.getProject())) {
                    return;
                }
                CommandProcessor.getInstance().executeCommand(((EditorImpl)editor).myProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Document doc = editor.getDocument();
                                doc.startGuardedBlockChecking();
                                try {
                                    doc.deleteString(MyTransferHandler.this.myDraggedRange.getStartOffset(), MyTransferHandler.this.myDraggedRange.getEndOffset());
                                }
                                catch (ReadOnlyFragmentModificationException e) {
                                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                                }
                                finally {
                                    doc.stopGuardedBlockChecking();
                                }
                            }
                        });
                    }
                }, EditorBundle.message((String)"move.selection.command.name", (Object[])new Object[0]), (Object)DND_COMMAND_KEY, UndoConfirmationPolicy.DEFAULT, editor.getDocument());
            }
            this.myDraggedRange = null;
        }
    }

    private class MyColorSchemeDelegate
    implements EditorColorsScheme {
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private int myFontSize = -1;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;

        private MyColorSchemeDelegate() {
            this.updateGlobalScheme();
        }

        private EditorColorsScheme getGlobal() {
            return this.myGlobalScheme;
        }

        public String getName() {
            return this.getGlobal().getName();
        }

        protected void initFonts() {
            String editorFontName = this.getEditorFontName();
            int editorFontSize = this.getEditorFontSize();
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(editorFontName, 0, editorFontSize);
            Font boldFont = new Font(editorFontName, 1, editorFontSize);
            Font italicFont = new Font(editorFontName, 2, editorFontSize);
            Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
            EditorImpl.this.reinitSettings();
        }

        public void setName(String name) {
            this.getGlobal().setName(name);
        }

        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey((Object)key)) {
                return (TextAttributes)this.myOwnAttributes.get((Object)key);
            }
            return this.getGlobal().getAttributes(key);
        }

        public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
            this.myOwnAttributes.put((Object)key, (Object)attributes);
        }

        public Color getDefaultBackground() {
            return this.getGlobal().getDefaultBackground();
        }

        public Color getDefaultForeground() {
            return this.getGlobal().getDefaultForeground();
        }

        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey((Object)key)) {
                return (Color)this.myOwnColors.get((Object)key);
            }
            return this.getGlobal().getColor(key);
        }

        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put((Object)key, (Object)color);
            EditorImpl.this.myCaretModel.reinitSettings();
            EditorImpl.this.mySelectionModel.reinitSettings();
        }

        public int getEditorFontSize() {
            if (this.myFontSize == -1) {
                return this.getGlobal().getEditorFontSize();
            }
            return this.myFontSize;
        }

        public void setEditorFontSize(int fontSize) {
            if (fontSize < 8) {
                fontSize = 8;
            }
            if (fontSize > 20) {
                fontSize = 20;
            }
            this.myFontSize = fontSize;
            this.initFonts();
        }

        public String getEditorFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getEditorFontName();
            }
            return this.myFaceName;
        }

        public void setEditorFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                return font;
            }
            return this.getGlobal().getFont(key);
        }

        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key, font);
            EditorImpl.this.reinitSettings();
        }

        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        public Object clone() {
            return null;
        }

        public void readExternal(Element element) throws InvalidDataException {
        }

        public void writeExternal(Element element) throws WriteExternalException {
        }

        public void updateGlobalScheme() {
            this.myGlobalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            EditorImpl.this.validateMousePointer(e);
            EditorImpl.this.runMouseDraggedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseDragged(e);
            }
            for (EditorMouseMotionListener listener : EditorImpl.this.myMouseMotionListeners) {
                listener.mouseDragged(event);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            EditorImpl.this.validateMousePointer(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                EditorImpl.this.myGutterComponent.mouseMoved(e);
            }
            if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                FoldRegion fold = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(e.getPoint());
                TooltipController controller = TooltipController.getInstance();
                if (fold != null) {
                    DocumentFragment range = this.createDocumentFragment(fold);
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), EditorImpl.this.getComponent().getRootPane().getLayeredPane());
                    controller.showTooltip((Editor)EditorImpl.this, p, new DocumentFragmentTooltipRenderer(range), false, FOLDING_TOOLTIP_GROUP);
                } else {
                    controller.cancelTooltip(FOLDING_TOOLTIP_GROUP);
                }
            }
            for (EditorMouseMotionListener listener : EditorImpl.this.myMouseMotionListeners) {
                listener.mouseMoved(event);
            }
        }

        private DocumentFragment createDocumentFragment(FoldRegion fold) {
            FoldingGroup group = fold.getGroup();
            int foldStart = fold.getStartOffset();
            if (group != null) {
                int endOffset = EditorImpl.this.myFoldingModel.getEndOffset(group);
                if (EditorImpl.this.offsetToVisualPosition((int)endOffset).line == EditorImpl.this.offsetToVisualPosition((int)foldStart).line) {
                    return new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, endOffset);
                }
            }
            int oldEnd = fold.getEndOffset();
            return new DocumentFragment((Document)EditorImpl.this.myDocument, foldStart, oldEnd);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            EditorImpl.this.requestFocus();
            this.runMousePressedCommand(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.runMouseReleasedCommand(e);
            if (!e.isConsumed() && EditorImpl.this.myMousePressedEvent != null && !EditorImpl.this.myMousePressedEvent.isConsumed() && Math.abs(e.getX() - EditorImpl.this.myMousePressedEvent.getX()) < EditorUtil.getSpaceWidth(0, EditorImpl.this) && Math.abs(e.getY() - EditorImpl.this.myMousePressedEvent.getY()) < EditorImpl.this.getLineHeight()) {
                this.runMouseClickedCommand(e);
            }
            EditorImpl.this.myMousePressedEvent = null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.runMouseEnteredCommand(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.runMouseExitedCommand(e);
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            if (event.getArea() == EditorMouseEventArea.LINE_MARKERS_AREA) {
                EditorImpl.this.myGutterComponent.mouseExited(e);
            }
            TooltipController.getInstance().cancelTooltip(FOLDING_TOOLTIP_GROUP);
        }

        private void runMousePressedCommand(final MouseEvent e) {
            EditorImpl.this.myMousePressedEvent = e;
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener mouseListener : EditorImpl.this.myMouseListeners) {
                mouseListener.mousePressed(event);
            }
            if (event.isConsumed() && !event.getMouseEvent().isPopupTrigger() && event.getArea() != EditorMouseEventArea.EDITING_AREA) {
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MyMouseAdapter.this.processMousePressed(e);
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorImpl.this.getDocument());
            } else {
                this.processMousePressed(e);
            }
        }

        private void runMouseClickedCommand(MouseEvent e) {
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseClicked(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseReleasedCommand(final MouseEvent e) {
            EditorImpl.this.myScrollingTimer.stop();
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseReleased(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
            if (EditorImpl.this.myCommandProcessor != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.processMouseReleased(e);
                    }
                };
                EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, runnable, "", (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorImpl.this.getDocument());
            } else {
                EditorImpl.this.processMouseReleased(e);
            }
        }

        private void runMouseEnteredCommand(MouseEvent e) {
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseEntered(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void runMouseExitedCommand(MouseEvent e) {
            EditorMouseEvent event = new EditorMouseEvent((Editor)EditorImpl.this, e, EditorImpl.this.getMouseEventArea(e));
            for (EditorMouseListener listener : EditorImpl.this.myMouseListeners) {
                listener.mouseExited(event);
                if (!event.isConsumed()) continue;
                e.consume();
                return;
            }
        }

        private void processMousePressed(MouseEvent e) {
            FoldRegion range;
            EditorMouseEventArea eventArea;
            EditorImpl.this.myInitialMouseEvent = e;
            if (EditorImpl.this.myMouseSelectionState != 0 && System.currentTimeMillis() - EditorImpl.this.myMouseSelectionChangeTimestamp > 1000L) {
                EditorImpl.this.setMouseSelectionState(0);
            }
            int x = e.getX();
            int y = e.getY();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if ((eventArea = EditorImpl.this.getMouseEventArea(e)) == EditorMouseEventArea.FOLDING_OUTLINE_AREA && (range = EditorImpl.this.myGutterComponent.findFoldingAnchorAt(x, y)) != null) {
                final boolean expansion = !range.isExpanded();
                int scrollShift = y - EditorImpl.this.getScrollingModel().getVerticalScrollOffset();
                Runnable processor = new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.myFoldingModel.flushCaretShift();
                        range.setExpanded(expansion);
                    }
                };
                EditorImpl.this.getFoldingModel().runBatchFoldingOperation(processor);
                y = EditorImpl.this.myGutterComponent.getHeadCenterY(range);
                EditorImpl.this.getScrollingModel().scrollVertically(y - scrollShift);
                return;
            }
            if (e.getSource() == EditorImpl.this.myGutterComponent) {
                if (eventArea == EditorMouseEventArea.LINE_MARKERS_AREA || eventArea == EditorMouseEventArea.ANNOTATIONS_AREA || eventArea == EditorMouseEventArea.LINE_NUMBERS_AREA) {
                    EditorImpl.this.myGutterComponent.mousePressed(e);
                    if (e.isConsumed()) {
                        return;
                    }
                }
                x = 0;
            }
            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
            EditorImpl.this.moveCaretToScreenPos(x, y);
            if (e.isPopupTrigger()) {
                return;
            }
            EditorImpl.this.requestFocus();
            int caretOffset = EditorImpl.this.getCaretModel().getOffset();
            EditorImpl.this.myMouseSelectedRegion = EditorImpl.this.myFoldingModel.getFoldingPlaceholderAt(new Point(x, y));
            EditorImpl.this.myMousePressedInsideSelection = EditorImpl.this.mySelectionModel.hasSelection() && caretOffset >= EditorImpl.this.mySelectionModel.getSelectionStart() && caretOffset <= EditorImpl.this.mySelectionModel.getSelectionEnd();
            if (!EditorImpl.this.myMousePressedInsideSelection && EditorImpl.this.mySelectionModel.hasBlockSelection()) {
                int[] starts = EditorImpl.this.mySelectionModel.getBlockSelectionStarts();
                int[] ends = EditorImpl.this.mySelectionModel.getBlockSelectionEnds();
                for (int i = 0; i < starts.length; ++i) {
                    if (caretOffset < starts[i] || caretOffset >= ends[i]) continue;
                    EditorImpl.this.myMousePressedInsideSelection = true;
                    break;
                }
            }
            if (EditorImpl.this.getMouseEventArea(e) == EditorMouseEventArea.LINE_NUMBERS_AREA && e.getClickCount() == 1) {
                EditorImpl.this.mySelectionModel.selectLineAtCaret();
                EditorImpl.this.setMouseSelectionState(2);
                EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                return;
            }
            if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown()) {
                if (EditorImpl.this.getMouseSelectionState() != 0) {
                    if (caretOffset < EditorImpl.this.mySavedSelectionStart) {
                        EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionEnd, caretOffset);
                    } else {
                        EditorImpl.this.mySelectionModel.setSelection(EditorImpl.this.mySavedSelectionStart, caretOffset);
                    }
                } else {
                    EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, caretOffset);
                }
            } else if (!EditorImpl.this.myMousePressedInsideSelection && (EditorImpl.this.getSelectionModel().hasSelection() || EditorImpl.this.getSelectionModel().hasBlockSelection())) {
                EditorImpl.this.setMouseSelectionState(0);
                EditorImpl.this.mySelectionModel.setSelection(caretOffset, caretOffset);
            } else if (!e.isPopupTrigger()) {
                switch (e.getClickCount()) {
                    case 2: {
                        EditorImpl.this.mySelectionModel.selectWordAtCaret(EditorImpl.this.mySettings.isMouseClickSelectionHonorsCamelWords());
                        EditorImpl.this.setMouseSelectionState(1);
                        EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                        EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                        EditorImpl.this.getCaretModel().moveToOffset(EditorImpl.this.mySavedSelectionEnd);
                        break;
                    }
                    case 3: {
                        EditorImpl.this.mySelectionModel.selectLineAtCaret();
                        EditorImpl.this.setMouseSelectionState(2);
                        EditorImpl.this.mySavedSelectionStart = EditorImpl.this.mySelectionModel.getSelectionStart();
                        EditorImpl.this.mySavedSelectionEnd = EditorImpl.this.mySelectionModel.getSelectionEnd();
                    }
                }
            }
        }
    }

    private class MyInputMethodHandler
    implements InputMethodRequests {
        private String composedText;
        private int composedTextStart;
        private int composedTextEnd;

        private MyInputMethodHandler() {
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            Point caret = EditorImpl.this.logicalPositionToXY(EditorImpl.this.getCaretModel().getLogicalPosition());
            Rectangle r = new Rectangle(caret, new Dimension(1, EditorImpl.this.getLineHeight()));
            Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            if (this.composedText != null) {
                Point p = EditorImpl.this.getContentComponent().getLocationOnScreen();
                p.x = x - p.x;
                p.y = y - p.y;
                int pos = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.xyToLogicalPosition(p));
                if (pos >= this.composedTextStart && pos <= this.composedTextEnd) {
                    return TextHitInfo.leading(pos - this.composedTextStart);
                }
            }
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            int caretIndex;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextStart;
                composedEndIndex = this.composedTextEnd;
            }
            if ((caretIndex = EditorImpl.this.getCaretModel().getOffset()) < composedStartIndex) {
                return caretIndex;
            }
            if (caretIndex < composedEndIndex) {
                return composedStartIndex;
            }
            return caretIndex - (composedEndIndex - composedStartIndex);
        }

        private String getText(int startIdx, int endIdx) {
            CharSequence chars = EditorImpl.this.getDocument().getCharsSequence();
            return ((Object)chars.subSequence(startIdx, endIdx)).toString();
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            String committed;
            int composedStartIndex = 0;
            int composedEndIndex = 0;
            if (this.composedText != null) {
                composedStartIndex = this.composedTextStart;
                composedEndIndex = this.composedTextEnd;
            }
            if (beginIndex < composedStartIndex) {
                if (endIndex <= composedStartIndex) {
                    committed = this.getText(beginIndex, endIndex - beginIndex);
                } else {
                    int firstPartLength = composedStartIndex - beginIndex;
                    committed = this.getText(beginIndex, firstPartLength) + this.getText(composedEndIndex, endIndex - beginIndex - firstPartLength);
                }
            } else {
                committed = this.getText(beginIndex + (composedEndIndex - composedStartIndex), endIndex - beginIndex);
            }
            return new AttributedString(committed).getIterator();
        }

        @Override
        public int getCommittedTextLength() {
            int length = EditorImpl.this.getDocument().getTextLength();
            if (this.composedText != null) {
                length -= this.composedText.length();
            }
            return length;
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            String text = EditorImpl.this.getSelectionModel().getSelectedText();
            return text == null ? null : new AttributedString(text).getIterator();
        }

        private void createComposedString(int composedIndex, AttributedCharacterIterator text) {
            StringBuffer strBuf = new StringBuffer();
            char c = text.setIndex(composedIndex);
            while (c != '\uffff') {
                strBuf.append(c);
                c = text.next();
            }
            this.composedText = new String(strBuf);
        }

        private void setInputMethodCaretPosition(InputMethodEvent e) {
            if (this.composedText != null) {
                int dot = this.composedTextStart;
                TextHitInfo caretPos = e.getCaret();
                if (caretPos != null) {
                    dot += caretPos.getInsertionIndex();
                }
                EditorImpl.this.getCaretModel().moveToOffset(dot);
                EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private void runUndoTransparent(final Runnable runnable) {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(EditorImpl.this.myProject, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(runnable);
                        }
                    }, "", (Object)EditorImpl.this.getDocument(), UndoConfirmationPolicy.DEFAULT, EditorImpl.this.getDocument());
                }
            });
        }

        private void replaceInputMethodText(InputMethodEvent e) {
            int commitCount = e.getCommittedCharacterCount();
            AttributedCharacterIterator text = e.getText();
            final Document doc = EditorImpl.this.getDocument();
            if (this.composedText != null) {
                if (!EditorImpl.this.isViewer() && doc.isWritable()) {
                    this.runUndoTransparent(new Runnable(){

                        @Override
                        public void run() {
                            doc.deleteString(Math.max(0, MyInputMethodHandler.this.composedTextStart), Math.min(MyInputMethodHandler.this.composedTextEnd, doc.getTextLength()));
                        }
                    });
                }
                this.composedText = null;
            }
            if (text != null) {
                int composedTextIndex;
                text.first();
                if (commitCount > 0) {
                    char c = text.current();
                    while (commitCount > 0) {
                        if (c >= ' ' && c != '\u007f') {
                            EditorImpl.this.processKeyTyped(c);
                        }
                        c = text.next();
                        --commitCount;
                    }
                }
                if (!EditorImpl.this.isViewer() && doc.isWritable() && (composedTextIndex = text.getIndex()) < text.getEndIndex()) {
                    this.createComposedString(composedTextIndex, text);
                    this.runUndoTransparent(new Runnable(){

                        @Override
                        public void run() {
                            EditorModificationUtil.insertStringAtCaret((Editor)EditorImpl.this, (String)MyInputMethodHandler.this.composedText, (boolean)false, (boolean)false);
                        }
                    });
                    this.composedTextStart = EditorImpl.this.getCaretModel().getOffset();
                    this.composedTextEnd = EditorImpl.this.getCaretModel().getOffset() + this.composedText.length();
                }
            }
        }
    }

    private static class MyInputMethodHandleSwingThreadWrapper
    implements InputMethodRequests {
        private final InputMethodRequests myDelegate;

        private MyInputMethodHandleSwingThreadWrapper(InputMethodRequests delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Rectangle getTextLocation(final TextHitInfo offset) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getTextLocation(offset);
            }
            final Rectangle[] r = new Rectangle[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getTextLocation(offset);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }

        @Override
        public TextHitInfo getLocationOffset(final int x, final int y) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getLocationOffset(x, y);
            }
            final TextHitInfo[] r = new TextHitInfo[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getLocationOffset(x, y);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }

        @Override
        public int getInsertPositionOffset() {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getInsertPositionOffset();
            }
            final int[] r = new int[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getInsertPositionOffset();
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }

        @Override
        public AttributedCharacterIterator getCommittedText(final int beginIndex, final int endIndex, final AttributedCharacterIterator.Attribute[] attributes) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getCommittedText(beginIndex, endIndex, attributes);
            }
            final AttributedCharacterIterator[] r = new AttributedCharacterIterator[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getCommittedText(beginIndex, endIndex, attributes);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }

        @Override
        public int getCommittedTextLength() {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getCommittedTextLength();
            }
            final int[] r = new int[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getCommittedTextLength();
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(final AttributedCharacterIterator.Attribute[] attributes) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return this.myDelegate.getSelectedText(attributes);
            }
            final AttributedCharacterIterator[] r = new AttributedCharacterIterator[1];
            try {
                GuiUtils.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        r[0] = MyInputMethodHandleSwingThreadWrapper.this.myDelegate.getSelectedText(attributes);
                    }
                });
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
            return r[0];
        }
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider,
    DeleteProvider {
        private MyEditable() {
        }

        public void performCopy(DataContext dataContext) {
            this.executeAction("EditorCopy", dataContext);
        }

        public boolean isCopyEnabled(DataContext dataContext) {
            return true;
        }

        public boolean isCopyVisible(DataContext dataContext) {
            return EditorImpl.this.getSelectionModel().hasSelection() || EditorImpl.this.getSelectionModel().hasBlockSelection();
        }

        public void performCut(DataContext dataContext) {
            this.executeAction("EditorCut", dataContext);
        }

        public boolean isCutEnabled(DataContext dataContext) {
            return !EditorImpl.this.isViewer() && EditorImpl.this.getDocument().isWritable();
        }

        public boolean isCutVisible(DataContext dataContext) {
            return EditorImpl.this.getSelectionModel().hasSelection() || EditorImpl.this.getSelectionModel().hasBlockSelection();
        }

        public void performPaste(DataContext dataContext) {
            this.executeAction("EditorPaste", dataContext);
        }

        public boolean isPastePossible(DataContext dataContext) {
            return !EditorImpl.this.isViewer() && EditorImpl.this.getDocument().isWritable();
        }

        public boolean isPasteEnabled(DataContext dataContext) {
            return !EditorImpl.this.isViewer() && EditorImpl.this.getDocument().isWritable();
        }

        public void deleteElement(DataContext dataContext) {
            this.executeAction("EditorDelete", dataContext);
        }

        public boolean canDeleteElement(DataContext dataContext) {
            return !EditorImpl.this.isViewer() && EditorImpl.this.getDocument().isWritable();
        }

        private void executeAction(String actionId, DataContext dataContext) {
            EditorAction action = (EditorAction)ActionManager.getInstance().getAction(actionId);
            if (action != null) {
                action.actionPerformed((Editor)EditorImpl.this, dataContext);
            }
        }
    }

    class MyScrollBar
    extends JScrollBar {
        @NonNls
        private static final String DECR_BUTTON_FIELD = "decrButton";
        @NonNls
        private static final String INCR_BUTTON_FIELD = "incrButton";
        @NonNls
        private static final String APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS = "apple.laf.AquaScrollBarUI";

        private MyScrollBar(int orientation) {
            super(orientation);
            this.setFocusable(false);
            this.putClientProperty("JScrollBar.fastWheelScrolling", Boolean.TRUE);
        }

        int getDecScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    Field decrButtonField = BasicScrollBarUI.class.getDeclaredField(DECR_BUTTON_FIELD);
                    decrButtonField.setAccessible(true);
                    JButton decrButtonValue = (JButton)decrButtonField.get(barUI);
                    LOG.assertTrue(decrButtonValue != null);
                    return insets.top + decrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc.getMessage());
                }
            }
            return insets.top + 15;
        }

        int getIncScrollButtonHeight() {
            ScrollBarUI barUI = this.getUI();
            Insets insets = this.getInsets();
            if (barUI instanceof BasicScrollBarUI) {
                try {
                    Field incrButtonField = BasicScrollBarUI.class.getDeclaredField(INCR_BUTTON_FIELD);
                    incrButtonField.setAccessible(true);
                    JButton incrButtonValue = (JButton)incrButtonField.get(barUI);
                    LOG.assertTrue(incrButtonValue != null);
                    return insets.bottom + incrButtonValue.getHeight();
                }
                catch (Exception exc) {
                    throw new IllegalStateException(exc.getMessage());
                }
            }
            if (APPLE_LAF_AQUA_SCROLL_BAR_UI_CLASS.equals(barUI.getClass().getName())) {
                return insets.bottom + 30;
            }
            return insets.bottom + 15;
        }

        @Override
        public int getUnitIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableUnitIncrement(vr, 1, direction);
        }

        @Override
        public int getBlockIncrement(int direction) {
            JViewport vp = EditorImpl.this.myScrollPane.getViewport();
            Rectangle vr = vp.getViewRect();
            return EditorImpl.this.myEditorComponent.getScrollableBlockIncrement(vr, 1, direction);
        }
    }

    private class ScrollingTimer {
        Timer myTimer;
        private static final int TIMER_PERIOD = 100;
        private static final int CYCLE_SIZE = 20;
        private int myXCycles;
        private int myYCycles;
        private int myDx;
        private int myDy;
        private int xPassedCycles = 0;
        private int yPassedCycles = 0;

        private ScrollingTimer() {
        }

        private void start(int dx, int dy) {
            this.myDx = 0;
            this.myDy = 0;
            if (dx > 0) {
                this.myXCycles = 20 / dx + 1;
                this.myDx = 1 + dx / 20;
            } else if (dx < 0) {
                this.myXCycles = -20 / dx + 1;
                this.myDx = -1 + dx / 20;
            }
            if (dy > 0) {
                this.myYCycles = 20 / dy + 1;
                this.myDy = 1 + dy / 20;
            } else if (dy < 0) {
                this.myYCycles = -20 / dy + 1;
                this.myDy = -1 + dy / 20;
            }
            if (this.myTimer != null) {
                return;
            }
            this.myTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorImpl.this.myCommandProcessor.executeCommand(EditorImpl.this.myProject, (Runnable)new DocumentRunnable(EditorImpl.this.myDocument, EditorImpl.this.myProject){

                        public void run() {
                            int oldSelectionStart = EditorImpl.this.mySelectionModel.getLeadSelectionOffset();
                            LogicalPosition caretPosition = EditorImpl.this.getCaretModel().getLogicalPosition();
                            int columnNumber = caretPosition.column;
                            ScrollingTimer.this.xPassedCycles++;
                            if (ScrollingTimer.this.xPassedCycles >= ScrollingTimer.this.myXCycles) {
                                ScrollingTimer.this.xPassedCycles = 0;
                                columnNumber += ScrollingTimer.this.myDx;
                            }
                            int lineNumber = caretPosition.line;
                            ScrollingTimer.this.yPassedCycles++;
                            if (ScrollingTimer.this.yPassedCycles >= ScrollingTimer.this.myYCycles) {
                                ScrollingTimer.this.yPassedCycles = 0;
                                lineNumber += ScrollingTimer.this.myDy;
                            }
                            LogicalPosition pos = new LogicalPosition(lineNumber, columnNumber);
                            EditorImpl.this.getCaretModel().moveToLogicalPosition(pos);
                            EditorImpl.this.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                            int newCaretOffset = EditorImpl.this.getCaretModel().getOffset();
                            int caretShift = newCaretOffset - EditorImpl.this.mySavedSelectionStart;
                            if (EditorImpl.this.getMouseSelectionState() != 0) {
                                if (caretShift < 0) {
                                    int newSelection = newCaretOffset;
                                    if (EditorImpl.this.getMouseSelectionState() == 1) {
                                        newSelection = EditorImpl.this.mySelectionModel.getWordAtCaretStart();
                                    } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                        newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line, 0)));
                                    }
                                    if (newSelection < 0) {
                                        newSelection = newCaretOffset;
                                    }
                                    EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionEnd), newSelection);
                                    EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                                } else {
                                    int newSelection = newCaretOffset;
                                    if (EditorImpl.this.getMouseSelectionState() == 1) {
                                        newSelection = EditorImpl.this.mySelectionModel.getWordAtCaretEnd();
                                    } else if (EditorImpl.this.getMouseSelectionState() == 2) {
                                        newSelection = EditorImpl.this.logicalPositionToOffset(EditorImpl.this.visualToLogicalPosition(new VisualPosition(EditorImpl.this.getCaretModel().getVisualPosition().line + 1, 0)));
                                    }
                                    if (newSelection < 0) {
                                        newSelection = newCaretOffset;
                                    }
                                    EditorImpl.this.mySelectionModel.setSelection(ScrollingTimer.this.validateOffset(EditorImpl.this.mySavedSelectionStart), newSelection);
                                    EditorImpl.this.getCaretModel().moveToOffset(newSelection);
                                }
                                return;
                            }
                            if (EditorImpl.this.mySelectionModel.hasBlockSelection()) {
                                EditorImpl.this.mySelectionModel.setBlockSelection(EditorImpl.this.mySelectionModel.getBlockStart(), EditorImpl.this.getCaretModel().getLogicalPosition());
                            } else {
                                EditorImpl.this.mySelectionModel.setSelection(oldSelectionStart, EditorImpl.this.getCaretModel().getOffset());
                            }
                        }
                    }, EditorBundle.message((String)"move.cursor.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorImpl.this.getDocument());
                }
            });
            this.myTimer.start();
        }

        private void stop() {
            if (this.myTimer != null) {
                this.myTimer.stop();
                this.myTimer = null;
            }
        }

        private int validateOffset(int offset) {
            if (offset < 0) {
                return 0;
            }
            if (offset > EditorImpl.this.myDocument.getTextLength()) {
                return EditorImpl.this.myDocument.getTextLength();
            }
            return offset;
        }
    }

    private class CaretCursor {
        private Point myLocation = new Point(0, 0);
        private int myWidth;
        private boolean myEnabled;
        private boolean myIsShown = false;
        private long myStartTime = 0L;

        private CaretCursor() {
            this.setEnabled(true);
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            boolean blink = EditorImpl.this.mySettings.isBlinkCaret();
            int blinkPeriod = EditorImpl.this.mySettings.getCaretBlinkPeriod();
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                ourCaretBlinkingCommand.myEditor = EditorImpl.this;
                ourCaretBlinkingCommand.setBlinkCaret(blink);
                ourCaretBlinkingCommand.setBlinkPeriod(blinkPeriod);
                this.myIsShown = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                return this.myIsShown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void passivate() {
            RepaintCursorCommand repaintCursorCommand = ourCaretBlinkingCommand;
            synchronized (repaintCursorCommand) {
                this.myIsShown = false;
            }
        }

        private void setPosition(Point location, int width) {
            this.myStartTime = System.currentTimeMillis();
            this.myLocation = location;
            this.myWidth = Math.max(width, 2);
            this.myIsShown = true;
            this.repaint();
        }

        private void repaint() {
            EditorImpl.this.myEditorComponent.repaintEditorComponent(this.myLocation.x, this.myLocation.y, this.myWidth, EditorImpl.this.getLineHeight());
        }

        private void paint(Graphics g) {
            if (!this.isEnabled() || !this.myIsShown || !IJSwingUtilities.hasFocus(EditorImpl.this.getContentComponent()) || EditorImpl.this.isRendererMode()) {
                return;
            }
            int x = this.myLocation.x;
            int lineHeight = EditorImpl.this.getLineHeight();
            int y = this.myLocation.y;
            Rectangle viewRect = EditorImpl.this.getScrollingModel().getVisibleArea();
            if (x - viewRect.x < 0) {
                return;
            }
            g.setColor(EditorImpl.this.myScheme.getColor(EditorColors.CARET_COLOR));
            if (EditorImpl.this.myIsInsertMode != EditorImpl.this.mySettings.isBlockCursor()) {
                for (int i = 0; i < EditorImpl.this.mySettings.getLineCursorWidth(); ++i) {
                    UIUtil.drawLine((Graphics)g, (int)(x + i), (int)y, (int)(x + i), (int)(y + lineHeight - 1));
                }
            } else {
                Color background = EditorImpl.this.myScheme.getColor(EditorColors.CARET_ROW_COLOR);
                if (background == null) {
                    background = EditorImpl.this.getBackroundColor();
                }
                g.setXORMode(background);
                g.fillRect(x, y, this.myWidth, lineHeight - 1);
                g.setPaintMode();
            }
        }
    }

    private static class RepaintCursorCommand
    implements Runnable {
        private long mySleepTime = 500L;
        private boolean myIsBlinkCaret = true;
        private EditorImpl myEditor = null;
        private final MyRepaintRunnable myRepaintRunnable = new MyRepaintRunnable();
        private ScheduledFuture<?> mySchedulerHandle;

        private RepaintCursorCommand() {
        }

        public void start() {
            if (this.mySchedulerHandle != null) {
                this.mySchedulerHandle.cancel(false);
            }
            this.mySchedulerHandle = JobScheduler.getScheduler().scheduleAtFixedRate(this, this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        }

        private void setBlinkPeriod(int blinkPeriod) {
            this.mySleepTime = blinkPeriod > 10 ? (long)blinkPeriod : 10L;
            this.start();
        }

        private void setBlinkCaret(boolean value) {
            this.myIsBlinkCaret = value;
        }

        @Override
        public void run() {
            if (this.myEditor != null) {
                CaretCursor activeCursor = this.myEditor.myCaretCursor;
                long time = System.currentTimeMillis();
                if ((time -= activeCursor.myStartTime) > this.mySleepTime) {
                    boolean toRepaint = true;
                    if (this.myIsBlinkCaret) {
                        activeCursor.myIsShown = !activeCursor.myIsShown;
                    } else {
                        toRepaint = !activeCursor.myIsShown;
                        activeCursor.myIsShown = true;
                    }
                    if (toRepaint) {
                        SwingUtilities.invokeLater(this.myRepaintRunnable);
                    }
                }
            }
        }

        private class MyRepaintRunnable
        implements Runnable {
            private MyRepaintRunnable() {
            }

            @Override
            public void run() {
                if (RepaintCursorCommand.this.myEditor != null) {
                    RepaintCursorCommand.this.myEditor.myCaretCursor.repaint();
                }
            }
        }
    }

    private class CachedFontContent {
        final char[][] data = new char[300][];
        final int[] starts = new int[300];
        final int[] ends = new int[300];
        final int[] x = new int[300];
        final int[] y = new int[300];
        final Color[] color = new Color[300];
        int myCount = 0;
        final FontInfo myFontType;
        private char[] myLastData;

        private CachedFontContent(FontInfo fontInfo) {
            this.myFontType = fontInfo;
        }

        private void flushContent(Graphics g) {
            if (this.myCount != 0) {
                if (EditorImpl.this.myCurrentFontType != this.myFontType) {
                    EditorImpl.this.myCurrentFontType = this.myFontType;
                    g.setFont(this.myFontType.getFont());
                }
                Color currentColor = null;
                for (int i = 0; i < this.myCount; ++i) {
                    if (!Comparing.equal((Object)this.color[i], currentColor)) {
                        currentColor = this.color[i];
                        g.setColor(currentColor != null ? currentColor : Color.black);
                    }
                    EditorImpl.this.drawChars(g, this.data[i], this.starts[i], this.ends[i], this.x[i], this.y[i]);
                    this.color[i] = null;
                    this.data[i] = null;
                }
                this.myCount = 0;
                this.myLastData = null;
            }
        }

        private void addContent(Graphics g, char[] _data, int _start, int _end, int _x, int _y, Color _color) {
            int count = this.myCount;
            if (count > 0) {
                int lastCount = count - 1;
                Color lastColor = this.color[lastCount];
                if (_data == this.myLastData && _start == this.ends[lastCount] && (_color == null || lastColor == null || _color == lastColor)) {
                    this.ends[lastCount] = _end;
                    if (lastColor == null) {
                        this.color[lastCount] = _color;
                    }
                    return;
                }
            }
            this.myLastData = _data;
            this.data[count] = _data;
            this.x[count] = _x;
            this.y[count] = _y;
            this.starts[count] = _start;
            this.ends[count] = _end;
            this.color[count] = _color;
            ++this.myCount;
            if (count >= 299) {
                this.flushContent(g);
            }
        }
    }
}

