/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedClassFileProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, EditorColorsScheme colors) {
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter(highlighter, colors);
    }

    public EditorHighlighter createEditorHighlighter(FileType fileType, EditorColorsScheme settings, Project project) {
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).getEditorHighlighter(project, null, settings);
        }
        SyntaxHighlighter highlighter = SyntaxHighlighter.PROVIDER.create(fileType, project, null);
        return this.createEditorHighlighter(highlighter, settings);
    }

    public EditorHighlighter createEditorHighlighter(Project project, FileType fileType) {
        return this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project);
    }

    public EditorHighlighter createEditorHighlighter(VirtualFile vFile, EditorColorsScheme settings, Project project) {
        FileType fileType = vFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighter editorHighlighter = substFileType.getEditorHighlighter(project, vFile, settings);
                boolean bl = isPlain = editorHighlighter.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter).isPlain();
                if (!isPlain) {
                    return editorHighlighter;
                }
            }
            return ((LanguageFileType)fileType).getEditorHighlighter(project, vFile, settings);
        }
        ContentBasedClassFileProcessor[] processors = (ContentBasedClassFileProcessor[])Extensions.getExtensions((ExtensionPointName)ContentBasedClassFileProcessor.EP_NAME);
        SyntaxHighlighter highlighter = null;
        for (ContentBasedClassFileProcessor processor : processors) {
            if (!processor.isApplicable(project, vFile)) continue;
            highlighter = processor.createHighlighter(project, vFile);
        }
        if (highlighter == null) {
            highlighter = SyntaxHighlighter.PROVIDER.create(fileType, project, vFile);
        }
        return this.createEditorHighlighter(highlighter, settings);
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project) {
        FileType fileType;
        Language substLanguage;
        if (vFile != null && project != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project)) != language && (fileType = substLanguage.getAssociatedFileType()) instanceof LanguageFileType) {
            return (LanguageFileType)fileType;
        }
        return null;
    }

    public EditorHighlighter createEditorHighlighter(Project project, VirtualFile file) {
        return this.createEditorHighlighter(file, EditorColorsManager.getInstance().getGlobalScheme(), project);
    }

    public EditorHighlighter createEditorHighlighter(Project project, String fileName) {
        return this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName, project);
    }

    public EditorHighlighter createEditorHighlighter(EditorColorsScheme settings, String fileName, Project project) {
        return this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName), settings, project);
    }
}

