/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.ex.util.SegmentArray;

public class SegmentArrayWithData
extends SegmentArray {
    private short[] myData = new short[64];

    public void setElementAt(int i, int startOffset, int endOffset, int data) {
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        super.setElementAt(i, startOffset, endOffset);
        this.myData = SegmentArrayWithData.reallocateArray(this.myData, i + 1);
        this.myData[i] = (short)data;
    }

    @Override
    public void remove(int startIndex, int endIndex) {
        this.myData = this.remove(this.myData, startIndex, endIndex);
        super.remove(startIndex, endIndex);
    }

    public void replace(int startIndex, int endIndex, SegmentArrayWithData newData) {
        int oldLen = endIndex - startIndex;
        int newLen = newData.getSegmentCount();
        int delta = newLen - oldLen;
        if (delta < 0) {
            this.remove(endIndex + delta, endIndex);
        } else if (delta > 0) {
            SegmentArrayWithData deltaData = new SegmentArrayWithData();
            for (int i = oldLen; i < newLen; ++i) {
                deltaData.setElementAt(i - oldLen, newData.getSegmentStart(i), newData.getSegmentEnd(i), newData.getSegmentData(i));
            }
            this.insert(deltaData, startIndex + oldLen);
        }
        int common = Math.min(newLen, oldLen);
        this.replace(startIndex, newData, common);
    }

    public void replace(int startOffset, SegmentArrayWithData data, int len) {
        System.arraycopy(data.myData, 0, this.myData, startOffset, len);
        super.replace(startOffset, data, len);
    }

    public void insert(SegmentArrayWithData segmentArray, int startIndex) {
        this.myData = this.insert(this.myData, segmentArray.myData, startIndex, segmentArray.getSegmentCount());
        super.insert(segmentArray, startIndex);
    }

    public short getSegmentData(int index) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        return this.myData[index];
    }

    public void setSegmentData(int index, int data) {
        if (index < 0 || index >= this.mySegmentCount) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        if (data < 0 && data > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("data out of short range" + data);
        }
        this.myData[index] = (short)data;
    }
}

