/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.ex.DiffStatusBar;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.Convertor;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextDiffType
implements DiffStatusBar.LegendTypeDescriptor {
    public static final TextDiffType INSERT = new TextDiffType(TextDiffTypeEnum.INSERT, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]), DiffColors.DIFF_INSERTED);
    public static final TextDiffType CHANGED = new TextDiffType(TextDiffTypeEnum.CHANGED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]), DiffColors.DIFF_MODIFIED);
    public static final TextDiffType DELETED = new TextDiffType(TextDiffTypeEnum.DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]), DiffColors.DIFF_DELETED);
    public static final TextDiffType CONFLICT = new TextDiffType(TextDiffTypeEnum.CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]), DiffColors.DIFF_CONFLICT);
    public static final TextDiffType NONE = new TextDiffType(TextDiffTypeEnum.NONE, DiffBundle.message((String)"diff.type.none.name", (Object[])new Object[0]), null);
    private final TextDiffTypeEnum myType;
    public static final List<TextDiffType> DIFF_TYPES = Arrays.asList(DELETED, CHANGED, INSERT);
    public static final List<TextDiffType> MERGE_TYPES = Arrays.asList(DELETED, CHANGED, INSERT, CONFLICT);
    private final TextAttributesKey myAttributesKey;
    private final String myDisplayName;
    public static final Convertor<TextDiffType, TextAttributesKey> ATTRIBUTES_KEY = new Convertor<TextDiffType, TextAttributesKey>(){

        public TextAttributesKey convert(TextDiffType textDiffType) {
            return textDiffType.getAttributesKey();
        }
    };

    public static TextDiffType create(@NotNull TextDiffTypeEnum type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/util/TextDiffType.create must not be null");
        }
        if (TextDiffTypeEnum.INSERT.equals((Object)type)) {
            return INSERT;
        }
        if (TextDiffTypeEnum.CHANGED.equals((Object)type)) {
            return CHANGED;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)type)) {
            return DELETED;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)type)) {
            return CONFLICT;
        }
        return NONE;
    }

    private TextDiffType(TextDiffTypeEnum type, String displayName, TextAttributesKey attrubutesKey) {
        this.myType = type;
        this.myAttributesKey = attrubutesKey;
        this.myDisplayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public Color getLegendColor(EditorColorsScheme colorScheme) {
        TextAttributes attributes = this.getTextAttributes(colorScheme);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    public TextAttributes getTextAttributes(EditorColorsScheme scheme) {
        return scheme.getAttributes(this.myAttributesKey);
    }

    public Color getPoligonColor(Editor editor1) {
        return this.getLegendColor(editor1.getColorsScheme());
    }

    public TextAttributes getTextAttributes(Editor editor1) {
        return this.getTextAttributes(editor1.getColorsScheme());
    }

    public Color getTextBackground(Editor editor) {
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes != null ? attributes.getBackgroundColor() : null;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }
}

