/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.UniteSameType;
import com.intellij.openapi.diff.impl.processing.Word;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import java.util.ArrayList;

class ByWord
implements DiffPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.processing.ByWord");
    private final ComparisonPolicy myComparisonPolicy;

    public ByWord(ComparisonPolicy comparisonPolicy) {
        this.myComparisonPolicy = comparisonPolicy;
    }

    public DiffFragment[] buildFragments(String text1, String text2) {
        Object[] words1 = ByWord.buildWords(text1, this.myComparisonPolicy);
        Object[] words2 = ByWord.buildWords(text2, this.myComparisonPolicy);
        Diff.Change change = Diff.buildChanges((Object[])words1, (Object[])words2);
        change = Util.concatEquals((Diff.Change)change, (Object[])words1, (Object[])words2);
        if (Math.max(this.countNotWhitespaces((Word[])words1), this.countNotWhitespaces((Word[])words2)) > 0 && this.countEqual(change, (Word[])words1, (Word[])words2) == 0) {
            return new DiffFragment[]{this.myComparisonPolicy.createFragment(text1, text2)};
        }
        FragmentBuilder result = new FragmentBuilder((Word[])words1, (Word[])words2, this.myComparisonPolicy, text1, text2);
        FragmentBuilder.Version version1 = result.getVersion1();
        FragmentBuilder.Version version2 = result.getVersion2();
        while (change != null) {
            if (change.line0 > version1.getCurrentWordIndex()) {
                this.processEquals(change.line0, change.line1, result);
            }
            if (change.inserted == 0) {
                this.processOneside(version1, change.deleted);
            } else if (change.deleted == 0) {
                this.processOneside(version2, change.inserted);
            } else {
                String prefix1 = version1.getCurrentWordPrefix();
                String prefix2 = version2.getCurrentWordPrefix();
                if (prefix1.length() > 0 || prefix2.length() > 0) {
                    result.add(this.myComparisonPolicy.createFragment(prefix1, prefix2));
                }
                result.addChangedWords(change.deleted, change.inserted);
            }
            change = change.link;
        }
        this.processEquals(words1.length, words2.length, result);
        result.addTails();
        DiffFragment[] fragments = result.getFragments();
        DiffFragment firstFragment = fragments[0];
        if (DiffUtil.isEmpty(firstFragment)) {
            DiffFragment[] newFragments = new DiffFragment[fragments.length - 1];
            System.arraycopy(fragments, 1, newFragments, 0, newFragments.length);
            fragments = newFragments;
        }
        return fragments;
    }

    private int countNotWhitespaces(Word[] words) {
        int counter = 0;
        for (int i = 0; i < words.length; ++i) {
            Word word = words[i];
            if (word.isWhitespace()) continue;
            ++counter;
        }
        return counter;
    }

    private int countEqual(Diff.Change change, Word[] words1, Word[] words2) {
        int counter = 0;
        int position1 = 0;
        int position2 = 0;
        while (change != null) {
            if (change.line0 > position1) {
                int same = change.line0 - position1;
                LOG.assertTrue(same == change.line1 - position2);
                for (int i = 0; i < same; ++i) {
                    if (words1[position1 + i].isWhitespace() || words2[position2 + i].isWhitespace()) continue;
                    ++counter;
                }
                position1 += same;
                position2 += same;
            }
            position1 += change.deleted;
            position2 += change.inserted;
            change = change.link;
        }
        int tailCount = words1.length - position1;
        LOG.assertTrue(tailCount == words2.length - position2);
        while (tailCount > 0) {
            if (!words1[words1.length - tailCount].isWhitespace() && !words2[words2.length - tailCount].isWhitespace()) {
                ++counter;
            }
            --tailCount;
        }
        return counter;
    }

    private void processOneside(FragmentBuilder.Version version, int wordCount) {
        String prefix = version.getCurrentWordPrefix();
        version.addOneSide(prefix, wordCount);
    }

    private void processEquals(int changed1, int changed2, FragmentBuilder result) {
        while (result.getVersion1().getCurrentWordIndex() < changed1) {
            result.processEqual();
        }
        LOG.assertTrue(changed2 == result.getVersion2().getCurrentWordIndex());
    }

    static Word[] buildWords(String text, ComparisonPolicy policy) {
        ArrayList<Word> words = new ArrayList<Word>();
        if (text.length() == 0 || !Character.isWhitespace(text.charAt(0))) {
            words.add(policy.createFormatting(text, new TextRange(0, 0)));
        }
        int start = 0;
        boolean withinFormatting = true;
        for (int i = 0; i < text.length(); ++i) {
            char nextChar = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(nextChar);
            if (withinFormatting) {
                if (isWhitespace) continue;
                if (start != -1 && start < i) {
                    words.add(policy.createFormatting(text, new TextRange(start, i)));
                }
                start = -1;
                withinFormatting = false;
            }
            if (nextChar == '\n') {
                if (start != -1) {
                    words.add(new Word(text, new TextRange(start, i)));
                }
                start = i;
                withinFormatting = true;
                continue;
            }
            if (Util.DELIMITERS_SET.contains((int)nextChar)) {
                if (start == -1) continue;
                words.add(new Word(text, new TextRange(start, i)));
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            TextRange range = new TextRange(start, text.length());
            Word lastWord = withinFormatting ? policy.createFormatting(text, range) : new Word(text, range);
            words.add(lastWord);
        }
        return words.toArray(new Word[words.size()]);
    }

    private static class FragmentBuilder {
        private final ArrayList<DiffFragment> myFragments = new ArrayList();
        private final Version myVersion1;
        private final Version myVersion2;
        private final DiffPolicy.ByChar BY_CHAR;
        private final DiffCorrection.ChangedSpace CORRECTION;
        private final ComparisonPolicy myComparisonPolicy;

        public FragmentBuilder(Word[] words1, Word[] words2, ComparisonPolicy comparisonPolicy, String text1, String text2) {
            this.myVersion1 = new Version(words1, text1, this, true);
            this.myVersion2 = new Version(words2, text2, this, false);
            this.BY_CHAR = new DiffPolicy.ByChar(comparisonPolicy);
            this.CORRECTION = new DiffCorrection.ChangedSpace(comparisonPolicy);
            this.myComparisonPolicy = comparisonPolicy;
        }

        public DiffFragment[] getFragments() {
            return this.myFragments.toArray(new DiffFragment[this.myFragments.size()]);
        }

        public Version getVersion1() {
            return this.myVersion1;
        }

        public Version getVersion2() {
            return this.myVersion2;
        }

        private void addAll(DiffFragment[] fragments) {
            for (int i = 0; i < fragments.length; ++i) {
                DiffFragment fragment = fragments[i];
                this.add(fragment);
            }
        }

        private void add(DiffFragment fragment) {
            int lastIndex;
            DiffFragment prevFragment;
            String text1 = fragment.getText1();
            String text2 = fragment.getText2();
            if (text1 != null) {
                this.myVersion1.addOffset(text1.length());
            }
            if (text2 != null) {
                this.myVersion2.addOffset(text2.length());
            }
            if (fragment.isEqual() && this.myFragments.size() > 0 && (prevFragment = this.myFragments.get(lastIndex = this.myFragments.size() - 1)).isEqual()) {
                this.myFragments.remove(lastIndex);
                fragment = DiffFragment.unchanged((String)(prevFragment.getText1() + fragment.getText1()), (String)(prevFragment.getText2() + fragment.getText2()));
            }
            this.myFragments.add(fragment);
        }

        private void addEqual(Word word1, Word word2) {
            this.addAll(this.CORRECTION.correct(new DiffFragment[]{this.myComparisonPolicy.createFragment(word1, word2)}));
        }

        public void processEqual() {
            Word word1 = this.myVersion1.getCurrentWord();
            Word word2 = this.myVersion2.getCurrentWord();
            this.addAll(this.fragmentsByChar(this.myVersion1.getCurrentWordPrefix(), this.myVersion2.getCurrentWordPrefix()));
            this.addEqual(word1, word2);
            this.addPostfixes();
            this.myVersion1.incCurrentWord();
            this.myVersion2.incCurrentWord();
        }

        private DiffFragment[] fragmentsByChar(String text1, String text2) {
            DiffFragment[] fragments = this.BY_CHAR.buildFragments(this.myVersion1.getPrevChar() + text1, this.myVersion2.getPrevChar() + text2);
            return Util.cutFirst((DiffFragment[])fragments);
        }

        private void addPostfixes() {
            DiffFragment[] fragments;
            DiffFragment firstFragment;
            String postfix1 = this.myVersion1.getCurrentWordPostfixAndOneMore();
            String postfix2 = this.myVersion2.getCurrentWordPostfixAndOneMore();
            int length1 = postfix1.length();
            int length2 = postfix2.length();
            DiffFragment wholePostfix = this.myComparisonPolicy.createFragment(postfix1, postfix2);
            if (wholePostfix.isEqual()) {
                this.add(DiffFragment.unchanged((String)this.cutLast(postfix1, length1), (String)this.cutLast(postfix2, length2)));
                return;
            }
            if ((length1 > 0 || length2 > 0) && (firstFragment = (fragments = this.BY_CHAR.buildFragments(postfix1, postfix2))[0]).isEqual()) {
                this.add(this.myComparisonPolicy.createFragment(this.cutLast(firstFragment.getText1(), length1), this.cutLast(firstFragment.getText2(), length2)));
            }
        }

        private String cutLast(String text, int length) {
            if (text.length() < length) {
                return text;
            }
            return text.substring(0, text.length() - 1);
        }

        private void addOneSide(String text, FragmentSide side) {
            DiffFragment fragment = side.createFragment(text, null, false);
            this.add(this.myComparisonPolicy.createFragment(fragment.getText1(), fragment.getText2()));
        }

        public void addChangedWords(int wordCount1, int wordCount2) {
            this.add(new DiffFragment(this.myVersion1.getWordSequence(wordCount1), this.myVersion2.getWordSequence(wordCount2)));
            this.myVersion1.incCurrentWord(wordCount1);
            this.myVersion2.incCurrentWord(wordCount2);
        }

        public void addTails() {
            DiffFragment lastFragment;
            String tail1 = this.myVersion1.getNotProcessedTail();
            String tail2 = this.myVersion2.getNotProcessedTail();
            if (tail1.length() == 0 && tail2.length() == 0) {
                return;
            }
            DiffFragment[] fragments = this.fragmentsByChar(tail1, tail2);
            if (this.myFragments.size() > 0 && (lastFragment = this.myFragments.get(this.myFragments.size() - 1)).isChange()) {
                int oneSideCount;
                for (oneSideCount = 0; oneSideCount < fragments.length && fragments[oneSideCount].isOneSide(); ++oneSideCount) {
                }
                if (oneSideCount > 0) {
                    this.myFragments.remove(this.myFragments.size() - 1);
                    DiffFragment[] onesideFragments = new DiffFragment[oneSideCount];
                    DiffFragment[] otherFragments = new DiffFragment[fragments.length - oneSideCount];
                    System.arraycopy(fragments, 0, onesideFragments, 0, oneSideCount);
                    System.arraycopy(fragments, oneSideCount, otherFragments, 0, otherFragments.length);
                    DiffFragment startingOneSides = UniteSameType.uniteAll(onesideFragments);
                    if (startingOneSides.isOneSide()) {
                        this.myFragments.add(lastFragment);
                        this.add(startingOneSides);
                    } else {
                        lastFragment = Util.unite((DiffFragment)lastFragment, (DiffFragment)startingOneSides);
                        this.myFragments.add(lastFragment);
                    }
                    fragments = otherFragments;
                }
            }
            this.addAll(fragments);
        }

        public static class Version {
            private final Word[] myWords;
            private int myCurrentWord = 0;
            private int myOffset = 0;
            private final String myText;
            private final FragmentBuilder myBuilder;
            private final FragmentSide mySide;

            public Version(Word[] words, String text, FragmentBuilder builder, boolean delete) {
                this.myWords = words;
                this.myText = text;
                this.myBuilder = builder;
                this.mySide = delete ? FragmentSide.SIDE1 : FragmentSide.SIDE2;
            }

            public int getProcessedOffset() {
                return this.myOffset;
            }

            public int getCurrentWordIndex() {
                return this.myCurrentWord;
            }

            public void addOffset(int offset) {
                this.myOffset += offset;
            }

            public void incCurrentWord() {
                this.incCurrentWord(1);
            }

            public String getWordSequence(int wordCount) {
                int start = this.myWords[this.myCurrentWord].getStart();
                int end = this.myWords[this.myCurrentWord + wordCount - 1].getEnd();
                return this.myText.substring(start, end);
            }

            public void incCurrentWord(int inserted) {
                this.myCurrentWord += inserted;
            }

            public Word getCurrentWord() {
                return this.myWords[this.myCurrentWord];
            }

            public String getCurrentWordPrefix() {
                return this.getCurrentWord().getPrefix(this.getProcessedOffset());
            }

            public String getCurrentWordPostfixAndOneMore() {
                int nextStart = this.myCurrentWord < this.myWords.length - 1 ? this.myWords[this.myCurrentWord + 1].getStart() : this.myText.length();
                Word word = this.getCurrentWord();
                String postfix = this.myText.substring(word.getEnd(), nextStart);
                return postfix + (nextStart == this.myText.length() ? (char)'\n' : this.myText.charAt(nextStart));
            }

            public String getNotProcessedTail() {
                LOG.assertTrue(this.myCurrentWord == this.myWords.length);
                return this.myText.substring(this.myOffset, this.myText.length());
            }

            public char getPrevChar() {
                return this.myOffset == 0 ? (char)'\n' : this.myText.charAt(this.myOffset - 1);
            }

            public void addOneSide(String prefix, int wordCount) {
                if (prefix.length() > 0) {
                    this.myBuilder.addOneSide(prefix, this.mySide);
                }
                this.myBuilder.addOneSide(this.getWordSequence(wordCount), this.mySide);
                this.incCurrentWord(wordCount);
            }
        }
    }
}

