/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PathMerger;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchAction;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PatchApplier<BinaryType extends FilePatch> {
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    private final List<FilePatch> myPatches;
    private final CustomBinaryPatchApplier<BinaryType> myCustomForBinaries;
    private final LocalChangeList myTargetChangeList;
    private final List<FilePatch> myRemainingPatches;
    private final PathsVerifier<BinaryType> myVerifier;

    public PatchApplier(Project project, VirtualFile baseDirectory, List<FilePatch> patches, LocalChangeList targetChangeList, CustomBinaryPatchApplier<BinaryType> customForBinaries) {
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myTargetChangeList = targetChangeList;
        this.myCustomForBinaries = customForBinaries;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, this.myBaseDirectory, this.myPatches, new PathsVerifier.BaseMapper(){

            @Override
            @Nullable
            public VirtualFile getFile(FilePatch patch, String path) {
                return PathMerger.getFile(PatchApplier.this.myBaseDirectory, path);
            }
        });
    }

    public ApplyPatchStatus execute() {
        this.myRemainingPatches.addAll(this.myPatches);
        ApplyPatchStatus status = (ApplyPatchStatus)((Object)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ApplyPatchStatus>(){

            public ApplyPatchStatus compute() {
                final Ref refStatus = new Ref((Object)ApplyPatchStatus.FAILURE);
                CommandProcessor.getInstance().executeCommand(PatchApplier.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        refStatus.set((Object)PatchApplier.this.executeWritable());
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
                return (ApplyPatchStatus)((Object)refStatus.get());
            }
        }));
        PatchApplier.showApplyStatus(this.myProject, status);
        this.refreshFiles();
        return status;
    }

    public static ApplyPatchStatus executePatchGroup(final Collection<PatchApplier> group) {
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        final Project project = group.iterator().next().myProject;
        ApplyPatchStatus result = (ApplyPatchStatus)((Object)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ApplyPatchStatus>(){

            public ApplyPatchStatus compute() {
                final Ref refStatus = new Ref(null);
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        for (PatchApplier applier : group) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)refStatus.get()), applier.executeWritable()));
                        }
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
                return (ApplyPatchStatus)((Object)refStatus.get());
            }
        }));
        result = result == null ? ApplyPatchStatus.FAILURE : result;
        for (PatchApplier applier : group) {
            applier.refreshFiles();
        }
        PatchApplier.showApplyStatus(project, result);
        return result;
    }

    protected ApplyPatchStatus executeWritable() {
        return (ApplyPatchStatus)((Object)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<ApplyPatchStatus>(){

            public ApplyPatchStatus compute() {
                final Ref refStatus = new Ref((Object)ApplyPatchStatus.FAILURE);
                CommandProcessor.getInstance().executeCommand(PatchApplier.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        if (!PatchApplier.this.myVerifier.execute()) {
                            return;
                        }
                        if (!PatchApplier.this.makeWritable(PatchApplier.this.myVerifier.getWritableFiles())) {
                            return;
                        }
                        List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches = PatchApplier.this.myVerifier.getTextPatches();
                        if (!PatchApplier.this.fileTypesAreOk(textPatches)) {
                            return;
                        }
                        ApplyPatchStatus status = PatchApplier.this.actualApply(PatchApplier.this.myVerifier);
                        if (status != null) {
                            refStatus.set((Object)status);
                        }
                    }
                }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null);
                return (ApplyPatchStatus)((Object)refStatus.get());
            }
        }));
    }

    protected void refreshFiles() {
        final List<FilePath> directlyAffected = this.myVerifier.getDirectlyAffected();
        List<VirtualFile> indirectlyAffected = this.myVerifier.getAllAffected();
        RefreshSession session = RefreshQueue.getInstance().createSession(false, true, new Runnable(){

            @Override
            public void run() {
                if (PatchApplier.this.myProject.isDisposed()) {
                    return;
                }
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)PatchApplier.this.myProject);
                if (PatchApplier.this.myTargetChangeList != null && !directlyAffected.isEmpty() && !PatchApplier.this.myTargetChangeList.getName().equals(changeListManager.getDefaultListName())) {
                    changeListManager.invokeAfterUpdate((Runnable)new FilesMover(changeListManager, directlyAffected), InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, VcsBundle.message((String)"change.lists.manager.move.changes.to.list", (Object[])new Object[0]), (Consumer)new Consumer<VcsDirtyScopeManager>(){

                        public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                            vcsDirtyScopeManager.filePathsDirty((Collection)directlyAffected, null);
                        }
                    }, null);
                } else {
                    VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)PatchApplier.this.myProject);
                    vcsDirtyScopeManager.filePathsDirty((Collection)directlyAffected, null);
                }
            }
        });
        session.addAllFiles(indirectlyAffected);
        session.launch();
    }

    @Nullable
    private ApplyPatchStatus actualApply(PathsVerifier<BinaryType> verifier) {
        List textPatches = verifier.getTextPatches();
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        ApplyPatchStatus status = null;
        try {
            status = this.applyList(textPatches, context, status);
            if (this.myCustomForBinaries == null) {
                status = this.applyList(verifier.getBinaryPatches(), context, status);
            } else {
                List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> binaryPatches = verifier.getBinaryPatches();
                ApplyPatchStatus patchStatus = this.myCustomForBinaries.apply(binaryPatches);
                List<FilePatch> appliedPatches = this.myCustomForBinaries.getAppliedPatches();
                this.moveForCustomBinaries(binaryPatches, appliedPatches);
                status = ApplyPatchStatus.and(status, patchStatus);
                this.myRemainingPatches.removeAll(appliedPatches);
            }
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage(), true);
            return ApplyPatchStatus.FAILURE;
        }
        return status;
    }

    private void moveForCustomBinaries(List<Pair<VirtualFile, ApplyFilePatchBase<BinaryType>>> patches, List<FilePatch> appliedPatches) throws IOException {
        for (Pair<VirtualFile, ApplyFilePatchBase<BinaryType>> patch : patches) {
            if (!appliedPatches.contains(((ApplyFilePatchBase)patch.getSecond()).getPatch())) continue;
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
        }
    }

    private <V extends FilePatch, T extends ApplyFilePatchBase<V>> ApplyPatchStatus applyList(List<Pair<VirtualFile, T>> patches, ApplyPatchContext context, ApplyPatchStatus status) throws IOException {
        for (Pair<VirtualFile, T> patch : patches) {
            ApplyPatchStatus patchStatus = ApplyPatchAction.applyOnly(this.myProject, (ApplyFilePatchBase)patch.getSecond(), context, (VirtualFile)patch.getFirst());
            this.myVerifier.doMoveIfNeeded((VirtualFile)patch.getFirst());
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus != ApplyPatchStatus.FAILURE) {
                this.myRemainingPatches.remove(((ApplyFilePatchBase)patch.getSecond()).getPatch());
                continue;
            }
            return status;
        }
        return status;
    }

    protected static void showApplyStatus(Project project, ApplyPatchStatus status) {
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            PatchApplier.showError(project, VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]), false);
        } else if (status == ApplyPatchStatus.PARTIAL) {
            PatchApplier.showError(project, VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]), false);
        } else if (ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(ChangesViewContentManager.TOOLWINDOW_ID, MessageType.INFO, VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        }
    }

    public List<FilePatch> getRemainingPatches() {
        return this.myRemainingPatches;
    }

    private boolean makeWritable(List<VirtualFile> filesToMakeWritable) {
        VirtualFile[] fileArray = VfsUtil.toVirtualFileArray(filesToMakeWritable);
        ReadonlyStatusHandler.OperationStatus readonlyStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(fileArray);
        return !readonlyStatus.hasReadonlyFiles();
    }

    private boolean fileTypesAreOk(List<Pair<VirtualFile, ApplyTextFilePatch>> textPatches) {
        for (Pair<VirtualFile, ApplyTextFilePatch> textPatch : textPatches) {
            FileType fileType;
            VirtualFile file = (VirtualFile)textPatch.getFirst();
            if (file.isDirectory() || (fileType = file.getFileType()) != FileTypes.UNKNOWN || (fileType = FileTypeChooser.associateFileType(file.getPresentableName())) != null) continue;
            PatchApplier.showError(this.myProject, "Cannot apply patch. File " + file.getPresentableName() + " type not defined.", true);
            return false;
        }
        return true;
    }

    public static void showError(final Project project, final String message, final boolean error) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        final String title = VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]);
        final Runnable messageShower = new Runnable(){

            @Override
            public void run() {
                if (error) {
                    Messages.showErrorDialog((Project)project, (String)message, (String)title);
                } else {
                    Messages.showInfoMessage((Project)project, (String)message, (String)title);
                }
            }
        };
        if (application.isDispatchThread()) {
            messageShower.run();
        } else {
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    messageShower.run();
                }
            });
        }
    }

    private class FilesMover
    implements Runnable {
        private final ChangeListManager myChangeListManager;
        private final List<FilePath> myDirectlyAffected;

        public FilesMover(ChangeListManager changeListManager, List<FilePath> directlyAffected) {
            this.myChangeListManager = changeListManager;
            this.myDirectlyAffected = directlyAffected;
        }

        @Override
        public void run() {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (FilePath file : this.myDirectlyAffected) {
                Change change = this.myChangeListManager.getChange(file);
                if (change == null) continue;
                changes.add(change);
            }
            this.myChangeListManager.moveChangesTo(PatchApplier.this.myTargetChangeList, changes.toArray(new Change[changes.size()]));
        }
    }
}

