/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionListener;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.fs.IFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementStorage
implements StateStorage,
Disposable {
    @NonNls
    private static final Set<String> OBSOLETE_COMPONENT_NAMES = new HashSet<String>(Arrays.asList("Palette"));
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.XmlElementStorage");
    @NonNls
    private static final String COMPONENT = "component";
    @NonNls
    private static final String ATTR_NAME = "name";
    @NonNls
    private static final String NAME = "name";
    protected TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    @NotNull
    private final String myRootElementName;
    private Object mySession;
    private StorageData myLoadedData;
    protected static StringInterner ourInterner = new StringInterner();
    protected final StreamProvider myStreamProvider;
    protected final String myFileSpec;
    private final ComponentRoamingManager myComponentRoamingManager;
    protected final boolean myIsProjectSettings;
    protected boolean myBlockSavingTheContent;
    protected Integer myUpToDateHash;
    protected Integer myProviderUpToDateHash;
    private boolean mySavingDisabled;
    private final Map<String, Element> myStorageComponentStates;
    private final ComponentVersionProvider myLocalVersionProvider;
    private final ComponentVersionProvider myRemoteVersionProvider;
    protected Map<String, Long> myProviderVersions;
    protected ComponentVersionListener myListener;

    protected XmlElementStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull Disposable parentDisposable, @NotNull String rootElementName, StreamProvider streamProvider, String fileSpec, ComponentRoamingManager componentRoamingManager, ComponentVersionProvider localComponentVersionsProvider) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/XmlElementStorage.<init> must not be null");
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/components/impl/stores/XmlElementStorage.<init> must not be null");
        }
        this.myBlockSavingTheContent = false;
        this.mySavingDisabled = false;
        this.myStorageComponentStates = new TreeMap<String, Element>();
        this.myProviderVersions = null;
        this.myListener = new ComponentVersionListener(){

            @Override
            public void componentStateChanged(String componentName) {
                XmlElementStorage.this.myLocalVersionProvider.changeVersion(componentName, System.currentTimeMillis());
            }
        };
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        this.myRootElementName = rootElementName;
        this.myStreamProvider = streamProvider;
        this.myFileSpec = fileSpec;
        this.myComponentRoamingManager = componentRoamingManager;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myIsProjectSettings = "$PROJECT_FILE$".equals(this.myFileSpec) || this.myFileSpec.startsWith("$PROJECT_CONFIG_DIR$");
        this.myLocalVersionProvider = localComponentVersionsProvider;
        this.myRemoteVersionProvider = new ComponentVersionProvider(){

            @Override
            public long getVersion(String name) {
                if (XmlElementStorage.this.myProviderVersions == null) {
                    XmlElementStorage.this.loadProviderVersions();
                }
                return XmlElementStorage.this.myProviderVersions.containsKey(name) ? XmlElementStorage.this.myProviderVersions.get(name) : 0L;
            }

            @Override
            public void changeVersion(String name, long version) {
                if (XmlElementStorage.this.myProviderVersions == null) {
                    XmlElementStorage.this.loadProviderVersions();
                }
                XmlElementStorage.this.myProviderVersions.put(name, version);
            }
        };
    }

    @Nullable
    protected abstract Document loadDocument() throws StateStorage.StateStorageException;

    @Nullable
    public synchronized Element getState(String componentName) throws StateStorage.StateStorageException {
        StorageData storageData = this.getStorageData(false);
        Element state = storageData.getState(componentName);
        if (state != null) {
            if (!this.myStorageComponentStates.containsKey(componentName)) {
                this.myStorageComponentStates.put(componentName, state);
            }
            storageData.removeState(componentName);
        }
        return state;
    }

    public boolean hasState(Object component, String componentName, Class<?> aClass, boolean reloadData) throws StateStorage.StateStorageException {
        StorageData storageData = this.getStorageData(reloadData);
        return storageData.hasState(componentName);
    }

    @Nullable
    public <T> T getState(Object component, String componentName, Class<T> stateClass, @Nullable T mergeInto) throws StateStorage.StateStorageException {
        Element element = this.getState(componentName);
        return DefaultStateSerializer.deserializeState(element, stateClass, mergeInto);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected StorageData getStorageData(boolean reloadData) throws StateStorage.StateStorageException {
        StorageData storageData;
        if (this.myLoadedData != null && !reloadData) {
            storageData = this.myLoadedData;
            if (storageData == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.getStorageData must not return null");
            return storageData;
        }
        this.myLoadedData = this.loadData(true, this.myListener);
        storageData = this.myLoadedData;
        if (storageData != null) return storageData;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.getStorageData must not return null");
    }

    @NotNull
    protected StorageData loadData(boolean useProvidersData, ComponentVersionListener listener) throws StateStorage.StateStorageException {
        Document document = this.loadDocument();
        StorageData result = this.createStorageData();
        if (document != null) {
            this.loadState(result, document.getRootElement());
        } else {
            LOG.info("Document was not loaded for " + this.myFileSpec);
        }
        if (!this.myIsProjectSettings && useProvidersData) {
            for (RoamingType roamingType : RoamingType.values()) {
                if (roamingType == RoamingType.DISABLED || roamingType == RoamingType.GLOBAL) continue;
                try {
                    Document sharedDocument;
                    if (!this.myStreamProvider.isEnabled() || (sharedDocument = StorageUtil.loadDocument(this.myStreamProvider.loadContent(this.myFileSpec, roamingType))) == null) continue;
                    this.filterComponentsDisabledForRoaming(sharedDocument.getRootElement(), roamingType);
                    this.filterOutOfDateComponents(sharedDocument.getRootElement());
                    this.loadState(result, sharedDocument.getRootElement());
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        StorageData storageData = result;
        if (storageData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.loadData must not return null");
        }
        return storageData;
    }

    protected void loadState(StorageData result, Element element) throws StateStorage.StateStorageException {
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
        }
        JDOMUtil.internElement((Element)element, (StringInterner)ourInterner);
        try {
            result.load(element);
            result.checkUnknownMacros(this.myPathMacroSubstitutor);
        }
        catch (IOException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
    }

    @NotNull
    protected StorageData createStorageData() {
        StorageData storageData = new StorageData(this.myRootElementName);
        if (storageData == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.createStorageData must not return null");
        }
        return storageData;
    }

    public void setDefaultState(Element element) {
        this.myLoadedData = this.createStorageData();
        try {
            this.loadState(this.myLoadedData, element);
        }
        catch (StateStorage.StateStorageException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        MyExternalizationSession myExternalizationSession;
        try {
            MyExternalizationSession session = new MyExternalizationSession(this.getStorageData(false).clone(), this.myListener);
            this.mySession = session;
            myExternalizationSession = session;
        }
        catch (StateStorage.StateStorageException e) {
            throw new RuntimeException(e);
        }
        if (myExternalizationSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.startExternalization must not return null");
        }
        return myExternalizationSession;
    }

    @NotNull
    public StateStorage.SaveSession startSave(StateStorage.ExternalizationSession externalizationSession) {
        assert (this.mySession == externalizationSession);
        StateStorage.SaveSession saveSession = this.mySavingDisabled ? this.createNullSession() : this.createSaveSession((MyExternalizationSession)externalizationSession);
        this.mySession = saveSession;
        StateStorage.SaveSession saveSession2 = saveSession;
        if (saveSession2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage.startSave must not return null");
        }
        return saveSession2;
    }

    private StateStorage.SaveSession createNullSession() {
        return new StateStorage.SaveSession(){

            public void save() throws StateStorage.StateStorageException {
            }

            public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
                return Collections.emptySet();
            }

            public Collection<IFile> getStorageFilesToSave() throws StateStorage.StateStorageException {
                return Collections.emptySet();
            }

            public List<IFile> getAllStorageFiles() {
                return Collections.emptyList();
            }
        };
    }

    protected abstract MySaveSession createSaveSession(MyExternalizationSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSave(StateStorage.SaveSession saveSession) {
        try {
            LOG.assertTrue(this.mySession == saveSession, (Object)("mySession=" + this.mySession + " saveSession=" + saveSession));
        }
        finally {
            this.mySession = null;
        }
    }

    public void disableSaving() {
        this.mySavingDisabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDocument(StorageData data) {
        Element element = data.save();
        if (this.myPathMacroSubstitutor != null) {
            try {
                this.myPathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.myPathMacroSubstitutor.reset();
            }
        }
        return new Document(element);
    }

    private Document createVersionDocument(Document copy) {
        return new Document(StateStorageManagerImpl.createComponentVersionsXml(this.loadVersions(copy)));
    }

    private Map<String, Long> loadVersions(Document copy) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        List list = copy.getRootElement().getChildren(COMPONENT);
        for (Object o : list) {
            long version;
            Element component;
            String name;
            if (!(o instanceof Element) || (name = (component = (Element)o).getAttributeValue("name")) == null || (version = this.myLocalVersionProvider.getVersion(name)) == 0L) continue;
            result.put(name, version);
        }
        return result;
    }

    public void dispose() {
    }

    public void resetData() {
        this.myLoadedData = null;
    }

    public void reload(@NotNull Set<String> changedComponents) throws StateStorage.StateStorageException {
        if (changedComponents == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/XmlElementStorage.reload must not be null");
        }
        StorageData storageData = this.loadData(false, this.myListener);
        StorageData oldLoadedData = this.myLoadedData;
        if (oldLoadedData != null) {
            HashSet componentsToRetain = new HashSet(oldLoadedData.myComponentStates.keySet());
            componentsToRetain.addAll(changedComponents);
            for (String componentToRetain : componentsToRetain) {
                if (storageData.myComponentStates.containsKey(componentToRetain) || !this.myStorageComponentStates.containsKey(componentToRetain)) continue;
                Element emptyElement = new Element(COMPONENT);
                LOG.info("Create empty component element for " + componentsToRetain);
                emptyElement.setAttribute("name", componentToRetain);
                storageData.myComponentStates.put(componentToRetain, emptyElement);
            }
            storageData.myComponentStates.keySet().retainAll(componentsToRetain);
        }
        this.myLoadedData = storageData;
    }

    private void filterComponentsDisabledForRoaming(Element element, RoamingType roamingType) {
        List components = element.getChildren(COMPONENT);
        ArrayList<Element> toDelete = new ArrayList<Element>();
        for (Object componentObj : components) {
            Element componentElement = (Element)componentObj;
            String nameAttr = componentElement.getAttributeValue("name");
            if (this.myComponentRoamingManager.getRoamingType(nameAttr) == roamingType) continue;
            toDelete.add(componentElement);
        }
        for (Element toDeleteElement : toDelete) {
            element.removeContent((Content)toDeleteElement);
        }
    }

    private void filterOutOfDateComponents(Element element) {
        List components = element.getChildren(COMPONENT);
        ArrayList<Element> toDelete = new ArrayList<Element>();
        for (Object componentObj : components) {
            Element componentElement = (Element)componentObj;
            String nameAttr = componentElement.getAttributeValue("name");
            if (this.myRemoteVersionProvider.getVersion(nameAttr) <= this.myLocalVersionProvider.getVersion(nameAttr)) {
                toDelete.add(componentElement);
                continue;
            }
            this.myLocalVersionProvider.changeVersion(nameAttr, this.myRemoteVersionProvider.getVersion(nameAttr));
        }
        for (Element toDeleteElement : toDelete) {
            element.removeContent((Content)toDeleteElement);
        }
    }

    private void loadProviderVersions() {
        this.myProviderVersions = new TreeMap<String, Long>();
        for (RoamingType type : RoamingType.values()) {
            Document doc = null;
            if (this.myStreamProvider.isEnabled()) {
                try {
                    doc = StorageUtil.loadDocument(this.myStreamProvider.loadContent(this.myFileSpec + ".ver", type));
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            if (doc == null) continue;
            StateStorageManagerImpl.loadComponentVersions(this.myProviderVersions, doc);
        }
    }

    protected static class StorageData {
        private final Map<String, Element> myComponentStates;
        protected final String myRootElementName;
        private Integer myHash;

        public StorageData(String rootElementName) {
            this.myComponentStates = new TreeMap<String, Element>();
            this.myRootElementName = rootElementName;
        }

        protected StorageData(StorageData storageData) {
            this.myRootElementName = storageData.myRootElementName;
            this.myComponentStates = new TreeMap<String, Element>(storageData.myComponentStates);
        }

        protected void load(@NotNull Element rootElement) throws IOException {
            Element[] elements;
            if (rootElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/XmlElementStorage$StorageData.load must not be null");
            }
            for (Element element : elements = JDOMUtil.getElements((Element)rootElement)) {
                if (!element.getName().equals(XmlElementStorage.COMPONENT)) continue;
                String name = element.getAttributeValue("name");
                if (name == null) {
                    LOG.info("Broken content in file : " + this);
                    continue;
                }
                if (OBSOLETE_COMPONENT_NAMES.contains(name)) continue;
                element.detach();
                if (element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
                assert (element.getAttributeValue("name") != null) : "No name attribute for component: " + name + " in " + this;
                Element existingElement = this.myComponentStates.get(name);
                if (existingElement != null) {
                    element = this.mergeElements(name, element, existingElement);
                }
                this.myComponentStates.put(name, element);
            }
        }

        private Element mergeElements(String name, Element element1, Element element2) {
            XmlConfigurationMerger[] mergers;
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.componentConfigurationMerger");
            for (XmlConfigurationMerger merger : mergers = (XmlConfigurationMerger[])point.getExtensions()) {
                if (!merger.getComponentName().equals(name)) continue;
                return merger.merge(element1, element2);
            }
            return element1;
        }

        @NotNull
        protected Element save() {
            Element rootElement = new Element(this.myRootElementName);
            for (String componentName : this.myComponentStates.keySet()) {
                assert (componentName != null);
                Element element = this.myComponentStates.get(componentName);
                if (element.getAttribute("name") == null) {
                    element.setAttribute("name", componentName);
                }
                rootElement.addContent((Element)element.clone());
            }
            Element element = rootElement;
            if (element == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/XmlElementStorage$StorageData.save must not return null");
            }
            return element;
        }

        @Nullable
        public Element getState(String name) {
            Element e = this.myComponentStates.get(name);
            if (e != null) {
                assert (e.getAttributeValue("name") != null) : "No name attribute for component: " + name + " in " + this;
                e.removeAttribute("name");
            }
            return e;
        }

        public void removeState(String componentName) {
            this.myComponentStates.remove(componentName);
            this.clearHash();
        }

        private void setState(@NotNull String componentName, Element element) {
            Attribute attr;
            if (componentName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/XmlElementStorage$StorageData.setState must not be null");
            }
            element.setName(XmlElementStorage.COMPONENT);
            ArrayList attributes = new ArrayList(element.getAttributes());
            for (Object attribute : attributes) {
                attr = (Attribute)attribute;
                element.removeAttribute(attr);
            }
            element.setAttribute("name", componentName);
            for (Object attribute : attributes) {
                attr = (Attribute)attribute;
                element.setAttribute(attr.getName(), attr.getValue());
            }
            this.myComponentStates.put(componentName, element);
            this.clearHash();
        }

        public StorageData clone() {
            return new StorageData(this);
        }

        public final int getHash() {
            if (this.myHash == null) {
                this.myHash = this.computeHash();
            }
            return this.myHash;
        }

        protected int computeHash() {
            int result = 0;
            for (String name : this.myComponentStates.keySet()) {
                result = 31 * result + name.hashCode();
                result = 31 * result + JDOMUtil.getTreeHash((Element)this.myComponentStates.get(name));
            }
            return result;
        }

        protected void clearHash() {
            this.myHash = null;
        }

        public Set<String> getDifference(StorageData storageData, PathMacroSubstitutor substitutor) {
            HashSet<String> bothStates = new HashSet<String>(this.myComponentStates.keySet());
            bothStates.retainAll(storageData.myComponentStates.keySet());
            HashSet<String> diffs = new HashSet<String>();
            diffs.addAll(storageData.myComponentStates.keySet());
            diffs.addAll(this.myComponentStates.keySet());
            diffs.removeAll(bothStates);
            for (String componentName : bothStates) {
                Element e1 = this.myComponentStates.get(componentName);
                Element e2 = storageData.myComponentStates.get(componentName);
                if (substitutor != null) {
                    substitutor.expandPaths(e2);
                }
                if (JDOMUtil.areElementsEqual((Element)e1, (Element)e2)) continue;
                diffs.add(componentName);
            }
            return diffs;
        }

        public boolean isEmpty() {
            return this.myComponentStates.size() == 0;
        }

        public boolean hasState(String componentName) {
            return this.myComponentStates.containsKey(componentName);
        }

        public void checkUnknownMacros(TrackingPathMacroSubstitutor pathMacroSubstitutor) {
            if (pathMacroSubstitutor == null) {
                return;
            }
            for (String componentName : this.myComponentStates.keySet()) {
                Set<String> unknownMacros = StorageUtil.getMacroNames(this.myComponentStates.get(componentName));
                if (unknownMacros.isEmpty()) continue;
                pathMacroSubstitutor.addUnknownMacros(componentName, unknownMacros);
            }
        }
    }

    protected abstract class MySaveSession
    implements StateStorage.SaveSession {
        StorageData myStorageData;
        private Document myDocumentToSave;

        public MySaveSession(MyExternalizationSession externalizationSession) {
            this.myStorageData = externalizationSession.myStorageData;
        }

        public final boolean needsSave() throws StateStorage.StateStorageException {
            assert (XmlElementStorage.this.mySession == this);
            return this._needsSave(this.calcHash());
        }

        private boolean _needsSave(Integer hash) {
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return false;
            }
            if (XmlElementStorage.this.myUpToDateHash == null) {
                if (hash != null) {
                    if (!this.physicalContentNeedsSave()) {
                        XmlElementStorage.this.myUpToDateHash = hash;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            if (hash != null) {
                if (hash.intValue() == XmlElementStorage.this.myUpToDateHash.intValue()) {
                    return false;
                }
                if (!this.physicalContentNeedsSave()) {
                    XmlElementStorage.this.myUpToDateHash = hash;
                    return false;
                }
                return true;
            }
            return this.physicalContentNeedsSave();
        }

        protected boolean physicalContentNeedsSave() {
            return true;
        }

        protected abstract void doSave() throws StateStorage.StateStorageException;

        public void clearHash() {
            XmlElementStorage.this.myUpToDateHash = null;
        }

        protected Integer calcHash() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void save() throws StateStorage.StateStorageException {
            assert (XmlElementStorage.this.mySession == this);
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            Integer hash = this.calcHash();
            try {
                this.saveForProviders(hash);
            }
            finally {
                this.saveLocally(hash);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveLocally(Integer hash) {
            try {
                if (!this.isHashUpToDate(hash) && this._needsSave(hash)) {
                    this.doSave();
                }
            }
            finally {
                XmlElementStorage.this.myUpToDateHash = hash;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveForProviders(Integer hash) {
            if (XmlElementStorage.this.myProviderUpToDateHash == null || !XmlElementStorage.this.myProviderUpToDateHash.equals(hash)) {
                try {
                    if (!XmlElementStorage.this.myIsProjectSettings) {
                        for (RoamingType roamingType : RoamingType.values()) {
                            if (roamingType == RoamingType.DISABLED) continue;
                            try {
                                Document copy = (Document)this.getDocumentToSave().clone();
                                XmlElementStorage.this.filterComponentsDisabledForRoaming(copy.getRootElement(), roamingType);
                                if (copy.getRootElement().getChildren().size() <= 0) continue;
                                StorageUtil.sendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec, copy, roamingType, true);
                                Document versionDoc = XmlElementStorage.this.createVersionDocument(copy);
                                if (versionDoc.getRootElement().getChildren().size() <= 0) continue;
                                StorageUtil.sendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec + ".ver", versionDoc, roamingType, true);
                            }
                            catch (IOException e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    XmlElementStorage.this.myProviderUpToDateHash = hash;
                }
            }
        }

        private boolean isHashUpToDate(Integer hash) {
            return XmlElementStorage.this.myUpToDateHash != null && XmlElementStorage.this.myUpToDateHash.equals(hash);
        }

        public boolean isHashUpToDate() {
            return this.isHashUpToDate(this.calcHash());
        }

        protected Document getDocumentToSave() {
            if (this.myDocumentToSave != null) {
                return this.myDocumentToSave;
            }
            Element element = this.myStorageData.save();
            this.myDocumentToSave = new Document(element);
            if (XmlElementStorage.this.myPathMacroSubstitutor != null) {
                XmlElementStorage.this.myPathMacroSubstitutor.collapsePaths(element);
            }
            return this.myDocumentToSave;
        }

        public StorageData getData() {
            return this.myStorageData;
        }

        @Nullable
        public Set<String> analyzeExternalChanges(Set<Pair<VirtualFile, StateStorage>> changedFiles) {
            try {
                Document document = XmlElementStorage.this.loadDocument();
                StorageData storageData = XmlElementStorage.this.createStorageData();
                if (document != null) {
                    XmlElementStorage.this.loadState(storageData, document.getRootElement());
                    return storageData.getDifference(this.myStorageData, XmlElementStorage.this.myPathMacroSubstitutor);
                }
                return Collections.emptySet();
            }
            catch (StateStorage.StateStorageException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
    }

    protected class MyExternalizationSession
    implements StateStorage.ExternalizationSession {
        private final StorageData myStorageData;
        private final ComponentVersionListener myListener;

        public MyExternalizationSession(StorageData storageData, ComponentVersionListener listener) {
            this.myStorageData = storageData;
            this.myListener = listener;
        }

        public void setState(Object component, String componentName, Object state, Storage storageSpec) throws StateStorage.StateStorageException {
            assert (XmlElementStorage.this.mySession == this);
            try {
                this.setState(componentName, DefaultStateSerializer.serializeState(state, storageSpec));
            }
            catch (WriteExternalException e) {
                LOG.debug((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void setState(String componentName, Element element) {
            if (element.getAttributes().isEmpty() && element.getChildren().isEmpty()) {
                return;
            }
            this.myStorageData.setState(componentName, element);
            Element oldElement = (Element)XmlElementStorage.this.myStorageComponentStates.get(componentName);
            try {
                if (oldElement != null && !JDOMUtil.areElementsEqual((Element)oldElement, (Element)element)) {
                    this.myListener.componentStateChanged(componentName);
                }
            }
            finally {
                XmlElementStorage.this.myStorageComponentStates.put(componentName, (Element)element.clone());
            }
        }
    }
}

