/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ConfirmExitDialog;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityInvokatorImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.application.impl.PluginsFacade;
import com.intellij.openapi.application.impl.Win32Restarter;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.ApplicationPathMacroManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.IApplicationStore;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.RoamingTypeExtensionPointBean;
import com.intellij.openapi.components.impl.stores.StoresFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiLock;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ReflectionCache;
import com.intellij.util.concurrency.ReentrantWriterPreferenceReadWriteLock;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ApplicationImpl
extends ComponentManagerImpl
implements ApplicationEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.impl.ApplicationImpl");
    private final ModalityState MODALITY_STATE_NONE = ModalityState.NON_MODAL;
    private final ModalityInvokator myInvokator = new ModalityInvokatorImpl();
    private final EventDispatcher<ApplicationListener> myDispatcher = EventDispatcher.create(ApplicationListener.class);
    private final boolean myTestModeFlag;
    private final boolean myHeadlessMode;
    private final boolean myCommandLineMode;
    private final boolean myIsInternal;
    private final String myName;
    private final ReentrantWriterPreferenceReadWriteLock myActionsLock = new ReentrantWriterPreferenceReadWriteLock();
    private final Stack<Runnable> myWriteActionsStack = new Stack();
    private volatile Runnable myExceptionalThreadWithReadAccessRunnable;
    private int myInEditorPaintCounter = 0;
    private long myStartTime = 0L;
    private boolean myDoNotSave = false;
    private volatile boolean myDisposeInProgress = false;
    private final AtomicBoolean mySaveSettingsIsInProgress = new AtomicBoolean(false);
    private final ExecutorService ourThreadExecutorsService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 1800L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "ApplicationImpl pooled thread"){

                @Override
                public void interrupt() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Interrupted worker, will remove from pool");
                    }
                    super.interrupt();
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            super.run();
                        }
                        catch (Throwable t) {
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.debug("Worker exits due to exception", t);
                        }
                    }
                }
            };
            thread.setPriority(4);
            return thread;
        }
    });
    private boolean myIsFiringLoadingEvent = false;
    @NonNls
    private static final String WAS_EVER_SHOWN = "was.ever.shown";
    private Boolean myActive;
    private static ThreadLocal<Integer> ourEdtSafe = new ThreadLocal();
    private static Thread ourDispatchThread = null;
    private final Object lock = new Object();
    private static final ThreadLocal<Boolean> exceptionalThreadWithReadAccessFlag = new ThreadLocal();

    @Override
    protected void boostrapPicoContainer() {
        super.boostrapPicoContainer();
        this.getPicoContainer().registerComponentImplementation(IComponentStore.class, StoresFactory.getApplicationStoreClass());
        this.getPicoContainer().registerComponentImplementation(ApplicationPathMacroManager.class);
    }

    @Override
    @NotNull
    public synchronized IApplicationStore getStateStore() {
        IApplicationStore iApplicationStore = (IApplicationStore)super.getStateStore();
        if (iApplicationStore == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/impl/ApplicationImpl.getStateStore must not return null");
        }
        return iApplicationStore;
    }

    public ApplicationImpl(boolean isInternal, boolean isUnitTestMode, boolean isHeadless, boolean isCommandLine, String appName) {
        super(null);
        this.getPicoContainer().registerComponentInstance(Application.class, (Object)this);
        CommonBundle.assertKeyIsFound = isUnitTestMode;
        if ((isInternal || isUnitTestMode) && !Comparing.equal((String)"off", (String)System.getProperty("idea.disposer.debug"))) {
            Disposer.setDebugMode((boolean)true);
        }
        this.myStartTime = System.currentTimeMillis();
        this.myName = appName;
        ApplicationManagerEx.setApplication(this);
        PluginsFacade.INSTANCE = new PluginsFacade(){

            public IdeaPluginDescriptor getPlugin(PluginId id) {
                return PluginManager.getPlugin((PluginId)id);
            }

            public IdeaPluginDescriptor[] getPlugins() {
                return PluginManager.getPlugins();
            }
        };
        if (!isUnitTestMode && !isHeadless) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(IdeEventQueue.getInstance());
            if (Patches.SUN_BUG_ID_6209673) {
                RepaintManager.setCurrentManager(new IdeRepaintManager());
            }
            IconLoader.activate();
        }
        this.myIsInternal = isInternal;
        this.myTestModeFlag = isUnitTestMode;
        this.myHeadlessMode = isHeadless;
        this.myCommandLineMode = isCommandLine;
        this.loadApplicationComponents();
        if (this.myTestModeFlag) {
            this.registerShutdownHook();
        }
        if (!isUnitTestMode && !isHeadless) {
            Disposer.register((Disposable)this, (Disposable)Disposer.newDisposable(), (String)"ui");
        }
    }

    private void registerShutdownHook() {
        ShutDownTracker.getInstance();
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (ApplicationImpl.this.isDisposed() || ApplicationImpl.this.isDisposeInProgress()) {
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManagerEx.setApplication(ApplicationImpl.this);
                            ApplicationImpl.this.saveAll();
                            ApplicationImpl.this.disposeSelf();
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    private boolean disposeSelf() {
        Project[] openProjects = ProjectManagerEx.getInstanceEx().getOpenProjects();
        final boolean[] canClose = new boolean[]{true};
        for (final Project project : openProjects) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    canClose[0] = ProjectUtil.closeProject(project);
                }
            }, ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]), null);
            if (canClose[0]) continue;
            return false;
        }
        this.myDisposeInProgress = true;
        Disposer.dispose((Disposable)this);
        Disposer.assertIsEmpty();
        return true;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean holdsReadLock() {
        return this.myActionsLock.isReadLockAcquired();
    }

    @Override
    protected void handleInitComponentError(Throwable ex, boolean fatal, String componentClassName) {
        if (PluginManager.isPluginClass((String)componentClassName)) {
            LOG.error(ex);
            PluginId pluginId = PluginManager.getPluginByClassName((String)componentClassName);
            String errorMessage = "Plugin " + pluginId.getIdString() + " failed to initialize and will be disabled:\n" + ex.getMessage() + "\nPlease restart " + ApplicationNamesInfo.getInstance().getFullProductName() + ".";
            PluginManager.disablePlugin((String)pluginId.getIdString());
            if (!this.myHeadlessMode) {
                JOptionPane.showMessageDialog(null, errorMessage);
            } else {
                System.out.println(errorMessage);
            }
            System.exit(1);
        } else if (fatal) {
            LOG.error(ex);
            String errorMessage = "Fatal error initializing class " + componentClassName + ":\n" + ex.toString() + "\nComplete error stacktrace was written to idea.log";
            if (!this.myHeadlessMode) {
                JOptionPane.showMessageDialog(null, errorMessage);
            } else {
                System.out.println(errorMessage);
            }
        }
        super.handleInitComponentError(ex, fatal, componentClassName);
    }

    private void loadApplicationComponents() {
        IdeaPluginDescriptor[] plugins;
        for (IdeaPluginDescriptor plugin : plugins = PluginManager.getPlugins()) {
            if (PluginManager.shouldSkipPlugin((IdeaPluginDescriptor)plugin)) continue;
            this.loadComponentsConfiguration(plugin.getAppComponents(), plugin, false);
        }
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getRootArea().getPicoContainer();
    }

    @Override
    public boolean isInternal() {
        return this.myIsInternal;
    }

    public boolean isUnitTestMode() {
        return this.myTestModeFlag;
    }

    public boolean isHeadlessEnvironment() {
        return this.myHeadlessMode;
    }

    public boolean isCommandLine() {
        return this.myCommandLineMode;
    }

    public IdeaPluginDescriptor getPlugin(PluginId id) {
        return PluginsFacade.INSTANCE.getPlugin(id);
    }

    public IdeaPluginDescriptor[] getPlugins() {
        return PluginsFacade.INSTANCE.getPlugins();
    }

    public Future<?> executeOnPooledThread(final Runnable action) {
        return this.ourThreadExecutorsService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (ProcessCanceledException e) {
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
    }

    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        ModalityInvokator modalityInvokator = this.myInvokator;
        if (modalityInvokator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/impl/ApplicationImpl.getInvokator must not return null");
        }
        return modalityInvokator;
    }

    public void invokeLater(Runnable runnable) {
        this.myInvokator.invokeLater(runnable);
    }

    public void invokeLater(Runnable runnable, @NotNull Condition expired) {
        if (expired == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeLater must not be null");
        }
        this.myInvokator.invokeLater(runnable, expired);
    }

    public void invokeLater(Runnable runnable, @NotNull ModalityState state) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeLater must not be null");
        }
        this.myInvokator.invokeLater(runnable, state);
    }

    public void invokeLater(Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeLater must not be null");
        }
        if (expired == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeLater must not be null");
        }
        this.myInvokator.invokeLater(runnable, state, expired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String path) throws IOException, InvalidDataException {
        this.getStateStore().setOptionsPath(path);
        this.getStateStore().setConfigPath(PathManager.getConfigPath());
        this.myIsFiringLoadingEvent = true;
        try {
            this.fireBeforeApplicationLoaded();
        }
        finally {
            this.myIsFiringLoadingEvent = false;
        }
        ApplicationImpl.loadComponentRoamingTypes();
        try {
            this.getStateStore().load();
        }
        catch (StateStorage.StateStorageException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected <T> T getComponentFromContainer(Class<T> interfaceClass) {
        if (this.myIsFiringLoadingEvent) {
            return null;
        }
        return super.getComponentFromContainer(interfaceClass);
    }

    private static void loadComponentRoamingTypes() {
        RoamingTypeExtensionPointBean[] componentRoamingTypes;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.ComponentRoamingType");
        for (RoamingTypeExtensionPointBean object : componentRoamingTypes = (RoamingTypeExtensionPointBean[])point.getExtensions()) {
            assert (object.componentName != null);
            assert (object.roamingType != null);
            RoamingType type = RoamingType.valueOf((String)object.roamingType);
            assert (type != null);
            ComponentRoamingManager.getInstance().setRoamingType(object.componentName, type);
        }
    }

    private void fireBeforeApplicationLoaded() {
        ApplicationLoadListener[] objects;
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.ApplicationLoadListener");
        for (ApplicationLoadListener object : objects = (ApplicationLoadListener[])point.getExtensions()) {
            object.beforeApplicationLoaded(this);
        }
    }

    @Override
    public void dispose() {
        this.fireApplicationExiting();
        this.disposeComponents();
        this.ourThreadExecutorsService.shutdownNow();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeChangesVisibleToEDT() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.hashCode();
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(Runnable process, String progressTitle, boolean canBeCanceled, Project project) {
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public boolean runProcessWithProgressSynchronously(Runnable process, String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent) {
        return this.runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project, parentComponent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runProcessWithProgressSynchronously(final Runnable process, String progressTitle, boolean canBeCanceled, @Nullable Project project, JComponent parentComponent, String cancelText) {
        this.assertIsDispatchThread();
        if (this.myExceptionalThreadWithReadAccessRunnable != null || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            try {
                ProgressManager.getInstance().runProcess(process, (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                return false;
            }
            return true;
        }
        final ProgressWindow progress = new ProgressWindow(canBeCanceled, false, project, parentComponent, cancelText);
        progress.setTitle(progressTitle);
        try {
            this.myExceptionalThreadWithReadAccessRunnable = process;
            final boolean[] threadStarted = new boolean[]{false};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable != process) {
                        LOG.error("myExceptionalThreadWithReadAccessRunnable != process, process = " + ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable);
                    }
                    ApplicationImpl.this.executeOnPooledThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable != process) {
                                LOG.error("myExceptionalThreadWithReadAccessRunnable != process, process = " + ApplicationImpl.this.myExceptionalThreadWithReadAccessRunnable);
                            }
                            boolean old = ApplicationImpl.setExceptionalThreadWithReadAccessFlag(true);
                            LOG.assertTrue(ApplicationImpl.this.isReadAccessAllowed());
                            try {
                                ProgressManager.getInstance().runProcess(process, (ProgressIndicator)progress);
                            }
                            catch (ProcessCanceledException e) {
                                progress.cancel();
                            }
                            finally {
                                ApplicationImpl.setExceptionalThreadWithReadAccessFlag(old);
                                ApplicationImpl.this.makeChangesVisibleToEDT();
                            }
                        }
                    });
                    threadStarted[0] = true;
                }
            });
            progress.startBlocking();
            LOG.assertTrue(threadStarted[0]);
            LOG.assertTrue(!progress.isRunning());
        }
        finally {
            this.myExceptionalThreadWithReadAccessRunnable = null;
            this.makeChangesVisibleToEDT();
        }
        return !progress.isCanceled();
    }

    @Override
    public boolean isInModalProgressThread() {
        if (this.myExceptionalThreadWithReadAccessRunnable == null || !ApplicationImpl.isExceptionalThreadWithReadAccess()) {
            return false;
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        return progressIndicator.isModal() && ((ProgressIndicatorEx)progressIndicator).isModalityEntered();
    }

    @Override
    public <T> List<Future<T>> invokeAllUnderReadAction(@NotNull Collection<Callable<T>> tasks, final ExecutorService executorService) throws Throwable {
        if (tasks == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeAllUnderReadAction must not be null");
        }
        final ArrayList<7> newCallables = new ArrayList<7>(tasks.size());
        for (final Callable<T> task : tasks) {
            Callable newCallable = new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    boolean old = ApplicationImpl.setExceptionalThreadWithReadAccessFlag(true);
                    try {
                        LOG.assertTrue(ApplicationImpl.this.isReadAccessAllowed());
                        Object v = task.call();
                        return v;
                    }
                    finally {
                        ApplicationImpl.setExceptionalThreadWithReadAccessFlag(old);
                    }
                }
            };
            newCallables.add(newCallable);
        }
        final Ref exception = new Ref();
        List result = (List)this.runReadAction(new Computable<List<Future<T>>>(){

            public List<Future<T>> compute() {
                try {
                    return ConcurrencyUtil.invokeAll((Collection)newCallables, (ExecutorService)executorService);
                }
                catch (Throwable throwable) {
                    exception.set((Object)throwable);
                    return null;
                }
            }
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
        return result;
    }

    public void invokeAndWait(Runnable runnable, @NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.invokeAndWait must not be null");
        }
        if (this.isDispatchThread()) {
            LOG.error("invokeAndWait must not be called from event queue thread");
            runnable.run();
            return;
        }
        if (ApplicationImpl.isExceptionalThreadWithReadAccess()) {
            LaterInvocator.invokeAndWait(runnable, modalityState);
            return;
        }
        if (this.myActionsLock.isReadLockAcquired()) {
            LOG.error("Calling invokeAndWait from read-action leads to possible deadlock.");
        }
        LaterInvocator.invokeAndWait(runnable, modalityState);
    }

    public ModalityState getCurrentModalityState() {
        Object[] entities = LaterInvocator.getCurrentModalEntities();
        return entities.length > 0 ? new ModalityStateEx(entities) : this.getNoneModalityState();
    }

    public ModalityState getModalityStateForComponent(Component c) {
        Window window;
        Window window2 = window = c instanceof Window ? (Window)c : SwingUtilities.windowForComponent(c);
        if (window == null) {
            return this.getNoneModalityState();
        }
        return LaterInvocator.modalityStateForWindow(window);
    }

    public ModalityState getDefaultModalityState() {
        if (EventQueue.isDispatchThread()) {
            return this.getCurrentModalityState();
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        return progress == null ? this.getNoneModalityState() : progress.getModalityState();
    }

    public ModalityState getNoneModalityState() {
        return this.MODALITY_STATE_NONE;
    }

    public long getStartTime() {
        return this.myStartTime;
    }

    public long getIdleTime() {
        return IdeEventQueue.getInstance().getIdleTime();
    }

    public void exit() {
        this.exit(false);
    }

    @Override
    public void exit(final boolean force) {
        if (!force && this.getDefaultModalityState() != ModalityState.NON_MODAL) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!force && !ApplicationImpl.showConfirmation()) {
                    ApplicationImpl.this.saveAll();
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                ApplicationImpl.this.saveSettings();
                if (!ApplicationImpl.this.canExit()) {
                    return;
                }
                if (ApplicationImpl.this.disposeSelf()) {
                    System.exit(0);
                }
            }
        };
        if (!this.isDispatchThread()) {
            this.invokeLater(runnable, ModalityState.NON_MODAL);
        } else {
            runnable.run();
        }
    }

    private static boolean showConfirmation() {
        boolean hasUnsafeBgTasks = ProgressManager.getInstance().hasUnsafeProgressIndicator();
        ConfirmExitDialog confirmExitDialog = new ConfirmExitDialog(hasUnsafeBgTasks);
        if (confirmExitDialog.isToBeShown()) {
            confirmExitDialog.show();
            if (!confirmExitDialog.isOK()) {
                return false;
            }
        }
        return true;
    }

    private boolean canExit() {
        Project[] projects;
        for (ApplicationListener applicationListener : this.myDispatcher.getListeners()) {
            if (applicationListener.canExitApplication()) continue;
            return false;
        }
        ProjectManagerEx projectManager = (ProjectManagerEx)ProjectManager.getInstance();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (projectManager.canClose(project)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReadAction(Runnable action) {
        boolean mustAcquire;
        boolean bl = mustAcquire = !this.isReadAccessAllowed();
        if (mustAcquire) {
            LOG.assertTrue(this.myTestModeFlag || !Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
            try {
                this.myActionsLock.readLock().acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        try {
            action.run();
        }
        finally {
            if (mustAcquire) {
                this.myActionsLock.readLock().release();
            }
        }
    }

    private static boolean isExceptionalThreadWithReadAccess() {
        Boolean flag = exceptionalThreadWithReadAccessFlag.get();
        return flag == Boolean.TRUE;
    }

    public static boolean setExceptionalThreadWithReadAccessFlag(boolean flag) {
        boolean old = ApplicationImpl.isExceptionalThreadWithReadAccess();
        if (flag) {
            exceptionalThreadWithReadAccessFlag.set(Boolean.TRUE);
        } else {
            exceptionalThreadWithReadAccessFlag.remove();
        }
        return old;
    }

    public <T> T runReadAction(final Computable<T> computation) {
        final Ref ref = Ref.create(null);
        this.runReadAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWriteAction(Runnable action) {
        Stack<Runnable> stack;
        this.assertCanRunWriteAction();
        ActivityTracker.getInstance().inc();
        this.fireBeforeWriteActionStart(action);
        LOG.assertTrue(this.myActionsLock.isWriteLockAcquired(Thread.currentThread()) || !Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing writeAction");
        try {
            this.myActionsLock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        try {
            stack = this.myWriteActionsStack;
            synchronized (stack) {
                this.myWriteActionsStack.push((Object)action);
            }
            this.fireWriteActionStarted(action);
            action.run();
        }
        finally {
            try {
                this.fireWriteActionFinished(action);
                stack = this.myWriteActionsStack;
                synchronized (stack) {
                    this.myWriteActionsStack.pop();
                }
            }
            finally {
                this.myActionsLock.writeLock().release();
            }
        }
    }

    public <T> T runWriteAction(final Computable<T> computation) {
        final Ref ref = Ref.create(null);
        this.runWriteAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCurrentWriteAction(Class actionClass) {
        Stack<Runnable> stack = this.myWriteActionsStack;
        synchronized (stack) {
            for (int i = this.myWriteActionsStack.size() - 1; i >= 0; --i) {
                Runnable action = (Runnable)this.myWriteActionsStack.get(i);
                if (actionClass != null && !ReflectionCache.isAssignable((Class)actionClass, action.getClass())) continue;
                return action;
            }
        }
        return null;
    }

    public void assertReadAccessAllowed() {
        if (this.myTestModeFlag || this.myHeadlessMode) {
            return;
        }
        if (!this.isReadAccessAllowed()) {
            LOG.error("Read access is allowed from event dispatch thread or inside read-action only (see com.intellij.openapi.application.Application.runReadAction())", new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "Our dispatch thread:" + ApplicationImpl.describe(ourDispatchThread), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
        }
    }

    @NonNls
    private static String describe(Thread o) {
        if (o == null) {
            return "null";
        }
        return o.toString() + " " + System.identityHashCode(o);
    }

    @Nullable
    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = EventQueue.class.getDeclaredMethod("getDispatchThread", new Class[0]);
            method.setAccessible(true);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isReadAccessAllowed() {
        Thread currentThread = Thread.currentThread();
        return ourDispatchThread == currentThread || ApplicationImpl.isExceptionalThreadWithReadAccess() || this.myActionsLock.isReadLockAcquired() || this.myActionsLock.isWriteLockAcquired() || this.isDispatchThread();
    }

    @Override
    public void assertReadAccessToDocumentsAllowed() {
    }

    private void assertCanRunWriteAction() {
        this.assertIsDispatchThread("Write access is allowed from event dispatch thread only");
    }

    public void assertIsDispatchThread() {
        this.assertIsDispatchThread("Access is allowed from event dispatch thread only.");
    }

    private void assertIsDispatchThread(String message) {
        if (this.myTestModeFlag || this.myHeadlessMode || ShutDownTracker.isShutdownHookRunning()) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (ourDispatchThread == currentThread) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            ourDispatchThread = currentThread;
        }
        if (ourDispatchThread == currentThread) {
            return;
        }
        Integer safeCounter = ourEdtSafe.get();
        if (safeCounter != null && safeCounter > 0) {
            return;
        }
        LOG.error(message, new String[]{"Current thread: " + ApplicationImpl.describe(Thread.currentThread()), "Our dispatch thread:" + ApplicationImpl.describe(ourDispatchThread), "SystemEventQueueThread: " + ApplicationImpl.describe(ApplicationImpl.getEventQueueThread())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runEdtSafeAction(@NotNull Runnable runnable) {
        Integer n;
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.runEdtSafeAction must not be null");
        }
        Integer value = ourEdtSafe.get();
        if (value == null) {
            value = 0;
        }
        ourEdtSafe.set(value + 1);
        try {
            runnable.run();
            int newValue = ourEdtSafe.get() - 1;
            n = newValue >= 1 ? Integer.valueOf(newValue) : null;
        }
        catch (Throwable throwable) {
            int newValue = ourEdtSafe.get() - 1;
            ourEdtSafe.set(newValue >= 1 ? Integer.valueOf(newValue) : null);
            throw throwable;
        }
        ourEdtSafe.set(n);
    }

    @Override
    public void assertIsDispatchThread(@Nullable JComponent component) {
        if (component == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        if (ourDispatchThread == curThread) {
            return;
        }
        if (Boolean.TRUE.equals(component.getClientProperty(WAS_EVER_SHOWN))) {
            this.assertIsDispatchThread();
        } else {
            JRootPane root = component.getRootPane();
            if (root != null) {
                component.putClientProperty(WAS_EVER_SHOWN, Boolean.TRUE);
                this.assertIsDispatchThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryRunReadAction(@NotNull Runnable action) {
        boolean mustAcquire;
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/impl/ApplicationImpl.tryRunReadAction must not be null");
        }
        boolean bl = mustAcquire = !this.isReadAccessAllowed();
        if (mustAcquire) {
            LOG.assertTrue(this.myTestModeFlag || !Thread.holdsLock(PsiLock.LOCK), (Object)"Thread must not hold PsiLock while performing readAction");
            try {
                if (!this.myActionsLock.readLock().attempt(0L)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        try {
            action.run();
        }
        finally {
            if (mustAcquire) {
                this.myActionsLock.readLock().release();
            }
        }
        return true;
    }

    public boolean tryToApplyActivationState(boolean active, Window window) {
        Component frame = UIUtil.findUltimateParent((Component)window);
        if (frame instanceof IdeFrame) {
            IdeFrame ideFrame = (IdeFrame)frame;
            if (this.isActive() != active) {
                this.myActive = active;
                System.setProperty("idea.active", Boolean.valueOf(this.myActive).toString());
                if (active) {
                    ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationActivated(ideFrame);
                } else {
                    ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationDeactivated(ideFrame);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        if (this.isUnitTestMode()) {
            return true;
        }
        if (this.myActive == null) {
            Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            return active != null;
        }
        return this.myActive;
    }

    public void assertWriteAccessAllowed() {
        LOG.assertTrue(this.isWriteAccessAllowed(), (Object)"Write access is allowed inside write-action only (see com.intellij.openapi.application.Application.runWriteAction())");
    }

    public boolean isWriteAccessAllowed() {
        return this.myActionsLock.isWriteLockAcquired(Thread.currentThread());
    }

    public void editorPaintStart() {
        ++this.myInEditorPaintCounter;
    }

    public void editorPaintFinish() {
        --this.myInEditorPaintCounter;
        LOG.assertTrue(this.myInEditorPaintCounter >= 0);
    }

    public void addApplicationListener(ApplicationListener l) {
        this.myDispatcher.addListener((EventListener)l);
    }

    public void addApplicationListener(ApplicationListener l, Disposable parent) {
        this.myDispatcher.addListener((EventListener)l, parent);
    }

    public void removeApplicationListener(ApplicationListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireApplicationExiting() {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).applicationExiting();
    }

    private void fireBeforeWriteActionStart(Runnable action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).beforeWriteActionStart((Object)action);
    }

    private void fireWriteActionStarted(Runnable action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionStarted((Object)action);
    }

    private void fireWriteActionFinished(Runnable action) {
        ((ApplicationListener)this.myDispatcher.getMulticaster()).writeActionFinished((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _saveSettings() {
        if (this.mySaveSettingsIsInProgress.compareAndSet(false, true)) {
            try {
                this.doSave();
            }
            catch (Throwable ex) {
                if (this.isUnitTestMode()) {
                    System.out.println("Saving application settings failed");
                    ex.printStackTrace();
                } else {
                    LOG.info("Saving application settings failed", ex);
                    this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ex instanceof PluginException) {
                                PluginException pluginException = (PluginException)ex;
                                PluginManager.disablePlugin((String)pluginException.getPluginId().getIdString());
                                Messages.showMessageDialog((String)("The plugin " + pluginException.getPluginId() + " failed to save settings and has been disabled. Please restart " + ApplicationNamesInfo.getInstance().getFullProductName()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                            } else {
                                Messages.showMessageDialog((String)ApplicationBundle.message((String)"application.save.settings.error", (Object[])new Object[]{ex.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                            }
                        }
                    });
                }
            }
            finally {
                this.mySaveSettingsIsInProgress.set(false);
            }
        }
    }

    public void saveSettings() {
        if (this.myDoNotSave || this.isUnitTestMode() || this.isHeadlessEnvironment()) {
            return;
        }
        this._saveSettings();
    }

    public void saveAll() {
        Project[] openProjects;
        if (this.myDoNotSave || this.isUnitTestMode() || this.isHeadlessEnvironment()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ProjectEx project = (ProjectEx)openProject;
            project.save();
        }
        this.saveSettings();
    }

    @Override
    public void doNotSave() {
        this.myDoNotSave = true;
    }

    @Override
    public boolean isDoNotSave() {
        return this.myDoNotSave;
    }

    public <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        return Extensions.getRootArea().getExtensionPoint(extensionPointName).getExtensions();
    }

    public boolean isDisposeInProgress() {
        return this.myDisposeInProgress;
    }

    public boolean isRestartCapable() {
        return SystemInfo.isWindows;
    }

    public void restart() {
        if (SystemInfo.isWindows) {
            Win32Restarter.restart();
        } else {
            this.exit();
        }
    }

    public boolean isSaving() {
        Project[] openProjects;
        if (this.getStateStore().isSaving()) {
            return true;
        }
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ProjectEx project = (ProjectEx)openProject;
            if (!project.getStateStore().isSaving()) continue;
            return true;
        }
        return false;
    }
}

