/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public final class ActionMenu
extends JMenu {
    private final String myPlace;
    private DataContext myContext;
    private final ActionGroup myGroup;
    private final PresentationFactory myPresentationFactory;
    private final Presentation myPresentation;
    private boolean myMnemonicEnabled;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private StubItem myStubItem;

    public ActionMenu(DataContext context, String place, ActionGroup group, PresentationFactory presentationFactory, boolean enableMnemonics) {
        this.myContext = context;
        this.myPlace = place;
        this.myGroup = group;
        this.myPresentationFactory = presentationFactory;
        this.myPresentation = this.myPresentationFactory.getPresentation((AnAction)group);
        this.myMnemonicEnabled = enableMnemonics;
        this.init();
        if (SystemInfo.isMacSystemMenu) {
            this.installSynchronizer();
        }
    }

    public void updateContext(DataContext context) {
        this.myContext = context;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
            this.myGroup.addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
        }
    }

    @Override
    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            this.myGroup.removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    @Override
    public void updateUI() {
        JPopupMenu popupMenu = this.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.updateUI();
        }
        if (UIUtil.isStandardMenuLAF()) {
            this.setUI((MenuItemUI)UIManager.getUI(this));
        } else {
            this.setUI(IdeaMenuUI.createUI(this));
            this.setFont(UIUtil.getMenuFont());
        }
    }

    private void init() {
        boolean macSystemMenu = SystemInfo.isMacSystemMenu && this.myPlace == "MainMenu";
        this.myStubItem = macSystemMenu ? null : new StubItem();
        this.addStubItem();
        this.addMenuListener(new MenuListenerImpl());
        this.setBorderPainted(false);
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setText(this.myPresentation.getText());
        this.updateIcon();
        this.setMnemonicEnabled(this.myMnemonicEnabled);
    }

    private void addStubItem() {
        if (this.myStubItem != null) {
            this.add(this.myStubItem);
        }
    }

    public void setMnemonicEnabled(boolean enable) {
        this.myMnemonicEnabled = enable;
        this.setMnemonic(this.myPresentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.myPresentation.getDisplayedMnemonicIndex());
    }

    @Override
    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        super.setDisplayedMnemonicIndex(this.myMnemonicEnabled ? index : -1);
    }

    @Override
    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.myMnemonicEnabled ? mnemonic : 0);
    }

    private void updateIcon() {
        Presentation presentation = this.myPresentation;
        Icon icon = presentation.getIcon();
        this.setIcon(icon);
        if (presentation.getDisabledIcon() != null) {
            this.setDisabledIcon(presentation.getDisabledIcon());
        } else {
            this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, this, this.myPresentation.getDescription());
    }

    public static void showDescriptionInStatusBar(boolean isIncluded, Component component, String description) {
        IdeFrameImpl frame;
        IdeFrameImpl ideFrameImpl = frame = component instanceof IdeFrameImpl ? (IdeFrameImpl)component : (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, component);
        if (frame != null) {
            StatusBarEx statusBar = frame.getStatusBar();
            if (isIncluded) {
                statusBar.setInfo(description);
            } else {
                statusBar.setInfo(null);
            }
        }
    }

    private void clearItems() {
        if (SystemInfo.isMacSystemMenu && this.myPlace == "MainMenu") {
            for (Component menuComponent : this.getMenuComponents()) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)menuComponent).clearItems();
                    if (!SystemInfo.isMacSystemMenu) continue;
                    ((ActionMenu)menuComponent).uninstallSynchronizer();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem)) continue;
                ((ActionMenuItem)menuComponent).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    private void fillMenu() {
        boolean mayContextBeInvalid;
        DataContext context;
        if (this.myContext != null) {
            context = this.myContext;
            mayContextBeInvalid = false;
        } else {
            context = DataManager.getInstance().getDataContext();
            mayContextBeInvalid = true;
        }
        Utils.fillMenu(this.myGroup, this, this.myMnemonicEnabled, this.myPresentationFactory, context, this.myPlace, true, mayContextBeInvalid);
    }

    private class MenuItemSynchronizer
    implements PropertyChangeListener {
        private MenuItemSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("visible".equals(name)) {
                ActionMenu.this.setVisible(ActionMenu.this.myPresentation.isVisible());
                if (SystemInfo.isMacSystemMenu && ActionMenu.this.myPlace == "MainMenu") {
                    ActionMenu.this.validateTree();
                }
            } else if ("enabled".equals(name)) {
                ActionMenu.this.setEnabled(ActionMenu.this.myPresentation.isEnabled());
            } else if ("mnemonicKey".equals(name)) {
                ActionMenu.this.setMnemonic(ActionMenu.this.myPresentation.getMnemonic());
            } else if ("mnemonicIndex".equals(name)) {
                ActionMenu.this.setDisplayedMnemonicIndex(ActionMenu.this.myPresentation.getDisplayedMnemonicIndex());
            } else if ("text".equals(name)) {
                ActionMenu.this.setText(ActionMenu.this.myPresentation.getText());
            } else if ("icon".equals(name) || "disabledIcon".equals(name)) {
                ActionMenu.this.updateIcon();
            }
        }
    }

    private class MenuListenerImpl
    implements MenuListener {
        private MenuListenerImpl() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            ActionMenu.this.clearItems();
            ActionMenu.this.addStubItem();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            ActionMenu.this.clearItems();
            ActionMenu.this.addStubItem();
        }

        @Override
        public void menuSelected(MenuEvent e) {
            ActionMenu.this.fillMenu();
        }
    }
}

